/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mapviewer.share.DimensionInfo;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.GeometryMetadataPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;

public class CreateGeometryTablePanel
extends JPanel {
    protected OlafDialog dlg = null;
    protected AbstractDataSource dataSource = null;
    protected long srid = 8307L;
    protected SpatialTableMetadata result = null;
    protected String keyColumn = null;
    protected String keySequence = null;
    protected GeometryMetadataPanel metaPanel = new GeometryMetadataPanel();
    protected JLabel keyLabel = new JLabel();
    protected JTextField keyTxt = new JTextField();
    protected JLabel labelLabel = new JLabel();
    protected JTextField labelTxt = new JTextField();
    protected JCheckBox createSequenceBox = new JCheckBox();

    public CreateGeometryTablePanel(AbstractDataSource dataSource, long srid, OlafDialog dlg) {
        this.dataSource = dataSource;
        this.srid = srid;
        this.dlg = dlg;
        dlg.setContentPane(this);
        if (dataSource == null) {
            throw new IllegalArgumentException("null datasource");
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(370, 382));
        this.keyLabel.setText(MessagesBundle.getMessage("Label_key_column_integer"));
        this.keyTxt.setText("featid");
        this.keyTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_primarykey_column"));
        this.labelLabel.setText(MessagesBundle.getMessage("Label_labelcolumn_64char"));
        this.labelTxt.setText("name");
        this.labelTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_label_column"));
        this.dlg.getOkButton().setText(MessagesBundle.getMessage("Create_table"));
        this.dlg.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateGeometryTablePanel.this.createButton_actionPerformed(e);
            }
        });
        this.createSequenceBox.setText(MessagesBundle.getMessage("Create_sequence"));
        this.createSequenceBox.setSelected(true);
        this.metaPanel.setGeometryTable("sptable");
        this.metaPanel.setGeometryColumn("geometry");
        this.metaPanel.setSRID(this.srid);
        this.metaPanel.addDimension("X", -180.0, 180.0, 5.0E-6);
        this.metaPanel.addDimension("Y", -90.0, 90.0, 5.0E-6);
        this.add((Component)this.metaPanel, new GridBagConstraints(0, 0, 3, 2, 1.0, 1.0, 13, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.keyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.keyTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.createSequenceBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.labelLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.add((Component)this.labelTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createButton_actionPerformed(ActionEvent e) {
        String table = this.metaPanel.getGeometryTable();
        if (table == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_table_name"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String column = this.metaPanel.getGeometryColumn();
        if (column == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_geometry_column"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        if (this.keyTxt.getText() == null || this.keyTxt.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_key_column"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String key = this.keyTxt.getText().trim();
        if (this.labelTxt.getText() == null || this.labelTxt.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_label_column"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String label = this.labelTxt.getText().trim();
        long srid = this.metaPanel.getSRID();
        if (srid < 0L) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Invalid_srid_value"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String[] dimnames = this.metaPanel.getDimNameValues();
        double[] minvalues = this.metaPanel.getMinValues();
        double[] maxvalues = this.metaPanel.getMaxValues();
        double[] tolvalues = this.metaPanel.getToleranceValues();
        if (this.metaPanel.getNumberofDimensions() < 2) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Not_enough_dimensions"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String[] attrs = new String[]{key, column, label};
        String[] types = new String[]{"NUMBER", "MDSYS.SDO_GEOMETRY", "VARCHAR2(64)"};
        boolean[] notNull = new boolean[]{true, false, false};
        this.setCursor(new Cursor(3));
        Vector<SpatialTableMetadata> metadata = new Vector<SpatialTableMetadata>();
        SpatialTableMetadata meta = new SpatialTableMetadata();
        meta.setName(table.toUpperCase());
        meta.setType(SpatialTableMetadata.GEOMETRY_TYPE);
        meta.setSpatialColumn(column.toUpperCase());
        meta.setOwner(this.dataSource.getConnectionProperties().getProperty("dataSource").toUpperCase());
        meta.setSRID((int)srid);
        for (int i = 0; i < this.metaPanel.getNumberofDimensions(); ++i) {
            DimensionInfo dinfo = new DimensionInfo(dimnames[i], minvalues[i], maxvalues[i], tolvalues[i]);
            meta.addDimensionInfo(dinfo);
        }
        metadata.add(meta);
        AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
        Throwable exception = null;
        try {
            da.openConnection();
            da.createTable(table, attrs, types, notNull, key, metadata);
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (exception != null) {
            ErrorDialog.showErrorDialog(exception, this, MessagesBundle.getFormattedMessage("Unable_tocreate_table", table), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        if (this.createSequenceBox.isSelected()) {
            String seqName = (table + "_" + key + "_SEQ").toUpperCase();
            try {
                da.openConnection();
                da.createSequence(seqName, 1L);
                this.keySequence = seqName;
            }
            catch (MDSException ex) {
                System.out.println("Warning: " + MessagesBundle.getFormattedMessage("Unable_tocreate_sequence_name", seqName) + "\n" + ex.getMessage());
            }
            catch (Exception ex) {
                System.out.println("Warning: " + MessagesBundle.getFormattedMessage("Unable_tocreate_sequence_name", seqName) + "\n" + ex.getMessage());
            }
            finally {
                try {
                    da.closeConnection();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        this.result = meta;
        this.keyColumn = key.toUpperCase();
        JOptionPane.showMessageDialog(this, MessagesBundle.getFormattedMessage("Table_created_registered_indexed", table), MessagesBundle.getMessage("Information"), 1);
    }

    public SpatialTableMetadata getSpatialTableMetadata() {
        return this.result;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getKeySequence() {
        return this.keySequence;
    }
}

