/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.Point2DD;
import oracle.spatial.topo.TopoFaceSplitInfo;
import oracle.spatial.topo.TopoPrimitives;

public class SimplifyGeometrySet {
    private TopoPrimitives topology = null;
    private Vector<JGeometry> origGeometries = new Vector();
    private Hashtable<Integer, Boolean> geomToBeSimplified = new Hashtable();
    private Hashtable<Integer, int[]> lineGeomMap = new Hashtable();
    private Hashtable<Integer, int[]> polyGeomMap = new Hashtable();
    private Hashtable<Integer, Integer> edgeIndexMap = new Hashtable();
    private Vector<JGeometry> topoEdgeGeoms = null;
    private Hashtable<Integer, FaceSplitInfo> faceSplits = new Hashtable();
    private Hashtable<Integer, Boolean> usedFaces = new Hashtable();

    public SimplifyGeometrySet() {
        try {
            this.topology = new TopoPrimitives(10, 10, 10, 10, null);
        }
        catch (Exception ex) {
            System.out.println("Unable to start topology class.");
            this.topology = null;
        }
    }

    public TopoPrimitives getTopology() {
        return this.topology;
    }

    public void reset() throws Exception {
        if (this.topology != null) {
            this.topology.reset();
        }
        this.lineGeomMap.clear();
        this.polyGeomMap.clear();
        this.edgeIndexMap.clear();
        this.topoEdgeGeoms = null;
        this.geomToBeSimplified.clear();
        this.origGeometries.clear();
        this.faceSplits.clear();
        this.usedFaces.clear();
    }

    public void buildTopology(Vector<JGeometry> geometries) throws Exception {
        this.reset();
        if (geometries == null || geometries.size() == 0) {
            return;
        }
        System.out.println("Building topology for [" + geometries.size() + "] geometries...");
        for (int i = 0; i < geometries.size(); ++i) {
            JGeometry geom = geometries.get(i);
            this.origGeometries.add(geom);
            int gtype = geom.getType();
            if (gtype == 1 || gtype == 5) {
                this.geomToBeSimplified.put(new Integer(i), new Boolean(false));
            } else if (gtype == 2 || gtype == 6) {
                this.geomToBeSimplified.put(new Integer(i), new Boolean(false));
            } else if (gtype == 3 || gtype == 7) {
                if (this.topology.getSrid() == -1) {
                    this.topology.setSrid(geom.getSRID());
                }
                try {
                    int splits = this.topology.getFaceSplitInfo().size();
                    int[] ids = this.topology.addPolygonGeometry(geom);
                    if (ids != null) {
                        this.polyGeomMap.put(new Integer(i), ids);
                    }
                    int updatedSplits = this.topology.getFaceSplitInfo().size();
                    for (int s = splits; s < updatedSplits; ++s) {
                        TopoFaceSplitInfo splitInfo = this.topology.getFaceSplitInfo().get(s);
                        FaceSplitInfo fsi = new FaceSplitInfo(splitInfo.getNewFace(), splitInfo.getSplitFace(), i);
                        this.faceSplits.put(new Integer(splitInfo.getNewFace()), fsi);
                    }
                    this.geomToBeSimplified.put(new Integer(i), new Boolean(true));
                }
                catch (Exception ex) {
                    System.err.println("Exception for geometry index [" + i + "]: " + ex.getMessage());
                    this.geomToBeSimplified.put(new Integer(i), new Boolean(false));
                }
            } else {
                this.geomToBeSimplified.put(new Integer(i), new Boolean(false));
            }
            if ((i + 1) % 300 != 0) continue;
            System.out.println("Geometry [" + (i + 1) + "] processed.");
        }
        Iterator it = this.topology.getEdgeIterator();
        int index = 0;
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            this.edgeIndexMap.put(new Integer(e.getId()), new Integer(index));
            ++index;
        }
    }

    public int getEdgeIndex(int edge) {
        Integer eIndex = this.edgeIndexMap.get(edge);
        if (eIndex == null) {
            return -1;
        }
        return eIndex;
    }

    private void printTopoElements(String geomType, int geomIndex, int[] elems) {
        System.out.println("###geom type: " + geomType);
        System.out.println("###geom index: " + geomIndex);
        if (elems != null) {
            String elements = "###topo elements: ";
            for (int i = 0; i < elems.length; ++i) {
                elements = i == 0 ? elements + elems[i] : elements + ", " + elems[i];
            }
            System.out.println(elements);
        }
    }

    public int[] getGeometryTopoElements(int geomIndex) {
        if (this.origGeometries == null) {
            return null;
        }
        JGeometry geom = this.origGeometries.get(geomIndex);
        if (geom == null) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5) {
            return null;
        }
        if (gtype == 2 || gtype == 6) {
            return this.lineGeomMap.get(new Integer(geomIndex));
        }
        if (gtype == 3 || gtype == 7) {
            return this.polyGeomMap.get(new Integer(geomIndex));
        }
        return null;
    }

    public Vector<JGeometry> getTopologyEdgeGeometries() {
        if (this.topoEdgeGeoms != null) {
            return this.topoEdgeGeoms;
        }
        if (this.topology == null) {
            return null;
        }
        Iterator it = this.topology.getEdgeIterator();
        Vector<JGeometry> edges = new Vector<JGeometry>();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            Point2DD[] coords = e.getCoords();
            double[] oords = new double[coords.length * 2];
            for (int i = 0; i < coords.length; ++i) {
                oords[2 * i] = coords[i].getX();
                oords[2 * i + 1] = coords[i].getY();
            }
            JGeometry ed = JGeometry.createLinearLineString((double[])oords, (int)2, (int)this.topology.getSrid());
            edges.add(ed);
        }
        if (edges.size() == 0) {
            return null;
        }
        this.topoEdgeGeoms = edges;
        return edges;
    }

    public JGeometry getTopologyEdgeGeometry(int edge) {
        if (this.topology == null) {
            return null;
        }
        try {
            Edge e = this.topology.getEdge(edge);
            if (e == null) {
                return null;
            }
            Point2DD[] coords = e.getCoords();
            double[] oords = new double[coords.length * 2];
            for (int i = 0; i < coords.length; ++i) {
                oords[2 * i] = coords[i].getX();
                oords[2 * i + 1] = coords[i].getY();
            }
            JGeometry ed = JGeometry.createLinearLineString((double[])oords, (int)2, (int)this.topology.getSrid());
            return ed;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void dumpFaceGeometries(Vector<JGeometry> simplifiedTopoEdges) {
        if (this.topology == null) {
            return;
        }
        ArrayList faces = this.topology.getFaceAdditions();
        if (faces != null) {
            for (int i = 0; i < faces.size(); ++i) {
                Integer id = (Integer)faces.get(i);
                if (id == -1) continue;
                try {
                    Face f = this.topology.getFace(id);
                    JGeometry g = this.getFaceGeometry(f.getID(), simplifiedTopoEdges);
                    if (g == null) continue;
                    System.out.println("Face #: " + f.getID() + "\n" + g.toStringFull());
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Unable to dump face [" + id + "]. " + ex.getMessage());
                }
            }
        }
    }

    public Vector<JGeometry> rebuildSimplifiedGeometries(Vector<JGeometry> simplifiedTopoEdges) {
        int i;
        JGeometry geom;
        this.usedFaces.clear();
        Vector<JGeometry> outGeoms = new Vector<JGeometry>();
        if (this.origGeometries == null) {
            return null;
        }
        System.out.println("Rebuilding geometries...");
        for (int i2 = 0; i2 < this.origGeometries.size(); ++i2) {
            Boolean b;
            if ((i2 + 1) % 500 == 0) {
                System.out.println("Geometry [" + (i2 + 1) + "] ...");
            }
            if ((b = this.geomToBeSimplified.get(new Integer(i2))) == null || !b.booleanValue()) {
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            geom = this.origGeometries.get(i2);
            int gtype = geom.getType();
            if (gtype == 1 || gtype == 5) {
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            if (gtype == 2 || gtype == 6) {
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            if (gtype == 3 || gtype == 7) {
                int[] elems = this.getGeometryTopoElements(i2);
                if (elems != null && elems.length > 0) {
                    JGeometry outg = null;
                    for (int j = 0; j < elems.length; ++j) {
                        this.usedFaces.put(new Integer(elems[j]), new Boolean(true));
                        JGeometry g = this.getFaceGeometry(elems[j], simplifiedTopoEdges);
                        if (g == null) continue;
                        outg = outg == null ? g : JGeometryUtil.addPolygon((JGeometry)outg, (JGeometry)g);
                    }
                    if (outg == null) {
                        outGeoms.add(this.origGeometries.get(i2));
                        continue;
                    }
                    outGeoms.add(outg);
                    continue;
                }
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            outGeoms.add(this.origGeometries.get(i2));
        }
        System.out.println("Processing missing faces ...");
        ArrayList topoFaces = this.topology.getFaceAdditions();
        for (i = 0; i < topoFaces.size(); ++i) {
            JGeometry geom2;
            FaceSplitInfo fsi;
            Integer f = (Integer)topoFaces.get(i);
            if (this.usedFaces.get(new Integer(f)) != null || (fsi = this.faceSplits.get(new Integer(f))) == null) continue;
            int geomIndex = -1;
            if (fsi.getSplitFace() == -1) {
                geomIndex = fsi.getGeomIndex();
            } else {
                FaceSplitInfo fsiSplit = this.faceSplits.get(new Integer(fsi.getSplitFace()));
                if (fsiSplit == null) continue;
                geomIndex = fsiSplit.getGeomIndex();
            }
            JGeometry g = this.getFaceGeometry(f, simplifiedTopoEdges);
            if (g == null || (geom2 = outGeoms.get(geomIndex)) == null || (geom2 = JGeometryUtil.addPolygon((JGeometry)geom2, (JGeometry)g)) == null) continue;
            outGeoms.set(geomIndex, geom2);
        }
        System.out.println("Cleaning very small areas for multi-polygons or collection with polygons ...");
        for (i = 0; i < outGeoms.size(); ++i) {
            geom = (JGeometry)outGeoms.get(i);
            if (geom.getType() != 7 && geom.getType() != 4) continue;
            double maxArea = Double.NEGATIVE_INFINITY;
            int maxAreaElem = -1;
            int numPolys = 0;
            JGeometry[] elems = geom.getElements();
            if (elems == null || elems.length <= 0) continue;
            double[] elemsArea = new double[elems.length];
            for (int j = 0; j < elems.length; ++j) {
                double area;
                JGeometry elem = elems[j];
                if (elem.getType() != 3) continue;
                elemsArea[j] = area = Math.abs(GeometryUtil.getPolygonArea((double[])elems[j].getOrdinatesArray()));
                if (numPolys == 0 || area > maxArea) {
                    maxArea = area;
                    maxAreaElem = j;
                }
                ++numPolys;
            }
            if (maxAreaElem <= -1 || numPolys <= true) continue;
            Hashtable<String, String> elemsToRemove = new Hashtable<String, String>();
            for (int j = 0; j < elems.length; ++j) {
                double areaPercent;
                if (maxAreaElem == j) continue;
                JGeometry elem = elems[j];
                int numPoints = elem.getOrdinatesArray().length / elem.getDimensions();
                if (elem.getType() != 3 || numPoints >= 11 || !((areaPercent = elemsArea[j] / maxArea * 100.0) < 2.0)) continue;
                elemsToRemove.put("" + j, "" + j);
            }
            if (elemsToRemove.size() <= 0) continue;
            JGeometry g = new JGeometry(elems[maxAreaElem].getType(), elems[maxAreaElem].getSRID(), elems[maxAreaElem].getElemInfo(), elems[maxAreaElem].getOrdinatesArray());
            for (int j = 0; j < elems.length; ++j) {
                if (maxAreaElem == j || elemsToRemove.get("" + j) != null) continue;
                JGeometry elem = elems[j];
                if (elem.getType() == 1) {
                    g = JGeometryUtil.addPoint((JGeometry)g, (JGeometry)elem);
                    continue;
                }
                if (elem.getType() == 2) {
                    g = JGeometryUtil.addLine((JGeometry)g, (JGeometry)elem);
                    continue;
                }
                if (elem.getType() != 3) continue;
                g = JGeometryUtil.addPolygon((JGeometry)g, (JGeometry)elem);
            }
            outGeoms.set(i, g);
        }
        System.out.println("Done with rebuilding geometries.");
        return outGeoms;
    }

    private JGeometry getFaceGeometry(int face, Vector<JGeometry> simplifiedTopoEdges) {
        JGeometry outgeom = null;
        try {
            Face f = this.topology.getFace(Math.abs(face));
            int bdedge = f.getBoundaryEdge();
            outgeom = this.getPolygonFromBoundaryEdge(f.getID(), bdedge, simplifiedTopoEdges);
            if (outgeom == null) {
                System.out.println("Unable to build face polygon from edge: " + bdedge);
                return null;
            }
            double[] oords = outgeom.getOrdinatesArray();
            if (oords == null || oords.length < 8) {
                return null;
            }
            int[] isledges = f.getIslandEdges();
            if (isledges != null && isledges.length > 0) {
                for (int i = 0; i < isledges.length; ++i) {
                    JGeometry hole = this.getPolygonFromBoundaryEdge(f.getID(), isledges[i], simplifiedTopoEdges);
                    if (hole == null || (oords = hole.getOrdinatesArray()) == null || oords.length < 8) continue;
                    outgeom = JGeometryUtil.addVoidPolygon((JGeometry)outgeom, (int)0, (JGeometry)hole);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to build polygon geometry for face: " + face);
            outgeom = null;
        }
        return outgeom;
    }

    private JGeometry getPolygonFromBoundaryEdge(int faceId, int bdedge, Vector<JGeometry> simplifiedTopoEdges) {
        JGeometry outgeom = null;
        try {
            Edge e = this.topology.getEdge(Math.abs(bdedge));
            int startEdge = e.getId();
            int nextEdge = -1;
            nextEdge = e.getBoundedFaceL() == faceId ? e.getNextEdgeL() : e.getNextEdgeR();
            double[] oords = this.getEdgeOords(e, simplifiedTopoEdges);
            if (bdedge < 0) {
                oords = GeometryUtil.reverseCoordinates((double[])oords, (int)2);
            }
            if (e.getOriginNode() == e.getEndNode()) {
                if (GeometryUtil.isClockwise((double[])oords)) {
                    oords = GeometryUtil.reverseCoordinates((double[])oords, (int)2);
                }
            } else {
                Vector<Point2DD> points = new Vector<Point2DD>();
                for (int i = 0; i < oords.length / 2; ++i) {
                    points.add(new Point2DD(oords[2 * i], oords[2 * i + 1]));
                }
                while (Math.abs(nextEdge) != Math.abs(startEdge)) {
                    int j;
                    Edge ne = this.topology.getEdge(Math.abs(nextEdge));
                    double[] neoords = this.getEdgeOords(ne, simplifiedTopoEdges);
                    if (nextEdge > 0) {
                        for (j = 1; j < neoords.length / 2; ++j) {
                            points.add(new Point2DD(neoords[2 * j], neoords[2 * j + 1]));
                        }
                    } else {
                        for (j = neoords.length / 2 - 2; j >= 0; --j) {
                            points.add(new Point2DD(neoords[2 * j], neoords[2 * j + 1]));
                        }
                    }
                    if (ne.getBoundedFaceL() == faceId) {
                        nextEdge = ne.getNextEdgeL();
                        continue;
                    }
                    nextEdge = ne.getNextEdgeR();
                }
                Point2DD[] p2ds = points.toArray(new Point2DD[points.size()]);
                oords = new double[p2ds.length * 2];
                for (int i = 0; i < p2ds.length; ++i) {
                    oords[i * 2] = p2ds[i].getX();
                    oords[i * 2 + 1] = p2ds[i].getY();
                }
            }
            int[] elemInfo = new int[]{1, 1003, 1};
            outgeom = new JGeometry(2003, this.topology.getSrid(), elemInfo, oords);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            outgeom = null;
        }
        return outgeom;
    }

    private double[] getEdgeOords(Edge e, Vector<JGeometry> simplifiedTopoEdges) {
        Integer simpliIndex = this.edgeIndexMap.get(e.getId());
        JGeometry simplEdgeGeom = simplifiedTopoEdges.get(simpliIndex);
        double[] oords = null;
        if (simplEdgeGeom == null) {
            Point2DD[] pts = e.getCoords();
            oords = new double[pts.length * 2];
            for (int i = 0; i < pts.length; ++i) {
                oords[i * 2] = pts[i].getX();
                oords[i * 2 + 1] = pts[i].getY();
            }
        } else {
            oords = simplEdgeGeom.getOrdinatesArray();
        }
        return oords;
    }

    private class FaceSplitInfo {
        private int newFace = -1;
        private int splitFace = -1;
        private int geomIndex = -1;

        public FaceSplitInfo(int newId, int splitId, int index) {
            this.newFace = newId;
            this.splitFace = splitId;
            this.geomIndex = index;
        }

        public int getNewFace() {
            return this.newFace;
        }

        public int getSplitFace() {
            return this.splitFace;
        }

        public int getGeomIndex() {
            return this.geomIndex;
        }
    }
}

