/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.AboutDialog;
import oracle.olapdv.app.DataValidateApp;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.util.MiscUtils;
import oracle.olapdv.writer.ValidationWriter;

public class DataValidateFrame
extends JFrame
implements ActionListener {
    private Logger LOG = Logger.getLogger(DataValidateFrame.class.getName());
    private DataValidateApp m_dataValidateApp;

    public DataValidateFrame(String string, DataValidateApp dataValidateApp) {
        super(string);
        this.m_dataValidateApp = dataValidateApp;
        this.init();
    }

    private void init() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("CLOSE");
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Help");
        JMenuItem jMenuItem2 = new JMenuItem("About...");
        jMenuItem2.setActionCommand("ABOUT");
        jMenuItem2.addActionListener(this);
        jMenu2.add(jMenuItem2);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("Close")) {
            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
            if (validateTopDO.getPendingSQLUpdates()) {
                int n = JOptionPane.showConfirmDialog(this, OLAPDVArb.getString("THERE_ARE_PENDING_SQL_UPDATES"), OLAPDVArb.getString("SAVE_PENDING_SQL_CHANGES_TITLE"), 1);
                if (n == 2) {
                    return;
                }
                QueryManager queryManager = new QueryManager();
                if (n == 0) {
                    queryManager.commit();
                } else {
                    queryManager.rollback();
                }
                validateTopDO.setPendingSQLUpdates(false);
            }
            List<ValidateModelDO> list = validateTopDO.getModels();
            for (ValidateModelDO validateModelDO : list) {
                if (!validateModelDO.getValidateReportPending()) continue;
                try {
                    this.setCursor(new Cursor(3));
                    ValidationWriter validationWriter = new ValidationWriter();
                    validationWriter.writeValidateReport(validateModelDO, true);
                    this.setCursor(Cursor.getDefaultCursor());
                }
                catch (SQLException sQLException) {
                    this.LOG.log(Level.SEVERE, "In method actionPerformed for close, SQL Exception occurred", sQLException);
                }
            }
            this.m_dataValidateApp.closeApplication(this.m_dataValidateApp);
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("About")) {
            AboutDialog aboutDialog = new AboutDialog(this);
            Rectangle rectangle = MiscUtils.centerWindow(this, 600, 275);
            aboutDialog.setBounds(rectangle);
            aboutDialog.setModal(true);
            aboutDialog.setVisible(true);
        }
    }
}

