/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.olap.model;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.olapdv.olap.model.AttributeDO;
import oracle.olapdv.olap.model.DataObject;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ModelMapDO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DimensionDO
extends DataObject {
    private ArrayList<HierarchyDO> m_hierarchyDOs = null;
    private ArrayList<AttributeDO> m_attributeDOs = null;
    private String m_dimensionType;
    private String xmlStr;
    private boolean validState = true;
    private String lastTimeDimensionModified;
    private static final String hierarchyNodeName = "Hierarchy";
    private static final String levelHierarchyNodeName = "LevelHierarchy";
    private static final String hierarchyLevelNodeName = "HierarchyLevel";
    private static final String dimensionLevelNodeName = "DimensionLevel";
    private static final String hierarchyLevelMapNodeName = "HierarchyLevelMap";

    public DimensionDO(String string) {
        super(string);
    }

    public void setValidState(boolean bl) {
        this.validState = bl;
    }

    public boolean getValidState() {
        return this.validState;
    }

    public void setLastTimeDimensionModified(String string) {
        this.lastTimeDimensionModified = string;
    }

    public String getLastTimeDimensionModified() {
        return this.lastTimeDimensionModified;
    }

    public HierarchyDO getHierarchyDOFromName(String string) {
        HierarchyDO hierarchyDO = null;
        for (HierarchyDO hierarchyDO2 : this.m_hierarchyDOs) {
            if (!hierarchyDO2.getName().equalsIgnoreCase(string)) continue;
            hierarchyDO = hierarchyDO2;
            break;
        }
        return hierarchyDO;
    }

    public ArrayList<HierarchyDO> getHierarchyDOs() {
        if (this.m_hierarchyDOs == null) {
            this.m_hierarchyDOs = new ArrayList();
        }
        return this.m_hierarchyDOs;
    }

    public ArrayList<AttributeDO> getAttributeDOs() {
        if (this.m_attributeDOs == null) {
            this.m_attributeDOs = new ArrayList();
        }
        return this.m_attributeDOs;
    }

    public AttributeDO getLongDescriptionAttributeDO() {
        AttributeDO attributeDO = null;
        for (AttributeDO attributeDO2 : this.m_attributeDOs) {
            String string = attributeDO2.getAttributeRole();
            if (string == null || !string.equalsIgnoreCase("LONG_DESCRIPTION")) continue;
            attributeDO = attributeDO2;
            break;
        }
        return attributeDO;
    }

    public void setAttributeDOs(ArrayList<AttributeDO> arrayList) {
        this.m_attributeDOs = arrayList;
    }

    public void setHierarchyDOs(ArrayList<HierarchyDO> arrayList) {
        this.m_hierarchyDOs = arrayList;
    }

    public boolean isHierarchyAlreadyPresent(HierarchyDO hierarchyDO) {
        boolean bl = false;
        if (this.m_hierarchyDOs == null) {
            this.m_hierarchyDOs = new ArrayList();
        }
        for (HierarchyDO hierarchyDO2 : this.m_hierarchyDOs) {
            String string = hierarchyDO2.getName();
            if (string == null || !string.equalsIgnoreCase(hierarchyDO.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void addHierarchyDO(HierarchyDO hierarchyDO) {
        if (this.m_hierarchyDOs == null) {
            this.m_hierarchyDOs = new ArrayList();
        }
        this.m_hierarchyDOs.add(hierarchyDO);
    }

    public void deleteLevel(String string, String string2) {
        int n = 0;
        boolean bl = false;
        for (HierarchyDO hierarchyDO : this.m_hierarchyDOs) {
            if (!hierarchyDO.getName().equalsIgnoreCase(string)) continue;
            for (LevelDO levelDO : hierarchyDO.getLevelDOs()) {
                if (levelDO.getName().equalsIgnoreCase(string2)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            hierarchyDO.getLevelDOs().remove(n);
            int n2 = hierarchyDO.getLevelDOs().size();
            for (int i = n; i < n2; ++i) {
                LevelDO levelDO = hierarchyDO.getLevelDOs().get(i);
                levelDO.setDepth(levelDO.getDepth() - 1);
            }
        }
    }

    public void setDimensionType(String string) {
        this.m_dimensionType = string;
    }

    public String getDimensionType() {
        return this.m_dimensionType;
    }

    public void setXMLString(String string) {
        this.xmlStr = string;
    }

    public String getXMLString() {
        return this.xmlStr;
    }

    public boolean supportPossibleTopLevelMemberLiteralMapping() {
        boolean bl = true;
        block0: for (HierarchyDO hierarchyDO : this.m_hierarchyDOs) {
            boolean bl2 = true;
            for (LevelDO levelDO : hierarchyDO.getLevelDOs()) {
                if (bl2) {
                    bl2 = false;
                    if (levelDO.getValidState() != LevelDO.ValidStates.VALID_ERROR) continue;
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    String string = levelMapDO.getColumnName();
                    if (string != null && string.length() > 0) {
                        levelDO.setValidState(LevelDO.ValidStates.VALID_WARNING);
                        continue;
                    }
                    bl = false;
                    continue block0;
                }
                if (levelDO.getValidState() != LevelDO.ValidStates.VALID_ERROR) continue;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    public void parseMappingFromXML(String string) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        StringReader stringReader = new StringReader(this.xmlStr);
        InputSource inputSource = new InputSource(stringReader);
        Document document = documentBuilder.parse(inputSource);
        HierarchyDO hierarchyDO = null;
        LevelDO levelDO = null;
        LevelMapDO levelMapDO = null;
        NodeList nodeList = document.getElementsByTagName(hierarchyNodeName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node = nodeList2.item(j);
                if (!node.getNodeName().equalsIgnoreCase(levelHierarchyNodeName)) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = namedNodeMap.getNamedItem("Name");
                hierarchyDO = this.getHierarchyDOFromName(node2.getNodeValue());
                NodeList nodeList3 = node.getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    Node node3 = nodeList3.item(k);
                    if (!node3.getNodeName().equalsIgnoreCase(hierarchyLevelNodeName)) continue;
                    NamedNodeMap namedNodeMap2 = node3.getAttributes();
                    Node node4 = namedNodeMap2.getNamedItem(dimensionLevelNodeName);
                    levelDO = hierarchyDO.getLevelDOFromName(node4.getNodeValue());
                    levelMapDO = new LevelMapDO(2);
                    levelDO.setLevelMapDO(levelMapDO);
                    NodeList nodeList4 = node3.getChildNodes();
                    for (int i2 = 0; i2 < nodeList4.getLength(); ++i2) {
                        Node node5 = nodeList4.item(i2);
                        if (!node5.getNodeName().equalsIgnoreCase(hierarchyLevelMapNodeName)) continue;
                        this.readHierarchyLevelMap(node5, levelMapDO, string);
                    }
                }
            }
        }
    }

    private String readHierarchyLevelMap(Node node, LevelMapDO levelMapDO, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        Object object5;
        String[] stringArray2;
        Object object6;
        Object object7;
        String string2 = null;
        Object object8 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("KeyExpression");
        String[] stringArray3 = ModelMapDO.parseColumnName(node2.getNodeValue());
        String string3 = stringArray3[0];
        String string4 = stringArray3[1];
        String string5 = stringArray3[2];
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        boolean bl = this.checkColumnMappingSupported(string5);
        levelMapDO.setKeyColumnMapSupported(bl);
        levelMapDO.setTableOwner(string3);
        levelMapDO.setTableName(string4);
        if (!bl) {
            object7 = this.doubleSingleQuoteEmbeddedQuote(string5);
            if (((String)object7).length() > 128) {
                object7 = ((String)object7).substring(0, 125) + "...";
            }
            levelMapDO.setColumnName((String)object7);
        } else {
            levelMapDO.setColumnName(string5);
        }
        object7 = namedNodeMap.getNamedItem("JoinCondition");
        if (object7 != null && ((String)(object6 = object7.getNodeValue())).indexOf("=") != -1) {
            stringArray2 = ((String)object6).split("=");
            object5 = stringArray2[0].trim();
            String string6 = stringArray2[1].trim();
            stringArray = ModelMapDO.parseColumnName((String)object5);
            object4 = ModelMapDO.parseColumnName(string6);
            object3 = stringArray[1];
            object2 = object4[1];
            String string7 = stringArray[2];
            object = object4[2];
            if (((String)object3).equalsIgnoreCase(string4)) {
                object8 = string7;
            } else if (((String)object2).equalsIgnoreCase(string4)) {
                object8 = object;
            }
            levelMapDO.setParentColumnName((String)object8);
        }
        object6 = this.getLongDescriptionAttributeDO();
        stringArray2 = "LONG_DESCRIPTION";
        if (object6 != null) {
            stringArray2 = ((DataObject)object6).getName();
        }
        object5 = node.getChildNodes();
        for (int i = 0; i < object5.getLength(); ++i) {
            stringArray = object5.item(i);
            if (!stringArray.getNodeName().equalsIgnoreCase("AttributeMap") || !(object3 = (object4 = stringArray.getAttributes()).getNamedItem("Name")).getNodeValue().equalsIgnoreCase((String)stringArray2)) continue;
            object2 = object4.getNamedItem("Expression");
            string2 = object2.getNodeValue();
            stringArray3 = ModelMapDO.parseColumnName(object2.getNodeValue());
            string5 = stringArray3[2];
            boolean bl2 = this.checkColumnMappingSupported(string5);
            levelMapDO.setDescColumnMapSupported(bl2);
            if (!bl2) {
                object = this.doubleSingleQuoteEmbeddedQuote(string5);
                if (((String)object).length() > 128) {
                    object = ((String)object).substring(0, 125) + "...";
                }
                levelMapDO.setLongDescColumnName((String)object);
                break;
            }
            levelMapDO.setLongDescColumnName(string5);
            break;
        }
        return string2;
    }

    private boolean checkColumnMappingSupported(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            bl = false;
        } else if (string.contains(" ") || string.contains("'") || string.contains("|") || string.contains("(") || string.contains(")")) {
            bl = false;
        }
        return bl;
    }

    private String doubleSingleQuoteEmbeddedQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string.toCharArray()) {
            if (c == '\'') {
                stringBuffer.append("''");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

