/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class Logger {
    public static final int DEBUG = 3;
    public static final int WARNING = 2;
    public static final int ERROR = 1;
    public static final int NONE = 0;
    private static int s_logLevel = 0;
    private static String s_logFile = null;
    private static String s_sessionLogFile = null;
    private static String s_sessionLevel = null;
    private static int s_xmlImportCounter = 0;

    public static boolean isLogging() {
        return s_logLevel == 3;
    }

    public static void logSessionBuild(String string) {
        Logger.writeToSessionLogFile(string, null, true);
    }

    public static void logSessionXML(String string) {
        String string2 = null;
        String string3 = "xmlCLOB";
        string = string.replaceAll("&apos;", "'");
        string2 = Logger.convertToClobAndImportXML(string3, string);
        Logger.writeToSessionLogFile(string2, null, true);
        ++s_xmlImportCounter;
    }

    public static synchronized void logDebug(String string, Object object) {
        if (s_logLevel >= 3) {
            Logger.writeToLogFile(Logger.format(3, string, "" + object), null);
        }
    }

    public static synchronized void logWarning(String string, Object object) {
        if (s_logLevel >= 2) {
            Logger.writeToLogFile(Logger.format(2, string, "" + object), null);
            Logger.writeToStderr(Logger.format(2, string, "" + object), null);
            Logger.writeToStdout(Logger.format(2, string, "" + object), null);
        }
    }

    public static synchronized void logError(String string, Throwable throwable) {
        if (s_logLevel >= 1) {
            Logger.writeToLogFile(Logger.format(1, string, "Exception:"), throwable);
            Logger.writeToStderr(Logger.format(1, string, "Exception:"), throwable);
            Logger.writeToStdout(Logger.format(1, string, "Exception:"), throwable);
        }
    }

    public static synchronized void logError(String string, Object object) {
        if (s_logLevel >= 1) {
            Logger.writeToLogFile(Logger.format(1, string, "" + object), null);
            Logger.writeToStderr(Logger.format(1, string, "" + object), null);
            Logger.writeToStdout(Logger.format(1, string, "" + object), null);
        }
    }

    public static synchronized void logError(String string, String string2, Throwable throwable) {
        if (s_logLevel >= 1) {
            Logger.writeToLogFile(Logger.format(1, string, string2), throwable);
            Logger.writeToStderr(Logger.format(1, string, string2), throwable);
            Logger.writeToStdout(Logger.format(1, string, string2), throwable);
        }
    }

    private Logger() {
    }

    private static void initialiseFromPreferences() {
        s_logFile = "DataValidate_Trace.log";
        s_logFile = s_logFile.length() == 0 ? null : s_logFile;
        String string = "warning";
        string = string.length() == 0 ? "none" : string.toLowerCase();
        s_sessionLevel = "none";
        if (string.equals("none")) {
            s_logLevel = 0;
        } else if (string.equals("debug")) {
            s_logLevel = 3;
        } else if (string.equals("warning")) {
            s_logLevel = 2;
        } else if (string.equals("error")) {
            s_logLevel = 1;
        }
    }

    public static void setLoggingLevel(int n) {
        s_logLevel = n;
    }

    public static boolean IsSessionLoggingOn() {
        return s_sessionLogFile != null;
    }

    public static String GetSessionLogFile() {
        return s_sessionLogFile;
    }

    public static String StartSessionLog() {
        Logger.StartSessionLog(null);
        return s_sessionLogFile;
    }

    public static String StartSessionLog(String string) {
        String string2;
        SimpleDateFormat simpleDateFormat;
        Date date = new Date();
        if (string == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss_SSSS_aaa");
            string2 = simpleDateFormat.format(date);
            String string3 = "";
            String string4 = "";
            if (!string4.trim().endsWith(File.separator)) {
                string4 = string4 + File.separator;
            }
            s_sessionLogFile = string4 + string3 + string2 + ".sql";
        } else {
            s_sessionLogFile = string;
        }
        System.out.println(s_sessionLogFile);
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSSS aaa");
        string2 = simpleDateFormat.format(date);
        return s_sessionLogFile;
    }

    public static void StopSessionLog() {
        s_sessionLogFile = null;
    }

    private static String format(int n, String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyy.MMMMM.dd GGG hh:mm:ss:SSSS aaa");
        long l = System.currentTimeMillis();
        Date date = new Date();
        String string3 = simpleDateFormat.format(date);
        string = string == null || string.equals("") ? "??? " : string + "() ";
        String string4 = "";
        string4 = n == 3 ? "[DBG]" : (n == 2 ? "[WRN]" : "[ERR]");
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string3).append(" ").append(string4).append(" ").append(string).append(string2);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToSessionLogFile(String string, Throwable throwable, boolean bl) {
        PrintWriter printWriter = null;
        if (s_sessionLogFile != null) {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(s_sessionLogFile, bl)));
                if (string != null) {
                    printWriter.println(string);
                }
                if (throwable != null) {
                    throwable.printStackTrace(printWriter);
                }
            }
            catch (Throwable throwable2) {
                System.out.println(throwable2);
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToLogFile(String string, Throwable throwable) {
        PrintWriter printWriter = null;
        if (s_logFile != null) {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(s_logFile, true)));
                if (string != null) {
                    printWriter.println(string);
                }
                if (throwable != null) {
                    throwable.printStackTrace(printWriter);
                }
            }
            catch (Throwable throwable2) {
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    private static void writeToStderr(String string, Throwable throwable) {
    }

    private static void writeToStdout(String string, Throwable throwable) {
        if (string != null) {
            System.out.println(string);
        }
        if (throwable != null) {
            try {
                throwable.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String convertToClobAndImportXML(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n'", true);
        stringBuffer.append("declare\n");
        stringBuffer.append(string + " clob;\n");
        stringBuffer.append("begin\n");
        stringBuffer.append("dbms_lob.createtemporary(" + string + ",TRUE);\n");
        stringBuffer.append("dbms_lob.open(" + string + ", DBMS_LOB.LOB_READWRITE);\n");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (string3.equals("\n")) {
                n = 0;
                if (n2 > 0) {
                    while (n2 > 200) {
                        stringBuffer.append("dbms_lob.writeappend(" + string + ", " + 200 + ", '" + stringBuffer2.substring(n, n + 200) + "');\n");
                        n2 -= 200;
                        n += 200;
                    }
                    stringBuffer.append("dbms_lob.writeappend(" + string + ", " + n2 + ", '" + stringBuffer2.substring(n) + "');\n");
                }
                stringBuffer2 = new StringBuffer();
                n2 = 0;
                continue;
            }
            if (string3.equals("'")) {
                stringBuffer2.append("''");
                ++n2;
                continue;
            }
            stringBuffer2.append(string3);
            n2 += string3.length();
        }
        if (stringBuffer2.length() > 0) {
            n = 0;
            if (n2 > 0) {
                while (n2 > 200) {
                    stringBuffer.append("dbms_lob.writeappend(" + string + ", " + 200 + ", '" + stringBuffer2.substring(n, n + 200) + "');\n");
                    n2 -= 200;
                    n += 200;
                }
                stringBuffer.append("dbms_lob.writeappend(" + string + ", " + n2 + ", '" + stringBuffer2.substring(n) + "');\n");
            }
        }
        stringBuffer.append("dbms_lob.close(" + string + ");\n");
        stringBuffer.append("dbms_cube.import_xml(" + string + ");\n");
        stringBuffer.append("end;\n");
        stringBuffer.append("/\n");
        return stringBuffer.toString();
    }

    static {
        try {
            Logger.initialiseFromPreferences();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

