/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.writer;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.AWDO;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.util.jdbc.SQLParam;
import oracle.olapdv.util.jdbc.SQLWrapper;
import oracle.olapdv.writer.Sequence;

public class ModelWriter {
    private static final Logger LOG = Logger.getLogger(ModelWriter.class.getName());
    private AWDO m_awDO;
    private ValidateModelDO m_validateModelDO;
    private Component m_parentComponent;

    public ModelWriter() {
    }

    public ModelWriter(AWDO aWDO, Component component) {
        this.m_awDO = aWDO;
        this.m_parentComponent = component;
    }

    public ModelWriter(ValidateModelDO validateModelDO) {
        this.m_validateModelDO = validateModelDO;
    }

    public boolean writeDimensionsToDataValidationTable(String string, boolean bl) {
        Connection connection = null;
        StringBuffer stringBuffer = null;
        boolean bl2 = true;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method writeDimensionsToDataValidationTable, SQL Exception occurred.", sQLException);
        }
        Sequence sequence = new Sequence();
        sequence.initializeSequence();
        String string2 = this.m_awDO.getName();
        SQLParam sQLParam = null;
        ArrayList<DimensionDO> arrayList = this.m_awDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            this.deleteDimensionFromValidationTable(connection, string, this.m_awDO.getName(), dimensionDO.getName(), bl);
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    Object object;
                    levelDO.setHierarchyDO(hierarchyDO);
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    String string3 = null;
                    String string4 = levelMapDO.getOwner();
                    String string5 = levelMapDO.getTableName();
                    String string6 = levelMapDO.getColumnName();
                    String string7 = levelMapDO.getParentColumnName();
                    string3 = levelDO.getParentLevelDO() != null ? levelDO.getParentLevelDO().getName() : null;
                    if (string4 == null) {
                        string4 = "";
                    }
                    if (string5 == null) {
                        string5 = "";
                    }
                    if (string6 == null) {
                        string6 = "";
                    }
                    String string8 = levelMapDO.getLongDescriptionColumnName();
                    long l = sequence.getNextSequenceValue();
                    stringBuffer = new StringBuffer("INSERT INTO OLAP_DIM_DATA_VALIDATION(");
                    stringBuffer.append("ROW_KEY, MODEL_OWNER, MODEL_NAME, DIMENSION_NAME, HIERARCHY_NAME, LEVEL_NAME, PARENT_LEVEL_NAME, DEPTH, ");
                    stringBuffer.append("TABLE_OWNER, DIMENSION_TABLE, MEMBER_COLUMN, DESCRIPTION_COLUMN, PARENT_JOIN_COLUMN, ");
                    stringBuffer.append("DIMENSION_TYPE, ATTRIBUTES) ");
                    stringBuffer.append("VALUES (");
                    stringBuffer.append(l + ", ");
                    stringBuffer.append("'" + string + "', '" + string2 + "', '" + dimensionDO.getName() + "', '");
                    if (string3 != null) {
                        stringBuffer.append(hierarchyDO.getName() + "', '" + levelDO.getName() + "', '" + string3 + "', ");
                    } else {
                        stringBuffer.append(hierarchyDO.getName() + "', '" + levelDO.getName() + "', null, ");
                    }
                    stringBuffer.append(levelDO.getDepth() + ", '");
                    stringBuffer.append(string4 + "', '" + string5 + "', '" + string6 + "', '");
                    if (string7 != null) {
                        stringBuffer.append(string8 + "', '" + string7 + "', ");
                    } else {
                        stringBuffer.append(string8 + "', null, ");
                    }
                    if (dimensionDO.getDimensionType() == null) {
                        stringBuffer.append("'STANDARD', ");
                    } else {
                        stringBuffer.append("'" + dimensionDO.getDimensionType() + "', ");
                    }
                    if (levelMapDO.getEndDateColumnName() == null) {
                        stringBuffer.append("null)");
                    } else {
                        object = "'END_DATE=" + levelMapDO.getEndDateColumnName() + ",TIMESPAN=" + levelMapDO.getTimeSpanColumnName() + "')";
                        stringBuffer.append((String)object);
                    }
                    try {
                        sQLParam = SQLWrapper.execute(connection, stringBuffer.toString());
                        if (!bl) continue;
                        object = new QueryManager();
                        ((QueryManager)object).commit();
                    }
                    catch (SQLException sQLException) {
                        LOG.log(Level.SEVERE, "In method writeDimensionsToDataValidationTable, SQL Exception occurred.", sQLException);
                        JOptionPane.showMessageDialog(this.m_parentComponent, OLAPDVArb.format("SQL_INSERT_ERROR_MSG", sQLException), OLAPDVArb.get("SQL_INSERT_ERROR_TITLE"), 0);
                        bl2 = false;
                    }
                }
            }
        }
        if (sQLParam != null) {
            sQLParam.closeResultSet();
        }
        return bl2;
    }

    public void writeValidateModelToValidationTable(String string, boolean bl) {
        Connection connection = null;
        StringBuffer stringBuffer = null;
        boolean bl2 = true;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method writeValidateModelToValidationTable, SQL Exception occurred.", sQLException);
        }
        Sequence sequence = new Sequence();
        sequence.initializeSequence();
        String string2 = this.m_validateModelDO.getName();
        SQLParam sQLParam = null;
        ArrayList<DimensionDO> arrayList = this.m_validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            this.deleteDimensionFromValidationTable(connection, string, string2, dimensionDO.getName(), bl);
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    Object object;
                    levelDO.setHierarchyDO(hierarchyDO);
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    String string3 = null;
                    String string4 = levelMapDO.getOwner();
                    String string5 = levelMapDO.getTableName();
                    String string6 = levelMapDO.getColumnName();
                    String string7 = levelMapDO.getParentColumnName();
                    string3 = levelDO.getParentLevelDO() != null ? levelDO.getParentLevelDO().getName() : null;
                    if (string4 == null) {
                        string4 = "";
                    }
                    if (string5 == null) {
                        string5 = "";
                    }
                    if (string6 == null) {
                        string6 = "";
                    }
                    String string8 = levelMapDO.getLongDescriptionColumnName();
                    long l = sequence.getNextSequenceValue();
                    stringBuffer = new StringBuffer("INSERT INTO OLAP_DIM_DATA_VALIDATION(");
                    stringBuffer.append("ROW_KEY, MODEL_OWNER, MODEL_NAME, DIMENSION_NAME, HIERARCHY_NAME, LEVEL_NAME, PARENT_LEVEL_NAME, DEPTH, ");
                    stringBuffer.append("TABLE_OWNER, DIMENSION_TABLE, MEMBER_COLUMN, DESCRIPTION_COLUMN, PARENT_JOIN_COLUMN, ");
                    stringBuffer.append("DIMENSION_TYPE, ATTRIBUTES) ");
                    stringBuffer.append("VALUES (");
                    stringBuffer.append(l + ", ");
                    stringBuffer.append("'" + string + "', '" + string2 + "', '" + dimensionDO.getName() + "', '");
                    if (string3 != null) {
                        stringBuffer.append(hierarchyDO.getName() + "', '" + levelDO.getName() + "', '" + string3 + "', ");
                    } else {
                        stringBuffer.append(hierarchyDO.getName() + "', '" + levelDO.getName() + "', null, ");
                    }
                    stringBuffer.append(levelDO.getDepth() + ", '");
                    stringBuffer.append(string4 + "', '" + string5 + "', '" + string6 + "', '");
                    if (string7 != null) {
                        stringBuffer.append(string8 + "', '" + string7 + "', ");
                    } else {
                        stringBuffer.append(string8 + "', null, ");
                    }
                    if (dimensionDO.getDimensionType() == null) {
                        stringBuffer.append("'STANDARD', ");
                    } else {
                        stringBuffer.append("'" + dimensionDO.getDimensionType() + "', ");
                    }
                    if (levelMapDO.getEndDateColumnName() == null) {
                        stringBuffer.append("null)");
                    } else {
                        object = "'END_DATE=" + levelMapDO.getEndDateColumnName() + ",TIMESPAN=" + levelMapDO.getTimeSpanColumnName() + "')";
                        stringBuffer.append((String)object);
                    }
                    try {
                        sQLParam = SQLWrapper.execute(connection, stringBuffer.toString());
                        if (!bl) continue;
                        object = new QueryManager();
                        ((QueryManager)object).commit();
                    }
                    catch (SQLException sQLException) {
                        LOG.log(Level.SEVERE, "In method writeValidateModelToValidationTable, SQL Exception occurred.", sQLException);
                    }
                }
            }
        }
        if (sQLParam != null) {
            sQLParam.closeResultSet();
        }
    }

    public void writeDimensionToValidateTable(ValidateModelDO validateModelDO, String string, String string2) {
        Connection connection = null;
        StringBuffer stringBuffer = null;
        boolean bl = true;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method writeDimensionToValidateTable, SQL Exception occurred.", sQLException);
        }
        Sequence sequence = new Sequence();
        sequence.initializeSequence();
        String string3 = validateModelDO.getName();
        SQLParam sQLParam = null;
        DimensionDO dimensionDO = validateModelDO.getDimensionDOFromName(string2);
        if (dimensionDO != null) {
            this.deleteDimensionFromValidationTable(connection, string, string3, dimensionDO.getName(), true);
            ArrayList<HierarchyDO> arrayList = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList) {
                ArrayList<LevelDO> arrayList2 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList2) {
                    Object object;
                    levelDO.setHierarchyDO(hierarchyDO);
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    String string4 = null;
                    String string5 = levelMapDO.getOwner();
                    String string6 = levelMapDO.getTableName();
                    String string7 = levelMapDO.getColumnName();
                    String string8 = levelMapDO.getParentColumnName();
                    string4 = levelDO.getParentLevelDO() != null ? levelDO.getParentLevelDO().getName() : null;
                    if (string5 == null) {
                        string5 = "";
                    }
                    if (string6 == null) {
                        string6 = "";
                    }
                    if (string7 == null) {
                        string7 = "";
                    }
                    String string9 = levelMapDO.getLongDescriptionColumnName();
                    long l = sequence.getNextSequenceValue();
                    stringBuffer = new StringBuffer("INSERT INTO OLAP_DIM_DATA_VALIDATION(");
                    stringBuffer.append("ROW_KEY, MODEL_OWNER, MODEL_NAME, DIMENSION_NAME, HIERARCHY_NAME, LEVEL_NAME, PARENT_LEVEL_NAME, DEPTH, ");
                    stringBuffer.append("TABLE_OWNER, DIMENSION_TABLE, MEMBER_COLUMN, DESCRIPTION_COLUMN, PARENT_JOIN_COLUMN, ");
                    stringBuffer.append("DIMENSION_TYPE, ATTRIBUTES) ");
                    stringBuffer.append("VALUES (");
                    stringBuffer.append(l + ", ");
                    stringBuffer.append("'" + string + "', '" + string3 + "', '" + dimensionDO.getName() + "', '");
                    if (string4 != null) {
                        stringBuffer.append(hierarchyDO.getName() + "', '" + levelDO.getName() + "', '" + string4 + "', ");
                    } else {
                        stringBuffer.append(hierarchyDO.getName() + "', '" + levelDO.getName() + "', null, ");
                    }
                    stringBuffer.append(levelDO.getDepth() + ", '");
                    stringBuffer.append(string5 + "', '" + string6 + "', '" + string7 + "', '");
                    if (string8 != null) {
                        stringBuffer.append(string9 + "', '" + string8 + "', ");
                    } else {
                        stringBuffer.append(string9 + "', null, ");
                    }
                    if (dimensionDO.getDimensionType() == null) {
                        stringBuffer.append("'STANDARD', ");
                    } else {
                        stringBuffer.append("'" + dimensionDO.getDimensionType() + "', ");
                    }
                    if (levelMapDO.getEndDateColumnName() == null) {
                        stringBuffer.append("null)");
                    } else {
                        object = "'END_DATE=" + levelMapDO.getEndDateColumnName() + ",TIMESPAN=" + levelMapDO.getTimeSpanColumnName() + "')";
                        stringBuffer.append((String)object);
                    }
                    try {
                        sQLParam = SQLWrapper.execute(connection, stringBuffer.toString());
                        object = new QueryManager();
                        ((QueryManager)object).commit();
                    }
                    catch (SQLException sQLException) {
                        LOG.log(Level.SEVERE, "In method writeDimensionToValidateTable, SQL Exception occurred.", sQLException);
                    }
                }
            }
        }
        if (sQLParam != null) {
            sQLParam.closeResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteModelFromTable(String string, String string2, boolean bl) {
        Connection connection = null;
        SQLParam sQLParam = null;
        String string3 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteModelFromTable, SQL Exception occurred.", sQLException);
        }
        string3 = "DELETE FROM OLAP_DIM_DATA_VALIDATION WHERE MODEL_OWNER = ? AND MODEL_NAME = ?";
        try {
            SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string), new SQLParam(string2)};
            sQLParam = SQLWrapper.execute(connection, string3, sQLParamArray);
            if (bl) {
                QueryManager queryManager = new QueryManager();
                queryManager.commit();
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteModelFromTable, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDimensionFromValidationTable(Connection connection, String string, String string2, String string3, boolean bl) {
        SQLParam sQLParam = null;
        String string4 = null;
        string4 = "DELETE OLAP_DIM_DATA_VALIDATION WHERE MODEL_OWNER = ? AND MODEL_NAME = ? AND DIMENSION_NAME = ?";
        SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string), new SQLParam(string2), new SQLParam(string3)};
        try {
            sQLParam = SQLWrapper.execute(connection, string4, sQLParamArray);
            if (bl) {
                QueryManager queryManager = new QueryManager();
                queryManager.commit();
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteDimensionFromValidationTable, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObsoleteModelInformationFromMainDVTable(String string, boolean bl) {
        SQLParam sQLParam = null;
        String string2 = null;
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteObsoleteModelInformationFromMainDVTable, SQL Exception occurred.", sQLException);
        }
        string2 = "DELETE OLAP_DIM_DATA_VALIDATION WHERE MODEL_OWNER IS NULL AND MODEL_NAME = ?";
        SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string)};
        try {
            sQLParam = SQLWrapper.execute(connection, string2, sQLParamArray);
            if (bl) {
                QueryManager queryManager = new QueryManager();
                queryManager.commit();
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteObsoleteModelInformationFromMainDVTable, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObsoleteModelInformationFromLastRunDVTable(String string, boolean bl) {
        SQLParam sQLParam = null;
        String string2 = null;
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteObsoleteModelInformationFromLastRunDVTable, SQL Exception occurred.", sQLException);
        }
        string2 = "DELETE OLAP_DIM_VALIDATE_LAST_RUN WHERE MODEL_OWNER IS NULL AND MODEL_NAME = ?";
        SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string)};
        try {
            sQLParam = SQLWrapper.execute(connection, string2, sQLParamArray);
            if (bl) {
                QueryManager queryManager = new QueryManager();
                queryManager.commit();
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteObsoleteModelInformationFromLastRunDVTable, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }
}

