/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.writer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.util.jdbc.SQLParam;
import oracle.olapdv.util.jdbc.SQLWrapper;
import oracle.sql.NUMBER;

public class ValidationWriter {
    private static final Logger LOG = Logger.getLogger(ValidationWriter.class.getName());

    public void writeValidateReport(ValidateModelDO validateModelDO, boolean bl) throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        String string = validateModelDO.getModelOwner();
        String string2 = validateModelDO.getName();
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method writeValidateReport, SQL Exception occurred.", sQLException);
        }
        String string3 = validateModelDO.getLastTimeValidated();
        try {
            for (DimensionDO dimensionDO : validateModelDO.getDimensionDOs()) {
                for (HierarchyDO hierarchyDO : dimensionDO.getHierarchyDOs()) {
                    for (LevelDO levelDO : hierarchyDO.getLevelDOs()) {
                        String string4 = levelDO.getOwningDimensionName();
                        String string5 = levelDO.getOwningHierarchyName();
                        String string6 = levelDO.getName();
                        int n = levelDO.getValidateReport("Distinct Members");
                        if (n == -1) continue;
                        int n2 = levelDO.getValidateReport("Distinct Members And Descriptions");
                        int n3 = levelDO.getValidateReport("Rows With Null Members");
                        int n4 = levelDO.getValidateReport("Members With Null Descriptions");
                        int n5 = levelDO.getValidateReport("Members With Multiple Descriptions");
                        int n6 = levelDO.getValidateReport("Descriptions With Multiple Members");
                        int n7 = levelDO.getValidateReport("Members With Multiple Parents");
                        int n8 = levelDO.getValidateReport("Descriptions With Multiple Parent Descriptions");
                        int n9 = levelDO.getValidateReport("Duplicate Members Across Levels");
                        String string7 = "UPDATE OLAP_DIM_DATA_VALIDATION SET   COUNT_DIST_MBR = " + n + ", COUNT_DIST_DESC = " + n2 + ", COUNT_NULL_MBR_ROWS = " + n3 + ", COUNT_NULL_DESC_ROWS = " + n4 + ", COUNT_MBR_WITH_MULT_DESC = " + n5 + ", COUNT_DESC_WITH_MULT_MBR = " + n6 + ", COUNT_MP_MBR = " + n7 + ", COUNT_MP_DESC = " + n8 + ", COUNT_NONUNIQUE_MBR = " + n9 + ", LAST_TIME_VALIDATED = '" + string3 + "' WHERE MODEL_OWNER = ? AND MODEL_NAME = ? AND DIMENSION_NAME = ? AND HIERARCHY_NAME = ? AND LEVEL_NAME = ?";
                        SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string), new SQLParam(string2), new SQLParam(string4), new SQLParam(string5), new SQLParam(levelDO.getName())};
                        sQLParam = SQLWrapper.execute(connection, string7, sQLParamArray);
                    }
                }
            }
            if (bl) {
                QueryManager queryManager = new QueryManager();
                queryManager.commit();
            }
            this.writeValidateReportLastRun(validateModelDO, bl);
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method writeValidateReport, SQL Exception occurred.", sQLException);
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    public void writeValidateReportLastRun(ValidateModelDO validateModelDO, boolean bl) {
        String string = validateModelDO.getModelOwner();
        String string2 = validateModelDO.getName();
        String[] stringArray = new String[]{"Distinct Members", "Distinct Members And Descriptions", "Duplicate Members Across Levels", "Rows With Null Members", "Members With Null Descriptions", "Members With Multiple Descriptions", "Descriptions With Multiple Members", "Members With Multiple Parents", "Descriptions With Multiple Parent Descriptions"};
        for (int i = 0; i < 9; ++i) {
            String string3 = stringArray[i];
            if (this.reportLastRunRowExists(string, string2, string3)) {
                this.updateLastTimeRunRow(string, string2, string3, validateModelDO.getReportLastTimeValidated(string3));
                continue;
            }
            this.insertLastTimeRunRow(string, string2, string3, validateModelDO.getReportLastTimeValidated(string3));
        }
        if (bl) {
            QueryManager queryManager = new QueryManager();
            queryManager.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertLastTimeRunRow(String string, String string2, String string3, String string4) {
        Connection connection = null;
        SQLParam sQLParam = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method insertLastTimeRunRow, SQL Exception occurred.", sQLException);
        }
        String string5 = "INSERT INTO OLAP_DIM_VALIDATE_LAST_RUN (model_owner, model_name, report_name, last_time_validated)  VALUES ('" + string + "', '" + string2 + "', '" + string3 + "', '" + string4 + "')";
        try {
            sQLParam = SQLWrapper.execute(connection, string5);
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method insertLastTimeRunRow, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastTimeRunRow(String string, String string2, String string3, String string4) {
        Connection connection = null;
        SQLParam sQLParam = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method updateLastTimeRunRow, SQL Exception occurred.", sQLException);
        }
        SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string), new SQLParam(string2), new SQLParam(string3)};
        String string5 = "UPDATE OLAP_DIM_VALIDATE_LAST_RUN SET LAST_TIME_VALIDATED = '" + string4 + "'  WHERE MODEL_OWNER = ? AND MODEL_NAME = ? AND REPORT_NAME = ?";
        try {
            sQLParam = SQLWrapper.execute(connection, string5, sQLParamArray);
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method updateLastTimeRunRow, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reportLastRunRowExists(String string, String string2, String string3) {
        Connection connection = null;
        SQLParam sQLParam = null;
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method reportLastRunRowExists, SQL Exception occurred.", sQLException);
        }
        SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string), new SQLParam(string2), new SQLParam(string3)};
        String string4 = "SELECT COUNT(*) FROM OLAP_DIM_VALIDATE_LAST_RUN WHERE MODEL_OWNER = ? AND MODEL_NAME = ? AND REPORT_NAME = ?";
        try {
            sQLParam = SQLWrapper.execute(connection, string4, sQLParamArray);
            OracleResultSet oracleResultSet = sQLParam.getResultSet();
            while (oracleResultSet.next()) {
                NUMBER nUMBER = oracleResultSet.getNUMBER(1);
                int n = nUMBER.intValue();
                if (n <= 0) continue;
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method reportLastRunRowExists, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteModelRowsFromLastRunTable(String string, String string2) {
        Connection connection = null;
        SQLParam sQLParam = null;
        String string3 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteModelRowsFromLastRunTable, SQL Exception occurred.", sQLException);
        }
        string3 = "DELETE FROM OLAP_DIM_VALIDATE_LAST_RUN WHERE MODEL_OWNER = ? AND MODEL_NAME = ?";
        try {
            SQLParam[] sQLParamArray = new SQLParam[]{new SQLParam(string), new SQLParam(string2)};
            sQLParam = SQLWrapper.execute(connection, string3, sQLParamArray);
            QueryManager queryManager = new QueryManager();
            queryManager.commit();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method deleteModelRowsFromLastRunTable, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }
}

