/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical;

import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraphView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorArb;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class GraphicalEditorToolbarActions {
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_Editor");
    public static final int DEFAULT_CMD_ID = Ide.findOrCreateCmdID((String)"DEFAULT_GE_ACTION_ID");
    static final int LAYOUT_CMD_ID = Ide.findOrCreateCmdID((String)"LAYOUT_GE_ACTION_ID");
    static final int READ_ONLY_MODE_CMD_ID = Ide.findOrCreateCmdID((String)"READ_ONLY_MODE_CMD_ID");
    static final int SELECT_MODE_CMD_ID = Ide.findOrCreateCmdID((String)"SELECT_MODE_GE_ACTION_ID");
    static final int PAN_MODE_CMD_ID = Ide.findOrCreateCmdID((String)"PAN_MODE_GE_ACTION_ID");
    static final int ZOOM_TO_SELECTION_MODE_CMD_ID = Ide.findOrCreateCmdID((String)"ZOOM_TO_SELECTION_MODE_GE_ACTION_ID");
    public static final int ZOOM_CMD_ID = Ide.findOrCreateCmdID((String)"ZOOM_GE_ACTION_ID");
    public static final int ZOOM_IN_CMD_ID = Ide.findOrCreateCmdID((String)"ZOOM_IN_GE_ACTION_ID");
    public static final int ZOOM_OUT_CMD_ID = Ide.findOrCreateCmdID((String)"ZOOM__OUT_GE_ACTION_ID");
    private boolean ignoreZoomChange = false;
    private ToggleToolButton roToggle;

    public void initToolBar(View view, Toolbar toolbar, final mxGraphView mxGraphView2, Controller controller, Controller controller2, Controller controller3, Controller controller4, Controller controller5, Controller controller6, Controller controller7, Controller controller8, Controller controller9, Controller controller10) {
        ButtonGroup buttonGroup = new ButtonGroup();
        IdeAction ideAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_REFRESH_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_REFRESH_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction2 = IdeAction.get((int)DEFAULT_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ACTION_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ACTION_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"extras/dropdown.png"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction3 = IdeAction.get((int)LAYOUT_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_LAYOUT_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_LAYOUT_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"layout.png"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction4 = IdeAction.get((int)READ_ONLY_MODE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_TOOLBAR_SWITCH_TO_WRITE")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_TOOLBAR_SWITCH_TO_WRITE")), (Icon)RaptorImagesArb.getIcon((String)"EDIT_CODE_BROKEN"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction5 = IdeAction.get((int)SELECT_MODE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_SELECT_MODE_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_SELECT_MODE_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"palArrow.png"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction6 = IdeAction.get((int)PAN_MODE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_PAN_MODE_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_PAN_MODE_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"pan.png"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction7 = IdeAction.get((int)ZOOM_TO_SELECTION_MODE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_TO_SELECTION_MODE_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_TO_SELECTION_MODE_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"zoom_to_selection.png"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction8 = IdeAction.get((int)ZOOM_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_BUTTON_NAME")), null, null, (boolean)true).newLocalAction(view);
        IdeAction ideAction9 = IdeAction.get((int)ZOOM_IN_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_IN_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_IN_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"zoomin.png"), null, (boolean)true).newLocalAction(view);
        IdeAction ideAction10 = IdeAction.get((int)ZOOM_OUT_CMD_ID, null, (String)StringUtils.stripMnemonic((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_OUT_BUTTON_NAME")), null, (Integer)StringUtils.getMnemonicKeyCode((String)GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_OUT_BUTTON_NAME")), (Icon)OracleIcons.getIcon((String)"zoomout.png"), null, (boolean)true).newLocalAction(view);
        if (controller != null) {
            ideAction.addController(controller);
            toolbar.add((ToggleAction)ideAction).setName("Refresh");
        }
        if (controller2 != null) {
            ideAction2.addController(controller2);
            ToolButton toolButton = toolbar.add((ToggleAction)ideAction2);
            toolButton.setName("Action");
            toolButton.setText(GraphicalEditorArb.getString("GRAPHICALEDITOR_ACTION_BUTTON_LABEL"));
            toolButton.setIcon(OracleIcons.getIcon((String)"extras/dropdown.png"));
            toolButton.setToolTipText(GraphicalEditorArb.getString("GRAPHICALEDITOR_ACTION_BUTTON_TOOLTIP"));
            ideAction2.putValue("BUTTON", (Object)toolButton);
        }
        if (controller3 != null) {
            ideAction4.addController(controller3);
            this.roToggle = new ToggleToolButton((ToggleAction)ideAction4);
            this.roToggle.setSelectedIcon(RaptorImagesArb.getIcon((String)"EDIT_CODE_BROKEN"));
            this.roToggle.setIcon(RaptorImagesArb.getIcon((String)"EDIT_CODE_WRITE"));
            this.roToggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GraphicalEditorToolbarActions.this.roToggle.isSelected()) {
                        GraphicalEditorToolbarActions.this.roToggle.setToolTipText(GraphicalEditorArb.getString("GRAPHICALEDITOR_TOOLBAR_SWITCH_TO_WRITE"));
                    } else {
                        GraphicalEditorToolbarActions.this.roToggle.setToolTipText(GraphicalEditorArb.getString("GRAPHICALEDITOR_TOOLBAR_SWITCH_TO_READ_ONLY"));
                    }
                }
            });
            toolbar.add((Component)this.roToggle, 1).setName("Edit");
        }
        if (controller4 != null) {
            ideAction3.addController(controller4);
            toolbar.add((ToggleAction)ideAction3).setName("Layout");
        }
        if (controller5 != null || controller6 != null || controller7 != null) {
            toolbar.addFiller();
        }
        if (controller5 != null) {
            ideAction5.addController(controller5);
            toolbar.addRadioButton((ToggleAction)ideAction5, buttonGroup).setName("PointerSelectMode");
        }
        if (controller6 != null) {
            ideAction6.addController(controller6);
            toolbar.addRadioButton((ToggleAction)ideAction6, buttonGroup).setName("PointerPanMode");
        }
        if (controller7 != null) {
            ideAction7.addController(controller7);
            toolbar.addRadioButton((ToggleAction)ideAction7, buttonGroup).setName("ZoomToSelectionMode");
        }
        if (controller8 != null || controller9 != null || controller10 != null) {
            toolbar.addFiller();
        }
        if (controller8 != null) {
            final JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"400%", "200%", "150%", "100%", "75%", "50%", GraphicalEditorArb.getString("GRAPHICALEDITOR_ZOOM_PAGE_LABEL")});
            jComboBox.setEditable(true);
            jComboBox.setMinimumSize(new Dimension(75, 0));
            jComboBox.setPreferredSize(new Dimension(75, 0));
            jComboBox.setMaximumSize(new Dimension(75, 100));
            jComboBox.setMaximumRowCount(9);
            jComboBox.setAction((Action)ideAction8);
            jComboBox.setName("ZoomCombo");
            ideAction8.addController(controller8);
            toolbar.add(jComboBox);
            mxEventSource.mxIEventListener mxIEventListener2 = new mxEventSource.mxIEventListener(){

                public void invoke(Object object, mxEventObject mxEventObject2) {
                    GraphicalEditorToolbarActions.this.ignoreZoomChange = true;
                    try {
                        jComboBox.setSelectedItem((int)Math.round(100.0 * mxGraphView2.getScale()) + "%");
                    }
                    finally {
                        GraphicalEditorToolbarActions.this.ignoreZoomChange = false;
                    }
                }
            };
            mxGraphView2.getGraph().getView().addListener("scale", mxIEventListener2);
            mxGraphView2.getGraph().getView().addListener("scaleAndTranslate", mxIEventListener2);
            mxIEventListener2.invoke(null, null);
        }
        if (controller9 != null) {
            ideAction9.addController(controller9);
            toolbar.add((ToggleAction)ideAction9).setName("ZoomIn");
        }
        if (ideAction10 != null) {
            ideAction10.addController(controller10);
            toolbar.add((ToggleAction)ideAction10).setName("ZoomOut");
        }
    }
}

