/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.oviewer.globalattributes;

import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridCellUpdated;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdate;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.oviewer.RowModel;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;

public class GlobalAttributesActionUpdate
implements IRaptorGridCellUpdated,
IRaptorGridUpdate {
    public static final String ROW_CURRENT_OPEN_WINDOW = "CURRENT_OPEN_WINDOW";
    public static final String ROW_DEFAULT_TIMEZONE = "DEFAULT_TIMEZONE";
    public static final String ROW_EMAIL_SENDER = "EMAIL_SENDER";
    public static final String ROW_EMAIL_SERVER = "EMAIL_SERVER";
    public static final String ROW_EVENT_EXPIRY_TIME = "EVENT_EXPIRY_TIME";
    public static final String ROW_FILE_WATCHER_COUNT = "FILE_WATCHER_COUNT";
    public static final String ROW_LAST_OBSERVED_EVENT = "LAST_OBSERVED_EVENT";
    public static final String ROW_LOG_HISTORY = "LOG_HISTORY";
    public static final String ROW_MAX_JOB_SLAVE_PROCESSES = "MAX_JOB_SLAVE_PROCESSES";
    static final String[] PROPERTIES = new String[]{"CURRENT_OPEN_WINDOW", "DEFAULT_TIMEZONE", "EMAIL_SENDER", "EMAIL_SERVER", "EVENT_EXPIRY_TIME", "FILE_WATCHER_COUNT", "LAST_OBSERVED_EVENT", "LOG_HISTORY", "MAX_JOB_SLAVE_PROCESSES"};
    private EditableGridInfo parcel = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        Connection connection = Connections.getInstance().getConnection(string);
        String string2 = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
        LockManager.lock((Connection)connection);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            RowModel rowModel = new RowModel(list, 0, 1, null);
            Map<String, Boolean> map = rowModel.getChanges();
            Map<String, Boolean> map2 = rowModel.getIsNull();
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            treeMap.put("model", rowModel);
            treeMap.put("changes", map);
            treeMap.put("isnull", map2);
            String string3 = dBMSSchedulerCodeGenerator.generate(string2, "SCHEDULER_ATTRIBUTES_UPDATE", treeMap);
            iRaptorTaskProgressUpdater.checkCanProceed();
            if (string3 == null) return 0;
            CallableStatement callableStatement = null;
            try {
                callableStatement = connection.prepareCall(string3);
                callableStatement.execute();
                if (callableStatement == null) return 0;
            }
            catch (SQLException sQLException) {
                int n;
                block9: {
                    try {
                        SQLErrorDialog.showErrorDialog((String)string, (Component)Ide.getMainWindow(), (String)SchedulerArb.getString("DB_DESTINATION_UPDATE_TITLE"), (SQLException)sQLException);
                        n = 1;
                        if (callableStatement == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (callableStatement == null) throw throwable;
                        callableStatement.close();
                        throw throwable;
                    }
                    callableStatement.close();
                }
                LockManager.unlock((Connection)connection);
                return n;
            }
            callableStatement.close();
            return 0;
        }
        finally {
            LockManager.unlock((Connection)connection);
        }
    }

    public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
        return null;
    }

    public void setGridInfo(EditableGridInfo editableGridInfo) {
        this.parcel = editableGridInfo;
    }
}

