/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractDateModifierClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ByClauseButtonPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.DatePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.FlatButton;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ByDate;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Date;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DateModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Month;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;

public class ByDateClause
extends AbstractDateModifierClause<ByDate, SortedClauseModel<ByDate>> {
    protected final Calendar calender = Calendar.getInstance();
    protected Locale locale = null;
    private final String[] months = new String[12];

    protected Date parseClauseElement(String string) {
        if ((string = string.trim()) != null && (string.length() == 4 || string.length() == 8)) {
            Integer n = null;
            Integer n2 = 1;
            Month month = Month.JAN;
            try {
                int n3 = -2;
                int n4 = 0;
                if (string.length() == 8) {
                    n = Integer.parseInt(string.substring(n3 += 2, n4 += 4));
                    n3 += 2;
                }
                month = Month.values()[Integer.parseInt(string.substring(n3 += 2, n4 += 2)) - 1];
                n2 = Integer.parseInt(string.substring(n3 += 2, n4 += 2));
                return new Date(n2, month, n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected void applyLocale(Locale locale) {
        this.locale = locale;
        Map<String, Integer> map = this.calender.getDisplayNames(2, 2, locale);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string;
            this.months[entry.getValue().intValue()] = string = entry.getKey();
        }
    }

    public ByDateClause(RepeatIntervalModel repeatIntervalModel) {
        this(ByDate.class, repeatIntervalModel);
    }

    protected ByDateClause(SortedClauseModel<ByDate> sortedClauseModel) {
        super(sortedClauseModel);
        this.applyLocale(Locale.getDefault());
    }

    protected ByDateClause(Class<ByDate> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new SortedClauseModel<ByDate>(clazz, ClauseType.BYDATE, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    public JPanel getYearPanel() {
        return this.getYearPanel(null);
    }

    public JPanel getNoYearPanel() {
        return this.getNoYearPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return this.getYearPanel(properties);
    }

    public JPanel getYearPanel(Properties properties) {
        Properties properties2 = properties != null ? properties : new Properties();
        properties2.setProperty("repeatinterval.component.ByClauseButtonPanel.hideActionButtons", "true");
        return new YearPanel(new NoYearPanel(properties2));
    }

    public JPanel getNoYearPanel(Properties properties) {
        return new NoYearPanel();
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    ArrayList<DateModifier> arrayList = new ArrayList<DateModifier>();
                    Date date = ByDateClause.this.parseClauseElement(string2 = ByDateClause.this.initialiseDateModifiers(string2, arrayList));
                    if (date == null) continue;
                    DateModifier dateModifier = null;
                    if (arrayList.size() > 0) {
                        dateModifier = (DateModifier)arrayList.get(arrayList.size() - 1);
                    }
                    ((SortedClauseModel)ByDateClause.this.clauseModel).add(new ByDate(date, dateModifier));
                }
            }
        }
    }

    protected class NoYearPanel
    extends ByClauseButtonPanel {
        public NoYearPanel(Properties properties) {
            super(properties, 1, 31, 7, "BYDATE", ByDateClause.this.months, Calendar.getInstance().get(2), "Month", null);
            ((SortedClauseModel)ByDateClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        public NoYearPanel() {
            this(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = actionEvent.getActionCommand();
            if (string.equals(this.clause)) {
                FlatButton flatButton = (FlatButton)actionEvent.getSource();
                Object object = this.getClauseElement(flatButton);
                if (object instanceof Date) {
                    ByDate byDate = new ByDate((Date)object);
                    Boolean bl = this.isButtonSelected(flatButton);
                    if (byDate != null && bl != null) {
                        if (!bl.booleanValue()) {
                            ((SortedClauseModel)ByDateClause.this.clauseModel).remove(byDate);
                        } else {
                            ((SortedClauseModel)ByDateClause.this.clauseModel).add(byDate);
                        }
                    }
                }
            } else if (string.equals("Clear")) {
                ((SortedClauseModel)ByDateClause.this.clauseModel).clear();
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            protected String getClauseElement(Date date) {
                StringBuffer stringBuffer = new StringBuffer();
                DecimalFormat decimalFormat = new DecimalFormat("00");
                DecimalFormat decimalFormat2 = new DecimalFormat("0000");
                if (date.getYear() != null) {
                    stringBuffer.append(decimalFormat2.format(date.getYear()));
                }
                stringBuffer.append(decimalFormat.format(date.getMonth() != null ? (long)(date.getMonth().ordinal() + 1) : 1L));
                stringBuffer.append(decimalFormat.format(date.getDay() != null ? (long)date.getDay().intValue() : 1L));
                return stringBuffer.toString();
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case BYDATE: {
                        Object object;
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object2 = repeatIntervalModelEvent.getNewValue();
                        Object object3 = repeatIntervalModelEvent.getOldValue();
                        if (object3 != null && !object3.getClass().isArray() && ((Date)(object = ((ByDate)repeatIntervalModelEvent.getOldValue()).getDate())).getYear() == null) {
                            NoYearPanel.this.changeButtonSelection(object, false);
                        }
                        if (object2 == null) break;
                        if (object2.getClass().isArray()) {
                            object = (ByDate[])object2;
                            Object[] objectArray = new Date[((ByDate[])object).length];
                            for (int i = 0; i < ((Object)object).length; ++i) {
                                objectArray[i] = ((ByDate)object[i]).getDate();
                            }
                            NoYearPanel.this.resetButtonSelections(objectArray);
                            break;
                        }
                        object = ((ByDate)object2).getDate();
                        if (((Date)object).getYear() != null) break;
                        NoYearPanel.this.changeButtonSelection(object, true);
                    }
                }
            }
        }
    }

    protected class YearPanel
    extends DatePanel {
        public YearPanel(ByClauseButtonPanel byClauseButtonPanel, boolean bl, Date[] dateArray) {
            super(byClauseButtonPanel, bl, dateArray);
            ((SortedClauseModel)ByDateClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        public YearPanel(boolean bl, boolean bl2, Date[] dateArray) {
            super(bl, bl2, dateArray);
            ((SortedClauseModel)ByDateClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        public YearPanel(Date[] dateArray) {
            this(false, false, dateArray);
        }

        public YearPanel(ByClauseButtonPanel byClauseButtonPanel) {
            this(byClauseButtonPanel, false, null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = actionEvent.getActionCommand();
            if (string.equals("dayOfLastMonth") || string.equals("dayOfThisMonth") || string.equals("dayOfNextMonth")) {
                FlatButton flatButton = (FlatButton)actionEvent.getSource();
                Date date = this.getClauseElement(flatButton, string);
                if (date != null) {
                    ByDate byDate = new ByDate(date);
                    Boolean bl = this.isPaintButtonSelected(flatButton);
                    if (byDate != null && bl != null) {
                        if (!bl.booleanValue()) {
                            ((SortedClauseModel)ByDateClause.this.clauseModel).remove(byDate);
                        } else {
                            ((SortedClauseModel)ByDateClause.this.clauseModel).add(byDate);
                        }
                    }
                }
            } else if (string.equals("Clear")) {
                ((SortedClauseModel)ByDateClause.this.clauseModel).clear();
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case BYDATE: {
                        Object object;
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object2 = repeatIntervalModelEvent.getNewValue();
                        Object object3 = repeatIntervalModelEvent.getOldValue();
                        if (object3 != null && !object3.getClass().isArray() && ((Date)(object = ((ByDate)repeatIntervalModelEvent.getOldValue()).getDate())).getYear() != null) {
                            YearPanel.this.changeSelection((Date)object, false);
                        }
                        if (object2 == null) break;
                        if (object2.getClass().isArray()) {
                            object = (ByDate[])object2;
                            Date[] dateArray = new Date[((ByDate[])object).length];
                            for (int i = 0; i < ((Object)object).length; ++i) {
                                dateArray[i] = ((ByDate)object[i]).getDate();
                            }
                            YearPanel.this.resetSelections(dateArray);
                            break;
                        }
                        object = ((ByDate)object2).getDate();
                        if (((Date)object).getYear() == null) break;
                        YearPanel.this.changeSelection((Date)object, true);
                    }
                }
            }
        }
    }
}

