/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.dbdestination;

import java.sql.Connection;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;

public class DBDestinationDropAction
extends ActionDialog {
    private static final String DBDEST_NAME = "name";
    private static final String DROP_MSG = "msg";
    private String dbDestName;

    public DBDestinationDropAction() {
        this.setScriptEditingEnabled(false);
    }

    protected List<ActionControl> createControls(Connection connection) {
        try {
            String string = this.getObjectName();
            this.dbDestName = "\"" + string + "\"";
        }
        catch (Exception exception) {
            return null;
        }
        try {
            String string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
            if (DBDestinationDropAction.checkNull(string) != null) {
                this.dbDestName = "\"" + string + "\"." + this.dbDestName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(DBDEST_NAME, SchedulerArb.getString("DBDESTINATION_DROP_NAME_LABEL"), this.dbDestName);
        LabelActionControl labelActionControl = new LabelActionControl(DROP_MSG, SchedulerArb.getString("DBDESTINATION_DROP_LABEL"));
        Vector<ActionControl> vector = new Vector<ActionControl>();
        textBoxActionControl.setEditable(false);
        vector.add((ActionControl)textBoxActionControl);
        vector.add((ActionControl)labelActionControl);
        return vector;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(DBDEST_NAME, this.dbDestName);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string2 = null;
        string2 = dBMSSchedulerCodeGenerator.generate(string, "DB_DESTINATION_DROP", treeMap2);
        return string2;
    }

    protected String getTitle() {
        return SchedulerArb.getString("DBDESTINATION_DROP_ACTION_TITLE");
    }

    public static String checkNull(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static String checkQuotes(String string) {
        if ((string = DBDestinationDropAction.checkNull(string)) != null && string.length() > 0) {
            string = string.replace("'", "''");
        }
        return string;
    }
}

