/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.IntervalActionControl;
import oracle.dbtools.raptor.ui.controls.OptionalActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.program.ProgramCreateAction;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;

public class ProgramTabProperties
extends ActionDialogTab {
    private String detached = "FALSE";
    private OraINTERVALDS scheduleLimit = null;
    private String maxRuns = null;
    private String maxFailures = null;
    private OraINTERVALDS maxRunDuration = null;
    private ActionControl detachedCtl = null;
    private ActionControl maxFailuresCtl = null;
    private ActionControl maxRunsCtl = null;
    private ActionControl maxRunDurationIntervalActionCtl = null;
    private ActionControl scheduleLimitActionCtl = null;
    private OptionalActionControl optionalMaxFailuresCtl = null;
    private OptionalActionControl optionalMaxRunsCtl = null;
    private OptionalActionControl optionalMaxRunDurationCtl = null;
    private OptionalActionControl optionalScheduleLimitCtl = null;
    private static final String PRIORITY = "JOB_PRIORITY";
    private static final String WEIGHT = "JOB_WEIGHT";
    private static final String MAX_RUNS = "MAX_RUNS";
    private static final String MAX_FAILURES = "MAX_FAILURES";
    private static final String MAX_RUN_DURATION = "MAX_RUN_DURATION";
    private static final String SCHEDULE_LIMIT = "SCHEDULE_LINIT";
    private static final String DETACHED = "DETACHED";

    public ProgramTabProperties(String string, String string2, DBObject dBObject, boolean bl) {
        super(string, string2);
        if (!bl) {
            this.getValuesFromDB(dBObject);
        }
    }

    private String getObjectName(DBObject dBObject) {
        return dBObject != null ? dBObject.getObjectName() : null;
    }

    private Connection getConnection(DBObject dBObject) {
        return dBObject != null ? dBObject.getConnection() : null;
    }

    private OraINTERVALDS getIntervalFromRS(OracleResultSet oracleResultSet, String string) {
        try {
            INTERVALDS iNTERVALDS = oracleResultSet.getINTERVALDS(string);
            String string2 = iNTERVALDS.stringValue();
            OraINTERVALDS oraINTERVALDS = OraINTERVALDS.getInstance((INTERVALDS)iNTERVALDS);
            string2 = oraINTERVALDS.toString();
            return oraINTERVALDS;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void setProgramDataFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                this.detached = this.getStringFromRS(resultSet, DETACHED);
                this.maxRuns = this.getStringFromRS(resultSet, MAX_RUNS);
                this.maxFailures = this.getStringFromRS(resultSet, MAX_FAILURES);
                this.maxRunDuration = this.getIntervalFromRS((OracleResultSet)resultSet, MAX_RUN_DURATION);
                this.scheduleLimit = this.getIntervalFromRS((OracleResultSet)resultSet, "SCHEDULE_LIMIT");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getValuesFromDB(DBObject dBObject) {
        block7: {
            String string = this.getObjectName(dBObject);
            Connection connection = this.getConnection(dBObject);
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_NAME", string);
                    String string2 = this.getQuery(connection, "getProgramData");
                    resultSet = dBUtil.executeOracleQuery(string2, hashMap);
                    if (resultSet != null) {
                        this.setProgramDataFromResultSet(resultSet);
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block7;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public List<ActionControl> createControls(Connection connection) {
        boolean bl = RaptorVersionTracker.checkVersion((Connection)connection, null, (Version)new Version("11.1"));
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        this.detachedCtl = new ComboBoxActionControl(DETACHED, SchedulerArb.getString("PROGRAM_DETACHED_LABEL"), new String[]{"TRUE", "FALSE"}, this.detached);
        if (bl) {
            if (this.maxRuns == null) {
                this.maxRunsCtl = new SpinnerActionControl(MAX_RUNS, SchedulerArb.getString("PROGRAM_MAX_RUNS_LABEL"), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
                this.optionalMaxRunsCtl = new OptionalActionControl(false, this.maxRunsCtl);
            } else {
                this.maxRunsCtl = new SpinnerActionControl(MAX_RUNS, SchedulerArb.getString("PROGRAM_MAX_RUNS_LABEL"), Integer.valueOf(this.maxRuns == null ? 0 : Integer.parseInt(this.maxRuns)), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
                this.optionalMaxRunsCtl = new OptionalActionControl(true, this.maxRunsCtl);
            }
            if (this.maxFailures == null) {
                this.maxFailuresCtl = new SpinnerActionControl(MAX_FAILURES, SchedulerArb.getString("PROGRAM_MAX_FAILURES_LABEL"), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
                this.optionalMaxFailuresCtl = new OptionalActionControl(false, this.maxFailuresCtl);
            } else {
                this.maxFailuresCtl = new SpinnerActionControl(MAX_FAILURES, SchedulerArb.getString("PROGRAM_MAX_FAILURES_LABEL"), Integer.valueOf(this.maxFailures == null ? 0 : Integer.parseInt(this.maxFailures)), Integer.valueOf(1), Integer.valueOf(100000), Integer.valueOf(1));
                this.optionalMaxFailuresCtl = new OptionalActionControl(true, this.maxFailuresCtl);
            }
            this.maxRunDurationIntervalActionCtl = new IntervalActionControl(MAX_RUN_DURATION, SchedulerArb.getString("PROGRAM_MAX_RUN_DURATION_LABEL"), this.maxRunDuration, true, false);
            this.optionalMaxRunDurationCtl = this.maxRunDuration != null ? new OptionalActionControl(true, this.maxRunDurationIntervalActionCtl) : new OptionalActionControl(false, this.maxRunDurationIntervalActionCtl);
            this.scheduleLimitActionCtl = new IntervalActionControl(SCHEDULE_LIMIT, SchedulerArb.getString("PROGRAM_SCHEDULE_LIMIT"), this.scheduleLimit, true, false);
            this.optionalScheduleLimitCtl = this.scheduleLimit != null ? new OptionalActionControl(true, this.scheduleLimitActionCtl) : new OptionalActionControl(false, this.scheduleLimitActionCtl);
            arrayList.add(this.detachedCtl);
            arrayList.add((ActionControl)this.optionalMaxRunsCtl);
            arrayList.add((ActionControl)this.optionalMaxFailuresCtl);
            arrayList.add((ActionControl)this.optionalMaxRunDurationCtl);
            arrayList.add((ActionControl)this.optionalScheduleLimitCtl);
        } else {
            arrayList.add(this.detachedCtl);
        }
        return arrayList;
    }

    private boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public void getScriptForProperties(ActionValuesLookup actionValuesLookup, Map<String, Object> map, Map<String, Boolean> map2, Map<String, Boolean> map3, ProgramCreateAction.Operation operation) {
        String string = actionValuesLookup.get(MAX_RUNS);
        String string2 = actionValuesLookup.get(SCHEDULE_LIMIT);
        String string3 = actionValuesLookup.get(MAX_RUN_DURATION);
        String string4 = actionValuesLookup.get(MAX_FAILURES);
        String string5 = actionValuesLookup.get(DETACHED);
        String string6 = null;
        if (this.maxRunDuration != null) {
            string6 = this.maxRunDuration.toString();
        }
        String string7 = null;
        if (this.scheduleLimit != null) {
            string7 = this.scheduleLimit.toString();
        }
        map3.put("detached", string5 == null);
        map3.put("max_runs", string == null);
        map3.put("schedule_limit", string2 == null);
        map3.put("max_run_duration", string3 == null);
        map3.put("max_failures", string4 == null);
        switch (operation) {
            case UPDATE: 
            case CREATE_NEW: {
                map2.put("detached", !this.equals(string5, this.detached));
                map2.put("max_runs", !this.equals(string, this.maxRuns));
                map2.put("schedule_limit", !this.equals(string2, string7));
                map2.put("max_run_duration", !this.equals(string3, string6));
                map2.put("max_failures", !this.equals(string4, this.maxFailures));
                break;
            }
            case CREATE_LIKE: {
                map2.put("detached", !this.equals(string5, "FALSE"));
                map2.put("max_runs", !this.equals(string, null));
                map2.put("schedule_limit", !this.equals(string2, null));
                map2.put("max_run_duration", !this.equals(string3, null));
                map2.put("max_failures", !this.equals(string4, null));
            }
        }
        map.put("detached", string5);
        map.put("max_runs", string);
        map.put("schedule_limit", string2);
        map.put("max_run_duration", string3);
        map.put("max_failures", string4);
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void initialize(Connection connection) {
        super.initialize(connection);
    }
}

