/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.wizards.job;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.wizards.AbstractWizardAction;
import oracle.dbtools.scheduler.wizards.TaskResult;
import oracle.dbtools.scheduler.wizards.job.JobArgumentsWizardPanel;
import oracle.dbtools.scheduler.wizards.job.JobDestinationWizardPanel;
import oracle.dbtools.scheduler.wizards.job.JobDetailsWizardPanel;
import oracle.dbtools.scheduler.wizards.job.JobNotificationWizardPanel;
import oracle.dbtools.scheduler.wizards.job.JobPropertiesWizardPanel;
import oracle.dbtools.scheduler.wizards.job.JobSummaryWizardPanel;
import oracle.dbtools.scheduler.wizards.job.JobWizardModel;
import oracle.ide.Ide;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.MessageDialog;

public class JobWizardAction
extends AbstractWizardAction<JobWizardModel> {
    private Dimension _bigSize = new Dimension(900, 600);

    @Override
    public boolean useBigSize() {
        return true;
    }

    @Override
    protected Dimension getBigSize() {
        return this._bigSize;
    }

    @Override
    protected boolean runDialog(JDialog jDialog) {
        ((JobWizardModel)this.getModel()).setDialog(jDialog);
        return super.runDialog(jDialog);
    }

    @Override
    public String getTitle() {
        return SchedulerArb.getString("JOB_WIZ_TITLE");
    }

    @Override
    protected Image getImage() {
        return SchedulerArb.getImage("JOB_WIZ_IMAGE");
    }

    @Override
    protected Image getLogoImage() {
        return SchedulerArb.getImage("JOB_WIZ_LOGO");
    }

    @Override
    protected FSMBuilder createFSMBuilder() {
        int n;
        FSMBuilder fSMBuilder = new FSMBuilder();
        ArrayList<Step> arrayList = new ArrayList<Step>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("DETAILS");
        arrayList.add(new Step(SchedulerArb.getString("JOB_WIZ_DETAILS_PAGE_TITLE"), JobDetailsWizardPanel.class, "f1_job_details_html"));
        if (((JobWizardModel)this.getModel()).getJobModel().FeatureMin111() && !((JobWizardModel)this.getModel()).getJobModel().FeatureisXE()) {
            arrayList2.add("DESTINATION");
            arrayList.add(new Step(SchedulerArb.getString("JOB_WIZ_DESTINATION_PAGE_TITLE"), JobDestinationWizardPanel.class, "f1_job_destination_html"));
        }
        arrayList2.add("ARGUMENTS");
        arrayList.add(new Step(SchedulerArb.getString("JOB_WIZ_ARGUMENTS_PAGE_TITLE"), JobArgumentsWizardPanel.class, "f1_job_arguments_html"));
        if (((JobWizardModel)this.getModel()).getJobModel().FeatureMin112()) {
            arrayList2.add("NOTIFICATION");
            arrayList.add(new Step(SchedulerArb.getString("JOB_WIZ_NOTIFICATION_PAGE_TITLE"), JobNotificationWizardPanel.class, "f1_job_notification_html"));
        }
        arrayList2.add("PROPERTIES");
        arrayList.add(new Step(SchedulerArb.getString("JOB_WIZ_PROPERTIES_PAGE_TITLE"), JobPropertiesWizardPanel.class, "f1_job_properties_html"));
        arrayList2.add("SUMMARY");
        arrayList.add(new Step(SchedulerArb.getString("JOB_WIZ_SUMMARY_PAGE_TITLE"), JobSummaryWizardPanel.class, "f1_job_summary_html"));
        fSMBuilder.newStartState((Step)arrayList.get(n), arrayList2.get(n + 1));
        for (n = 0; n < arrayList.size() - 1; ++n) {
            fSMBuilder.newState(arrayList2.get(n), (Step)arrayList.get(n), arrayList2.get(n + 1));
        }
        fSMBuilder.newFinalState(arrayList2.get(n), (Step)arrayList.get(n));
        return fSMBuilder;
    }

    @Override
    protected JobWizardModel createModel() {
        NewJobModel newJobModel = new NewJobModel(this.getDBObject(), NewJobModel.Operation.CREATE_NEW);
        newJobModel.setNewJobInformation();
        JobWizardModel jobWizardModel = new JobWizardModel(newJobModel);
        jobWizardModel.setConnection(this.getConnection());
        return jobWizardModel;
    }

    @Override
    protected void queueActionTask() throws TraversalException {
        RaptorTask<TaskResult> raptorTask = new RaptorTask<TaskResult>(UiResources.getString((String)"PERFORM_ACTION"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected TaskResult doWork() throws TaskException {
                TaskResult taskResult = new TaskResult();
                JobWizardAction.this.commitActionTask((JobWizardModel)JobWizardAction.this.getModel(), taskResult);
                this.setMessage(taskResult.getMessage());
                return taskResult;
            }
        };
        raptorTask.setCancellable(this.isActionTaskCancellable());
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        TaskResult taskResult = null;
        try {
            taskResult = (TaskResult)raptorTask.getResult();
        }
        catch (Exception exception) {
            taskResult = new TaskResult();
            taskResult.setStatus(false);
            taskResult.setException(exception);
            taskResult.setMessage(exception.getLocalizedMessage());
        }
        final TaskResult taskResult2 = taskResult;
        if (!taskResult.getStatus()) {
            throw new TraversalException(taskResult.getMessage() + (taskResult.getException() == null ? "" : "\n" + taskResult.getException().getMessage()), UiResources.getString((String)"ERROR_TITLE"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = taskResult2.getMessage();
                if (string != null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)UiResources.getString((String)"SUCCESS_TITLE"), null);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    protected void commitActionTask(JobWizardModel jobWizardModel, TaskResult taskResult) {
        jobWizardModel.processScript(this.getTitle(), taskResult);
    }

    @Override
    protected void cancelActionTask(JobWizardModel jobWizardModel) {
        jobWizardModel.cancelProcessScript();
    }

    @Override
    protected boolean isActionTaskBackgroundable() {
        return true;
    }

    @Override
    protected boolean isActionTaskCancellable() {
        return true;
    }

    @Override
    protected String getObjectType() {
        return "SCHNEWJOB";
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    public class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return JobWizardAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(JobWizardAction.this.getDBObject().getDBVersion(), "JOB_LIST", null);
            return RaptorQueryUtils.promoteToDba((String)string, (Connection)JobWizardAction.this.getDBObject().getConnection());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = JobWizardAction.this.getDBObject().getConnection();
            LockManager.lock((Connection)connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("JOB_NAME");
                        vector.add(string);
                    }
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            finally {
                LockManager.unlock((Connection)connection);
            }
            return vector;
        }
    }
}

