/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class IntArrayFactory
extends ObjectFactory {
    public static final IntArrayFactory INT_ARRAY_FACTORY = new IntArrayFactory();
    private static final byte INT_ARRAY_CODE = 26;

    private IntArrayFactory() {
    }

    @Override
    public byte getObjectCode() {
        return 26;
    }

    @Override
    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int len = input.readInt();
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readInt();
        }
        return array;
    }

    @Override
    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        int[] array = (int[])object;
        int len = array.length;
        output.writeInt(len);
        for (int i = 0; i < len; ++i) {
            output.writeInt(array[i]);
        }
    }
}

