/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

abstract class SideBorder
extends AbstractBorder {
    protected final Color color;
    protected final int thickness;

    protected abstract void drawBorder(Graphics var1, int var2, int var3);

    protected abstract void setInsets(Insets var1);

    SideBorder(Color color, int thickness) {
        this.color = color;
        this.thickness = thickness;
    }

    @Override
    public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(this.color);
        this.drawBorder(g, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    @Override
    public final Insets getBorderInsets(Component c) {
        return this.getBorderInsets(null, new Insets(0, 0, 0, 0));
    }

    @Override
    public final Insets getBorderInsets(Component c, Insets insets) {
        this.setInsets(insets);
        return insets;
    }

    @Override
    public final boolean isBorderOpaque() {
        return true;
    }
}

