/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareAlgorithm;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.wedge.TextLineContributor;

final class InlineCompareModel {
    private Collection _matchedLines;

    InlineCompareModel() {
    }

    public static InlineCompareModel buildModel(SequenceCompareModel model, SequenceCompareDifference selectedBlock) throws CompareFailedException {
        InlineCompareModel inlineModel = new InlineCompareModel();
        if (selectedBlock.getLength(ContributorKind.FIRST) == selectedBlock.getLength(ContributorKind.SECOND)) {
            inlineModel.buildTrivialModel(model, selectedBlock);
        } else {
            inlineModel.buildLineMatchedModel(model, selectedBlock);
        }
        return inlineModel;
    }

    private void buildLineMatchedModel(SequenceCompareModel model, SequenceCompareDifference selectedBlock) throws CompareFailedException {
        int firstLine = selectedBlock.getStart(ContributorKind.FIRST);
        int secondLine = selectedBlock.getStart(ContributorKind.SECOND);
        this._matchedLines = new ArrayList();
        block0: for (int i = firstLine; i < firstLine + selectedBlock.getLength(ContributorKind.FIRST); ++i) {
            MatchedLine match = null;
            for (int j = secondLine; j < secondLine + selectedBlock.getLength(ContributorKind.SECOND); ++j) {
                match = this.findMatch(model, i, j);
                if (match == null) continue;
                this._matchedLines.add(match);
                secondLine = j + 1;
                continue block0;
            }
        }
    }

    private MatchedLine findMatch(SequenceCompareModel model, int firstLine, int secondLine) throws CompareFailedException {
        SequenceCompareAlgorithm algorithm = new SequenceCompareAlgorithm();
        TextLineContributor firstContrib = this.createContributor(model, ContributorKind.FIRST, firstLine);
        TextLineContributor secondContrib = this.createContributor(model, ContributorKind.SECOND, secondLine);
        if (firstContrib.getLength() <= 0 || secondContrib.getLength() <= 0) {
            return null;
        }
        SequenceCompareModel tcm = (SequenceCompareModel)algorithm.compare((CompareContributor)firstContrib, (CompareContributor)secondContrib);
        int firstDiffSize = 0;
        int secondDiffSize = 0;
        SequenceCompareDifference[] diffs = tcm.getDifferenceBlocks();
        for (int i = 0; i < diffs.length; ++i) {
            SequenceCompareDifference block = diffs[i];
            firstDiffSize += block.getLength(ContributorKind.FIRST);
            secondDiffSize += block.getLength(ContributorKind.SECOND);
        }
        double firstPct = (double)firstDiffSize / (double)firstContrib.getLength();
        double secondPct = (double)secondDiffSize / (double)secondContrib.getLength();
        if (firstPct >= 0.5 || secondPct >= 0.5) {
            return null;
        }
        return new MatchedLine(firstLine, secondLine, diffs);
    }

    private void buildTrivialModel(SequenceCompareModel model, SequenceCompareDifference selectedBlock) throws CompareFailedException {
        int firstLine = selectedBlock.getStart(ContributorKind.FIRST);
        int secondLine = selectedBlock.getStart(ContributorKind.SECOND);
        SequenceCompareAlgorithm algorithm = new SequenceCompareAlgorithm();
        this._matchedLines = new ArrayList();
        for (int i = 0; i < selectedBlock.getLength(ContributorKind.FIRST); ++i) {
            TextLineContributor firstContrib = this.createContributor(model, ContributorKind.FIRST, firstLine += i);
            TextLineContributor secondContrib = this.createContributor(model, ContributorKind.SECOND, secondLine += i);
            if (firstContrib.getLength() <= 0 || secondContrib.getLength() <= 0) continue;
            SequenceCompareModel tcm = (SequenceCompareModel)algorithm.compare((CompareContributor)firstContrib, (CompareContributor)secondContrib);
            this._matchedLines.add(new MatchedLine(firstLine, secondLine, tcm.getDifferenceBlocks()));
        }
    }

    private TextLineContributor createContributor(SequenceCompareModel model, ContributorKind contributor, int line) {
        return new TextLineContributor((TextCompareContributor)model.getContributor(contributor), line);
    }

    public Collection getMatchedLines() {
        return this._matchedLines;
    }

    public static class MatchedLine {
        private int _firstContributorLine;
        private int _secondContributorLine;
        private SequenceCompareDifference[] _differences;

        MatchedLine(int firstLine, int secondLine, SequenceCompareDifference[] diffs) {
            this._firstContributorLine = firstLine;
            this._secondContributorLine = secondLine;
            this._differences = diffs;
        }

        public int getLine(ContributorKind contributor) {
            if (contributor == ContributorKind.FIRST) {
                return this._firstContributorLine;
            }
            return this._secondContributorLine;
        }

        public SequenceCompareDifference[] getDifferences() {
            return this._differences;
        }
    }
}

