/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import oracle.javatools.buffer.GuardedException;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.Log;

public abstract class BasicWriteAction
extends BasicAction {
    private static final Log LOG = new Log("status-lock");

    protected BasicWriteAction(String actionName) {
        super(actionName);
    }

    protected BasicWriteAction(String actionName, BasicAction.MultiSelectionBehavior multiSelectionBehavior) {
        super(actionName, multiSelectionBehavior);
    }

    @Override
    protected boolean actionSetup(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
        if (!super.actionSetup(event, editor, document)) {
            return false;
        }
        BasicWriteAction.makeEditable(editor);
        return BasicWriteAction.isEditable(editor, true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        LOG.trace("************ performing write action for {0}", (Object)event);
        try {
            super.actionPerformed(event);
        }
        catch (GuardedException ge) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    protected void lock(BasicDocument document) {
        document.writeLock(false);
    }

    @Override
    protected void unlock(BasicDocument document) {
        document.writeUnlock();
    }
}

