/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.php;

import oracle.javatools.editor.language.php.PHPLanguage;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.GenericLexer;
import oracle.javatools.parser.generic.Language;

public class PHPLexer
extends GenericLexer {
    static Language phpLanguage = new PHPLanguage();

    public PHPLexer() {
        this(phpLanguage);
    }

    protected PHPLexer(Language language) {
        super(language);
    }

    public int lex(LexerToken lexedToken) {
        if (this.useLastToken) {
            return super.lex(lexedToken);
        }
        int token = super.lex(lexedToken);
        switch (token) {
            case 19: {
                int bufferEnd = this.textBuffer.getLength();
                int operStart = this.startOffset;
                if (bufferEnd - operStart < 3 || this.textBuffer.getChar(operStart++) != '<' || this.textBuffer.getChar(operStart++) != '<' || this.textBuffer.getChar(operStart) != '<') break;
                int idStart = this.startOffset + 3;
                int idEnd = this.findIdentifierEnd(idStart);
                if (idStart == idEnd) {
                    return token;
                }
                this.lastToken = 14;
                int idLen = idEnd - idStart;
                char idChar = this.textBuffer.getChar(idStart);
                for (int pos = idEnd; pos < bufferEnd; ++pos) {
                    char c = this.textBuffer.getChar(pos);
                    if (c != idChar || !this.regionMatches(idStart, idEnd, pos, pos + idLen) || !this.isStartOfLine(pos) || !this.isEndOfLine(pos + idLen)) continue;
                    this.endOffset = this.currentPos = pos + idLen;
                    return this.fillLexerToken(lexedToken);
                }
                this.endOffset = this.currentPos = bufferEnd;
                return this.fillLexerToken(lexedToken);
            }
        }
        return token;
    }

    private int findIdentifierEnd(int start) {
        int end = this.textBuffer.getLength();
        for (int pos = start; pos < end; ++pos) {
            char c = this.textBuffer.getChar(pos);
            if (phpLanguage.isIdentifierCharacter(c)) continue;
            return pos;
        }
        return end;
    }

    private boolean isStartOfLine(int start) {
        int bufferEnd = this.textBuffer.getLength();
        if (start < 0 || start >= bufferEnd) {
            return false;
        }
        if (start == 0) {
            return true;
        }
        char c = this.textBuffer.getChar(start - 1);
        return c == '\n' || c == '\r';
    }

    private boolean isEndOfLine(int end) {
        int bufferEnd = this.textBuffer.getLength();
        if (end < 0 || end > bufferEnd) {
            return false;
        }
        if (end == bufferEnd) {
            return true;
        }
        char c = this.textBuffer.getChar(end);
        if (c == '\n' || c == '\r') {
            return true;
        }
        if (c == ';') {
            return this.isEndOfLine(end + 1);
        }
        return false;
    }

    private boolean regionMatches(int start1, int end1, int start2, int end2) {
        int end = this.textBuffer.getLength();
        if (end2 > end || end1 > end) {
            return false;
        }
        int len1 = end1 - start1;
        int len2 = end2 - start2;
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            char c2;
            char c1 = this.textBuffer.getChar(start1 + i);
            if (c1 == (c2 = this.textBuffer.getChar(start2 + i))) continue;
            return false;
        }
        return true;
    }
}

