/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.plsql;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.AbstractBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.generic.BraceHelper;
import oracle.javatools.parser.plsql.PlsqlTokens;
import oracle.javatools.parser.plsql.syntax.PlsqlLexer;

public final class PLSQLBraceProvider
extends AbstractBraceProvider
implements PlsqlTokens {
    private static final String[][] BRACES = new String[][]{{"(", ")"}, {"[", "]"}, {"<<", ">>"}};
    private static final String BRACE_CHARACTERS = "()[]<>";
    protected static final BraceHelper braceHelper = new BraceHelper(BRACES);
    protected TextBuffer textBuffer;

    public PLSQLBraceProvider(LanguageSupport support) {
        BasicDocument document = support.getDocument();
        this.textBuffer = document.getTextBuffer();
    }

    @Override
    protected TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    @Override
    protected BraceHelper getBraceHelper() {
        return braceHelper;
    }

    @Override
    protected Lexer getLexer() {
        return new PlsqlLexer();
    }

    @Override
    protected String getBraceCharacters() {
        return BRACE_CHARACTERS;
    }

    @Override
    protected boolean isBraceToken(int token) {
        switch (token) {
            case 78: 
            case 80: 
            case 82: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }
}

