/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class EnvironmentVariables {
    private static Map _vars = EnvironmentVariables.retrieveEnvironmentVars();

    private EnvironmentVariables() {
    }

    public static final synchronized String getVariable(String name) {
        return (String)_vars.get(name.toUpperCase());
    }

    public static final synchronized Map get() {
        return Collections.unmodifiableMap(_vars);
    }

    private static final Map retrieveEnvironmentVars() {
        try {
            return EnvironmentVariables.retrieveEnvironmentVarsImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("windows") >= 0;
    }

    private static final void writeTextFile(File file, String contents) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(contents);
        out.close();
    }

    private static final Map retrieveEnvironmentVarsImpl() throws IOException, InterruptedException {
        String[] cmd = null;
        File scriptFile = null;
        if (EnvironmentVariables.isWindows()) {
            cmd = new String[]{"cmd.exe", "/c", "set"};
        } else {
            scriptFile = File.createTempFile(".jdevenv_set", "sh");
            EnvironmentVariables.writeTextFile(scriptFile, "set");
            cmd = new String[]{"sh", scriptFile.getPath()};
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmd).getInputStream()));
        HashMap vars = new HashMap();
        String line = null;
        while ((line = in.readLine()) != null) {
            EnvironmentVariables.populateVariableMap(vars, line);
        }
        if (scriptFile != null) {
            scriptFile.delete();
        }
        return vars;
    }

    private static final void populateVariableMap(Map map, String line) {
        String name = null;
        String value = null;
        int i = line.indexOf(61);
        if (i <= 0 || i >= line.length() - 1) {
            return;
        }
        name = line.substring(0, i);
        value = line.substring(i + 1).trim();
        if (name.indexOf(32) >= 0 || value.equals("")) {
            return;
        }
        map.put(name.toUpperCase(), value);
    }
}

