/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.favoritesNavigator.FavoriteItemFactory;
import oracle.help.navigator.favoritesNavigator.FavoritesActionUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;

public class FavoritesNavigator
extends LazyNavigator {
    private static final String _DEFAULT_LABEL_ID = "addfavoriteitem.favorites";
    private static final String _DELETE_KEY = "addfavoriteitem.delete";
    private static final String _RENAME_DOT = "addfavoriteitem.renamedot";
    private static final String _NEW_FOLDER_DOT = "addfavoriteitem.newfolderdot";
    private static ResourceBundle _miscBundle;
    private FavoritesModel _favoritesModel;
    private TopicTreePane _treePane;

    public FavoritesNavigator() {
        _miscBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle", StaticLocaleContext.getLocale());
    }

    public String getDefaultLabel() {
        String defaultLabel = _miscBundle.getString(_DEFAULT_LABEL_ID);
        return defaultLabel;
    }

    @Override
    public void addViewNow(View view) {
    }

    @Override
    public void removeViewNow(View view) {
    }

    public void setFavoritesModel(FavoritesModel favoritesModel) {
        this._favoritesModel = favoritesModel;
    }

    public TopicTreeNode getCurrentSelectionNode() {
        TopicTreeItem selectedItem;
        if (this._treePane != null && (selectedItem = this._treePane.getSelectedItem()) != null) {
            return selectedItem.getTopicTreeNode();
        }
        return null;
    }

    public Topic getCurrentSelection() {
        TopicTreeItem selectedItem;
        if (this._treePane != null && (selectedItem = this._treePane.getSelectedItem()) != null) {
            return selectedItem.getTopic();
        }
        return null;
    }

    public void addTopicTreeListener(TopicTreeListener listener) {
        this._treePane.addTopicTreeListener(listener);
    }

    public void removeTopicTreeListener(TopicTreeListener listener) {
        this._treePane.removeTopicTreeListener(listener);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (this._treePane != null) {
            this._treePane.getTopicTreeComponent().setVisible(aFlag);
        }
    }

    @Override
    protected void doInitializationNow() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 1, 1, 1));
        TopicTreeNode rootTopicTreeNode = this.getFavoritesModel().getFavoritesRoot().getParent();
        TopicTreeComponent tree = new TopicTreeComponent(rootTopicTreeNode, new FavoriteItemFactory(this.getFavoritesModel()));
        tree.setPreferredItemsOnScreen(10);
        this._treePane = new TopicTreePane(tree);
        this._treePane.addTopicTreeListener(new TreePaneListener());
        this.add(this._treePane);
    }

    protected FavoritesModel getFavoritesModel() {
        return this._favoritesModel;
    }

    private class TreePaneListener
    implements TopicTreeListener,
    ActionListener {
        private JMenuItem _deleteMenuItem;
        private JMenuItem _renameMenuItem;
        private JMenuItem _newFolderMenuItem;
        private TopicTreeNode _node;

        private TreePaneListener() {
        }

        @Override
        public void topicActivated(TopicTreeItem item, boolean newWindow) {
            int mode = newWindow ? 2 : 1;
            FavoritesNavigator.this.fireTopicActivated(item.getTopic(), mode);
        }

        @Override
        public void topicSelected(TopicTreeItem item) {
            Topic selectedTopic = item == null ? null : item.getTopic();
            FavoritesNavigator.this.fireTopicSelected(selectedTopic);
        }

        @Override
        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            Topic topic;
            this._node = item.getTopicTreeNode();
            if (this._node != FavoritesNavigator.this._favoritesModel.getFavoritesRoot() && (topic = item.getTopic()) != null && topic.hasTarget()) {
                String displayNewLabel = MenuUtils.getDefaultMenuLabel("menu.Display_New");
                JMenuItem displayNew = new JMenuItem(displayNewLabel);
                displayNew.setAction(new DisplayInNewWindowAction(item));
                MenuUtils.setMenuLabelAndAccelerator(displayNew, "menu.Display_New", true);
                displayNew.setActionCommand(displayNewLabel);
                popup.add(displayNew);
                popup.add(new JPopupMenu.Separator());
            }
            String newFolderLabel = StringUtils.stripMnemonic((String)_miscBundle.getString(FavoritesNavigator._NEW_FOLDER_DOT));
            this._newFolderMenuItem = new JMenuItem(newFolderLabel);
            MenuUtils.setMenuLabelAndAccelerator(this._newFolderMenuItem, newFolderLabel, null, true);
            this._newFolderMenuItem.setActionCommand(newFolderLabel);
            this._newFolderMenuItem.addActionListener(this);
            popup.add(this._newFolderMenuItem);
            if (this._node != FavoritesNavigator.this._favoritesModel.getFavoritesRoot()) {
                String renameLabel = StringUtils.stripMnemonic((String)_miscBundle.getString(FavoritesNavigator._RENAME_DOT));
                this._renameMenuItem = new JMenuItem(renameLabel);
                MenuUtils.setMenuLabelAndAccelerator(this._renameMenuItem, renameLabel, null, true);
                this._renameMenuItem.setActionCommand(renameLabel);
                this._renameMenuItem.addActionListener(this);
                popup.add(this._renameMenuItem);
                String deleteLabel = StringUtils.stripMnemonic((String)_miscBundle.getString(FavoritesNavigator._DELETE_KEY));
                this._deleteMenuItem = new JMenuItem(deleteLabel);
                MenuUtils.setMenuLabelAndAccelerator(this._deleteMenuItem, deleteLabel, null, true);
                this._deleteMenuItem.setActionCommand(deleteLabel);
                this._deleteMenuItem.addActionListener(this);
                popup.add(this._deleteMenuItem);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this._deleteMenuItem) {
                FavoritesNavigator.this._favoritesModel.removeFavoriteItem(this._node);
            } else if (e.getSource() == this._renameMenuItem) {
                FavoritesActionUtils.renameFavoriteItem(FavoritesNavigator.this, this._node, FavoritesNavigator.this._favoritesModel);
            } else if (e.getSource() == this._newFolderMenuItem) {
                FavoritesActionUtils.createNewFolder(FavoritesNavigator.this, this._node, FavoritesNavigator.this._favoritesModel);
            }
        }

        private class DisplayInNewWindowAction
        extends AbstractAction {
            private TopicTreeItem _item;

            public DisplayInNewWindowAction(TopicTreeItem item) {
                this._item = item;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                FavoritesNavigator.this.fireTopicActivated(this._item.getTopic(), 2);
            }
        }
    }
}

