/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.searchNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.BooleanExpression;
import oracle.help.common.search.QueryStringBreaker;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;

public class SearchNavigator
extends LazyNavigator
implements ItemListener,
ActionListener {
    private static int BORDER_SIZE = 10;
    private static int SPACE_SIZE = BORDER_SIZE / 2;
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static String TYPE_SEARCH_NAVIGATOR = "oracle.help.navigator.searchNavigator.SearchNavigator";
    private static String DEFAULT_LABEL_ID = "navigator.searchNavigator.default_label";
    private static final int SEARCH_ALL_WORDS = 0;
    private static final int SEARCH_ANY_WORDS = 1;
    private static final int SEARCH_BOOLEAN = 2;
    private JComboBox _searchField;
    private JButton _searchButton;
    private JRadioButton _allRadio;
    private JRadioButton _anyRadio;
    private JRadioButton _booleanRadio;
    private JCheckBox _caseCheck;
    private JButton _openButton;
    private JLabel _status;
    private static String _inProgress;
    private static String _foundtopics;
    private static String _failed;
    private static String _searching;
    private static String _stopSearch;
    private SpreadTable _resultTable;
    private ResultTableSelectionListener _selectionListener;
    private SearchModel _searchModel;
    private SearchHistoryModel _searchHistory;
    private ArrayList _queryHandlers;
    private boolean _doingSearch;
    private boolean _showOpenButton = true;

    public Topic getCurrentSelection() {
        if (this._selectionListener != null) {
            return this._selectionListener.getSelectedTopic();
        }
        return null;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            // empty if block
        }
        super.setVisible(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            if (e.getSource() == this._openButton) {
                Topic selectedTopic = this._selectionListener.getSelectedTopic();
                if (selectedTopic != null) {
                    this.fireTopicActivated(selectedTopic);
                }
            } else {
                SearchNavigator selectedTopic = this;
                synchronized (selectedTopic) {
                    if (this._doingSearch) {
                        return;
                    }
                    this._doingSearch = true;
                }
                String searchText = null;
                Object selItem = this._searchField.getEditor().getItem();
                if (selItem != null) {
                    searchText = selItem.toString();
                }
                int searchType = 0;
                if (this._anyRadio.isSelected()) {
                    searchType = 1;
                } else if (this._booleanRadio.isSelected()) {
                    searchType = 2;
                }
                if (searchText != null && (searchText = searchText.trim()).length() > 0) {
                    UserQuery aQuery = new UserQuery(searchText, searchType, this._caseCheck.isSelected());
                    this._searchHistory.addQuery(aQuery);
                    this._searchField.setSelectedIndex(0);
                    WindowUtils.parentFrame((Component)this).setCursor(Cursor.getPredefinedCursor(3));
                    this._status.setText(_inProgress);
                    this._status.invalidate();
                    SearchWorker searcher = new SearchWorker(WindowUtils.parentFrame((Component)this), aQuery);
                    searcher.setVisible(true);
                    WindowUtils.parentFrame((Component)this).setCursor(Cursor.getPredefinedCursor(0));
                    int count = ((OHJSearchModelData)this._searchModel.getSearchModelData()).getRowCount();
                    if (count > 0) {
                        int index = _foundtopics.indexOf("%d");
                        this._status.setText(_foundtopics.substring(0, index) + count + _foundtopics.substring(index + 2));
                        try {
                            Grid resultGrid = this._resultTable.getGrid();
                            resultGrid.setSelection(new TwoDSelection(0, true));
                        }
                        catch (Exception exception) {}
                    } else {
                        this._status.setText(_failed);
                    }
                    this._status.invalidate();
                }
                this._doingSearch = false;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        UserQuery selectedQuery;
        int index;
        if (e != null && e.getStateChange() == 1 && (index = this._searchField.getSelectedIndex()) != -1 && (selectedQuery = this._searchHistory.getQuery(index)) != null) {
            this._caseCheck.setSelected(selectedQuery.getCaseSensitive());
            this._allRadio.setSelected(selectedQuery.getSearchType() == 0);
            this._anyRadio.setSelected(selectedQuery.getSearchType() == 1);
            this._booleanRadio.setSelected(selectedQuery.getSearchType() == 2);
        }
    }

    public String getDefaultLabel() {
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String defaultLabel = bundle.getString(DEFAULT_LABEL_ID);
        return defaultLabel;
    }

    public void showOpenButton(boolean visible) {
        this._showOpenButton = visible;
    }

    @Override
    protected void doInitializationNow() {
        this._searchModel = new SearchModel((SearchModelData)new OHJSearchModelData(), this.getInitialViewsArray());
        ((OHJSearchModelData)this._searchModel.getSearchModelData()).addModelListener((TwoDModelListener)new ResultTableDataListener());
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(SPACE_SIZE, BORDER_SIZE));
        mainPanel.setBorder(new EmptyBorder(BORDER_SIZE, BORDER_SIZE, BORDER_SIZE, BORDER_SIZE));
        JPanel north = new JPanel();
        north.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets.top = 0;
        c.insets.left = 0;
        this._searchField = new JComboBox();
        this._searchHistory = new SearchHistoryModel();
        this._searchField.setModel(this._searchHistory);
        this._searchField.addItemListener(this);
        this._searchField.setEditable(true);
        this._searchField.getEditor().addActionListener(this);
        JLabel label = MnemonicUtils.createLabel(bundle.getString("navigator.searchNavigator.fieldlabel"), this._searchField.getEditor().getEditorComponent());
        north.add((Component)label, c);
        c.insets.top = 5;
        c.gridwidth = -1;
        north.add((Component)this._searchField, c);
        c.insets.left = 5;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.gridwidth = 0;
        this._searchButton = MnemonicUtils.createButton(bundle.getString("navigator.searchNavigator.search"));
        this._searchButton.addActionListener(this);
        north.add((Component)this._searchButton, c);
        c.insets.top = 0;
        c.insets.left = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 0;
        this._caseCheck = MnemonicUtils.createCheckBox(bundle.getString("navigator.searchNavigator.casesensitive"));
        north.add((Component)this._caseCheck, c);
        label = MnemonicUtils.createLabel(bundle.getString("navigator.searchNavigator.searchfor"));
        north.add((Component)label, c);
        ButtonGroup group = new ButtonGroup();
        this._allRadio = MnemonicUtils.createRadioButton(bundle.getString("navigator.searchNavigator.allwords"), true);
        this._anyRadio = MnemonicUtils.createRadioButton(bundle.getString("navigator.searchNavigator.anyword"), false);
        this._booleanRadio = MnemonicUtils.createRadioButton(bundle.getString("navigator.searchNavigator.boolean"), false);
        group.add(this._allRadio);
        group.add(this._anyRadio);
        group.add(this._booleanRadio);
        north.add((Component)this._allRadio, c);
        north.add((Component)this._anyRadio, c);
        north.add((Component)this._booleanRadio, c);
        mainPanel.add((Component)north, "North");
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout(0, SPACE_SIZE));
        center.add((Component)this._createResultsList(bundle), "Center");
        label = MnemonicUtils.createLabel(bundle.getString("navigator.searchNavigator.selectinfo"), (Component)this._resultTable);
        center.add((Component)label, "North");
        mainPanel.add((Component)center, "Center");
        JPanel south = new JPanel();
        south.setLayout(new BorderLayout(SPACE_SIZE, 0));
        this._status = MnemonicUtils.createLabel("");
        south.add((Component)this._status, "Center");
        this._openButton = MnemonicUtils.createButton(bundle.getString("navigator.searchNavigator.openbutton"));
        this._openButton.setEnabled(false);
        this._openButton.addActionListener(this);
        if (this._showOpenButton) {
            south.add((Component)this._openButton, "East");
        }
        mainPanel.add((Component)south, "South");
        this.add((Component)mainPanel, "Center");
        this.validate();
        _inProgress = bundle.getString("navigator.searchNavigator.inprogress");
        _failed = bundle.getString("navigator.searchNavigator.searchfailed");
        _foundtopics = bundle.getString("navigator.searchNavigator.foundtopics");
        _searching = bundle.getString("navigator.searchNavigator.searching");
        _stopSearch = bundle.getString("navigator.searchNavigator.stopsearch");
        this._doingSearch = false;
    }

    @Override
    protected void addViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_SEARCH_NAVIGATOR)) {
            this._searchModel.addView(view);
        }
    }

    @Override
    protected void removeViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_SEARCH_NAVIGATOR)) {
            this._searchModel.removeView(view);
            this._resultTable.getGrid().setCanvasOrigin(0, 0);
        }
    }

    private JComponent _createResultsList(ResourceBundle bundle) {
        Object[] items = new String[]{bundle.getString("navigator.searchNavigator.rank"), bundle.getString("navigator.searchNavigator.topictitle"), bundle.getString("navigator.searchNavigator.source")};
        ArrayOneDModel headerDs = new ArrayOneDModel(items);
        this._resultTable = new SpreadTable((TwoDModel)((OHJSearchModelData)this._searchModel.getSearchModelData()), (OneDModel)headerDs, null);
        this._resultTable.setHorizontalSeparatorsVisible(false);
        this._resultTable.setVerticalSeparatorsVisible(false);
        this._resultTable.setScrollByRow(true);
        Header header = this._resultTable.getColumnHeader();
        header.setCanMoveItems(false);
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)((OHJSearchModelData)this._searchModel.getSearchModelData()));
        Grid grid = this._resultTable.getGrid();
        grid.setGridSelectionManager(GeneralGridSelectionManager.createSingleRowSelectionManager());
        grid.setPreferredRowsOnScreen(4);
        grid.setColumnPainter(0, (Painter)new ImagePainter(0));
        grid.setColumnPainter(1, (Painter)new TextPainter());
        grid.setDefaultInputHandler((CellInputHandler)new ResultTableInputHandler());
        TableResizer resizeListener = new TableResizer();
        this._resultTable.addResizeListener((TableResizeListener)resizeListener);
        this._resultTable.setColumnWidth(0, 100);
        this._resultTable.setColumnWidth(1, 150);
        this._resultTable.setColumnWidth(2, 100);
        this._selectionListener = new ResultTableSelectionListener();
        this._resultTable.addPropertyChangeListener((PropertyChangeListener)this._selectionListener);
        JScrollPane component = new JScrollPane((Component)this._resultTable, 22, 31);
        component.addComponentListener(resizeListener);
        return component;
    }

    private class SearchWorker
    extends JDialog
    implements Runnable,
    ActionListener {
        private boolean _done;
        private Thread _t;
        private Frame _parent;
        private JLabel _status;
        private JButton _stopButton;
        private Thread _thread;
        private UserQuery _query;

        public SearchWorker(Frame parent, UserQuery query) {
            super(parent, _searching, true);
            this.getContentPane().setLayout(new BorderLayout());
            this._parent = parent;
            this._status = new JLabel(_inProgress, 0);
            this._query = query;
            this.getContentPane().add((Component)this._status, "Center");
            DialogButtonBar south = new DialogButtonBar();
            this._stopButton = MnemonicUtils.createButton(_stopSearch);
            this._stopButton.addActionListener(this);
            south.add((Component)this._stopButton);
            this.getContentPane().add((Component)south, "South");
            this.pack();
            Dimension s = this.getSize();
            s.width += BORDER_SIZE;
            s.height += BORDER_SIZE;
            this.setSize(s.width, s.height);
            Window reference = WindowUtils.getWindow((Component)SearchNavigator.this);
            Point p = reference.getLocationOnScreen();
            Dimension ds = reference.getSize();
            this.setLocation(p.x + (ds.width - s.width) / 2, p.y + (ds.height - s.height) / 2);
            this.setResizable(false);
            this._thread = new Thread((Runnable)this, "Searching Thread");
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this._done = false;
                this._thread.start();
                if (!this._done) {
                    super.setVisible(true);
                }
            }
            super.setVisible(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                try {
                    this.wait(0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._query != null) {
                    if (this._query.getSearchType() != 2) {
                        boolean allWords = this._query.getSearchType() == 0;
                        ArrayList wordsArrayList = new ArrayList();
                        QueryStringBreaker.breakQueryString((String)this._query.getQueryText(), (Locale)StaticLocaleContext.getLocale(), wordsArrayList, (boolean)this._query.getCaseSensitive());
                        String[] words = new String[wordsArrayList.size()];
                        wordsArrayList.toArray(words);
                        SearchNavigator.this._resultTable.freezeRepaints();
                        try {
                            SearchNavigator.this._searchModel.startSearch(words, allWords, this._query.getCaseSensitive());
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            SearchNavigator.this._resultTable.unfreezeRepaints();
                        }
                    } else {
                        try {
                            SearchExpression expr = BooleanExpression.buildExpressionTree((String)this._query.getQueryText(), (boolean)this._query.getCaseSensitive());
                            if (expr == null) break block16;
                            SearchNavigator.this._resultTable.freezeRepaints();
                            try {
                                SearchNavigator.this._searchModel.startSearch(expr);
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                SearchNavigator.this._resultTable.unfreezeRepaints();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this._done = true;
            this.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e != null && e.getSource() == this._stopButton) {
                SearchNavigator.this._searchModel.stopSearch();
            }
        }
    }

    private class ResultTableInputHandler
    extends CellInputHandler {
        public void mouseClicked(MouseEvent e, Grid grid, int column, int row) {
            if (e.getClickCount() > 1) {
                ActionEvent event = new ActionEvent(SearchNavigator.this._openButton, 1001, "");
                SearchNavigator.this.actionPerformed(event);
            }
            super.mouseClicked(e, grid, column, row);
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int column, int row) {
            if (keyEvent != null) {
                if (keyEvent.getKeyCode() == 10) {
                    ActionEvent event = new ActionEvent(SearchNavigator.this._openButton, 1001, "");
                    SearchNavigator.this.actionPerformed(event);
                    keyEvent.consume();
                }
                super.keyPressed(keyEvent, grid, column, row);
            }
        }
    }

    private class ResultTableDataListener
    extends TwoDModelAdapter {
        private ResultTableDataListener() {
        }

        public void rowsRemoved(TwoDModelEvent e) {
            if (e != null) {
                int currentSel = SearchNavigator.this._selectionListener.getSelectedRowIndex();
                int start = e.getRowStartIndex();
                int count = e.getRowCount();
                if (start <= currentSel && start + count > currentSel) {
                    SearchNavigator.this._selectionListener.clearSelection();
                }
            }
        }
    }

    private class ResultTableSelectionListener
    implements PropertyChangeListener {
        private int _selectedRow = -1;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt != null && evt.getPropertyName() == "selection") {
                TwoDSelection newSel = SearchNavigator.this._resultTable.getSelection();
                this._selectedRow = newSel != null ? newSel.getSingleRow() : -1;
                if (this._selectedRow != -1) {
                    SearchNavigator.this._openButton.setEnabled(true);
                } else {
                    SearchNavigator.this._openButton.setEnabled(false);
                }
                SearchNavigator.this.fireTopicSelected(SearchNavigator.this.getCurrentSelection());
            }
        }

        public Topic getSelectedTopic() {
            if (this._selectedRow != -1) {
                return SearchNavigator.this._searchModel.getTopicForRow(this._selectedRow);
            }
            return null;
        }

        public int getSelectedRowIndex() {
            return this._selectedRow;
        }

        public void clearSelection() {
            SearchNavigator.this._openButton.setEnabled(false);
            this._selectedRow = -1;
            SearchNavigator.this.fireTopicSelected(null);
        }
    }

    private class TableResizer
    extends ComponentAdapter
    implements TableResizeListener {
        @Override
        public void componentResized(ComponentEvent event) {
            Dimension size = SearchNavigator.this._resultTable.getParent().getSize();
            int rankWidth = (int)(0.14 * (double)size.width);
            int titleWidth = (int)(0.61 * (double)size.width);
            int sourceWidth = size.width - rankWidth - titleWidth;
            SearchNavigator.this._resultTable.setColumnWidth(0, rankWidth);
            SearchNavigator.this._resultTable.setColumnWidth(1, titleWidth);
            SearchNavigator.this._resultTable.setColumnWidth(2, sourceWidth);
        }

        public void columnResizing(TableEvent e) {
        }

        public void columnResized(TableEvent e) {
            if (e != null) {
                Dimension size = SearchNavigator.this._resultTable.getSize();
                int rankWidth = SearchNavigator.this._resultTable.getColumnWidth(0);
                int titleWidth = SearchNavigator.this._resultTable.getColumnWidth(1);
                int sourceWidth = size.width - rankWidth - titleWidth;
                SearchNavigator.this._resultTable.setColumnWidth(2, sourceWidth);
            }
        }

        public void rowResizing(TableEvent e) {
        }

        public void rowResized(TableEvent e) {
        }
    }

    private class SearchHistoryModel
    extends DefaultComboBoxModel {
        SearchHistoryModel() {
        }

        void addQuery(UserQuery query) {
            if (query != null) {
                int index = super.getIndexOf(query);
                super.insertElementAt(query, 0);
                if (index >= 0) {
                    super.removeElementAt(index + 1);
                }
            }
        }

        UserQuery getQuery(int index) {
            UserQuery result = null;
            try {
                result = (UserQuery)super.getElementAt(index);
            }
            catch (Exception e) {
                result = null;
            }
            return result;
        }
    }

    private class UserQuery {
        private String _queryText;
        private int _searchType;
        private boolean _caseSensitive;

        UserQuery(String queryText, int searchType, boolean caseSensitive) {
            this._queryText = queryText;
            this._searchType = searchType;
            this._caseSensitive = caseSensitive;
        }

        String getQueryText() {
            return this._queryText;
        }

        int getSearchType() {
            return this._searchType;
        }

        boolean getCaseSensitive() {
            return this._caseSensitive;
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            try {
                UserQuery aQuery = (UserQuery)obj;
                if (this._queryText.equals(aQuery._queryText) && this._searchType == aQuery._searchType && this._caseSensitive == aQuery._caseSensitive) {
                    isEqual = true;
                }
            }
            catch (Exception e) {
                isEqual = false;
            }
            return isEqual;
        }

        public String toString() {
            return this._queryText;
        }
    }
}

