/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.tocNavigator.MergingTopicTreeNode;
import oracle.help.common.navigator.tocNavigator.TOCUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.tocNavigator.TOCItemFactory;

public class TOCNavigator
extends Navigator {
    private static String TYPE_TOCNAVIGATOR = "oracle.help.navigator.tocNavigator.TOCNavigator";
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String DEFAULT_LABEL_ID = "navigator.tocNavigator.default_label";
    private TopicTreePane _treePane;
    private MergingTopicTreeNode _rootTopicTreeNode;

    public void initNavigator(View[] initialViews) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 1, 1, 1));
        this._rootTopicTreeNode = new MergingTopicTreeNode(initialViews);
        TopicTreeComponent tree = new TopicTreeComponent((TopicTreeNode)this._rootTopicTreeNode, TOCItemFactory.getInstance());
        this._treePane = new TopicTreePane(tree);
        this.add(this._treePane);
        this.addTopicTreeListener(this._treePane);
    }

    public String getDefaultLabel() {
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String defaultLabel = bundle.getString(DEFAULT_LABEL_ID);
        return defaultLabel;
    }

    public Topic getCurrentSelection() {
        TopicTreeItem item = this._treePane.getSelectedItem();
        return item == null ? null : item.getTopic();
    }

    public TopicTreeNode getCurrentSelectionNode() {
        TopicTreeItem item = this._treePane.getSelectedItem();
        return item == null ? null : item.getTopicTreeNode();
    }

    public void addView(View view) {
        if (view != null && view.getType().equals(TYPE_TOCNAVIGATOR)) {
            this._rootTopicTreeNode.addView(view);
        }
    }

    public void removeView(View view) {
        if (view != null && view.getType().equals(TYPE_TOCNAVIGATOR)) {
            this._rootTopicTreeNode.removeView(view);
        }
    }

    public void printNavigator() {
        try {
            PrinterUtils.print((JComponent)((Object)this._treePane.getTopicTreeComponent()), null, (boolean)false, (Frame)WindowUtils.parentFrame((Component)this), (String)"OHJ Table of Contents", null, null, null, (double)1.0, (double)1.0, (double)1.0, (double)1.0);
        }
        catch (Exception e) {
            System.err.println("Error printing Navigator");
        }
    }

    public boolean selectMatchingTopic(URL url) {
        TopicTreeNode current = this.getCurrentSelectionNode();
        List views = this._rootTopicTreeNode.getContributingViews();
        TopicTreeNode node = TOCUtils.findClosestMatchingNode((TopicTreeNode)current, (URL)url, (List)views);
        return this._treePane.selectTopicTreeNode(node);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this._treePane.getTopicTreeComponent().setVisible(aFlag);
    }

    protected void addTopicTreeListener(TopicTreePane treePane) {
        treePane.addTopicTreeListener(new TreePaneListener());
    }

    protected final TopicTreePane getTopicTreePane() {
        return this._treePane;
    }

    protected final MergingTopicTreeNode getRootNode() {
        return this._rootTopicTreeNode;
    }

    private class TreePaneListener
    implements TopicTreeListener {
        private TreePaneListener() {
        }

        @Override
        public void topicActivated(TopicTreeItem item, boolean newWindow) {
            int mode = newWindow ? 2 : 1;
            TOCNavigator.this.fireTopicActivated(item.getTopic(), mode);
        }

        @Override
        public void topicSelected(TopicTreeItem item) {
            Topic selectedTopic = item == null ? null : item.getTopic();
            TOCNavigator.this.fireTopicSelected(selectedTopic);
        }

        @Override
        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            Topic topic = item.getTopic();
            if (topic != null && topic.hasTarget()) {
                String displayNewLabel = MenuUtils.getDefaultMenuLabel("menu.Display_New");
                JMenuItem displayNew = new JMenuItem(displayNewLabel);
                displayNew.setAction(new DisplayInNewWindowAction(item));
                MenuUtils.setMenuLabelAndAccelerator(displayNew, "menu.Display_New", true);
                displayNew.setActionCommand(displayNewLabel);
                popup.add(displayNew);
            }
        }

        private class DisplayInNewWindowAction
        extends AbstractAction {
            private TopicTreeItem _item;

            public DisplayInNewWindowAction(TopicTreeItem item) {
                this._item = item;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                TOCNavigator.this.fireTopicActivated(this._item.getTopic(), 2);
            }
        }
    }
}

