/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.properties;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListDataListener;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.ProblemMarker;
import oracle.ideimpl.markers.properties.MarkerProperty;
import oracle.javatools.util.ModelUtil;

public class ProblemSeverityPropertyEditor
extends InspectorPropertyEditor
implements AdapterFactory<MarkerProperty, PropertyEditorFactory2>,
ComboBoxModel {
    private ProblemMarker marker;
    private JComboBox editor;

    public ProblemSeverityPropertyEditor() {
    }

    private ProblemSeverityPropertyEditor(ProblemMarker marker) {
        this.marker = marker;
    }

    public Object getValue() {
        return this.marker.severity();
    }

    public void setValue(Object value) {
        if (!(value instanceof Number)) {
            return;
        }
        ProblemMarker.Severity severity = ProblemMarker.Severity.valueOf(((Number)value).intValue());
        if (null != severity) {
            try {
                this.marker.severity(severity.value);
                this.firePropertyChange(String.valueOf(PropertyModel.COLUMN_VALUE), null, value);
            }
            catch (MarkerException e) {
                Logger.getAnonymousLogger().log(Level.FINE, "Exception trying to set severity on marker", e);
            }
        }
    }

    public String getAsText() {
        Object value = this.getValue();
        if (!(value instanceof Number)) {
            return null;
        }
        ProblemMarker.Severity severity = ProblemMarker.Severity.valueOf(((Number)value).intValue());
        if (null == severity) {
            return null;
        }
        return severity.getName();
    }

    public void setAsText(String text) {
        ProblemMarker.Severity severity = null;
        for (ProblemMarker.Severity sev : ProblemMarker.Severity.values()) {
            if (!ModelUtil.areEqual((Object)text, (Object)sev.getName())) continue;
            severity = sev;
            break;
        }
        if (null == severity) {
            try {
                severity = ProblemMarker.Severity.valueOf(text);
            }
            catch (IllegalArgumentException e) {
                Logger.getAnonymousLogger().log(Level.FINE, "Exception trying to set severity on marker", e);
            }
        }
        if (null != severity) {
            this.setValue((Object)severity);
        }
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle r) {
    }

    public boolean hasInlineEditor() {
        return true;
    }

    public Component getInlineEditor() {
        if (null == this.editor) {
            this.initEditor();
        }
        return this.editor;
    }

    public PropertyEditorFactory2 adapt(MarkerProperty property) {
        if (ModelUtil.areEqual((Object)"severity", (Object)property.attribute.id()) && property.marker instanceof ProblemMarker) {
            return new ProblemSeverityPropertyEditor((ProblemMarker)property.marker);
        }
        return null;
    }

    private void initEditor() {
        this.editor = new JComboBox(this);
        this.editor.setRenderer(new SeverityRenderer());
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.setValue(anItem);
    }

    @Override
    public Object getSelectedItem() {
        Object value = this.getValue();
        if (!(value instanceof Number)) {
            return null;
        }
        return ProblemMarker.Severity.valueOf(((Number)value).intValue());
    }

    @Override
    public int getSize() {
        return ProblemMarker.Severity.values().length;
    }

    @Override
    public Object getElementAt(int index) {
        return ProblemMarker.Severity.values()[index];
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }

    private static class SeverityRenderer
    extends DefaultListCellRenderer {
        private SeverityRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ProblemMarker.Severity) {
                ProblemMarker.Severity severity = (ProblemMarker.Severity)((Object)value);
                comp.setIcon(severity.getIcon());
                comp.setText(severity.getName());
            }
            return comp;
        }
    }
}

