/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.unit_test.codehook.CodeHook;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.editor.CodeHookPanel;
import oracle.dbtools.unit_test.editor.ListTableModel;
import oracle.javatools.icons.OracleIcons;

public abstract class CodeHookListTableModel<T>
extends ListTableModel<T> {
    protected static final int SELECTOR = 0;
    protected CodeHookLookup _lookup;
    private static Component DUMMY_RENDERER = new JLabel();

    public CodeHookListTableModel(String[] stringArray, String[] stringArray2) {
        super(stringArray, stringArray2);
    }

    @Override
    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.getColumnModel().getColumn(0).setMaxWidth(10);
        jTable.setDefaultEditor(CodeHook.class, new CodeHookCellEditor());
        jTable.setDefaultRenderer(CodeHook.class, new CodeHookCellRenderer());
        jTable.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    public AbstractAction getRemoveSelectedAction() {
        final AbstractAction abstractAction = super.getRemoveSelectedAction();
        AbstractAction abstractAction2 = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                int n = CodeHookListTableModel.this.getSelectedRow();
                int n2 = CodeHookListTableModel.this.getSelectedRowCount();
                for (int i = 0; i < n2; ++i) {
                    int n3 = n + i;
                    Object object = CodeHookListTableModel.this.getValueAt(n3, 1);
                    if (!(object instanceof CodeHook)) continue;
                }
                if (bl) {
                    abstractAction.actionPerformed(actionEvent);
                }
            }

            @Override
            public boolean isEnabled() {
                return abstractAction.isEnabled();
            }
        };
        return abstractAction2;
    }

    class CodeHookCellRenderer
    implements TableCellRenderer {
        CodeHookCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(final JTable jTable, Object object, boolean bl, boolean bl2, final int n, int n2) {
            Border border;
            if (null == object) {
                return DUMMY_RENDERER;
            }
            final CodeHookPanel codeHookPanel = new CodeHookPanel((ICodeHook)object, CodeHookListTableModel.this._lookup);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n2 = codeHookPanel.getPreferredSize().height;
                    if (jTable.getRowHeight(n) != n2) {
                        jTable.setRowHeight(n, n2);
                    }
                }
            });
            codeHookPanel.setEditable(CodeHookListTableModel.this.isEditable());
            if (bl2 && (border = UIManager.getBorder("Table.focusCellHighlightBorder")) != null) {
                codeHookPanel.setBorder(border);
            }
            return codeHookPanel;
        }
    }

    class CodeHookCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        CodeHookPanel editor;

        CodeHookCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editor = new CodeHookPanel((ICodeHook)object, CodeHookListTableModel.this._lookup);
            this.editor.setEditable(CodeHookListTableModel.this.isEditable());
            final JTable jTable2 = jTable;
            final int n3 = n;
            final int n4 = n2;
            this.editor.addPropertyChangeListener("CODE_HOOK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jTable2.getModel().setValueAt(CodeHookCellEditor.this.editor.getCodeHook(), n3, n4);
                }
            });
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor == null ? null : this.editor.getCodeHook();
        }
    }
}

