/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.controls.celleditor.PairElement;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.editor.LookupDetailTableModel;
import oracle.dbtools.unit_test.editor.ScrollableJPanel;
import oracle.dbtools.unit_test.editor.UtLookupEditor;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupNode;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLookupItem;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class LookupDetails
extends JPanel {
    private static final long serialVersionUID = 1L;
    private PairElement _category;
    private PairElement _datatype;
    private UtLookupEditor _editor;
    private JTable _table;
    private LookupDetailTableModel _tm;
    private boolean _unsavedChanges;
    private List<Action> _actions = new ArrayList<Action>();
    private Toolbar _toolbar;
    private JPanel _panelCenter = new ScrollableJPanel();
    private JScrollPane _scrollPane = new JScrollPane(this._panelCenter);
    private boolean _initialized;

    public LookupDetails(UtLookupEditor utLookupEditor, UtLookupNode utLookupNode) {
        this._editor = utLookupEditor;
        this._category = utLookupNode.getCategoryPair();
        this._datatype = utLookupNode.getDatatypePair();
    }

    public PairElement getCategory() {
        return this._category;
    }

    public PairElement getDatatype() {
        return this._datatype;
    }

    public void updateUI(PairElement pairElement, PairElement pairElement2) {
        this.setInitialized(false);
        this._category = pairElement;
        this._datatype = pairElement2;
        this.removeAll();
        this.invalidate();
        this.setLayout(new BorderLayout());
        this._toolbar = this._editor.getToolbar();
        this.add((Component)this._toolbar, "North");
        this._panelCenter.removeAll();
        this._panelCenter.setLayout(new GridBagLayout());
        this._actions.clear();
        JButton jButton = new JButton();
        AbstractAction abstractAction = this.getAddRowAction();
        jButton.setAction(abstractAction);
        jButton.setName("ListTable.Add");
        this._actions.add(abstractAction);
        JButton jButton2 = new JButton();
        abstractAction = this.getRemoveRowAction();
        jButton2.setAction(abstractAction);
        jButton2.setName("ListTable.Remove");
        this._actions.add(abstractAction);
        this._panelCenter.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 10), 0, 0));
        this._panelCenter.add((Component)jButton2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0));
        this._tm = new LookupDetailTableModel();
        this._tm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                LookupDetails.this.markDirty(true);
            }
        });
        this._tm.loadTableModel(this._category.getName(), this._datatype.getName());
        this._table = new JTable(this._tm){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                TableCellEditor tableCellEditor = null;
                DataValue dataValue = (DataValue)LookupDetails.this._tm.getValueAt(n, n2);
                if (null != dataValue) {
                    tableCellEditor = UiUtils.getTableCellEditor(dataValue);
                }
                return tableCellEditor;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                TableCellRenderer tableCellRenderer = null;
                DataValue dataValue = (DataValue)LookupDetails.this._tm.getValueAt(n, n2);
                if (null != dataValue) {
                    tableCellRenderer = UiUtils.getTableCellRenderer(dataValue);
                }
                if (null == tableCellRenderer) {
                    tableCellRenderer = super.getCellRenderer(n, n2);
                }
                return tableCellRenderer;
            }
        };
        this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LookupDetails.this.toggleButtons();
            }
        });
        this._panelCenter.add((Component)this._table, new GridBagConstraints(1, 1, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._scrollPane, "Center");
        this.validate();
        this.repaint();
        this.setEditable(this._editor.isEditable());
        this.setInitialized(true);
    }

    void setEditable(boolean bl) {
        if (null != this._tm) {
            this._tm.setTableEditable(bl);
        }
        if (!bl && null != this._table && null != this._table.getCellEditor()) {
            this._table.getCellEditor().cancelCellEditing();
        }
        this.toggleButtons();
    }

    private void toggleButtons() {
        View.updateToolbarActions((Toolbar)this._editor.getToolbar());
        for (Action action : this._actions) {
            action.setEnabled(action.isEnabled());
        }
    }

    void commit() throws ObjectUpdateException {
        boolean bl = true;
        if (null != this._table && null != this._table.getCellEditor()) {
            bl = this._table.getCellEditor().stopCellEditing();
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
        this.saveLookup();
    }

    private void saveLookup() throws ObjectUpdateException {
        if (this._unsavedChanges) {
            if (null != this._tm) {
                this._tm.saveTableModel();
            }
            this._unsavedChanges = false;
            this.toggleButtons();
        }
    }

    void rollback() {
        this.revertLookups();
    }

    private void revertLookups() {
        if (this._unsavedChanges) {
            this._unsavedChanges = false;
            if (null != this._tm) {
                this.updateUI(this._category, this._datatype);
            }
        }
    }

    private boolean isInitialized() {
        return this._initialized;
    }

    private void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    private void markDirty(boolean bl) {
        if (this.isInitialized()) {
            this._editor.markDirty(bl);
            this._unsavedChanges = bl;
            this.toggleButtons();
        }
    }

    public AbstractAction getRemoveRowAction() {
        AbstractAction abstractAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookupDetails.this.removeSelected();
            }

            @Override
            public boolean isEnabled() {
                return LookupDetails.this._editor.isEditable() && 0 < LookupDetails.this._table.getSelectedRowCount();
            }
        };
        return abstractAction;
    }

    private void removeSelected() {
        int[] nArray = this._table.getSelectedRows();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            arrayList.add(n);
        }
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            this._tm.removeRow(n);
        }
    }

    public AbstractAction getAddRowAction() {
        AbstractAction abstractAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookupDetails.this.addRow();
            }

            @Override
            public boolean isEnabled() {
                return LookupDetails.this._editor.isEditable();
            }
        };
        return abstractAction;
    }

    private void addRow() {
        DataTypeConnectionProvider dataTypeConnectionProvider = UtAddin.getDataTypeConnectionProvider();
        DataTypeFactory dataTypeFactory = dataTypeConnectionProvider.getDataTypeFactory();
        Map map = dataTypeFactory.getSupportedTypeMetadata(dataTypeConnectionProvider);
        TypeMetadata typeMetadata = (TypeMetadata)map.get(this._datatype.getName());
        DataType dataType = dataTypeFactory.getDataType(dataTypeConnectionProvider, typeMetadata);
        DataValue dataValue = dataType.getDataValue(null);
        UtLookupItem utLookupItem = new UtLookupItem(this._category.getID(), this._datatype.getName(), String.valueOf(dataType.getSqlDataType(ValueType.DEFAULT)), UUID.randomUUID().toString(), this._datatype.getID(), dataValue);
        this._tm.addRow(utLookupItem);
    }
}

