/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.controls.grid.ResultSetTableCellRenderer;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.editor.ResultsTreeNode;
import oracle.dbtools.unit_test.editor.ResultsTreeTableModel;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Ide;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public abstract class ResultsTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTreeTable _table;
    private ResultsTreeTableModel _model;
    private boolean _initialized;

    public void updateUI(UtTest utTest) {
        this.init();
        this._model.updateContent(utTest);
        this.repaint();
        this.initColumnWidths();
        this.expandTree();
    }

    public void updateUI(UtSuite utSuite) {
        this.init();
        this._model.updateContent(utSuite);
        this.repaint();
        this.initColumnWidths();
        this.expandTree();
    }

    protected abstract Toolbar getToolbar();

    private void init() {
        if (this._initialized) {
            return;
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        Toolbar toolbar = this.getToolbar();
        if (null != toolbar) {
            this.add((Component)toolbar, "North");
        }
        this._model = new ResultsTreeTableModel();
        this._table = new JTreeTable((TreeTableModel)this._model);
        this._table.setAutoResizeMode(0);
        this._table.setCellSelectionEnabled(true);
        this._table.setColumnSelectionAllowed(true);
        this._table.setRowSelectionAllowed(true);
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)new SingleLineStringRenderer());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    ResultsTreePanel.this.popupCurrentCell(mouseEvent.getPoint());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ResultsTreePanel.this.showContextMenu(mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ResultsTreePanel.this.showContextMenu(mouseEvent.getPoint());
                }
            }
        };
        this._table.addMouseListener((MouseListener)mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane((Component)this._table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JTree jTree = this._table.getTree();
        jTree.setCellRenderer(new NodeRenderer());
        jTree.setShowsRootHandles(false);
        Color color = this._table.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        this.expandTree();
        this.initColumnWidths();
        this.add((Component)jScrollPane, "Center");
        this.validate();
        this.repaint();
        this._initialized = true;
    }

    private void purgeTestResult(String string) {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_DELETE_RESULT"), (String)UtAddinArb.getString("DELETE_RESULT_TITLE"), null, (boolean)true)) {
            return;
        }
        UtUtils.purgeTestResult(string);
        this._model.updateContent();
        this.expandTree();
    }

    private void purgeSuiteResult(String string) {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_DELETE_RESULT"), (String)UtAddinArb.getString("DELETE_RESULT_TITLE"), null, (boolean)true)) {
            return;
        }
        UtUtils.purgeSuiteResult(string);
        this._model.updateContent();
        this.expandTree();
    }

    private void showContextMenu(Point point) {
        Object object;
        TreePath treePath;
        int n = this._table.columnAtPoint(point);
        if (n == 0 && (treePath = this._table.getTree().getClosestPathForLocation(point.x, point.y)) != null && (object = treePath.getLastPathComponent()) instanceof ResultsTreeNode) {
            ResultsTreeNode resultsTreeNode = (ResultsTreeNode)object;
            final String string = resultsTreeNode.getTestResultId();
            if (string != null) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(UtAddinArb.getString("DELETE_RESULT"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultsTreePanel.this.purgeTestResult(string);
                    }
                });
                jPopupMenu.add(jMenuItem);
                jPopupMenu.show((Component)this._table, point.x, point.y);
            } else {
                final String string2 = resultsTreeNode.getSuiteResultId();
                if (string2 != null) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(UtAddinArb.getString("DELETE_RESULT"));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ResultsTreePanel.this.purgeSuiteResult(string2);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show((Component)this._table, point.x, point.y);
                }
            }
        }
    }

    private void popupCurrentCell(Point point) {
        int n = this._table.columnAtPoint(point);
        if (n == 3) {
            int n2 = this._table.rowAtPoint(point);
            String string = null;
            Object object = this._table.getValueAt(n2, n);
            if (object != null) {
                string = object.toString();
            }
            UtUtils.popupMessage((Component)this._table, UiArb.getString("RESULTS_MESSAGE"), string);
        }
    }

    public void expandTree() {
        JTree jTree = this._table.getTree();
        TreePath treePath = jTree.getPathForRow(0);
        jTree.collapsePath(treePath);
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath2 = jTree.getPathForRow(i);
            jTree.expandPath(treePath2);
        }
        jTree.expandPath(treePath);
    }

    public void initColumnWidths() {
        this._table.getColumnModel().getColumn(0).setPreferredWidth(320);
        this._table.getColumnModel().getColumn(3).setPreferredWidth(600);
        this._table.getColumnModel().setColumnMargin(10);
    }

    class SingleLineStringRenderer
    extends ResultSetTableCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        SingleLineStringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = object == null ? "" : object.toString();
            try {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                String string2 = bufferedReader.readLine();
                int n3 = string2.length();
                if (n3 > 120) {
                    n3 = 117;
                }
                string2 = string2.substring(0, n3);
                if (n3 < string.length()) {
                    string2 = string2 + "...";
                }
                string = string2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.getTableCellRendererComponent(jTable, (Object)string, bl, bl2, n, n2);
        }
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        NodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ResultsTreeNode) {
                ResultsTreeNode resultsTreeNode = (ResultsTreeNode)object;
                String string = resultsTreeNode.getStatus();
                if (null == string) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"unit_test.png"));
                } else if ("UT_RUNNING".equals(string)) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"run.png"));
                } else if ("UT_ERROR".equals(string)) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"error.png"));
                } else if ("UT_SUCCESS".equals(string)) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
                } else if ("UT_WARNING".equals(string)) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
                } else if ("".equals(string)) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"unit_test_ignored.png"));
                }
            } else {
                jLabel.setText(object == null ? "" : object.toString());
                jLabel.setForeground(Color.RED);
                String string = "Internal: Unexpected node type: " + object;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string);
            }
            return jLabel;
        }
    }
}

