/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.UtDataTypeConnectionReference;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.locking.LockManager;
import oracle.dbtools.unit_test.navigator.nodes.UtDefaultElement;
import oracle.dbtools.unit_test.navigator.nodes.UtEditorNode;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public abstract class UtEditor
extends Editor
implements Dirtyable {
    private JPanel _panel = new JPanel();
    private ShutdownHook myShutdownHook = new ShutdownHook(){

        public boolean canShutdown() {
            return UtEditor.this.canUpdateContent();
        }

        public void shutdown() {
        }
    };
    private ChangeListener myKeystrokeChangeListener;
    private IdeAction _pinAction;
    private Icon _pinIcon;
    private Icon _pinnedIcon;
    private static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"UnitTestEditor.Pin");
    private boolean _pinned;
    private IdeAction _refreshAction;
    private static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"UnitTestEditor.Refresh");
    private IdeAction _runAction;
    static final int RUN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"UnitTestEditor.Run");
    private IdeAction _debugAction;
    private static final int DEBUG_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"UnitTestEditor.Debug");
    private boolean _haveEditLock = false;
    private IdeAction _editAction;
    private static final int EDIT_CMD_ID = Ide.findOrCreateCmdID((String)"UnitTestEditor.Edit");
    private IdeAction _commitAction;
    private static final int COMMIT_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"UnitTestEditor.Commit");
    private IdeAction _rollbackAction;
    private static final int ROLLBACK_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"UnitTestEditor.Rollback");
    private String _dataConnectionQualName;
    protected static final String DB_QUAL_NAME = "DB_QUAL_NAME";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    public static final String ACCEL_FILE = "/oracle/dbtools/unit_test/editor/accelerators.xml";
    private boolean updatingKeyMap;

    protected JPanel getEditorPanel() {
        return this._panel;
    }

    public UtEditor() {
        this.initializeUtEditorAttributes();
    }

    protected abstract void init();

    public final void open() {
        ExitCommand.addShutdownHook((ShutdownHook)this.myShutdownHook);
        if (null == this._dataConnectionQualName) {
            this.setDataConnectionQualName(UtAddin.getDataTypeConnectionReference().peekConnectionQualName());
        }
        final KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this.myKeystrokeChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == keyStrokeOptions) {
                    UtEditor.this.updateKeyMap(keyStrokeOptions);
                }
            }
        };
        keyStrokeOptions.addChangeListener(this.myKeystrokeChangeListener);
        this.updateKeyMap(keyStrokeOptions);
        this.init();
    }

    public void close() {
        this.handlePendingEdits();
        this.releaseEditLock();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        keyStrokeOptions.removeChangeListener(this.myKeystrokeChangeListener);
        ExitCommand.removeShutdownHook((ShutdownHook)this.myShutdownHook);
        super.close();
    }

    public final Component getGUI() {
        return this.getEditorPanel();
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public boolean isDirty() {
        return this.getEditorNode().isDirty();
    }

    public void markDirty(boolean bl) {
        this.getEditorNode().markDirty(bl);
    }

    protected IdeAction getPinToggleAction() {
        if (null == this._pinAction) {
            this._pinIcon = OracleIcons.getIcon((String)"pin.png");
            this._pinnedIcon = RaptorImagesArb.getIcon((String)"PINNED");
            this._pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID).newLocalAction((View)this);
            this.setupAcceleratorToolTip(this._pinAction);
            this._pinAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (PIN_EDITOR_CMD_ID == n) {
                        UtEditor.this.setPinned(!UtEditor.this.isPinned());
                        ideAction.setState(UtEditor.this.isPinned());
                        this.update(ideAction, context);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (PIN_EDITOR_CMD_ID == n) {
                        if (UtEditor.this.isPinned()) {
                            ideAction.putValue("SmallIcon", (Object)UtEditor.this._pinnedIcon);
                        } else {
                            ideAction.putValue("SmallIcon", (Object)UtEditor.this._pinIcon);
                        }
                        return true;
                    }
                    return false;
                }
            });
            this._pinAction.setState(this.isPinned());
            this._pinAction.updateAction();
        }
        return this._pinAction;
    }

    private void setPinned(boolean bl) {
        this._pinned = bl;
    }

    public boolean isPinned() {
        return this._pinned;
    }

    protected IdeAction getRefreshAction() {
        if (null == this._refreshAction) {
            this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID).newLocalAction((View)this);
            this.setupAcceleratorToolTip(this._refreshAction);
            this._refreshAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (REFRESH_EDITOR_CMD_ID == n) {
                        UtEditor.this.refresh();
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return REFRESH_EDITOR_CMD_ID == n;
                }
            });
        }
        return this._refreshAction;
    }

    protected void run(String string) {
    }

    public IdeAction getRunAction() {
        return this._runAction;
    }

    protected IdeAction getRunAction(String string) {
        if (null == this._runAction) {
            this._runAction = IdeAction.get((int)RUN_EDITOR_CMD_ID).newLocalAction((View)this);
            this._runAction.setName(string);
            this.setupAcceleratorToolTip(this._runAction);
            this._runAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (RUN_EDITOR_CMD_ID == n) {
                        if (UtEditor.this.canUpdateContent()) {
                            UtEditor.this.run(UtEditor.this.getDataConnectionQualName());
                        }
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return RUN_EDITOR_CMD_ID == n;
                }
            });
        }
        return this._runAction;
    }

    protected void debug(String string) {
    }

    protected IdeAction getDebugAction() {
        if (null == this._debugAction) {
            this._debugAction = IdeAction.get((int)DEBUG_EDITOR_CMD_ID).newLocalAction((View)this);
            this.setupAcceleratorToolTip(this._debugAction);
            this._debugAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (DEBUG_EDITOR_CMD_ID == n) {
                        String string;
                        if (UtEditor.this.canUpdateContent() && null != (string = UtEditor.this.getDataConnectionQualName())) {
                            UtEditor.this.debug(string);
                        }
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return DEBUG_EDITOR_CMD_ID == n;
                }
            });
        }
        return this._debugAction;
    }

    protected void obtainEditLock() {
        if (LockManager.getInstance().lock(UtAddin.getRepositoryManager().getConnection(), this.getElementId())) {
            this.setHaveEditLock(true);
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)UiArb.getString("CANT_GET_LOCK"), (String)UiArb.getString("CANT_GET_LOCT_TITLE"), (String)"f1_unabletogetlock_html");
        }
    }

    protected void releaseEditLock() {
        if (this.haveEditLock() && LockManager.getInstance().unlock(UtAddin.getRepositoryManager().getConnection(), this.getElementId())) {
            this.setHaveEditLock(false);
        }
    }

    protected boolean haveEditLock() {
        return this._haveEditLock;
    }

    protected void setHaveEditLock(boolean bl) {
        this._haveEditLock = bl;
    }

    boolean isEditable() {
        return this.haveEditLock();
    }

    protected IdeAction getEditAction() {
        if (null == this._editAction) {
            this._editAction = IdeAction.get((int)EDIT_CMD_ID).newLocalAction((View)this);
            this.setupAcceleratorToolTip(this._editAction);
            this._editAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (EDIT_CMD_ID == n) {
                        UtEditor.this.refresh();
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (EDIT_CMD_ID == n) {
                        ideAction.setEnabled(!UtEditor.this.isEditable());
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._editAction;
    }

    protected IdeAction getCommitAction() {
        if (null == this._commitAction) {
            this._commitAction = IdeAction.get((int)COMMIT_CHANGES_CMD_ID).newLocalAction((View)this);
            this.setupAcceleratorToolTip(this._commitAction);
            this._commitAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (COMMIT_CHANGES_CMD_ID == n) {
                        UtEditor.this.doCommit();
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (COMMIT_CHANGES_CMD_ID == n) {
                        ideAction.setEnabled(UtEditor.this.isEditable() && UtEditor.this.isDirty());
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._commitAction;
    }

    protected IdeAction getRollbackAction() {
        if (null == this._rollbackAction) {
            this._rollbackAction = IdeAction.get((int)ROLLBACK_CHANGES_CMD_ID).newLocalAction((View)this);
            this.setupAcceleratorToolTip(this._rollbackAction);
            this._rollbackAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (ROLLBACK_CHANGES_CMD_ID == n) {
                        if (UtEditor.this.isDirty()) {
                            UtEditor.this.doRollback();
                        } else {
                            UtEditor.this.releaseEditLock();
                            UtEditor.this.obtainEditLock();
                            UtEditor.this.editorShown();
                        }
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (ROLLBACK_CHANGES_CMD_ID == n) {
                        ideAction.setEnabled(UtEditor.this.isEditable() && UtEditor.this.isDirty());
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._rollbackAction;
    }

    protected String getDataConnectionQualName() {
        return this._dataConnectionQualName;
    }

    public void setDataConnectionQualName(String string) {
        if (!this.areEqual(string, this._dataConnectionQualName)) {
            String string2 = this._dataConnectionQualName;
            this._dataConnectionQualName = string;
            UtDataTypeConnectionReference utDataTypeConnectionReference = UtAddin.getDataTypeConnectionReference();
            if (null == utDataTypeConnectionReference.peekConnectionQualName()) {
                utDataTypeConnectionReference.setConnectionQualName(this._dataConnectionQualName);
            }
            this.firePropertyChange(DB_QUAL_NAME, string2, this._dataConnectionQualName);
        }
    }

    private boolean areEqual(Object object, Object object2) {
        if (null == object) {
            return null == object2;
        }
        return object.equals(object2);
    }

    protected void switchDataConnection(String string) {
        this.setDataConnectionQualName(string);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void addConnectionCombo(Toolbar toolbar) {
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        toolbar.add((Component)jPanel);
        jPanel.setVisible(false);
        toolbar.add(Box.createHorizontalStrut(10));
        DBConnectionComboBox dBConnectionComboBox = new DBConnectionComboBox();
        dBConnectionComboBox.setCurrentConnection(this._dataConnectionQualName);
        this.addPropertyChangeListener(DB_QUAL_NAME, new DataTypeConnectionListener(dBConnectionComboBox));
        JComboBox jComboBox = dBConnectionComboBox.getJComboBox();
        jComboBox.addItemListener(new ConnComboListener(dBConnectionComboBox));
        UiUtils.nameForQA(jComboBox, "DataConnection", new String[0]);
        toolbar.add((Component)jComboBox);
    }

    public UtEditorNode getEditorNode() {
        return (UtEditorNode)this.getContext().getNode();
    }

    public UtDefaultElement getElementNode() {
        return this.getEditorNode().getElement();
    }

    public String getElementId() {
        return this.getElementNode().getId();
    }

    public String getElementName() {
        return this.getElementNode().getName();
    }

    protected abstract void commit() throws ObjectUpdateException;

    private void doCommit() {
        try {
            this.commit();
            this.releaseEditLock();
            this.markDirty(false);
            this.obtainEditLock();
            this.editorShown();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, UtUtils.asString(exception));
        }
    }

    protected abstract void rollback();

    private void doRollback() {
        try {
            this.releaseEditLock();
            this.rollback();
            this.markDirty(false);
            this.obtainEditLock();
            this.editorShown();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, UtUtils.asString(exception));
        }
    }

    public void refresh() {
        try {
            this.releaseEditLock();
            this.updateContent(false);
            this.markDirty(false);
            this.obtainEditLock();
            this.editorShown();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, UtUtils.asString(exception));
        }
    }

    protected abstract void updateContent(boolean var1);

    public boolean canUpdateContent() {
        boolean bl = true;
        try {
            this.stopEditing();
        }
        catch (Exception exception) {
            bl = false;
        }
        if (this.isDirty()) {
            int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)UtAddinArb.format("UNSAVED_INFO", this.getElementName()), (String)UtAddinArb.getString("UNSAVED_TITLE"), null, (boolean)true);
            switch (n) {
                case 1: {
                    this.doCommit();
                    break;
                }
                case 0: {
                    this.doRollback();
                    break;
                }
                case -1: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected void stopEditing() {
    }

    private void handlePendingEdits() {
        if (UtAddin.isReposPingable() && this.isDirty()) {
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.format("UNSAVED_INFO", this.getElementName()), (String)UtAddinArb.getString("UNSAVED_TITLE"), null)) {
                this.doCommit();
            } else {
                this.doRollback();
            }
        }
    }

    private void setupAcceleratorToolTip(IdeAction ideAction) {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(UtEditor.getKeyStrokeContext());
        List list = keyStrokeMap.getKeyStrokesFor(ideAction.getCommandId());
        if (list != null && list.size() > 0) {
            KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(" (");
            for (int i = 0; i < keyStrokes.getLength(); ++i) {
                KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                if (keyStroke == null) continue;
                String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append("+");
                }
                stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                ideAction.putValueDirectly("AcceleratorKey", (Object)keyStroke);
            }
            stringBuffer.append(")");
            ideAction.putValueDirectly("last-tooltip-suffix", (Object)stringBuffer.toString());
            this.getEditorPanel().getActionMap().put(ideAction.getCommandId(), (Action)ideAction);
        }
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        this.updateKeyMap(this.getEditorPanel(), keyStrokeOptions);
    }

    private void updateKeyMap(JComponent jComponent, KeyStrokeOptions keyStrokeOptions) {
        if (!this.updatingKeyMap) {
            this.updatingKeyMap = true;
            MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)UtEditor.getKeyStrokeContext());
            jComponent.setInputMap(1, (InputMap)multiInputMap);
            this.updatingKeyMap = false;
        }
    }

    private static KeyStrokeContext getKeyStrokeContext() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        return keyStrokeContextRegistry.getContext(ACCEL_FILE);
    }

    private static void registerKeyStrokeContext(KeyStrokeOptions keyStrokeOptions) {
        KeyStrokeContext keyStrokeContext = UtEditor.getKeyStrokeContext();
        keyStrokeOptions.removeContext(keyStrokeContext);
        keyStrokeOptions.addContext(keyStrokeContext);
        keyStrokeOptions.solvePostponedMaps();
    }

    private void initializeUtEditorAttributes() {
        this.setEditorAttribute("scrollable", Boolean.FALSE);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_unittesting_html");
    }

    static {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        UtEditor.registerKeyStrokeContext(keyStrokeOptions);
    }

    private class DataTypeConnectionListener
    implements PropertyChangeListener {
        private DBConnectionComboBox _combo;

        public DataTypeConnectionListener(DBConnectionComboBox dBConnectionComboBox) {
            this._combo = dBConnectionComboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = (String)propertyChangeEvent.getNewValue();
            this._combo.setCurrentConnection(string);
        }
    }

    private class ConnComboListener
    implements ItemListener {
        private DBConnectionComboBox _combo;

        public ConnComboListener(DBConnectionComboBox dBConnectionComboBox) {
            this._combo = dBConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    String string = (String)itemEvent.getItem();
                    UtEditor.this.switchDataConnection(string);
                    if (string.equals(this._combo.getCurrentConnectionName())) break;
                    this._combo.setCurrentConnection(string);
                    break;
                }
            }
        }
    }
}

