/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator;

import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.navigator.UtNavigatorContextMenu;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.navigator.tree.UtNavigatorTreeNode;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;

public class UtNavigatorWindow
extends NavigatorWindow {
    private NavigatorTreeNode handlerParentNode;
    private AsynchronousLoadHandler handler;

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_unittesting_html");
    }

    UtNavigatorWindow(ViewId viewId) {
        super(viewId);
    }

    protected void initCustomItems() {
        NavigatorTree navigatorTree = this.getTree();
        navigatorTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                Object object;
                if (UtNavigatorWindow.this.handler != null && (object = treeModelEvent.getTreePath().getLastPathComponent()) instanceof UtNavigatorTreeNode) {
                    NavigatorTreeNode navigatorTreeNode;
                    Element element;
                    TreeNode treeNode;
                    UtNavigatorTreeNode utNavigatorTreeNode = (UtNavigatorTreeNode)((Object)object);
                    if (UtNavigatorWindow.this.handlerParentNode == utNavigatorTreeNode && utNavigatorTreeNode.getChildCount() > 0 && (treeNode = utNavigatorTreeNode.getChildAt(0)) instanceof NavigatorTreeNode && (element = (navigatorTreeNode = (NavigatorTreeNode)treeNode).getElement()) != null && !(element instanceof DummyElement)) {
                        UtNavigatorWindow.this.handler.onLoadComplete((NavigatorTreeNode)utNavigatorTreeNode);
                        UtNavigatorWindow.this.handler = null;
                    }
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        CustomTree customTree = navigatorTree.getTree();
        UtNavigatorContextMenu.getInstance().attachMouseListener(navigatorTree);
        customTree.getSelectionModel().setSelectionMode(4);
        RootFolder.getInstance().externalInit();
        this.getContextMenu().addContextMenuListener((ContextMenuListener)UtNavigatorContextMenu.getInstance());
    }

    public void setAsynchronousLoadHandler(NavigatorTreeNode navigatorTreeNode, AsynchronousLoadHandler asynchronousLoadHandler) {
        this.handlerParentNode = navigatorTreeNode;
        this.handler = asynchronousLoadHandler;
    }

    public String getTitleName() {
        return UtAddinArb.getString("TITLE_NAME");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return UtAddin.navIcon;
    }

    protected Controller createController() {
        return UtNavigatorContextMenu.getInstance();
    }

    protected Element getRootElement() {
        return RootFolder.getInstance();
    }

    protected boolean isRootVisible() {
        return true;
    }

    public static interface AsynchronousLoadHandler {
        public void onLoadComplete(NavigatorTreeNode var1);
    }
}

