/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.process_validation;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.codehook.PLSQLCodeEditor;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.Validation;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.jdbc.OracleCallableStatement;

public class PlSqlValidation
extends Validation
implements IValidation {
    private String _name = ValidationArb.getString("CODE_VALIDATION_NAME");
    private PLSQLCodeEditor _codeEditor = new PLSQLCodeEditor();

    public PlSqlValidation() {
        this.onChangeEditability();
        this.setDefaultCode();
    }

    private void setDefaultCode() {
        String string = ValidationArb.getString("PLSQL_CODE_TEMPLATE");
        this._codeEditor.setCode(string);
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._codeEditor.getCode();
    }

    @Override
    protected Component createComponent() {
        return this._codeEditor.createEditorPanel(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PlSqlValidation.this.fireChangeListeners();
            }
        });
    }

    @Override
    public String getXml() {
        String string = this._codeEditor.getCode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<validation>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + string + "]]></description>");
        stringBuilder.append("<code><![CDATA[" + string + "]]></code>");
        stringBuilder.append("</validation>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = string != null ? UtUtils.getXmlValue(string, "validation", "code") : "";
        this._codeEditor.setCode(string2);
        this._codeEditor.setReadOnly(!this.isEditable());
    }

    @Override
    protected void onChangeEditability() {
        this._codeEditor.setReadOnly(!this.isEditable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runValidation(DataTypeConnectionProvider dataTypeConnectionProvider, Map<String, Object> map) throws Exception {
        Connection connection = dataTypeConnectionProvider.getValidDataTypeConnection();
        DataTypeFactory dataTypeFactory = dataTypeConnectionProvider.getDataTypeFactory();
        PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder = new PLSQLBoundBlockBuilder();
        pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallBlocks, this.substituteValues(this._codeEditor.getCode(), map));
        if (Connections.getInstance().lock(connection)) {
            try {
                String string = pLSQLBoundBlockBuilder.generateSql();
                CallableStatement callableStatement = connection.prepareCall(string);
                BindContext bindContext = dataTypeFactory.getBindContext(OracleCallableStatement.class, dataTypeConnectionProvider);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    DataValue dataValue;
                    if (!(entry.getValue() instanceof DataValue) || (dataValue = (DataValue)entry.getValue()) == null) continue;
                    DataType dataType = dataValue.getDataType();
                    DataVariable dataVariable = dataTypeFactory.getDataVariable(entry.getKey(), dataType, BindingMode.IN);
                    BindingStrategy bindingStrategy = dataType.getBind(bindContext, (DataBinding)dataVariable);
                    bindingStrategy.setByNameBindToken(entry.getKey());
                    if (bindingStrategy.getBindingStyle(BindingMode.IN) != BindingStyle.NAME) continue;
                    int n = 0;
                    try {
                        bindingStrategy.bind((Statement)callableStatement, dataValue);
                        ++n;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() != 17147 && sQLException.getErrorCode() != 17003) {
                            throw sQLException;
                        }
                        if (n != 0) continue;
                        callableStatement.close();
                        callableStatement = connection.prepareCall(string);
                    }
                }
                try {
                    callableStatement.execute();
                }
                finally {
                    callableStatement.close();
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

