/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.process_validation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.unit_test.codehook.PLSQLCodeEditor;
import oracle.dbtools.unit_test.process_validation.AbstractCompare;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;

public class ResultSetCompare
extends AbstractCompare {
    private String _name = ValidationArb.getString("RESULTSET_COMPARE_NAME");
    private JTextField _sourceQueryField = new JTextField("", 30);
    private JTextField _targetQueryField = new JTextField("", 30);
    private JButton _sourceEditButton = new JButton(ValidationArb.getString("EDIT_BUTTON_LABEL"));
    private JButton _targetEditButton = new JButton(ValidationArb.getString("EDIT_BUTTON_LABEL"));

    public ResultSetCompare() {
        this.onChangeEditability();
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return "(" + this._sourceQueryField.getText() + ") = (" + this._targetQueryField.getText() + ")";
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(ValidationArb.getString("SOURCE_QUERY_LABEL") + " ");
        JLabel jLabel2 = new JLabel(ValidationArb.getString("TARGET_QUERY_LABEL") + " ");
        JLabel jLabel3 = new JLabel(ValidationArb.getString("RESULTSET_COMPARE_NOTE"));
        Insets insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._sourceQueryField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._sourceEditButton, new GridBagConstraints(2, 0, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._targetQueryField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._targetEditButton, new GridBagConstraints(2, 1, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.setUpChangeListener(this._sourceQueryField);
        this.setUpChangeListener(this._targetQueryField);
        this._sourceEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLSQLCodeEditor pLSQLCodeEditor = new PLSQLCodeEditor();
                pLSQLCodeEditor.setCode(ResultSetCompare.this._sourceQueryField.getText());
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)pLSQLCodeEditor.createEditorPanel(), null, (String)ValidationArb.getString("EDIT_QUERY_TITLE"), (int)3);
                jEWTDialog.setOKButtonEnabled(true);
                boolean bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                if (bl) {
                    ResultSetCompare.this._sourceQueryField.setText(pLSQLCodeEditor.getCode());
                }
            }
        });
        this._targetEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLSQLCodeEditor pLSQLCodeEditor = new PLSQLCodeEditor();
                pLSQLCodeEditor.setCode(ResultSetCompare.this._targetQueryField.getText());
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)pLSQLCodeEditor.createEditorPanel(), null, (String)ValidationArb.getString("EDIT_QUERY_TITLE"), (int)3);
                jEWTDialog.setOKButtonEnabled(true);
                boolean bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                if (bl) {
                    ResultSetCompare.this._targetQueryField.setText(pLSQLCodeEditor.getCode());
                }
            }
        });
        return jPanel;
    }

    @Override
    public String getXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<validation>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + this.getDescription() + "]]></description>");
        stringBuilder.append("<source><![CDATA[" + this._sourceQueryField.getText() + "]]></source>");
        stringBuilder.append("<target><![CDATA[" + this._targetQueryField.getText() + "]]></target>");
        stringBuilder.append("</validation>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = "";
        String string3 = "";
        if (string != null) {
            string2 = UtUtils.getXmlValue(string, "validation", "source");
            string3 = UtUtils.getXmlValue(string, "validation", "target");
        }
        this._sourceQueryField.setText(string2);
        this._targetQueryField.setText(string3);
    }

    @Override
    protected void onChangeEditability() {
        this._sourceQueryField.setEditable(this.isEditable());
        this._targetQueryField.setEditable(this.isEditable());
        this._sourceEditButton.setEnabled(this.isEditable());
        this._targetEditButton.setEnabled(this.isEditable());
    }

    @Override
    public void runValidation(DataTypeConnectionProvider dataTypeConnectionProvider, Map<String, Object> map) throws Exception {
        Connection connection = dataTypeConnectionProvider.getValidDataTypeConnection();
        if (!this.compareQueryResults(connection, UtUtils.removeTrailingSemiColons(this.substituteValues(this._sourceQueryField.getText(), map)), UtUtils.removeTrailingSemiColons(this.substituteValues(this._targetQueryField.getText(), map)))) {
            throw new Exception(ValidationArb.getString("RESULT_SET_COMPARE_CHECK_FAILED"));
        }
    }
}

