/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.startup;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.codehook.CodeHookDefaults;
import oracle.dbtools.unit_test.codehook.PLSQLCodeEditor;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.Startup;
import oracle.dbtools.unit_test.startup.StartupArb;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.MessageDialog;

public class TableCopyStartup
extends Startup
implements IStartup {
    private String _name = StartupArb.getString("TABLE_COPY_STARTUP_NAME");
    private JTextField _sourceTableField = new JTextField("", 30);
    private JTextField _predicateField = new JTextField("", 30);
    private JTextField _tempTableField = new JTextField("", 30);
    private JButton _sourceBrowseButton = new JButton(StartupArb.getString("BROWSE_BUTTON_LABEL"));
    private JButton _predicateEditButton = new JButton(StartupArb.getString("EDIT_BUTTON_LABEL"));
    private JTextField _selectStmtField = new JTextField("", 30);
    private JButton _selectCheckButton = new JButton(StartupArb.getString("CHECK_BUTTON_LABEL"));
    private JButton _tempBrowseButton = new JButton(StartupArb.getString("BROWSE_BUTTON_LABEL"));

    public TableCopyStartup() {
        this.onChangeEditability();
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._tempTableField.getText() + " := " + this._selectStmtField.getText();
    }

    @Override
    public CodeHookDefaults getDefaults() {
        return new CodeHookDefaults(this._sourceTableField.getText(), this._tempTableField.getText(), this._predicateField.getText());
    }

    @Override
    protected void applyDefaults(CodeHookDefaults codeHookDefaults) {
        String string;
        String string2;
        String string3;
        String string4 = this._sourceTableField.getText();
        if ((string4 == null || string4.equals("")) && (string3 = codeHookDefaults.getTableName()) != null && !string3.equals("")) {
            this._sourceTableField.setText(string3);
        }
        if ((string3 = this._tempTableField.getText()) == null || string3.equals("")) {
            String string5;
            string2 = codeHookDefaults.getTempTableName();
            string = null;
            string = string2 != null && !string2.equals("") ? string2 : ((string5 = codeHookDefaults.getOwnerName()) != null && !string5.equals("") ? (string5.length() > 26 ? "\"TMP$" + string5.substring(0, 26) + "\"" : "\"TMP$" + string5 + "\"") : "\"T$TEMP_TABLE\"");
            this._tempTableField.setText(string);
        }
        if (((string2 = this._predicateField.getText()) == null || string2.equals("")) && (string = codeHookDefaults.getPredicate()) != null && !string.equals("")) {
            this._predicateField.setText(string);
        }
        this.setSelectStmtLabel();
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(StartupArb.getString("SOURCE_TABLE_LABEL") + " ");
        JLabel jLabel2 = new JLabel(StartupArb.getString("CONDITION_LABEL") + " ");
        JLabel jLabel3 = new JLabel(StartupArb.getString("GENERATED_QUERY_LABEL") + " ");
        JLabel jLabel4 = new JLabel(StartupArb.getString("TARGET_TABLE_LABEL") + " ");
        Insets insets = new Insets(10, 10, 10, 10);
        this._selectStmtField.setEditable(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._sourceTableField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._sourceBrowseButton, new GridBagConstraints(2, 0, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._predicateField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._predicateEditButton, new GridBagConstraints(2, 1, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._selectStmtField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._selectCheckButton, new GridBagConstraints(2, 2, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._tempTableField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._tempBrowseButton, new GridBagConstraints(2, 3, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TableCopyStartup.this.setSelectStmtLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TableCopyStartup.this.setSelectStmtLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TableCopyStartup.this.setSelectStmtLabel();
            }
        };
        this._sourceTableField.getDocument().addDocumentListener(documentListener);
        this._predicateField.getDocument().addDocumentListener(documentListener);
        this.setUpChangeListener(this._sourceTableField);
        this.setUpChangeListener(this._predicateField);
        this.setUpChangeListener(this._tempTableField);
        this._sourceBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UtUtils.selectTableName();
                if (string != null) {
                    TableCopyStartup.this._sourceTableField.setText(string);
                    TableCopyStartup.this.setSelectStmtLabel();
                }
            }
        });
        this._predicateEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLSQLCodeEditor pLSQLCodeEditor = new PLSQLCodeEditor();
                pLSQLCodeEditor.setCode(TableCopyStartup.this._predicateField.getText());
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)pLSQLCodeEditor.createEditorPanel(), null, (String)StartupArb.getString("EDIT_CONDITION_TITLE"), (int)3);
                jEWTDialog.setOKButtonEnabled(true);
                boolean bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                if (bl) {
                    String string = pLSQLCodeEditor.getCode();
                    TableCopyStartup.this._predicateField.setText(string);
                    TableCopyStartup.this.setSelectStmtLabel();
                }
            }
        });
        this._selectCheckButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Exception exception;
                block14: {
                    exception = null;
                    try {
                        Connection connection;
                        try {
                            connection = UtAddin.getDataTypeConnectionProvider().getDataTypeConnection();
                        }
                        catch (DataTypeConnectionException dataTypeConnectionException) {
                            if (dataTypeConnectionException.getCause() instanceof ConnectionCanceledException) {
                                return;
                            }
                            if (dataTypeConnectionException.getCause() instanceof Exception) {
                                throw (Exception)dataTypeConnectionException.getCause();
                            }
                            return;
                        }
                        if (!Connections.getInstance().lock(connection)) break block14;
                        try {
                            String string = TableCopyStartup.this._selectStmtField.getText();
                            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                                preparedStatement.execute();
                            }
                        }
                        finally {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                }
                if (exception == null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)StartupArb.getString("SELECT_SUCCESS_MESSAGE"), (String)StartupArb.getString("SUCCESS_TITLE"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(StartupArb.getString("SELECT_FAILED_MESSAGE") + "\n- " + exception.getLocalizedMessage()), (String)StartupArb.getString("FAILED_TITLE"), null);
                }
            }
        });
        this._tempBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UtUtils.selectTableName();
                if (string != null) {
                    TableCopyStartup.this._tempTableField.setText(string);
                }
            }
        });
        return jPanel;
    }

    @Override
    public String getXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<startup>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + this.getDescription() + "]]></description>");
        stringBuilder.append("<source><![CDATA[" + this._sourceTableField.getText() + "]]></source>");
        stringBuilder.append("<predicate><![CDATA[" + this._predicateField.getText() + "]]></predicate>");
        stringBuilder.append("<temp><![CDATA[" + this._tempTableField.getText() + "]]></temp>");
        stringBuilder.append("</startup>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (string != null) {
            string2 = UtUtils.getXmlValue(string, "startup", "source");
            string3 = UtUtils.getXmlValue(string, "startup", "predicate");
            string4 = UtUtils.getXmlValue(string, "startup", "temp");
        }
        this._sourceTableField.setText(string2);
        this._predicateField.setText(string3);
        this._tempTableField.setText(string4);
        this.setSelectStmtLabel();
    }

    private void setSelectStmtLabel() {
        String string = this._sourceTableField.getText();
        String string2 = this._predicateField.getText();
        String string3 = "";
        if (string != null && !string.equals("")) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT ROWID AS SRC$ROWID, s.* FROM ");
            stringBuffer.append(string);
            stringBuffer.append(" s ");
            if (string2 != null && !string2.equals("")) {
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string2);
            }
            string3 = stringBuffer.toString();
        }
        this._selectStmtField.setText(string3);
    }

    @Override
    protected void onChangeEditability() {
        this._sourceTableField.setEditable(this.isEditable());
        this._predicateField.setEditable(this.isEditable());
        this._tempTableField.setEditable(this.isEditable());
        this._sourceBrowseButton.setEnabled(this.isEditable());
        this._predicateEditButton.setEnabled(this.isEditable());
        this._selectCheckButton.setEnabled(this.isEditable());
        this._tempBrowseButton.setEnabled(this.isEditable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performWork(Connection connection) throws Exception {
        block18: {
            if (Connections.getInstance().lock(connection)) {
                try {
                    PreparedStatement preparedStatement;
                    String string;
                    boolean bl = false;
                    String string2 = "select count(*) from " + this._tempTableField.getText();
                    try (PreparedStatement preparedStatement2 = connection.prepareStatement(string2);){
                        preparedStatement2.execute();
                    }
                    if (!bl) {
                        string = "drop table " + this._tempTableField.getText();
                        preparedStatement = connection.prepareStatement(string);
                        try {
                            preparedStatement.execute();
                            bl = true;
                        }
                        finally {
                            preparedStatement.close();
                        }
                    }
                    if (!bl) break block18;
                    string = "create table " + this._tempTableField.getText() + " as " + this._selectStmtField.getText();
                    preparedStatement = connection.prepareStatement(string);
                    try {
                        preparedStatement.execute();
                        connection.commit();
                    }
                    finally {
                        preparedStatement.close();
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    public boolean isCompleteTableCopy() {
        String string = this._predicateField.getText();
        return string == null || string.equals("");
    }
}

