/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.xml.parser.v2.XMLElement;

public class UtArguments {
    private boolean _seeded;
    private UtTest _test;
    private String _key;
    private String _owner;
    private String _object_name;
    private String _package_name;
    private Integer _object_id;
    private String _overload;
    private String _argument_name;
    private Integer _position;
    private Integer _sequence;
    private Integer _data_level;
    private String _data_type;
    private Integer _default_length;
    private String _in_out;
    private Integer _data_length;
    private Integer _data_precision;
    private Integer _data_scale;
    private Integer _radix;
    private String _character_set_name;
    private String _type_owner;
    private String _type_name;
    private String _type_subname;
    private String _type_link;
    private String _pls_type;
    private Integer _char_length;
    private String _char_used;

    public UtArguments(String string, UtTest utTest, String string2, String string3, String string4, Integer n, String string5, String string6, Integer n2, Integer n3, Integer n4, String string7, Integer n5, String string8, Integer n6, Integer n7, Integer n8, Integer n9, String string9, String string10, String string11, String string12, String string13, String string14, Integer n10, String string15) {
        this._test = utTest;
        this._seeded = string == null;
        this._key = this._seeded ? UUID.randomUUID().toString() : string;
        this._owner = string2;
        this._object_name = string3;
        this._package_name = string4;
        this._object_id = n;
        this._overload = string5;
        this._argument_name = string6;
        this._position = n2;
        this._sequence = n3;
        this._data_level = n4;
        this._data_type = string7;
        this._default_length = n5;
        this._in_out = string8;
        this._data_length = n6;
        this._data_precision = n7;
        this._data_scale = n8;
        this._radix = n9;
        this._character_set_name = string9;
        this._type_owner = string10;
        this._type_name = string11;
        this._type_subname = string12;
        this._type_link = string13;
        this._pls_type = string14;
        this._char_length = n10;
        this._char_used = string15;
    }

    private Integer getInteger(XMLElement xMLElement, String string) {
        Integer n = null;
        String string2 = xMLElement.getAttribute(string);
        if (string2.equals("")) {
            string2 = null;
        }
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    private String getString(XMLElement xMLElement, String string) {
        String string2 = xMLElement.getAttribute(string);
        if (string2.equals("")) {
            string2 = null;
        }
        return string2;
    }

    UtArguments(XMLElement xMLElement, UtTest utTest, ImportContext importContext) {
        this._test = utTest;
        this._key = this.getString(xMLElement, "id");
        this._owner = this.getString(xMLElement, "owner");
        this._object_name = this.getString(xMLElement, "object_name");
        this._package_name = this.getString(xMLElement, "package_name");
        this._object_id = this.getInteger(xMLElement, "object_id");
        this._overload = this.getString(xMLElement, "overload");
        this._argument_name = this.getString(xMLElement, "argument_name");
        this._position = this.getInteger(xMLElement, "position");
        this._sequence = this.getInteger(xMLElement, "sequence");
        this._data_level = this.getInteger(xMLElement, "data_level");
        this._data_type = this.getString(xMLElement, "data_type");
        this._default_length = this.getInteger(xMLElement, "default_length");
        this._in_out = this.getString(xMLElement, "in_out");
        this._data_length = this.getInteger(xMLElement, "data_length");
        this._data_precision = this.getInteger(xMLElement, "data_precision");
        this._data_scale = this.getInteger(xMLElement, "data_scale");
        this._radix = this.getInteger(xMLElement, "radix");
        this._character_set_name = this.getString(xMLElement, "character_set_name");
        this._type_owner = this.getString(xMLElement, "type_owner");
        this._type_name = this.getString(xMLElement, "type_name");
        this._type_subname = this.getString(xMLElement, "type_subname");
        this._type_link = this.getString(xMLElement, "type_link");
        this._pls_type = this.getString(xMLElement, "pls_type");
        this._char_length = this.getInteger(xMLElement, "char_length");
        this._char_used = this.getString(xMLElement, "char_used");
    }

    private void setString(XMLElement xMLElement, String string, String string2) {
        if (string2 != null) {
            xMLElement.setAttribute(string, string2);
        }
    }

    private void setInteger(XMLElement xMLElement, String string, Integer n) {
        if (n != null) {
            xMLElement.setAttribute(string, Integer.toString(n));
        }
    }

    void exportFields(XMLElement xMLElement, ExportContext exportContext) {
        XMLElement xMLElement2 = exportContext.createExportedElement(xMLElement, "arg");
        this.setString(xMLElement2, "id", this._key);
        this.setString(xMLElement2, "owner", this._owner);
        this.setString(xMLElement2, "object_name", this._object_name);
        this.setString(xMLElement2, "package_name", this._package_name);
        this.setInteger(xMLElement2, "object_id", this._object_id);
        this.setString(xMLElement2, "overload", this._overload);
        this.setString(xMLElement2, "argument_name", this._argument_name);
        this.setInteger(xMLElement2, "position", this._position);
        this.setInteger(xMLElement2, "sequence", this._sequence);
        this.setInteger(xMLElement2, "data_level", this._data_level);
        this.setString(xMLElement2, "data_type", this._data_type);
        this.setInteger(xMLElement2, "default_length", this._default_length);
        this.setString(xMLElement2, "in_out", this._in_out);
        this.setInteger(xMLElement2, "data_length", this._data_length);
        this.setInteger(xMLElement2, "data_precision", this._data_precision);
        this.setInteger(xMLElement2, "data_scale", this._data_scale);
        this.setInteger(xMLElement2, "radix", this._radix);
        this.setString(xMLElement2, "character_set_name", this._character_set_name);
        this.setString(xMLElement2, "type_owner", this._type_owner);
        this.setString(xMLElement2, "type_name", this._type_name);
        this.setString(xMLElement2, "type_subname", this._type_subname);
        this.setString(xMLElement2, "type_link", this._type_link);
        this.setString(xMLElement2, "pls_type", this._pls_type);
        this.setInteger(xMLElement2, "char_length", this._char_length);
        this.setString(xMLElement2, "char_used", this._char_used);
    }

    public TypeMetadata get_type_metadata(DataTypeFactory dataTypeFactory) {
        UtArguments utArguments2;
        LinkedList<NamedValue> linkedList;
        ArrayList<UtArguments> arrayList = this._test.getChildArgumentsSorted(this._sequence);
        LinkedList<NamedValue> linkedList2 = linkedList = arrayList != null && arrayList.size() > 0 ? new LinkedList<NamedValue>() : null;
        if (linkedList != null) {
            for (UtArguments utArguments2 : arrayList) {
                TypeMetadata typeMetadata = utArguments2.get_type_metadata(dataTypeFactory);
                linkedList.add(new NamedValue(utArguments2._argument_name, (Object)typeMetadata));
            }
        }
        HashMap hashMap = new HashMap();
        this.addAttribute(hashMap, TypeMetadata.Attribute.DATA_TYPE, DataTypesUtil.reformatDataTypeString((String)this._pls_type));
        this.addAttribute(hashMap, TypeMetadata.Attribute.BASE_TYPE, DataTypesUtil.reformatDataTypeString((String)this._data_type));
        this.addAttribute(hashMap, TypeMetadata.Attribute.DATA_LENGTH, this._data_length);
        this.addAttribute(hashMap, TypeMetadata.Attribute.DATA_PRECISION, this._data_precision);
        this.addAttribute(hashMap, TypeMetadata.Attribute.DATA_SCALE, this._data_scale);
        this.addAttribute(hashMap, TypeMetadata.Attribute.DATA_RADIX, this._radix);
        this.addAttribute(hashMap, TypeMetadata.Attribute.TYPE_OWNER, this._type_owner);
        this.addAttribute(hashMap, TypeMetadata.Attribute.TYPE_NAME, this._type_name);
        this.addAttribute(hashMap, TypeMetadata.Attribute.TYPE_SUBNAME, this._type_subname);
        this.addAttribute(hashMap, TypeMetadata.Attribute.TYPE_LINK, this._type_link);
        if (this._char_length != null && this._char_length != 0) {
            this.addAttribute(hashMap, TypeMetadata.Attribute.CHAR_LENGTH, this._char_length);
            this.addAttribute(hashMap, TypeMetadata.Attribute.CHAR_USED, this._char_used);
        }
        this.addAttribute(hashMap, TypeMetadata.Attribute.TYPE_COMPONENTS, linkedList);
        if (this._in_out != null && this._in_out.equals("IN") && this._data_type != null && (this._data_type.equals("CURSOR") || this._data_type.equals("REF CURSOR"))) {
            this.addAttribute(hashMap, TypeMetadata.Attribute.IMPL_DATA_TYPE, "PL/SQL CURSOR_FOR");
        }
        utArguments2 = dataTypeFactory.getTypeMetadata((Map)hashMap);
        return utArguments2;
    }

    private void addAttribute(HashMap<TypeMetadata.Attribute, Object> hashMap, TypeMetadata.Attribute attribute, Object object) {
        if (object != null) {
            hashMap.put(attribute, object);
        }
    }

    public boolean isSeeded() {
        return this._seeded;
    }

    public String get_argument_name() {
        return this._argument_name;
    }

    public Integer get_char_length() {
        return this._char_length;
    }

    public String get_char_used() {
        return this._char_used;
    }

    public String get_character_set_name() {
        return this._character_set_name;
    }

    public Integer get_data_length() {
        return this._data_length;
    }

    public Integer get_data_level() {
        return this._data_level;
    }

    public Integer get_data_precision() {
        return this._data_precision;
    }

    public Integer get_data_scale() {
        return this._data_scale;
    }

    public String get_data_type() {
        return this._data_type;
    }

    public Integer get_default_length() {
        return this._default_length;
    }

    public String get_in_out() {
        return this._in_out;
    }

    public String getArgId() {
        return this._key;
    }

    public Integer get_object_id() {
        return this._object_id;
    }

    public String get_object_name() {
        return this._object_name;
    }

    public String get_overload() {
        return this._overload;
    }

    public String get_owner() {
        return this._owner;
    }

    public String get_package_name() {
        return this._package_name;
    }

    public String get_pls_type() {
        return this._pls_type;
    }

    public Integer get_position() {
        return this._position;
    }

    public Integer get_radix() {
        return this._radix;
    }

    public Integer get_sequence() {
        return this._sequence;
    }

    public String get_type_link() {
        return this._type_link;
    }

    public String get_type_name() {
        return this._type_name;
    }

    public String get_type_owner() {
        return this._type_owner;
    }

    public String get_type_subname() {
        return this._type_subname;
    }

    public String get_utid() {
        return this._test.getId();
    }

    public boolean isReturn() {
        return this._position == 0;
    }

    public UtTest getTest() {
        return this._test;
    }

    public String getDataTypeString() {
        String string = this.getUserTypeString();
        if (string == null) {
            string = this.get_data_type();
        }
        if (string == null) {
            string = this.get_pls_type();
        }
        return DataTypesUtil.reformatDataTypeString((String)string);
    }

    private String getUserTypeString() {
        String string = this.get_type_owner();
        String string2 = this.get_type_name();
        String string3 = this.get_type_subname();
        StringBuilder stringBuilder = new StringBuilder();
        this.append(stringBuilder, string);
        this.append(stringBuilder, string2);
        this.append(stringBuilder, string3);
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private StringBuilder append(StringBuilder stringBuilder, String string) {
        if (string != null) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(".").append(string);
            }
        }
        return stringBuilder;
    }

    UtArguments createUpgradeArg(UtTest utTest, String string) {
        UtArguments utArguments = new UtArguments();
        utArguments._test = utTest;
        this._seeded = false;
        utArguments._key = string == null ? this._key : string;
        utArguments._owner = this._owner;
        utArguments._object_name = this._object_name;
        utArguments._package_name = this._package_name;
        utArguments._object_id = this._object_id;
        utArguments._overload = this._overload;
        utArguments._argument_name = this._argument_name;
        utArguments._position = this._position;
        utArguments._sequence = this._sequence;
        utArguments._data_level = this._data_level;
        utArguments._data_type = this._data_type;
        utArguments._default_length = this._default_length;
        utArguments._in_out = this._in_out;
        utArguments._data_length = this._data_length;
        utArguments._data_precision = this._data_precision;
        utArguments._data_scale = this._data_scale;
        utArguments._radix = this._radix;
        utArguments._character_set_name = this._character_set_name;
        utArguments._type_owner = this._type_owner;
        utArguments._type_name = this._type_name;
        utArguments._type_subname = this._type_subname;
        utArguments._type_link = this._type_link;
        utArguments._pls_type = this._pls_type;
        utArguments._char_length = this._char_length;
        utArguments._char_used = this._char_used;
        return utArguments;
    }

    private UtArguments() {
    }
}

