/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.javatools.icons.OracleIcons;

public final class DataMinerSearchControl
extends JPanel
implements DataminerGUIPanel {
    private JButton searchButton;
    private JLabel searchLabel;
    private JTextField textField;

    public DataMinerSearchControl() {
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.searchLabel = new JLabel();
        this.textField = new JTextField();
        this.searchButton = new JButton();
        this.searchLabel.setText("Search:");
        this.textField.setMinimumSize(new Dimension(160, 20));
        this.textField.setPreferredSize(new Dimension(160, 20));
        this.searchButton.setText("Find");
        this.searchButton.setBorderPainted(false);
        this.searchButton.setPreferredSize(new Dimension(20, 20));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textField, -2, -1, -2).addComponent(this.searchLabel).addComponent(this.searchButton, -2, -1, -2))));
        this.searchLabel.getAccessibleContext().setAccessibleName("Tag");
    }

    public void setLabelText(String string) {
        this.searchLabel.setText(string);
    }

    public void setButtonStyle(String string, Icon icon) {
        this.searchButton.setIcon(icon);
        this.searchButton.setText(string);
    }

    public void setTextFieldEnabled(boolean bl) {
        this.textField.setEnabled(bl);
    }

    public void setSearchText(String string) {
        this.textField.setText(string);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public String getSearchText() {
        return this.textField.getText();
    }

    public JButton getSearchButton() {
        return this.searchButton;
    }

    public void useMagnifyingGlassIcon() {
        this.searchButton.setText("");
        this.searchButton.setSize(this.searchButton.getPreferredSize());
        this.searchButton.setIcon(OracleIcons.getIcon((String)"search.png"));
    }

    public void addActionListener(boolean bl, ActionListener actionListener) {
        if (bl) {
            final ActionListener actionListener2 = actionListener;
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        actionListener2.actionPerformed(new ActionEvent(DataMinerSearchControl.this.searchButton, 0, DataMinerSearchControl.this.searchButton.getActionCommand()));
                    }
                }
            });
        }
        this.searchButton.addActionListener(actionListener);
    }

    @Override
    public void initRes() {
        this.searchLabel.setText(CommonLrb.get("SEARCH"));
        this.searchButton.setText(CommonLrb.get("FIND"));
    }

    @Override
    public void initUI() {
    }
}

