/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.charts.axischart.AxisChartInteractive;
import oracle.charts.codec.PNGEncoder;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ClipboardUtils;
import oracle.dss.graph.Graph;
import oracle.ide.Ide;

public class GraphContextMenu
extends JPopupMenu {
    private JMenuItem viewData;
    private JMenuItem saveImageAs;
    private JMenuItem copyImage;
    private Object _graph;
    private static final Logger theLogger = Logger.getLogger(GraphContextMenu.class.getName());
    private GraphDataDisplay target;

    public GraphContextMenu(GraphDataDisplay graphDataDisplay, Object object) {
        this._graph = object;
        this.target = graphDataDisplay;
        this.saveImageAs = new JMenuItem(ControlsLrb.get("GRAPH_CONTEXT_MENU_SAVE"));
        this.copyImage = new JMenuItem(ControlsLrb.get("GRAPH_CONTEXT_MENU_COPY"));
        this.viewData = new JMenuItem(ControlsLrb.get("GRAPH_CONTEXT_MENU_VIEW"));
        this.add(this.copyImage);
        this.add(this.saveImageAs);
        this.add(this.viewData);
        this.viewData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphContextMenu.this.target.showData(GraphContextMenu.this._graph);
            }
        });
        this.saveImageAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GraphContextMenu.this._graph instanceof Graph) {
                    GraphContextMenu.this.saveGraph((Graph)GraphContextMenu.this._graph);
                } else if (GraphContextMenu.this._graph instanceof AxisChartInteractive) {
                    GraphContextMenu.this.saveGraph((AxisChartInteractive)GraphContextMenu.this._graph);
                }
            }
        });
        this.copyImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GraphContextMenu.this._graph instanceof Graph) {
                    GraphContextMenu.this.copyGraph((Graph)GraphContextMenu.this._graph);
                } else if (GraphContextMenu.this._graph instanceof AxisChartInteractive) {
                    GraphContextMenu.this.copyGraph((AxisChartInteractive)GraphContextMenu.this._graph);
                }
            }
        });
    }

    private void saveGraph(AxisChartInteractive axisChartInteractive) {
        try {
            JFileChooser jFileChooser = new JFileChooser(axisChartInteractive.getTitle().getText());
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(ControlsLrb.get("FILE_NANE_EXTENSION_FILE"), "jpeg", "jpg", "gif", "tiff", "tif", "png"));
            jFileChooser.setSelectedFile(new File(StringUtils.trimDoubleQuotes(axisChartInteractive.getTitle().getText()) + ".png"));
            int n = jFileChooser.showDialog((Component)Ide.getMainWindow(), ControlsLrb.get("GRAPH_CONTEXT_MENU_ACTION"));
            if (n == 0) {
                BufferedImage bufferedImage = new BufferedImage(axisChartInteractive.getWidth(), axisChartInteractive.getHeight(), 13);
                Graphics2D graphics2D = null;
                graphics2D = bufferedImage.createGraphics();
                axisChartInteractive.drawBuffer(graphics2D);
                FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                PNGEncoder pNGEncoder = new PNGEncoder((OutputStream)fileOutputStream);
                pNGEncoder.encode((RenderedImage)bufferedImage);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void saveGraph(Graph graph) {
        try {
            JFileChooser jFileChooser = new JFileChooser(graph.getTitle().getText());
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(ControlsLrb.get("FILE_NANE_EXTENSION_FILE"), "jpeg", "jpg", "gif", "tiff", "tif", "png"));
            jFileChooser.setSelectedFile(new File(StringUtils.trimDoubleQuotes(graph.getTitle().getText()) + ".png"));
            int n = jFileChooser.showDialog((Component)Ide.getMainWindow(), ControlsLrb.get("GRAPH_CONTEXT_MENU_ACTION"));
            if (n == 0) {
                graph.setImageSize(new Dimension(graph.getWidth(), graph.getHeight()));
                FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                graph.exportToPNGWithException((OutputStream)fileOutputStream);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void copyGraph(Graph graph) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            graph.setImageSize(new Dimension(graph.getWidth(), graph.getHeight()));
            graph.exportToPNG((OutputStream)byteArrayOutputStream);
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ClipboardUtils clipboardUtils = new ClipboardUtils(bufferedImage);
            clipboardUtils.setContentToClipboard();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }

    private void copyGraph(AxisChartInteractive axisChartInteractive) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedImage bufferedImage = new BufferedImage(axisChartInteractive.getWidth(), axisChartInteractive.getHeight(), 13);
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage.createGraphics();
            axisChartInteractive.drawBuffer(graphics2D);
            PNGEncoder pNGEncoder = new PNGEncoder((OutputStream)byteArrayOutputStream);
            pNGEncoder.encode((RenderedImage)bufferedImage);
            ClipboardUtils clipboardUtils = new ClipboardUtils(bufferedImage);
            clipboardUtils.setContentToClipboard();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

