/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.GroupByAttributeSelectionRowData;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONPeerObserver;
import oracle.dmt.dataminer.controls.JSONStructureDefaultTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructureGroupByTreeTable;
import oracle.dmt.dataminer.controls.JSONStructureGroupByTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructurePanel;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AddGroupByColumnPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;

public class JSONStructureGroupByPanel
extends JSONStructurePanel {
    protected AddGroupByColumnPanel enclosingPanel;
    protected List<JSONAttributeType> jsonGrpByAttributes;
    protected List<AttributeExType> relationalGrpByAttrs;
    protected JSONPeerObserver dataPeerObserver;
    private String AVAILABLE_ATTRIBUTES = ControlsLrb.get("JSON_GROUP_BY_AVAILABLE_ATTRIBUTES");

    public void setEnclosingPanel(AddGroupByColumnPanel addGroupByColumnPanel) {
        this.enclosingPanel = addGroupByColumnPanel;
        this.registerDataPeerObserver(addGroupByColumnPanel);
        JSONStructureGroupByTreeTableModel jSONStructureGroupByTreeTableModel = (JSONStructureGroupByTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureGroupByTreeTableModel.setGroupingElement(this.jsonGrpByAttributes, this.relationalGrpByAttrs);
        this.addRelationalAttributes(jSONStructureGroupByTreeTableModel);
    }

    protected void addRelationalAttributes(JSONStructureGroupByTreeTableModel jSONStructureGroupByTreeTableModel) {
        List<AttributeExType> list = this.enclosingPanel.getJSONQueryEditorPanel().getAvailRelationalAttributes();
        jSONStructureGroupByTreeTableModel.setAdditionalData(list);
    }

    @Override
    protected void createJSONTree() {
        this.jsonTree = new JSONStructureGroupByTreeTable();
    }

    public void registerDataPeerObserver(JSONPeerObserver jSONPeerObserver) {
        this.dataPeerObserver = jSONPeerObserver;
    }

    @Override
    protected void setPanelTitle() {
        JSONStructureGroupByTreeTableModel jSONStructureGroupByTreeTableModel = (JSONStructureGroupByTreeTableModel)this.jsonTree.getTreeModel();
        int n = jSONStructureGroupByTreeTableModel.getNodeCount();
        if (1 < n) {
            int n2 = 0;
            if (this.jsonGrpByAttributes != null) {
                n2 += this.jsonGrpByAttributes.size();
            }
            if (this.relationalGrpByAttrs != null) {
                n2 += this.relationalGrpByAttrs.size();
            }
            Object[] objectArray = new Object[]{n2, n - 1};
            String string = MessageFormat.format(titleTemplate, objectArray);
            this.titleLabel.setText(string);
            return;
        }
        this.titleLabel.setText(JSONElement.EMPTY_STRING);
    }

    public void updatePanelTitle(int n) {
        JSONStructureGroupByTreeTableModel jSONStructureGroupByTreeTableModel = (JSONStructureGroupByTreeTableModel)this.jsonTree.getTreeModel();
        int n2 = jSONStructureGroupByTreeTableModel.getNodeCount();
        Object[] objectArray = new Object[]{n, n2 - 1};
        String string = MessageFormat.format(titleTemplate, objectArray);
        this.titleLabel.setText(string);
    }

    public JSONStructureGroupByPanel(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, JSONColumnsType.Attribute attribute, List<JSONAttributeType> list, List<AttributeExType> list2, boolean bl) {
        super(context, abstractDataNode, attributeType, attribute, bl);
        this.jsonGrpByAttributes = list;
        this.relationalGrpByAttrs = list2;
    }

    @Override
    public void jsonAttrSelectionChanged2(Map<JSONElement, Boolean> map) {
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        ArrayList<GroupByAttributeSelectionRowData> arrayList = new ArrayList<GroupByAttributeSelectionRowData>();
        for (JSONElement jSONElement : map.keySet()) {
            JSONAttributeType jSONAttributeType;
            String string = jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement.getElementID());
            GroupByAttributeSelectionRowData groupByAttributeSelectionRowData = null;
            if (jSONElement.isJson()) {
                jSONAttributeType = new JSONAttributeType();
                jSONAttributeType.setPath(string);
                int n = string.lastIndexOf(".");
                String string2 = string.substring(n + 1, string.length());
                String string3 = StringUtils.trimDoubleQuotes(string2);
                string3 = string3.toUpperCase();
                string3 = string3.replaceAll("\\s+", "");
                jSONAttributeType.setDataType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN));
                if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                    jSONAttributeType.setUnnest(Boolean.TRUE);
                }
                jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN)));
                jSONAttributeType.setDBName(this.enclosingPanel.getJSONQueryEditorPanel().getNameGenerator().GenerateName(string3, jSONAttributeType.getPath()));
                jSONAttributeType.setStatus(AttributeStatus.VALID);
                this.addParentJSONJSONAttributesTypeElements(jSONElement);
                groupByAttributeSelectionRowData = new GroupByAttributeSelectionRowData(jSONAttributeType, (boolean)map.get((Object)jSONElement));
            } else {
                jSONAttributeType = new AttributeExType();
                jSONAttributeType.setName(string);
                String string4 = this.enclosingPanel.getJSONQueryEditorPanel().getNameGenerator().GenerateName(string, string);
                if (string.compareTo(string4) != 0) {
                    jSONAttributeType.setAlias(string4);
                }
                jSONAttributeType.setDataType(jSONElement.getDataType());
                jSONAttributeType.setNewDataType(jSONElement.getDataType());
                jSONAttributeType.setStatus(AttributeStatus.VALID);
                groupByAttributeSelectionRowData = new GroupByAttributeSelectionRowData((AttributeExType)jSONAttributeType, (boolean)map.get((Object)jSONElement));
            }
            arrayList.add(groupByAttributeSelectionRowData);
        }
        this.enclosingPanel.reload(arrayList);
        jSONStructureDefaultTreeTableModel.updateTransientData(arrayList);
    }

    private void addParentJSONJSONAttributesTypeElements(JSONElement jSONElement) {
        JSONStructureGroupByTreeTableModel jSONStructureGroupByTreeTableModel = (JSONStructureGroupByTreeTableModel)this.jsonTree.getTreeModel();
        JSONElement jSONElement2 = (JSONElement)((Object)jSONStructureGroupByTreeTableModel.getRoot());
        for (JSONElement jSONElement3 = jSONElement; null != jSONElement3 && !((Object)((Object)jSONElement3)).equals((Object)jSONElement2); jSONElement3 = (JSONElement)((Object)jSONElement3.getParent())) {
            JSONAttributeType jSONAttributeType = new JSONAttributeType();
            String string = jSONStructureGroupByTreeTableModel.getJSONElementPathByID(jSONElement3.getElementID());
            jSONAttributeType.setPath(string);
            int n = string.lastIndexOf(".");
            String string2 = string.substring(n + 1, string.length());
            String string3 = StringUtils.trimDoubleQuotes(string2);
            string3 = string3.toUpperCase();
            string3 = string3.replaceAll("\\s+", "");
            jSONAttributeType.setDataType((String)jSONElement3.getValue(JSONElement.JSON_DATA_COLUMN));
            if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                jSONAttributeType.setUnnest(Boolean.TRUE);
            }
            jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONElement3.getValue(JSONElement.JSON_DATA_COLUMN)));
            jSONAttributeType.setDBName(this.enclosingPanel.getJSONQueryEditorPanel().getNameGenerator().GenerateName(string3, jSONAttributeType.getPath()));
            jSONAttributeType.setStatus(AttributeStatus.VALID);
        }
    }

    @Override
    public void reload() {
        if (this.selJSONAttribute != null) {
            this.enableComponents(false);
            LoadUIData loadUIData = new LoadUIData();
            loadUIData.execute();
        }
    }

    @Override
    protected JSONStructureDefaultTreeTableModel loadJSONPanel(String string) {
        JSONStructureGroupByTreeTableModel jSONStructureGroupByTreeTableModel = (JSONStructureGroupByTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureGroupByTreeTableModel.loadJSONPanel(this.dataGuideInfo, string);
        return jSONStructureGroupByTreeTableModel;
    }

    protected class LoadUIData
    extends JSONStructurePanel.LoadUI {
        protected LoadUIData() {
            super(JSONStructureGroupByPanel.this);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            Boolean bl = Boolean.TRUE;
            this.showTree();
            try {
                DataGuideInfoType dataGuideInfoType = JSONStructureGroupByPanel.this.editedJSONColumn.getDataGuideInfo();
                if (null != dataGuideInfoType) {
                    if (null != dataGuideInfoType.getSystem()) {
                        String string = dataGuideInfoType.getSystem().getDataGuideTable();
                        JSONStructureGroupByPanel.this.dataGuideInfo = new ArrayList();
                        if (null == dataGuideInfoType.getSystem().getDataGuide() && null != string) {
                            DatabaseMetadataUtils.loadDataGuide(JSONStructureGroupByPanel.this.getContext(), JSONStructureGroupByPanel.this.dataGuideInfo, string);
                            dataGuideInfoType.getSystem().setDataGuide(this.dataGuide);
                        } else if (null != dataGuideInfoType.getSystem().getDataGuide()) {
                            for (DataGuideType.Item item : dataGuideInfoType.getSystem().getDataGuide().getItem()) {
                                String string2 = item.getPath();
                                String string3 = item.getType();
                                String string4 = null;
                                int n = string2.lastIndexOf(".");
                                if (n != -1) {
                                    string4 = string2.substring(n + 1, string2.length() - 1);
                                }
                                NameValuePair nameValuePair = new NameValuePair(string4, (Object)string3);
                                NameValuePair nameValuePair2 = new NameValuePair(string2, (Object)nameValuePair);
                                JSONStructureGroupByPanel.this.dataGuideInfo.add(nameValuePair2);
                            }
                        }
                    } else if (null != dataGuideInfoType.getCustom() && null != dataGuideInfoType.getCustom().getDataGuide()) {
                        JSONStructureGroupByPanel.this.dataGuideInfo = new ArrayList();
                        for (DataGuideType.Item item : dataGuideInfoType.getCustom().getDataGuide().getItem()) {
                            String string = item.getPath();
                            String string5 = item.getType();
                            String string6 = null;
                            int n = string.lastIndexOf(".");
                            if (n != -1) {
                                string6 = string.substring(n + 1, string.length() - 1);
                            }
                            NameValuePair nameValuePair = new NameValuePair(string6, (Object)string5);
                            NameValuePair nameValuePair3 = new NameValuePair(string, (Object)nameValuePair);
                            JSONStructureGroupByPanel.this.dataGuideInfo.add(nameValuePair3);
                        }
                    }
                } else assert (false) : "Incorrect invocation: Data guide has to be available!";
                JSONStructureGroupByPanel.this._success = true;
            }
            catch (Exception exception) {
                JSONStructureGroupByPanel.this._ex = exception;
                JSONStructureGroupByPanel.this._success = false;
            }
            return bl;
        }

        @Override
        protected void done() {
            JTree jTree = JSONStructureGroupByPanel.this.jsonTree.getTree();
            JSONStructureGroupByTreeTableModel jSONStructureGroupByTreeTableModel = (JSONStructureGroupByTreeTableModel)((Object)jTree.getModel());
            JSONElement jSONElement = (JSONElement)((Object)jSONStructureGroupByTreeTableModel.getRoot());
            jSONStructureGroupByTreeTableModel.setSelJSONAttribute(JSONStructureGroupByPanel.this.selJSONAttribute);
            jSONElement.setRootValue(JSONStructureGroupByPanel.this.AVAILABLE_ATTRIBUTES);
            JSONStructureGroupByPanel.this.jsonTree.getTree().setRootVisible(true);
            JSONStructureGroupByPanel.this.enableComponents(true);
            if (JSONStructureGroupByPanel.this._success && JSONStructureGroupByPanel.this._ex == null) {
                JSONStructureGroupByPanel.this.updateTreeSize();
                JSONStructureGroupByPanel.this.jsonTree.expandAll(true);
                if (JSONStructureGroupByPanel.this.dataPeerObserver != null) {
                    JSONStructureGroupByPanel.this.dataPeerObserver.updateJsonStructureTree();
                    JSONStructureGroupByPanel.this.setPanelTitle();
                    JSONStructureGroupByPanel.this.searchField.setEnabled(true);
                }
                JSONStructureGroupByPanel.this.updateUI();
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)JSONStructureGroupByPanel.this._ex, (String)ControlsLrb.get("JSON_GUIDE_LOADING_FAILURE_TITLE"), (String)ControlsLrb.get("JSON_GUIDE_LOADING_FAILURE_MESSAGE"), null);
            }
        }
    }
}

