/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dmt.dataminer.server.Compatibles;

public class TableCell {
    private TableCell _parentTableCell;
    private BigDecimal _valueId;
    private String[] _splitValues;
    private String _value;
    private TableCellType _type;
    private String _valueType;
    private Map<String, Set<String>> _dataTypeColsMap = null;

    public TableCell(BigDecimal bigDecimal, String string, String string2) {
        this._valueId = bigDecimal;
        this.setSplitValues(string, string2);
    }

    public TableCell(String string, TableCellType tableCellType) {
        this._value = string;
        this._type = tableCellType;
    }

    public TableCell(TableCell tableCell, BigDecimal bigDecimal, String string, String string2, TableCellType tableCellType) {
        this._parentTableCell = tableCell;
        this._valueId = bigDecimal;
        this._value = string;
        this._valueType = string2;
        this._type = tableCellType;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public Map<String, Set<String>> getDataTypeColsMap() {
        return this._dataTypeColsMap;
    }

    public void setDataTypeColsMap(Map<String, Set<String>> map) {
        this._dataTypeColsMap = map;
    }

    public void setSplitValues(String string, String string2) {
        if (this._splitValues == null) {
            this._splitValues = new String[2];
        }
        this._splitValues[0] = string;
        this._splitValues[1] = string2;
        this._value = string == null ? string2 : string + "." + string2;
        this._type = TableCellType.TABLE_NAME;
    }

    public String[] getSplitValues() {
        return this._splitValues;
    }

    public String getValue() {
        return this._value;
    }

    public BigDecimal getValueId() {
        return this._valueId;
    }

    public TableCellType getType() {
        return this._type;
    }

    public String getValueType() {
        return this._valueType;
    }

    public TableCell getParentTableCell() {
        return this._parentTableCell;
    }

    public String toString() {
        return this._value;
    }

    public Set<String> getCompatibleColumns(String string) {
        TreeSet<String> treeSet = null;
        if (this._dataTypeColsMap != null) {
            List<String> list = Compatibles.COLUMN_DATA_TYPES.get(string);
            for (String string2 : list) {
                Set<String> set = this._dataTypeColsMap.get(string2);
                if (set == null) continue;
                if (treeSet == null) {
                    treeSet = new TreeSet<String>(set);
                    continue;
                }
                treeSet.addAll(set);
            }
        }
        return treeSet;
    }

    public static enum TableCellType {
        TABLE_NAME,
        COLUMN_NAME;

    }
}

