/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.editors;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.controls.DataMinerFindValuesPanel;
import oracle.dmt.dataminer.core.dal.sql.queries.StringSearchQuery;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public class FindValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Context context;
    private boolean listMultipleSelection;
    private JPanel panel;
    private JTextField textField;
    private JButton searchButton;
    private DataMinerFindValuesPanel findPanel;

    public FindValueCellEditor(Context context, StringSearchQuery stringSearchQuery, boolean bl) {
        this.findPanel = new DataMinerFindValuesPanel(context, stringSearchQuery, DataMinerFindValuesPanel.DisplayMode.GHOST);
        this.listMultipleSelection = bl;
        this.context = context;
        this.initUI();
    }

    private void initUI() {
        this.textField = new JTextField();
        this.searchButton = new JButton();
        this.panel = new CustomEditorPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.textField);
        this.panel.add(this.searchButton);
        this.panel.setBackground(this.textField.getBackground());
        this.panel.setBorder(this.textField.getBorder());
        this.textField.setBorder(null);
        this.findPanel.setMultiSelection(this.listMultipleSelection);
        this.findPanel.addOKListener(actionEvent -> this.commitValue(this.findPanel.getSelectedValue()));
        this.searchButton.setIcon(OracleIcons.getIcon((String)"search.png"));
        this.searchButton.addActionListener(actionEvent -> this.findPanel.show(this.searchButton));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.textField.setText(object.toString());
        this.textField.requestFocus();
        this.searchButton.setVisible(true);
        return this.panel;
    }

    public void clearFindPanel() {
        this.findPanel.clear();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.isCellContentInvalid()) {
            return false;
        }
        return super.stopCellEditing();
    }

    private boolean isCellContentInvalid() {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() == 2;
        }
        return super.isCellEditable(eventObject);
    }

    public void commitValue(String string) {
        this.textField.setText(string);
        this.stopCellEditing();
    }

    public void setQuery(StringSearchQuery stringSearchQuery) {
        assert (stringSearchQuery != null) : "Query cannot be null.";
        this.findPanel.setQuery(stringSearchQuery);
    }

    private class CustomEditorPanel
    extends JPanel {
        private CustomEditorPanel() {
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return this.isTabKeyPressed(keyStroke) ? this.processTabKey() : this.processKeyPressed(keyStroke, n);
        }

        private boolean isTabKeyPressed(KeyStroke keyStroke) {
            return keyStroke.getKeyCode() == 9;
        }

        private boolean processTabKey() {
            FindValueCellEditor.this.searchButton.requestFocus();
            return true;
        }

        private boolean processKeyPressed(KeyStroke keyStroke, int n) {
            return this.hasAssociatedAction(keyStroke, n) ? this.setFocusOnTextField() : false;
        }

        private boolean hasAssociatedAction(KeyStroke keyStroke, int n) {
            boolean bl = false;
            InputMap inputMap = FindValueCellEditor.this.textField.getInputMap(n);
            ActionMap actionMap = FindValueCellEditor.this.textField.getActionMap();
            if (inputMap != null && actionMap != null && this.isEnabled()) {
                Object object = inputMap.get(keyStroke);
                Action action = object == null ? null : actionMap.get(object);
                bl = action != null;
            }
            return bl;
        }

        private boolean setFocusOnTextField() {
            FindValueCellEditor.this.textField.requestFocus();
            return true;
        }
    }
}

