/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;

public abstract class PLSQLPackage {
    private static int ITEM_LEN = 85;
    private String m_packageName = "";
    private String m_packageComment = "";
    private Vector<String> m_procedureNames = new Vector();
    private Vector<String[]> m_procedureParameterNames = new Vector();
    private Vector<String[]> m_procedureParameterTypes = new Vector();
    private Vector<String[]> m_procedureParameterDefaultValues = new Vector();
    private Vector<String> m_procedureBody = new Vector();
    private boolean m_definerRights = true;
    private String PACKAGE_HEADER = "CREATE OR REPLACE PACKAGE {0} AUTHID {1} AS \n";
    private String PACKAGE_FOOTER = "END {0} ;";
    private String PACKAGE_BODY_HEADER = "CREATE OR REPLACE PACKAGE BODY {0}  AS \n";
    private static char SINGLE_QUOTE = (char)39;
    private static char SMILEY_CHAR = '\u0001';

    public PLSQLPackage(String string, String string2) {
        this.m_packageName = string;
        this.m_packageComment = string2;
    }

    public PLSQLPackage() {
    }

    public void setPackageName(String string) {
        this.m_packageName = string;
    }

    public void setPackageComment(String string) {
        this.m_packageComment = string;
    }

    public void addProcedureDefinition(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String string2) {
        this.m_procedureNames.add(string);
        this.m_procedureParameterNames.add(stringArray);
        this.m_procedureParameterTypes.add(stringArray2);
        this.m_procedureBody.add(string2);
        this.m_procedureParameterDefaultValues.add(stringArray3);
    }

    public String getCreatePackageResult() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.generateCreatePackageHeader(stringBuffer);
        this.generateProcedureDefinitions(stringBuffer);
        this.generateCreatePackageFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String getCreatePackageBodyResult() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        this.generateCreatePackageBodyHeader(stringBuffer);
        this.generatePackageBodyDetails(stringBuffer);
        this.generateCreatePackageBodyFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public void setDefinerRights(boolean bl) {
        this.m_definerRights = bl;
    }

    public boolean getDefinerRights() {
        return this.m_definerRights;
    }

    private static void escapeSingleQuotes(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        if (-1 == string.indexOf("COMMENT")) {
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (SINGLE_QUOTE != stringBuffer.charAt(i)) continue;
                stringBuffer.insert(i + 1, SINGLE_QUOTE);
                ++i;
            }
        }
    }

    private static int insureSinqleQuotesAreNotSplit(StringBuffer stringBuffer, int n) {
        boolean bl = true;
        --n;
        do {
            if (SINGLE_QUOTE != stringBuffer.charAt(n)) {
                bl = false;
                ++n;
                continue;
            }
            --n;
        } while (bl);
        return n;
    }

    protected static String[] createSQLArray(StringBuffer stringBuffer) {
        int n;
        int n2 = ITEM_LEN;
        int n3 = stringBuffer.length();
        if (n3 == 0) {
            return new String[0];
        }
        PLSQLPackage.escapeSingleQuotes(stringBuffer);
        n3 = stringBuffer.length();
        int n4 = n3 / ITEM_LEN;
        if (n3 % ITEM_LEN > 0) {
            ++n4;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n4);
        int n5 = 0;
        int n6 = ITEM_LEN;
        boolean bl = false;
        for (n = 0; n < n4; ++n) {
            if (n6 <= n3) {
                n6 = PLSQLPackage.insureSinqleQuotesAreNotSplit(stringBuffer, n6);
                arrayList.add(n, stringBuffer.substring(n5, n6));
            } else {
                arrayList.add(n, stringBuffer.substring(n5));
            }
            n5 = n6;
            n6 += n2;
        }
        if (n5 < n3) {
            arrayList.add(n, stringBuffer.substring(n5));
        }
        String[] stringArray = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, stringArray, 0, arrayList.size());
        return stringArray;
    }

    protected void generateCreatePackageHeader(StringBuffer stringBuffer) {
        Object[] objectArray = new Object[]{this.m_packageName, this.m_definerRights ? "DEFINER" : "CURRENT_USER"};
        stringBuffer.append(MessageFormat.format(this.PACKAGE_HEADER, objectArray));
    }

    protected void generateCreatePackageFooter(StringBuffer stringBuffer) {
        Object[] objectArray = new Object[]{this.m_packageName};
        stringBuffer.append(MessageFormat.format(this.PACKAGE_FOOTER, objectArray));
    }

    protected void generateCreatePackageBodyHeader(StringBuffer stringBuffer) {
        Object[] objectArray = new Object[]{this.m_packageName};
        stringBuffer.append(MessageFormat.format(this.PACKAGE_BODY_HEADER, objectArray));
    }

    protected void generateCreatePackageBodyFooter(StringBuffer stringBuffer) {
        this.generateCreatePackageFooter(stringBuffer);
    }

    protected void generatePackageBodyDetails(StringBuffer stringBuffer) {
        for (int i = 0; i < this.m_procedureNames.size(); ++i) {
            stringBuffer.append("PROCEDURE ");
            stringBuffer.append(this.m_procedureNames.get(i));
            String[] stringArray = this.m_procedureParameterNames.get(i);
            String[] stringArray2 = this.m_procedureParameterTypes.get(i);
            String[] stringArray3 = this.m_procedureParameterDefaultValues.get(i);
            if (stringArray.length > 0) {
                stringBuffer.append(" (");
            }
            for (int j = 0; j < stringArray.length; ++j) {
                stringBuffer.append(stringArray[j] + " " + stringArray2[j] + " DEFAULT '" + stringArray3[j] + "'");
                if (j + 1 >= stringArray.length) continue;
                stringBuffer.append(", ");
            }
            if (stringArray.length > 0) {
                stringBuffer.append(")");
            }
            stringBuffer.append(" IS \n");
            stringBuffer.append(this.m_procedureBody.get(i) + " \n ");
            stringBuffer.append("END; \n ");
        }
    }

    protected void generateProcedureDefinitions(StringBuffer stringBuffer) {
        for (int i = 0; i < this.m_procedureNames.size(); ++i) {
            stringBuffer.append("PROCEDURE ");
            stringBuffer.append(this.m_procedureNames.get(i));
            String[] stringArray = this.m_procedureParameterNames.get(i);
            String[] stringArray2 = this.m_procedureParameterTypes.get(i);
            String[] stringArray3 = this.m_procedureParameterDefaultValues.get(i);
            if (stringArray.length > 0) {
                stringBuffer.append(" (");
            }
            for (int j = 0; j < stringArray.length; ++j) {
                stringBuffer.append(stringArray[j] + " " + stringArray2[j] + " DEFAULT '" + stringArray3[j] + "'");
                if (j + 1 >= stringArray.length) continue;
                stringBuffer.append(", ");
            }
            if (stringArray.length > 0) {
                stringBuffer.append(")");
            }
            stringBuffer.append("; \n");
        }
    }

    public static String[] createQuotedConcatConstructorParms(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "\u0001 || \u0001\"\u0001 || " + stringArray[i] + " || \u0001\"\u0001 || \u0001";
        }
        return stringArray2;
    }

    public static String[] createQuotedConcatConstructorParmsOLD(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "\" || " + stringArray[i] + " || \"";
        }
        return stringArray2;
    }

    public static String[] createQuotedParms(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "\"" + stringArray[i] + "\"";
        }
        return stringArray2;
    }
}

