/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.mviewer.ModelViewerState;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.PCAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.FeatureExtraction;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelC;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelR;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.NaiveBayes;
import oracle.dmt.dataminer.server.model.Regression;
import oracle.dmt.dataminer.server.model.SingularValueDecomposition;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesC;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesR;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.ide.Context;

public abstract class BaseViewerState {
    protected Context context;
    protected String algorithm;
    protected ModelViewerState modelViewerState;
    protected ConnectionManager connectionManager;
    protected SqlDataAccessObject dao;

    public BaseViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this.context = context;
        this.modelViewerState = new ModelViewerState(context);
        this.modelViewerState.load();
        this.connectionManager = ConnectionFolder.getConnectionFolder(context);
        this.dao = new SqlDataAccessObject(this.connectionManager);
    }

    public ModelViewerState getModelViewerState() {
        return this.modelViewerState;
    }

    public boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this.context.getNode();
        boolean bl = modelNode instanceof ANModelNode;
        return bl;
    }

    public boolean isAssociation() {
        boolean bl = this.getModelGeneralDescription().isAssociationRulesModel();
        return bl;
    }

    public boolean isClassification() {
        boolean bl = this.getModelGeneralDescription().isClassificationModel();
        return bl;
    }

    public boolean isClustering() {
        boolean bl = this.getModelGeneralDescription().isClusteringModel();
        return bl;
    }

    public boolean isFeatureExtraction() {
        boolean bl = this.getModelGeneralDescription().isFeatureExtractionModel();
        return bl;
    }

    public boolean isExplicitFeatureExtration() {
        boolean bl = this.getModelGeneralDescription().isExplicitFeatureExtractionModel();
        return bl;
    }

    public boolean isRegression() {
        boolean bl = this.getModelGeneralDescription().isRegressionModel();
        return bl;
    }

    public boolean isNB() {
        boolean bl = this.getModelGeneralDescription().isNaiveBayesAlgorithm();
        return bl;
    }

    public boolean isGLM() {
        boolean bl = this.getModelGeneralDescription().isGeneralizedLinearModelAlgorithm();
        return bl;
    }

    public boolean isSVM() {
        boolean bl = this.getModelGeneralDescription().isSupportVectorMachinesAlgorithm();
        return bl;
    }

    public boolean isDT() {
        boolean bl = this.getModelGeneralDescription().isDecisionTreeAlgorithm();
        return bl;
    }

    public boolean isAR() {
        boolean bl = this.getModelGeneralDescription().isAPrioriAssociationRulesAlgorithm();
        return bl;
    }

    public boolean isKM() {
        boolean bl = this.getModelGeneralDescription().isKmeansAlgorithm();
        return bl;
    }

    public boolean isOC() {
        boolean bl = this.getModelGeneralDescription().isOClusterAlgorithm();
        return bl;
    }

    public boolean isEM() {
        boolean bl = this.getModelGeneralDescription().isEMAlgorithm();
        return bl;
    }

    public boolean isNMF() {
        boolean bl = this.getModelGeneralDescription().isNonnegativeMatrixFactorAlgorithm();
        return bl;
    }

    public boolean isPCA() {
        boolean bl = this.getContext().getNode() instanceof PCAModelNode && this.getModelGeneralDescription().isSingularValueDecompositionAlgorithm();
        return bl;
    }

    public boolean isSVD() {
        boolean bl = this.getContext().getNode() instanceof SVDModelNode && this.getModelGeneralDescription().isSingularValueDecompositionAlgorithm();
        return bl;
    }

    public boolean isESA() {
        boolean bl = this.getModelGeneralDescription().isExplicitSemanticAnalysisAlgorithm();
        return bl;
    }

    public boolean isAI() {
        return this.getModelGeneralDescription().isAttributeImportanceModel();
    }

    private ModelGeneralDescription getModelGeneralDescription() {
        return this.modelViewerState.getOdmModel().getModelGeneralDescription();
    }

    public Context getContext() {
        return this.context;
    }

    public String getUserName() {
        return this.modelViewerState.getUserName();
    }

    public String getModelName() {
        return this.modelViewerState.getModelName();
    }

    protected Model getModel() {
        return this.modelViewerState.getOdmModel();
    }

    protected Classification getClassification() {
        return (Classification)this.modelViewerState.getOdmModel();
    }

    protected Regression getRegression() {
        return (Regression)this.modelViewerState.getOdmModel();
    }

    public Clustering getClustering() {
        return (Clustering)this.getModelViewerState().getOdmModel();
    }

    protected NaiveBayes getNb() {
        return (NaiveBayes)this.modelViewerState.getOdmModel();
    }

    protected GeneralizedLinearModelC getGlmC() {
        return (GeneralizedLinearModelC)this.modelViewerState.getOdmModel();
    }

    protected GeneralizedLinearModelR getGlmR() {
        return (GeneralizedLinearModelR)this.modelViewerState.getOdmModel();
    }

    protected SupportVectorMachinesC getSvmC() {
        return (SupportVectorMachinesC)this.modelViewerState.getOdmModel();
    }

    protected SupportVectorMachinesR getSvmR() {
        return (SupportVectorMachinesR)this.modelViewerState.getOdmModel();
    }

    protected SingularValueDecomposition getSvd() {
        return (SingularValueDecomposition)this.modelViewerState.getOdmModel();
    }

    protected FeatureExtraction getFeatureExtraction() {
        return (FeatureExtraction)this.modelViewerState.getOdmModel();
    }

    public AssociationRules getAssociationRules() {
        return (AssociationRules)this.modelViewerState.getOdmModel();
    }

    public void setPartitionId(PartitionVO partitionVO) {
        String string = null;
        if (partitionVO != null) {
            string = partitionVO.getPartitionID();
        }
        this.setPartitionId(string);
    }

    public void setPartitionId(String string) {
        this.getModel().setPartitionId(string);
    }

    public Class<? extends ModelType> getModelTypeClass() {
        Class<ExplicitSemanticAnalysisModelType> clazz = null;
        if (this.isESA()) {
            clazz = ExplicitSemanticAnalysisModelType.class;
        } else if (this.isPCA()) {
            clazz = PCAModelType.class;
        } else if (this.isNMF()) {
            clazz = NonNegativeMatrixFactorModelType.class;
        } else if (this.isSVD()) {
            clazz = SVDModelType.class;
        } else assert (false) : "Not Implemented Yet";
        return clazz;
    }
}

