/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.rules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.editors.RangeCellEditor;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.ar.RulesFilterSetting;
import oracle.dmt.dataminer.core.model.ar.filter.FilterFor;
import oracle.dmt.dataminer.core.model.ar.filter.FilterOn;
import oracle.dmt.dataminer.core.model.ar.filter.FilterRule;
import oracle.dmt.dataminer.core.model.ar.filter.FilterType;
import oracle.dmt.dataminer.core.model.ar.filter.SortBy;
import oracle.dmt.dataminer.core.model.common.Range;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.res.ARLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARRulesViewerState;
import oracle.dmt.dataminer.mviewer.arrules.rules.FilterRuleFactory;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARFilterPanel;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.editor.Editor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.Version;

public class ARRulesFilterPanel
extends JPanel {
    private boolean filterExpanded;
    private Editor editor;
    private ArFilterTableModel filterTableModel;
    private ARRulesViewerState state;
    private PropertyChangeSupport pcs;
    private Dimension filterSize;
    private Version dbVersion;
    private ButtonGroup _jSortGrp;
    private JButton jApplyFilterButton;
    private JRadioButton jAscBtn;
    private JLabel jCollapsedFilterMsgLbl;
    private JRadioButton jDescBtn;
    private JButton jExpandButton;
    private JLabel jFetchSizeLabel;
    private JSpinner jFetchSizeValue;
    private JLabel jFilterMessageLbl;
    private JPanel jFilterMsgPanel;
    private JPanel jFilterPanel;
    private DataMinerTablePanel jFilterTablePanel;
    private JPanel jFilterTitlePanel;
    private ModelViewerPartitionToolbar jPartitionToolbar;
    private JLabel jSortByLabel;
    private JComboBox<SortBy> jSortCombo;
    private JCheckBox jUseFilterChkBox;
    private JButton jFilterForRuleBtn;
    private JButton jFilterForAntecedentBtn;
    private JButton jFilterForConsequentBtn;
    private JButton jDeleteFilterRowBtn;
    private ActionMenuToolButton jAddFilterAction;
    private FilterOnCellEditor filterOnCellEditor;

    public ARRulesFilterPanel(Editor editor, ARRulesViewerState aRRulesViewerState) {
        this.editor = editor;
        this.state = aRRulesViewerState;
        this.pcs = new PropertyChangeSupport(this);
        this.dbVersion = ConnectionFolder.getConnectionFolder(aRRulesViewerState.getContext()).getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jSortGrp = new ButtonGroup();
        this.jSortByLabel = new JLabel();
        this.jSortCombo = new JComboBox();
        this.jFetchSizeLabel = new JLabel();
        this.jFetchSizeValue = new JSpinner();
        this.jApplyFilterButton = new JButton();
        this.jExpandButton = new JButton();
        this.jPartitionToolbar = new ModelViewerPartitionToolbar();
        this.jAscBtn = new JRadioButton();
        this.jDescBtn = new JRadioButton();
        this.jFilterTitlePanel = new JPanel();
        this.jFilterMsgPanel = new JPanel();
        this.jCollapsedFilterMsgLbl = new JLabel();
        this.jFilterPanel = new JPanel();
        this.jUseFilterChkBox = new JCheckBox();
        this.jFilterTablePanel = new DataMinerTablePanel();
        this.jFilterMessageLbl = new JLabel();
        this.jSortByLabel.setText("Sort by:");
        this.jFetchSizeLabel.setText("Fetch Size:");
        this.jApplyFilterButton.setText("Query");
        this.jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this.jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this.jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this.jExpandButton.setText("More");
        this.jExpandButton.setMaximumSize(new Dimension(87, 23));
        this.jExpandButton.setMinimumSize(new Dimension(87, 23));
        this.jExpandButton.setPreferredSize(new Dimension(87, 23));
        this._jSortGrp.add(this.jAscBtn);
        this.jAscBtn.setText("Ascending");
        this._jSortGrp.add(this.jDescBtn);
        this.jDescBtn.setText("Descending");
        this.jFilterTitlePanel.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.jCollapsedFilterMsgLbl.setText("No Filter");
        GroupLayout groupLayout = new GroupLayout(this.jFilterMsgPanel);
        this.jFilterMsgPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jCollapsedFilterMsgLbl, -1, 679, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jCollapsedFilterMsgLbl).addGap(6, 6, 6)));
        this.jUseFilterChkBox.setText("Use filter");
        this.jUseFilterChkBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jFilterTablePanel.setMinimumSize(new Dimension(23, 130));
        this.jFilterMessageLbl.setText("Rules Message");
        GroupLayout groupLayout2 = new GroupLayout(this.jFilterPanel);
        this.jFilterPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFilterTablePanel, GroupLayout.Alignment.TRAILING, -1, 689, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jFilterMessageLbl)).addComponent(this.jUseFilterChkBox, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jUseFilterChkBox, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFilterTablePanel, -1, 130, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFilterMessageLbl).addGap(6, 6, 6)));
        GroupLayout groupLayout3 = new GroupLayout(this.jFilterTitlePanel);
        this.jFilterTitlePanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jFilterPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jFilterMsgPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jFilterMsgPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFilterPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jSortByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSortCombo, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAscBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDescBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFetchSizeValue, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jApplyFilterButton, -2, 119, -2)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.jPartitionToolbar, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jExpandButton, -2, 119, -2)).addComponent(this.jFilterTitlePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSortByLabel).addComponent(this.jSortCombo, -2, -1, -2).addComponent(this.jAscBtn).addComponent(this.jDescBtn)).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jApplyFilterButton, -2, -1, -2).addComponent(this.jFetchSizeValue, -2, -1, -2).addComponent(this.jFetchSizeLabel, -2, 14, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jExpandButton, -2, -1, -2).addComponent(this.jPartitionToolbar, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.jFilterTitlePanel, -1, -1, Short.MAX_VALUE).addGap(5, 5, 5)));
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jFilterMessageLbl, null, (String)"");
        ResourceUtils.resButton((AbstractButton)this.jApplyFilterButton, (String)ControlsLrb.get("FILTER_QUERY"));
        this.jApplyFilterButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_QUERY"));
        this.jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_QUERY_ADA"));
        this.jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this.jFetchSizeLabel, (Component)this.jFetchSizeValue, (String)ControlsLrb.get("FILTER_FETCH_SIZE"));
        this.jFetchSizeLabel.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_FETCH_SIZE"));
        this.jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_FETCH_SIZE_ADA"));
        this.jFetchSizeValue.setToolTipText(ControlsLrb.get("FILTER_FETCH_SIZE_ADA") + "\n" + ControlsLrb.get("FILTER_FETCH_SIZE_RANGE"));
        ResourceUtils.resLabel((JLabel)this.jSortByLabel, this.jSortCombo, (String)ControlsLrb.get("FILTER_SORT_BY"));
        this.jSortByLabel.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_SORT_BY"));
        this.jSortByLabel.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_SORT_BY_ADA"));
        this.jSortCombo.setModel(new DefaultComboBoxModel<SortBy>(SortBy.values()));
        this.jSortCombo.setToolTipText(ControlsLrb.get("FILTER_SORT_BY_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jAscBtn, (String)SortDirection.ASCENDING.toString());
        ResourceUtils.resButton((AbstractButton)this.jDescBtn, (String)SortDirection.DESCENDING.toString());
        ResourceUtils.resButton((AbstractButton)this.jExpandButton, (String)ControlsLrb.get("FILTER_MORE"));
        this.jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
        this.jExpandButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_MORE"));
        this.jExpandButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_MORE_ADA"));
        this.jExpandButton.setHorizontalTextPosition(10);
        this.jExpandButton.setHorizontalTextPosition(10);
        ResourceUtils.resButton((AbstractButton)this.jUseFilterChkBox, (String)ControlsLrb.get("FILTER_USE_FILTER"));
        this.jUseFilterChkBox.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_USE_FILTER"));
        this.jUseFilterChkBox.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_USE_FILTER_ADA"));
    }

    private void initUI() {
        this.initUIControls();
        this.initFilter();
    }

    private void initUIControls() {
        this.jSortCombo.setSelectedItem(SortBy.LIFT);
        this.jDescBtn.setSelected(true);
        this.jFetchSizeValue.setModel(new SpinnerNumberModel(this.state.getFilterSetting().getFetchSize(), 1, Integer.MAX_VALUE, 100));
        this.jFilterPanel.setVisible(false);
        this.jPartitionToolbar.setVisible(false);
    }

    private void initFilter() {
        this.initFilterTable();
        this.initFilterToolbar();
        this.initOtherFilterRelatedListeners();
    }

    private void initFilterTable() {
        List list = this.state.getFilterSetting().getFilters();
        ArrayList arrayList = new ArrayList(list.size());
        arrayList.addAll(list);
        this.filterTableModel = new ArFilterTableModel(arrayList);
        this.filterTableModel.addTableModelListener(new FilterTableModelListener());
        this.jFilterTablePanel.setup((TableModel)((Object)this.filterTableModel), "Filter", 0);
        this.filterOnCellEditor = new FilterOnCellEditor(this.dbVersion);
        TableColumnModel tableColumnModel = this.jFilterTablePanel.getTable().getColumnModel();
        tableColumnModel.getColumn(0).setCellEditor(new TypeCellEditor());
        tableColumnModel.getColumn(2).setCellRenderer((TableCellRenderer)((Object)new FilterForRenderer()));
        tableColumnModel.getColumn(1).setCellEditor(this.filterOnCellEditor);
        tableColumnModel.getColumn(2).setCellEditor(new FilterForCellEditor());
        tableColumnModel.getColumn(3).setCellEditor(new ValueCellEditor());
        this.jFilterTablePanel.getTable().getSelectionModel().addListSelectionListener(new FilterTableSelectionListener());
        this.jFilterTablePanel.getTable().setEnabled(false);
    }

    private void initFilterToolbar() {
        ChangeFilterForAction changeFilterForAction = new ChangeFilterForAction();
        this.jFilterForRuleBtn = new JButton(DataMinerIcons.get(Icons.AR_RULE));
        this.jFilterForAntecedentBtn = new JButton(DataMinerIcons.get(Icons.AR_ANTECEDENT));
        this.jFilterForConsequentBtn = new JButton(DataMinerIcons.get(Icons.AR_CONSEQUENT));
        this.jFilterForRuleBtn.addActionListener(changeFilterForAction);
        this.jFilterForAntecedentBtn.addActionListener(changeFilterForAction);
        this.jFilterForConsequentBtn.addActionListener(changeFilterForAction);
        this.jFilterForRuleBtn.setEnabled(false);
        this.jFilterForAntecedentBtn.setEnabled(false);
        this.jFilterForConsequentBtn.setEnabled(false);
        this.jFilterForRuleBtn.setToolTipText(ARRulesLrb.get("RULES_FILTER_FILTER_FOR_RULE_BTN_TOOLTIP"));
        this.jFilterForAntecedentBtn.setToolTipText(ARRulesLrb.get("RULES_FILTER_FILTER_FOR_ANTECEDENT_BTN_TOOLTIP"));
        this.jFilterForConsequentBtn.setToolTipText(ARRulesLrb.get("RULES_FILTER_FILTER_FOR_CONSEQUENT_BTN_TOOLTIP"));
        this.jFilterTablePanel.addControlBarComponents(this.jFilterForRuleBtn, this.jFilterForAntecedentBtn, this.jFilterForConsequentBtn);
        AddMetricFilterAction addMetricFilterAction = new AddMetricFilterAction();
        AddItemFilterAction addItemFilterAction = new AddItemFilterAction();
        Action[] actionArray = new Action[]{addMetricFilterAction, addItemFilterAction};
        this.jAddFilterAction = new ActionMenuToolButton((Action)addMetricFilterAction);
        this.jAddFilterAction.setToolTipText(ARRulesLrb.get("RULES_FILTER_ADD_RULE_BTN_TOOLTIP"));
        this.jAddFilterAction.setMenuActions(actionArray);
        this.jAddFilterAction.setEnabled(false);
        this.jDeleteFilterRowBtn = new JButton(new DeleteFilterRowsAction());
        this.jDeleteFilterRowBtn.setToolTipText(ARRulesLrb.get("RULES_FILTER_DELETE_FILTER_BTN_TOOLTIP"));
        this.jFilterTablePanel.addControlBarComponents(new Component[]{this.jAddFilterAction, this.jDeleteFilterRowBtn});
    }

    private void initOtherFilterRelatedListeners() {
        this.jExpandButton.addActionListener(new ToogleFilterButtonActionListener());
        this.jUseFilterChkBox.addActionListener(new UseFilterCheckBoxActionListener());
    }

    private void enableDisableFilter() {
        boolean bl = this.jUseFilterChkBox.isSelected();
        RulesFilterSetting rulesFilterSetting = this.state.getFilterSetting();
        rulesFilterSetting.setFilterEnabled(bl);
        this.jFilterTablePanel.getTable().setEnabled(bl);
        this.enableDisableFilterToolbarButtons();
    }

    private void enableDisableFilterToolbarButtons() {
        int[] nArray = this.jFilterTablePanel.getTable().getSelectedRowsInModel();
        boolean bl = this.jUseFilterChkBox.isSelected();
        boolean bl2 = bl && nArray.length > 0;
        List list = this.filterTableModel.getRows(nArray);
        boolean bl3 = bl2 && list.stream().allMatch(filterRule -> {
            boolean bl = !filterRule.isRuleOnlyFilter();
            return bl;
        });
        boolean bl4 = bl2 && list.stream().anyMatch(filterRule -> {
            boolean bl = !filterRule.isAntConOnlyFilter();
            return bl;
        });
        this.jFilterForConsequentBtn.setEnabled(bl3);
        this.jFilterForAntecedentBtn.setEnabled(bl3);
        this.jFilterForRuleBtn.setEnabled(bl4);
        this.jDeleteFilterRowBtn.setEnabled(bl2);
        this.jAddFilterAction.setEnabled(bl);
    }

    private void disableFilterForToolbarButtons() {
        this.jFilterForConsequentBtn.setEnabled(false);
        this.jFilterForAntecedentBtn.setEnabled(false);
        this.jFilterForRuleBtn.setEnabled(false);
    }

    private void updateFilterLabelsAndQueryButton() {
        FilterState filterState = this.getFilterState();
        boolean bl = !FilterState.DISABLED.equals((Object)filterState);
        boolean bl2 = FilterState.VALID.equals((Object)filterState) || FilterState.DISABLED.equals((Object)filterState);
        this.jApplyFilterButton.setEnabled(bl2);
        this.jCollapsedFilterMsgLbl.setText(filterState.collapsedMessage);
        this.jCollapsedFilterMsgLbl.setIcon(filterState.collapsedMessageIcon);
        if (bl) {
            this.jFilterMessageLbl.setText(filterState.filterMessage);
            this.jFilterMessageLbl.setIcon(filterState.filterMessageIcon);
        }
        this.jFilterMessageLbl.setEnabled(bl);
    }

    private FilterState getFilterState() {
        List list = this.filterTableModel.getSrcData();
        boolean bl = this.jUseFilterChkBox.isSelected();
        FilterState filterState = FilterState.DISABLED;
        if (bl) {
            boolean bl2 = list.stream().allMatch(filterRule -> filterRule.isValid());
            if (bl2) {
                boolean bl3 = list.stream().distinct().count() != (long)list.size();
                filterState = bl3 ? FilterState.DUPLICATE : FilterState.VALID;
            } else {
                filterState = FilterState.INVALID;
            }
        }
        return filterState;
    }

    public void addActionListener(ActionListener actionListener) {
        this.jApplyFilterButton.addActionListener(actionListener);
    }

    public void addFilterPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    void beforeLoad() {
        this.updateRulesFilterSetting();
    }

    private void updateRulesFilterSetting() {
        RulesFilterSetting rulesFilterSetting = this.state.getFilterSetting();
        rulesFilterSetting.setFilters(this.filterTableModel.getSrcData());
        int n = (Integer)this.jFetchSizeValue.getValue();
        rulesFilterSetting.setFetchSize(n);
        SortBy sortBy = (SortBy)this.jSortCombo.getSelectedItem();
        SortDirection sortDirection = this.jAscBtn.isSelected() ? SortDirection.ASCENDING : SortDirection.DESCENDING;
        ArrayList<SortSpec> arrayList = new ArrayList<SortSpec>(1);
        arrayList.add(new SortSpec(sortBy.getServerName(), sortDirection));
        rulesFilterSetting.setSortSpecs(arrayList);
        boolean bl = this.jUseFilterChkBox.isSelected();
        rulesFilterSetting.setFilterEnabled(bl);
    }

    void afterLoad() {
        if (this.state.hasAggregates()) {
            this.jSortCombo.setModel(new DefaultComboBoxModel<SortBy>(SortBy.values()));
            for (String string : this.state.aggregates()) {
                String string2 = String.format("(%s%s + %s%s)", "ANT_RULE_", string, "CON_RULE_", string);
                this.jSortCombo.addItem(new SortBy(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_RULE"), string), string2));
                this.jSortCombo.addItem(new SortBy(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_ANTECEDENT"), string), "ANT_RULE_" + string));
                this.jSortCombo.addItem(new SortBy(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_CONSEQUENT"), string), "CON_RULE_" + string));
            }
            this.filterOnCellEditor.setAggregates(this.state.aggregates());
        }
    }

    String getSelectedPartitionID() {
        return this.jPartitionToolbar.getSelectedPartitionID();
    }

    boolean isFilterExpanded() {
        return this.filterExpanded;
    }

    private void setFilterExpanded(boolean bl) {
        boolean bl2 = this.filterExpanded;
        this.filterExpanded = bl;
        this.pcs.firePropertyChange("FILTER_EXPANDED", bl2, this.filterExpanded);
    }

    void loadPartitionToobar() {
        this.jPartitionToolbar.load(this.editor);
    }

    private static class ValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TableCellEditor editor;
        private TableCellEditor rangeEditor = new RangeCellEditor();
        private TableCellEditor defaultEditor = new DefaultCellEditor(new JTextField());

        private ValueCellEditor() {
            this.editor = this.rangeEditor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Range) {
                this.editor = this.rangeEditor;
            } else if (object instanceof String) {
                this.editor = this.defaultEditor;
            }
            return this.editor.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return this.editor.isCellEditable(eventObject);
        }

        @Override
        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return this.editor.shouldSelectCell(eventObject);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.editor.removeCellEditorListener(cellEditorListener);
        }

        @Override
        public CellEditorListener[] getCellEditorListeners() {
            return ((AbstractCellEditor)((Object)this.editor)).getCellEditorListeners();
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.editor.addCellEditorListener(cellEditorListener);
        }
    }

    private static class FilterForCellEditor
    extends DefaultCellEditor {
        private DefaultComboBoxModel<FilterFor> metricModel;
        private DefaultComboBoxModel<FilterFor> ruleOnlyModel;
        private DefaultComboBoxModel<FilterFor> itemSetModel;

        private FilterForCellEditor() {
            super(new JComboBox());
            this.setClickCountToStart(2);
            this.initModels();
        }

        private void initModels() {
            this.metricModel = new DefaultComboBoxModel();
            this.metricModel.addElement(FilterFor.RULE);
            this.metricModel.addElement(FilterFor.ANTECEDENT);
            this.metricModel.addElement(FilterFor.CONSEQUENT);
            this.ruleOnlyModel = new DefaultComboBoxModel();
            this.ruleOnlyModel.addElement(FilterFor.RULE);
            this.itemSetModel = new DefaultComboBoxModel();
            this.itemSetModel.addElement(FilterFor.ANTECEDENT);
            this.itemSetModel.addElement(FilterFor.CONSEQUENT);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            JComboBox jComboBox = (JComboBox)component;
            DefaultComboBoxModel<FilterFor> defaultComboBoxModel = this.getComboModel(jTable, n);
            jComboBox.setModel(defaultComboBoxModel);
            return component;
        }

        private DefaultComboBoxModel<FilterFor> getComboModel(JTable jTable, int n) {
            FilterOn filterOn;
            DefaultComboBoxModel<FilterFor> defaultComboBoxModel = null;
            FilterType filterType = (FilterType)jTable.getValueAt(n, 0);
            defaultComboBoxModel = FilterType.METRIC.equals((Object)filterType) ? (FilterOn.SUPPORT.equals((Object)(filterOn = (FilterOn)jTable.getValueAt(n, 1))) || FilterOn.SUPPORT_COUNT.equals((Object)filterOn) || filterOn.isAggregate() ? this.metricModel : this.ruleOnlyModel) : this.itemSetModel;
            return defaultComboBoxModel;
        }
    }

    private static class FilterForRenderer
    extends GenericTableCellRenderer {
        private FilterForRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object == null) {
                jLabel.setText("");
                jLabel.setIcon(null);
            } else {
                FilterFor filterFor = (FilterFor)object;
                switch (filterFor) {
                    case RULE: {
                        jLabel.setIcon(DataMinerIcons.get(Icons.AR_RULE));
                        break;
                    }
                    case ANTECEDENT: {
                        jLabel.setIcon(DataMinerIcons.get(Icons.AR_ANTECEDENT));
                        break;
                    }
                    case CONSEQUENT: {
                        jLabel.setIcon(DataMinerIcons.get(Icons.AR_CONSEQUENT));
                        break;
                    }
                    default: {
                        assert (false) : "invalid option";
                        break;
                    }
                }
                jLabel.setText(object.toString());
            }
            return jLabel;
        }
    }

    private static class FilterOnCellEditor
    extends DefaultCellEditor {
        private DefaultComboBoxModel<FilterOn> comboModel;
        private Version dbVersion;

        private FilterOnCellEditor(Version version) {
            super(new JComboBox());
            this.dbVersion = version;
            this.setClickCountToStart(2);
            this.setModel(version);
        }

        private void setModel(Version version) {
            JComboBox jComboBox = (JComboBox)this.getComponent();
            FilterOn[] filterOnArray = DbVersionHelper.isDB122Up((Version)version) ? FilterOn.FILTERS_12_2 : FilterOn.FILTERS;
            this.comboModel = new DefaultComboBoxModel<FilterOn>(filterOnArray);
            jComboBox.setModel(this.comboModel);
        }

        private void setAggregates(List<String> list) {
            this.setModel(this.dbVersion);
            for (String string : list) {
                this.comboModel.addElement(new FilterOn(string, string));
                this.comboModel.addElement(new FilterOn(string + "-" + ARLrb.get((String)"ITEMSET"), string));
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.setSelectedIndex(0);
            return component;
        }
    }

    private static class TypeCellEditor
    extends DefaultCellEditor {
        private TypeCellEditor() {
            super(new JComboBox());
            this.setClickCountToStart(2);
            this.setModel();
        }

        private void setModel() {
            JComboBox jComboBox = (JComboBox)this.getComponent();
            FilterType[] filterTypeArray = new FilterType[]{FilterType.ITEM_INCLUDE, FilterType.ITEM_EXCLUDE};
            DefaultComboBoxModel<FilterType> defaultComboBoxModel = new DefaultComboBoxModel<FilterType>(filterTypeArray);
            jComboBox.setModel(defaultComboBoxModel);
        }
    }

    private static enum FilterState {
        DISABLED("", null, CoreCommonLrb.get((String)"MSG_FILTER_NO_FILTER"), null),
        VALID("", null, CoreCommonLrb.get((String)"MSG_FILTER_ACTIVE"), OracleIcons.getIcon((String)"filter.png")),
        INVALID(CoreCommonLrb.get((String)"MSG_FILTER_INCOMPLET"), OracleIcons.getIcon((String)"error.png"), CoreCommonLrb.get((String)"MSG_FILTER_INCOMPLET"), OracleIcons.getIcon((String)"error.png")),
        DUPLICATE(CoreCommonLrb.get((String)"MSG_FILTER_DUPLICATE"), OracleIcons.getIcon((String)"warning.png"), CoreCommonLrb.get((String)"MSG_FILTER_DUPLICATE"), OracleIcons.getIcon((String)"warning.png"));

        private String filterMessage;
        private Icon filterMessageIcon;
        private String collapsedMessage;
        private Icon collapsedMessageIcon;

        private FilterState(String string2, Icon icon, String string3, Icon icon2) {
            this.filterMessage = string2;
            this.filterMessageIcon = icon;
            this.collapsedMessage = string3;
            this.collapsedMessageIcon = icon2;
        }
    }

    private class ArFilterTableModel
    extends ODMrTableModel<FilterRule> {
        private static final int TYPE = 0;
        private static final int FILTER_ON = 1;
        private static final int FILTER_FOR = 2;
        private static final int VALUE = 3;
        private final String[] COLUMNS;

        private ArFilterTableModel(List<FilterRule> list) {
            super(list);
            this.COLUMNS = new String[]{ARLrb.get((String)"RULES_FILTER_TYPE"), ARLrb.get((String)"RULES_FILTER_FILTER_ON"), ARLrb.get((String)"RULES_FILTER_FILTER_FOR"), ARLrb.get((String)"RULES_FILTER_VALUE")};
            this.setColumnIdentifiers(this.COLUMNS);
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = true;
            boolean bl2 = FilterType.METRIC.equals(this.getValueAt(n, 0));
            switch (n2) {
                case 0: {
                    bl = !bl2;
                    break;
                }
                case 1: {
                    bl = bl2;
                    break;
                }
                case 2: {
                    boolean bl3;
                    bl = bl3 = this.getValueAt(n, 1) != null;
                    break;
                }
                case 3: {
                    if (bl2) {
                        boolean bl4;
                        bl = bl4 = this.getValueAt(n, 2) != null;
                        break;
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }

        public Object getValueAt(int n, int n2) {
            String string = "";
            FilterRule filterRule = (FilterRule)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    string = filterRule.getFilterType();
                    break;
                }
                case 1: {
                    string = filterRule.getFilterOn();
                    break;
                }
                case 2: {
                    string = filterRule.getFilterFor();
                    break;
                }
                case 3: {
                    if (FilterType.METRIC.equals((Object)filterRule.getFilterType())) {
                        string = filterRule.getRange();
                        break;
                    }
                    string = filterRule.getValue();
                    break;
                }
                default: {
                    assert (false) : "Invalid column index";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            FilterRule filterRule = (FilterRule)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    filterRule.setFilterType((FilterType)object);
                    break;
                }
                case 1: {
                    FilterOn filterOn = (FilterOn)object;
                    filterRule.setFilterOn(filterOn);
                    FilterRule filterRule2 = FilterRuleFactory.getNewMetricFilterRule(filterOn, ARRulesFilterPanel.this.dbVersion);
                    if (filterRule.getFilterFor() != null) {
                        boolean bl;
                        if (filterRule.isRuleOnlyFilter()) {
                            filterRule.setFilterFor(FilterFor.RULE);
                        }
                        boolean bl2 = bl = filterRule.getRange() == null || filterRule.getRange().getType() != filterRule2.getRange().getType();
                        if (!bl) break;
                        filterRule.setRange(filterRule2.getRange());
                        break;
                    }
                    filterRule.setFilterFor(FilterFor.RULE);
                    filterRule.setRange(filterRule2.getRange());
                    break;
                }
                case 2: {
                    filterRule.setFilterFor((FilterFor)object);
                    break;
                }
                case 3: {
                    if (FilterType.METRIC.equals((Object)filterRule.getFilterType())) {
                        filterRule.setRange((Range)object);
                        break;
                    }
                    filterRule.setValue(object.toString());
                    break;
                }
                default: {
                    assert (false) : "Invalid column index";
                    break;
                }
            }
            this.fireTableRowsUpdated(n, n);
            ARRulesFilterPanel.this.enableDisableFilterToolbarButtons();
        }
    }

    private class FilterTableSelectionListener
    implements ListSelectionListener {
        private FilterTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ARRulesFilterPanel.this.enableDisableFilterToolbarButtons();
        }
    }

    private class FilterTableModelListener
    implements TableModelListener {
        private FilterTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getType();
            if (n == -1 || n == 1 || n == 0) {
                ARRulesFilterPanel.this.updateFilterLabelsAndQueryButton();
            }
        }
    }

    private class ChangeFilterForAction
    implements ActionListener {
        private ChangeFilterForAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ARRulesFilterPanel.this.jFilterTablePanel.getTable().getSelectedRowsInModel();
            FilterFor filterFor = this.getSelectedFilterFor(actionEvent.getSource());
            this.updateRows(nArray, filterFor);
        }

        private FilterFor getSelectedFilterFor(Object object) {
            FilterFor filterFor = null;
            filterFor = object == ARRulesFilterPanel.this.jFilterForAntecedentBtn ? FilterFor.ANTECEDENT : (object == ARRulesFilterPanel.this.jFilterForConsequentBtn ? FilterFor.CONSEQUENT : FilterFor.RULE);
            return filterFor;
        }

        private void updateRows(int[] nArray, FilterFor filterFor) {
            List list = ARRulesFilterPanel.this.filterTableModel.getRows(nArray);
            for (FilterRule filterRule : list) {
                filterRule.setFilterFor(filterFor);
            }
            ARRulesFilterPanel.this.filterTableModel.fireTableDataChanged();
            ARRulesFilterPanel.this.jFilterTablePanel.getTable().setSelectedRowsInModel(nArray);
        }
    }

    private class DeleteFilterRowsAction
    extends AbstractAction {
        private DeleteFilterRowsAction() {
            super("", OracleIcons.getIcon((String)"delete.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ARRulesFilterPanel.this.jFilterTablePanel.getTable().isEditing()) {
                ARRulesFilterPanel.this.jFilterTablePanel.getTable().getCellEditor().cancelCellEditing();
            }
            int[] nArray = ARRulesFilterPanel.this.jFilterTablePanel.getTable().getSelectedRowsInModel();
            ARRulesFilterPanel.this.filterTableModel.removeRows(nArray);
        }
    }

    private class AddItemFilterAction
    extends AbstractAction {
        private AddItemFilterAction() {
            super(CoreCommonLrb.get((String)"ITEM"), OracleIcons.getIcon((String)"add.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelARFilterPanel modelARFilterPanel = new ModelARFilterPanel(ARRulesFilterPanel.this.state.getContext(), ARRulesFilterPanel.this.state.getModelDescriptor(ARRulesFilterPanel.this.getSelectedPartitionID()));
            DialogHelper dialogHelper = new DialogHelper(modelARFilterPanel);
            if (dialogHelper.showAsDialog(ARRulesFilterPanel.this)) {
                this.addNewRules(modelARFilterPanel);
            }
        }

        private void addNewRules(ModelARFilterPanel modelARFilterPanel) {
            List<String> list = modelARFilterPanel.getIncludeAntecedents();
            List<String> list2 = modelARFilterPanel.getIncludeConsequents();
            List<String> list3 = modelARFilterPanel.getExcludeAntecedents();
            List<String> list4 = modelARFilterPanel.getExcludeConsequents();
            int n = list.size() + list2.size() + list3.size() + list4.size();
            ArrayList<FilterRule> arrayList = new ArrayList<FilterRule>(n);
            this.processList(arrayList, FilterType.ITEM_INCLUDE, FilterFor.ANTECEDENT, list);
            this.processList(arrayList, FilterType.ITEM_INCLUDE, FilterFor.CONSEQUENT, list2);
            this.processList(arrayList, FilterType.ITEM_EXCLUDE, FilterFor.ANTECEDENT, list3);
            this.processList(arrayList, FilterType.ITEM_EXCLUDE, FilterFor.CONSEQUENT, list4);
            ARRulesFilterPanel.this.filterTableModel.addRows(arrayList);
        }

        private void processList(List<FilterRule> list, FilterType filterType, FilterFor filterFor, List<String> list2) {
            for (String string : list2) {
                FilterRule filterRule = this.createNewRule(filterType, string, filterFor);
                list.add(filterRule);
            }
        }

        private FilterRule createNewRule(FilterType filterType, String string, FilterFor filterFor) {
            FilterRule filterRule = new FilterRule();
            filterRule.setFilterType(filterType);
            filterRule.setFilterOn(FilterOn.ITEMSET);
            filterRule.setFilterFor(filterFor);
            filterRule.setValue(string);
            return filterRule;
        }
    }

    private class AddMetricFilterAction
    extends AbstractAction {
        private AddMetricFilterAction() {
            super(CoreCommonLrb.get((String)"METRIC"), OracleIcons.getIcon((String)"add.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.addNewRule();
            this.openEditorOnNewRule();
            ARRulesFilterPanel.this.disableFilterForToolbarButtons();
        }

        private void addNewRule() {
            FilterRule filterRule = new FilterRule();
            filterRule.setFilterType(FilterType.METRIC);
            ARRulesFilterPanel.this.filterTableModel.addRow(filterRule);
        }

        private void openEditorOnNewRule() {
            int n = ARRulesFilterPanel.this.filterTableModel.getRowCount() - 1;
            int n2 = ARRulesFilterPanel.this.jFilterTablePanel.getTable().convertRowIndexToView(n);
            ARRulesFilterPanel.this.jFilterTablePanel.getTable().editCellAt(n2, 1);
            ARRulesFilterPanel.this.jFilterTablePanel.getTable().getEditorComponent().requestFocus();
            ARRulesFilterPanel.this.jFilterTablePanel.getTable().setRowSelectionInterval(n2, n2);
        }
    }

    private class UseFilterCheckBoxActionListener
    implements ActionListener {
        private UseFilterCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ARRulesFilterPanel.this.enableDisableFilter();
            ARRulesFilterPanel.this.updateFilterLabelsAndQueryButton();
        }
    }

    private class ToogleFilterButtonActionListener
    implements ActionListener {
        private ToogleFilterButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.toogleFilter();
        }

        private void toogleFilter() {
            ARRulesFilterPanel.this.jFilterPanel.setVisible(!ARRulesFilterPanel.this.jFilterPanel.isVisible());
            ARRulesFilterPanel.this.jFilterMsgPanel.setVisible(!ARRulesFilterPanel.this.jFilterMsgPanel.isVisible());
            if (ARRulesFilterPanel.this.filterExpanded) {
                ARRulesFilterPanel.this.filterSize = ARRulesFilterPanel.this.jFilterPanel.getSize();
                ARRulesFilterPanel.this.setFilterExpanded(false);
                ResourceUtils.resButton((AbstractButton)ARRulesFilterPanel.this.jExpandButton, (String)ControlsLrb.get("FILTER_MORE"));
                ARRulesFilterPanel.this.jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
                ARRulesFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_MORE"));
                ARRulesFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_MORE_ADA"));
            } else {
                ARRulesFilterPanel.this.setFilterExpanded(true);
                ARRulesFilterPanel.this.jFilterPanel.setPreferredSize(ARRulesFilterPanel.this.filterSize);
                ResourceUtils.resButton((AbstractButton)ARRulesFilterPanel.this.jExpandButton, (String)ControlsLrb.get("FILTER_HIDE"));
                ARRulesFilterPanel.this.jExpandButton.setIcon(DataMinerIcons.get(Icons.COLLAPSE));
                ARRulesFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_HIDE"));
                ARRulesFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_HIDE_ADA"));
                ARRulesFilterPanel.this.jExpandButton.setHorizontalTextPosition(10);
            }
        }
    }
}

