/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.rules;

import oracle.dmt.dataminer.core.model.ar.filter.FilterFor;
import oracle.dmt.dataminer.core.model.ar.filter.FilterOn;
import oracle.dmt.dataminer.core.model.ar.filter.FilterRule;
import oracle.dmt.dataminer.core.model.ar.filter.FilterType;
import oracle.dmt.dataminer.core.model.common.Range;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.javatools.util.Version;

public class FilterRuleFactory {
    private static ARPreferences AR_PREFS = ARPreferences.getInstance();

    public static FilterRule getNewMetricFilterRule(FilterOn filterOn, Version version) {
        FilterRule filterRule = new FilterRule();
        filterRule.setFilterType(FilterType.METRIC);
        filterRule.setFilterOn(filterOn);
        filterRule.setFilterFor(FilterFor.RULE);
        if (FilterOn.LIFT.equals((Object)filterOn)) {
            if (DbVersionHelper.isDB122Up((Version)version)) {
                filterRule.setRange(new Range(Range.Type.POSITIVE_DOUBLE, (Number)AR_PREFS.getMinLift(), (Number)AR_PREFS.getMaxLift()));
            } else {
                filterRule.setRange(new Range(Range.Type.POSITIVE_DOUBLE, (Number)AR_PREFS.getMinLift()));
            }
        } else if (FilterOn.CONFIDENCE.equals((Object)filterOn)) {
            if (DbVersionHelper.isDB122Up((Version)version)) {
                filterRule.setRange(new Range(Range.Type.PERCENTAGE, (Number)AR_PREFS.getMinConfidence(), (Number)AR_PREFS.getMaxConfidence()));
            } else {
                filterRule.setRange(new Range(Range.Type.PERCENTAGE, (Number)AR_PREFS.getMinConfidence()));
            }
        } else if (FilterOn.REV_CONFIDENCE.equals((Object)filterOn)) {
            filterRule.setRange(new Range(Range.Type.PERCENTAGE, (Number)0, null));
        } else if (FilterOn.ITEMS_IN_RULE.equals((Object)filterOn)) {
            filterRule.setRange(new Range(Range.Type.POSITIVE_INTEGER, (Number)AR_PREFS.getMinItems(), (Number)AR_PREFS.getMaxItems()));
        } else if (FilterOn.SUPPORT.equals((Object)filterOn)) {
            if (DbVersionHelper.isDB122Up((Version)version)) {
                filterRule.setRange(new Range(Range.Type.PERCENTAGE, (Number)AR_PREFS.getMinSupport(), (Number)AR_PREFS.getMaxSupport()));
            } else {
                filterRule.setRange(new Range(Range.Type.PERCENTAGE, (Number)AR_PREFS.getMinSupport()));
            }
        } else if (FilterOn.SUPPORT_COUNT.equals((Object)filterOn)) {
            filterRule.setRange(new Range(Range.Type.POSITIVE_INTEGER, (Number)0, null));
        } else {
            filterRule.setRange(new Range(Range.Type.DOUBLE, (Number)0, null));
        }
        return filterRule;
    }
}

