/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusTreeRule;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class ClusterRulePane
extends JPanel
implements DataminerGUIPanel {
    private ClusTreeNode treeNode;
    private JScrollPane _ruleScrollPane;
    private JEditorPane _ruleViewPane;
    private JComboBox _topItemSelect;
    private JLabel _componentLabel;
    private JLabel _comboLabel;
    private JCheckBox wrapCheckbox;
    private boolean wrap;
    private int topNAttributes;
    private JPanel contentPanel;

    public ClusterRulePane(ClusTreeNode clusTreeNode) {
        this.treeNode = clusTreeNode;
        String[] stringArray = new String[]{ClusteringTreeEditorLrb.get("ALL_ITEMS"), Integer.toString(1), Integer.toString(2), Integer.toString(3), Integer.toString(4), Integer.toString(5), Integer.toString(6), Integer.toString(7), Integer.toString(8), Integer.toString(9), Integer.toString(10)};
        this.wrapCheckbox = new JCheckBox();
        this._topItemSelect = new JComboBox<String>(stringArray);
        this._componentLabel = new JLabel();
        this._comboLabel = new JLabel();
        this._comboLabel.setLabelFor(this._topItemSelect);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 2));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 440, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 119, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(ClusteringTreeEditorLrb.get("RULE_CONTAINER_LABEL"), this._componentLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("TOP_N_ITEMS_LABEL"), this._comboLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("WRAP_RULE_OPTION"), this.wrapCheckbox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        final ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this._ruleScrollPane = new JScrollPane();
        this._ruleViewPane = new JEditorPane();
        this._ruleScrollPane.setViewportView(this._ruleViewPane);
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNRuleAttributes();
        this._topItemSelect.setSelectedIndex(this.topNAttributes);
        this._topItemSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterRulePane.this.topNAttributes = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                clusteringTreePreferencesSettings.setTopNRuleAttributes(ClusterRulePane.this.topNAttributes);
                String string = ClusTreeRule.getRulesHtml(ClusterRulePane.this.treeNode, ClusterRulePane.this.wrap, ClusterRulePane.this.topNAttributes);
                ClusterRulePane.this.displayRules(string);
            }
        });
        ControlBar controlBar = new ControlBar();
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setControlBar(controlBar);
        componentWithTitlebar.setLabel(this._componentLabel);
        componentWithTitlebar.add((Component)this._ruleScrollPane);
        controlBar.add((Component)this._comboLabel);
        controlBar.add((Component)new JLabel(" "));
        controlBar.add((Component)this._topItemSelect);
        controlBar.addSeparator();
        controlBar.add((Component)this.wrapCheckbox);
        this.contentPanel.add((Component)componentWithTitlebar);
        this.wrap = clusteringTreePreferencesSettings.getWrapNodeRules();
        this.wrapCheckbox.setSelected(this.wrap);
        this.wrapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterRulePane.this.wrap = ((JCheckBox)actionEvent.getSource()).isSelected();
                clusteringTreePreferencesSettings.setWrapNodeRules(ClusterRulePane.this.wrap);
                String string = ClusTreeRule.getRulesHtml(ClusterRulePane.this.treeNode, ClusterRulePane.this.wrap, ClusterRulePane.this.topNAttributes);
                ClusterRulePane.this.displayRules(string);
            }
        });
        String string = ClusTreeRule.getRulesHtml(this.treeNode, this.wrap, this.topNAttributes);
        this.displayRules(string);
    }

    private void displayRules(String string) {
        this._ruleViewPane.setContentType("text/html");
        this._ruleViewPane.setText(string);
        this._ruleViewPane.select(0, 0);
        this._ruleViewPane.setEditable(false);
    }
}

