/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.ESACoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoeffViewer;
import oracle.dmt.dataminer.mviewer.coefficients.NBProbabilitiesTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.PCACoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.SVDCoefViewerTableModel;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.dmt.dataminer.utils.UITools;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class CoefViewer
extends JPanel
implements GeneralCoeffViewer {
    private static final int GLM_FROZEN_COLUMNS = 2;
    private CoefViewerState state;
    private CoefViewerMainPanel mainPanel;
    private boolean loadedFilterSetting;
    private NumberFormat labelNumericalFormat;
    private NumberFormat labelPercentageFormat;
    private BlockingComponent overlayPanel;
    private HistogramBarRenderer barRenderer;
    private DataMinerTablePanel dataMinerTablePanel;

    public CoefViewer(CoefViewerMainPanel coefViewerMainPanel, CoefViewerState coefViewerState) {
        this.mainPanel = coefViewerMainPanel;
        this.state = coefViewerState;
        this.labelNumericalFormat = Formats.ModelViewer.getNumeric();
        this.labelPercentageFormat = Formats.ModelViewer.getPercentage();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 504, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 257, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = "";
        if (this.state.isSVM() || this.state.isAnomaly() || this.state.isNMF() || this.state.isSVD() || this.state.isPCA() || this.state.isESA()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        } else if (this.state.isNB()) {
            string = CoefficientsLrb.get("PROBABILTIES_ROWS_OUT_OF_TOTAL");
        } else if (this.state.isGLM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        }
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this.state.isSVM() || this.state.isGLM() || this.state.isAnomaly() || this.state.isNMF() || this.state.isSVD() || this.state.isPCA() || this.state.isESA()) {
            n3 = 0;
        }
        Integer n4 = n2 + n3;
        String string2 = NumericFormat.format((int)n);
        String string3 = NumericFormat.format((int)n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.initializeControls();
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setNoEntryInstructionText(TableMessages.LOADING.getMessage());
        this.enableControls(false);
    }

    private void enableControls(boolean bl) {
        this.dataMinerTablePanel.getSearchField().setEnabled(bl);
    }

    @Override
    public void load() {
        LoadWorker loadWorker = new LoadWorker();
        loadWorker.execute();
    }

    @Override
    public void prepareReload() {
        this.setLoading(true);
        this.resetUI();
        QueryWorker queryWorker = new QueryWorker();
        queryWorker.execute();
    }

    private void setLoading(boolean bl) {
        this.mainPanel.updateLoading(bl);
    }

    private void resetUI() {
        this.state.clearRows();
        this.enableControls(false);
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    @Override
    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overlayPanel = blockingComponent;
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this.state.getHelpInfo();
    }

    @Override
    public void setFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this.state.setFilterSetting(coefficientFilterSetting);
        this.prepareReload();
    }

    private boolean isLoading() {
        return this.mainPanel.isLoading();
    }

    @Override
    public CoefficientFilterSetting getCachedFilterState() {
        return this.state.getCachedFilterSetting();
    }

    @Override
    public void setCachedFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this.state.setCachedFilterSetting(coefficientFilterSetting);
    }

    private void setupSVMTable(CoefViewerTableModel coefViewerTableModel) {
        coefViewerTableModel.setAbsoluteValueSort(this.state.getFilterSetting().getFilterAndSortByAbsolute());
        UITools.setModelPresevingSort(this.dataMinerTablePanel, coefViewerTableModel);
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        this.setHistogramRendererToTableColumn(dataMinerTable, 2, this.state.getMaximumABSCoefficient().longValue());
        if (this.state.isAnomaly()) {
            this.dataMinerTablePanel.getTable().setSortColumn(2, false);
        }
    }

    private void setHistogramRendererToTableColumn(DataMinerTable dataMinerTable, int n, double d) {
        this.barRenderer = new HistogramBarRenderer(1.0, true, this.labelNumericalFormat);
        dataMinerTable.getFullColumnModel().getColumn(n).setCellRenderer(this.barRenderer);
        this.barRenderer.setMaximumValue(d);
    }

    private void setupSVDTable(SVDCoefViewerTableModel sVDCoefViewerTableModel) {
        sVDCoefViewerTableModel.setAbsoluteValueSort(this.state.getFilterSetting().getFilterAndSortByAbsolute());
        UITools.setModelPresevingSort(this.dataMinerTablePanel, sVDCoefViewerTableModel);
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        this.setHistogramRendererToTableColumn(dataMinerTable, 1, this.state.getMaximumABSCoefficient().longValue());
    }

    private void setupPCATable(PCACoefViewerTableModel pCACoefViewerTableModel) {
        pCACoefViewerTableModel.setAbsoluteValueSort(this.state.getFilterSetting().getFilterAndSortByAbsolute());
        UITools.setModelPresevingSort(this.dataMinerTablePanel, pCACoefViewerTableModel);
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        this.setHistogramRendererToTableColumn(dataMinerTable, 1, this.state.getMaximumABSCoefficient().longValue());
    }

    private void setupNBTable(NBProbabilitiesTableModel nBProbabilitiesTableModel) {
        nBProbabilitiesTableModel.updateColumnIdentifiers(this.state.getSelectedTargetClass().toString());
        nBProbabilitiesTableModel.setAbsoluteValueSort(this.state.getFilterSetting().getFilterAndSortByAbsolute());
        UITools.setModelPresevingSort(this.dataMinerTablePanel, nBProbabilitiesTableModel);
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        this.setHistogramRendererToTableColumn(dataMinerTable, 2, 100.0);
    }

    private void setupGLMTable(GLMCoefViewerTableModel gLMCoefViewerTableModel) {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        dataMinerTable.setFixedColumns(2, new int[0]);
        gLMCoefViewerTableModel.setAbsoluteValueSort(this.state.getFilterSetting().getFilterAndSortByAbsolute());
        UITools.setModelPresevingSort(this.dataMinerTablePanel, gLMCoefViewerTableModel);
        dataMinerTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = dataMinerTable.getFullColumnModel();
        this.barRenderer = new HistogramBarRenderer(1.0, true, this.labelNumericalFormat);
        this.barRenderer.setMaximumValue(this.state.getMaximumABSCoefficient().longValue());
        tableColumnModel.getColumn(2).setCellRenderer(this.barRenderer);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getScientificRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
        if (this.state.isCovarianceIndicator()) {
            tableColumnModel.getColumn(11).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(7).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(10).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(6).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(4).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(5).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(8).setCellRenderer(tableCellRenderer2);
        }
        tableColumnModel.getColumn(3).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(gLMCoefViewerTableModel.getColumnExpCofficientColumnNumber()).setCellRenderer(tableCellRenderer2);
        dataMinerTable.autoSizeColumnsToFit();
    }

    private void setupESATable(ESACoefViewerTableModel eSACoefViewerTableModel) {
        eSACoefViewerTableModel.setAbsoluteValueSort(this.state.getFilterSetting().getFilterAndSortByAbsolute());
        this.dataMinerTablePanel.setup((TableModel)((Object)eSACoefViewerTableModel), null, 0, true);
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        dataMinerTable.setSortColumn(2, false);
        this.setHistogramRendererToTableColumn(dataMinerTable, 2, 1.0);
    }

    private void setupTable() {
        ODMrTableModel oDMrTableModel = this.state.getTableModel();
        if (this.state.isSVM() || this.state.isAnomaly() || this.state.isNMF()) {
            if (this.state.isAnomaly()) {
                this.state.setSortByAbsoluteValue(this.state.getFilterSetting().getFilterAndSortByAbsolute());
            }
            this.setupSVMTable((CoefViewerTableModel)this.state.getTableModel());
        } else if (this.state.isSVD()) {
            this.state.setSortByAbsoluteValue(this.state.getFilterSetting().getFilterAndSortByAbsolute());
            this.setupSVDTable((SVDCoefViewerTableModel)this.state.getTableModel());
        } else if (this.state.isPCA()) {
            this.state.setSortByAbsoluteValue(this.state.getFilterSetting().getFilterAndSortByAbsolute());
            this.setupPCATable((PCACoefViewerTableModel)this.state.getTableModel());
        } else if (this.state.isGLM()) {
            this.setupGLMTable((GLMCoefViewerTableModel)this.state.getTableModel());
        } else if (this.state.isNB()) {
            this.setupNBTable((NBProbabilitiesTableModel)this.state.getTableModel());
        } else if (this.state.isESA()) {
            String string = CoefficientsLrb.get("COEFFICIENT_FAILURE");
            if (oDMrTableModel.getSrcData().isEmpty()) {
                string = CoefficientsLrb.get("ESA_SELECT_FEATURE_ID");
            } else {
                this.setupESATable((ESACoefViewerTableModel)this.state.getTableModel());
            }
            this.dataMinerTablePanel.getTable().setNoEntryInstructionText(string);
        }
        this.dataMinerTablePanel.trySearch();
        this.mainPanel.updateTarget();
        this.loadRowsOutOfTotalLabel(this.state.getTableModel().getRowCount(), this.state.getTotalDetailCount());
        this.enableControls(true);
        this.setLoading(false);
        if (this.dataMinerTablePanel.getTable().getRowCount() > 0) {
            this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{0});
        }
        this.setLoaded(true);
    }

    private void setLoaded(boolean bl) {
        if (!this.loadedFilterSetting) {
            this.mainPanel.setFilterPanelInitialState(this.state.getFilterSetting());
            this.loadedFilterSetting = true;
        }
        this.mainPanel.updateLoaded(bl);
    }

    private void setFailureTableState() {
        this.setNoEntryTextMessage();
        ODMrTableModel oDMrTableModel = this.state.getTableModel();
        if (oDMrTableModel != null) {
            oDMrTableModel.clear();
            this.loadRowsOutOfTotalLabel(this.state.getTableModel().getRowCount(), this.state.getTotalDetailCount());
        }
    }

    private void setNoEntryTextMessage() {
        String string = "";
        if (this.state.isSVM() || this.state.isAnomaly() || this.state.isFeatureExtraction()) {
            string = CoefficientsLrb.get("COEFFICIENT_FAILURE");
        } else if (this.state.isGLM()) {
            string = CoefficientsLrb.get("STATISTICS_FAILURE");
        } else if (this.state.isNB()) {
            string = CoefficientsLrb.get("PROBABILITIES_FAILURE");
        }
        this.dataMinerTablePanel.getTable().setNoEntryInstructionText(string);
    }

    private class QueryWorker
    extends ODMrSwingWorker<Void, Void> {
        public QueryWorker() {
            super(CoefViewer.this, CoefViewer.this.overlayPanel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            CoefViewer.this.state.reloadCoefficients(CoefViewer.this.mainPanel.getViewerFilterPanel().getPartitionToolbar().getPartitionVO().getPartitionID());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            CoefViewer.this.setupTable();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            CoefViewer.this.setFailureTableState();
            this.setTableMessage(TableMessages.ERROR.getMessage());
            DataMinerEditor.handleEditorException(CoefViewer.this.mainPanel.getEditor().getContext(), throwable, ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"));
        }
    }

    private class LoadWorker
    extends ODMrSwingWorker<Void, Void> {
        public LoadWorker() {
            super(CoefViewer.this, CoefViewer.this.overlayPanel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            CoefViewer.this.setLoading(true);
            CoefViewer.this.mainPanel.getViewerFilterPanel().getPartitionToolbar().load(CoefViewer.this.mainPanel.getEditor());
            CoefViewer.this.state.load(CoefViewer.this.mainPanel.getViewerFilterPanel().getPartitionToolbar().getPartitionVO());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            CoefViewer.this.setupTable();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            CoefViewer.this.setFailureTableState();
            this.setTableMessage(TableMessages.ERROR.getMessage());
            if (CoefficientsLrb.get("COEFFICIENT_VIEWER_NO_TARGET_PRIORS_VALUES").equals(throwable.getMessage())) {
                MessageDialog.information((Component)CoefViewer.this, (Object)throwable.getMessage(), (String)CoreCommonLrb.get((String)"WARNING"), null);
            } else {
                DataMinerEditor.handleEditorException(CoefViewer.this.mainPanel.getEditor().getContext(), throwable, ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"));
            }
        }
    }
}

