/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree.model;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvDefaultSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dt.schema.ScoreDistribution;
import oracle.dmt.dataminer.mviewer.dtree.DTTreeRule;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditor;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.RoundedTreeNode;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeLink;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;

public class DTTreeNode
extends IlvDefaultSDMNode
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(DTTreeNode.class.getName());
    protected Node jaxbData;
    protected String tag;
    protected Context context;
    private String id;
    private String x;
    private String y;
    private List<ScoreDistribution> scoreDistributions;
    private Map<String, ScoreDistribution> targetValueToScoreDistributionMap;
    private double recordCount = 0.0;
    private double totalRecords = 0.0;
    private double support = 0.0;
    private double confidence = 0.0;
    private boolean otherIsVisible = false;
    private Integer expanded = 1;
    private String splitColumn;
    private Boolean splitVisible;
    private int maxValuesDisplayed = 0;
    private int valuesDisplayed = 0;
    public static final String OTHER = "other";
    private static String freqBarWidth = "15";
    private static Integer minBarHeight = 0;
    private static Integer maxBarHeight = 20;
    private static Font treeFont = new Font("Dialog", 0, 12);
    private static Font treeTitleFont = new Font("Dialog", 1, 13);
    private static final String LABEL = "label";
    private static final String TOOLTIP = "tooltip";
    private static final String SPLIT = "split";
    private static final String SPLIT_VISIBLE = "isSplitVisible";
    private static final String CONFIDENCE = "confidence";
    private static final String SUPPORT = "support";
    private static final String PREDICTION = "prediction";
    private static final String TITLE = "nodeTitle";
    private static final String TEXT = "text";
    private static final String EXPANDABLE = "isExpandable";
    private static final String EXPANDED = "expanded";
    private static final String HEADER_VISIBLE = "isHeaderDetailVisible";
    private static final String CHART_VISIBLE = "barChartVisible";
    private static final String CHART_BAR_WIDTH = "chartBarWidth";
    private static final String LEGEND_COLOR = "legendColor";
    private static final String FREQ = "freq";
    private static final String MAX_FREQ_HEIGHT = "maxFreqHeight";
    private static final String MIN_FREQ_HEIGHT = "minFreqHeight";
    private static final String SCORE_COUNT = "scoreCount";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String FONT = "font";
    private static final String TITLE_FONT = "titleFont";

    public DTTreeNode(String string, Node node, List<ScoreDistribution> list, Context context) {
        super(string);
        Object object2;
        this.tag = string;
        this.jaxbData = node;
        this.scoreDistributions = list;
        this.context = context;
        this.x = "-1";
        this.y = "-1";
        this.setMaxValuesDisplayed(this.getModel().getMaxTargetValuesDisplayed());
        this.targetValueToScoreDistributionMap = new HashMap<String, ScoreDistribution>();
        for (Object object2 : this.scoreDistributions) {
            this.targetValueToScoreDistributionMap.put(object2.getValue(), (ScoreDistribution)object2);
        }
        DTTreeNode dTTreeNode = this.findParentNode();
        object2 = this.getData().getRecordCount();
        String string2 = null;
        string2 = dTTreeNode != null ? dTTreeNode.getData().getRecordCount() : this.getModel().getRootNodeMetadata().getRecordCount();
        this.totalRecords = Double.valueOf(string2);
        this.recordCount = Double.valueOf((String)object2);
        this.support = this.recordCount / this.totalRecords;
        this.confidence = this.getPredictedRecordCount(this.getData().getScore()) / this.recordCount;
        this.splitColumn = null;
        this.splitVisible = null;
    }

    public void setMaxValuesDisplayed(int n) {
        this.maxValuesDisplayed = n;
        if (this.getModel().isSortByConfidence().booleanValue()) {
            if (this.scoreDistributions.size() > this.maxValuesDisplayed) {
                this.otherIsVisible = true;
            }
        } else if (this.getModel().getRootTargetValueCount() > this.maxValuesDisplayed) {
            this.otherIsVisible = true;
        }
    }

    private IlvSDMEngine getEngine() {
        IlvSDMEngine ilvSDMEngine = null;
        DTModelNode dTModelNode = (DTModelNode)this.context.getNode();
        ilvSDMEngine = dTModelNode.getEngine();
        return ilvSDMEngine;
    }

    public DecisionTreeSDMModel getModel() {
        DTModelNode dTModelNode = (DTModelNode)this.context.getNode();
        SDMUndoFilter sDMUndoFilter = this.getFilterModel();
        if (sDMUndoFilter == null) {
            return null;
        }
        return (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
    }

    public SDMUndoFilter getFilterModel() {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine == null) {
            return null;
        }
        return (SDMUndoFilter)ilvSDMEngine.getModel();
    }

    public void assignPropertyChangeListener(IlvSDMEngine ilvSDMEngine) {
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, true);
        if (ilvGraphic == null || !(ilvGraphic instanceof RoundedTreeNode)) {
            throw new RuntimeException("not instanceof RoundedTreeNode");
        }
        RoundedTreeNode roundedTreeNode = (RoundedTreeNode)ilvGraphic;
        roundedTreeNode.addParameterChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        this.getUndoFilter().setObjectProperty((Object)this, string, object);
    }

    public SDMUndoFilter getUndoFilter() {
        DTModelNode dTModelNode = (DTModelNode)this.context.getNode();
        IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
        if (ilvSDMEngine == null) {
            return null;
        }
        return (SDMUndoFilter)ilvSDMEngine.getModel();
    }

    public String getTag() {
        return this.tag;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public Object getProperty(String string) {
        Object object = null;
        try {
            if ("userObject".equals(string) || "CSSclass".equals(string)) {
                object = this.getData().getId();
            } else if (string.equals(X)) {
                object = this.x;
            } else if (string.equals(Y)) {
                object = this.y;
            } else if (string.endsWith(TITLE)) {
                object = this.getNodeTitle();
            } else if (string.equals(SCORE_COUNT)) {
                object = this.getVisibleTargetValuesCount();
            } else if (string.startsWith(LEGEND_COLOR)) {
                object = this.getTargetValueLegendColor(string);
            } else if (string.startsWith(TEXT)) {
                object = this.getTargetValueText(string);
            } else if (string.startsWith(FREQ)) {
                object = this.getFrequencyPropertyValue(string);
            } else if (string.equals(MIN_FREQ_HEIGHT)) {
                object = minBarHeight.toString();
            } else if (string.equals(MAX_FREQ_HEIGHT)) {
                object = maxBarHeight.toString();
            } else if (string.equals(CHART_BAR_WIDTH)) {
                object = freqBarWidth;
            } else if (string.equals(CHART_VISIBLE)) {
                object = this.getModel().isBarChartVisible().toString();
            } else if (string.equals(HEADER_VISIBLE)) {
                object = this.getModel().isHeaderDetailVisible().toString();
            } else if (string.equals(TOOLTIP)) {
                object = this.getToolTip();
            } else if (string.equals(LABEL)) {
                object = this.getLabel();
            } else if (string.equals(EXPANDED)) {
                object = "" + this.expanded;
            } else if (string.equals(EXPANDABLE)) {
                object = "" + this.hasChildrenMetadata(this.getData());
            } else if (string.equals(PREDICTION)) {
                object = this.getNodePredictionDisplayString();
            } else if (string.equals(SUPPORT)) {
                object = this.getNodeSupportDisplayString();
            } else if (string.equals(CONFIDENCE)) {
                object = this.getNodeConfidenceDisplayString();
            } else {
                if (string.equals(SPLIT_VISIBLE)) {
                    return this.isSplitVisible().toString();
                }
                if (string.equals(SPLIT)) {
                    object = this.getNodeSplitDisplayString();
                } else if (string.equals(FONT)) {
                    object = treeFont;
                } else if (string.equals(TITLE_FONT)) {
                    object = treeTitleFont;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return object;
    }

    public void setProperty(String string, Object object) {
        if (X.equals(string)) {
            this.x = (String)object;
        } else if (Y.equals(string)) {
            this.y = (String)object;
        } else if (EXPANDED.equals(string)) {
            this.expanded = (Integer)object;
        }
    }

    public String getNodeTitle() {
        return DecisionTreeEditorLrb.get("NODE_ID") + " " + this.getData().getId();
    }

    private String getNodePredictionDisplayString() {
        return DecisionTreeEditorLrb.get("NODE_PREDICTION") + " " + this.getData().getScore();
    }

    private String getNodeSplitDisplayString() {
        return DecisionTreeEditorLrb.get("NODE_SPLIT") + " " + this.getSplitColumn();
    }

    private String getToolTip() {
        String string = "<html>";
        string = string + this.getNodeTitle();
        string = string + "<br>";
        string = string + this.getNodePredictionDisplayString();
        string = string + "<br>";
        string = string + this.getNodeSupportDisplayString();
        string = string + "<br>";
        string = string + this.getNodeConfidenceDisplayString();
        String string2 = this.getSplitColumn();
        if (string2 != null) {
            string = string + "<br>";
            string = string + this.getNodeSplitDisplayString();
        }
        string = string + "</html>";
        return string;
    }

    private String getTargetValueLegendColor(String string) {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        int n = Integer.parseInt(string.substring(11, 13)) - 1;
        if (n >= this.valuesDisplayed) {
            return "";
        }
        String string2 = this.getTargetValueForIndex(n);
        return decisionTreeSDMModel.getColorForTargetValue(string2);
    }

    private String getTargetValueText(String string) {
        int n = Integer.parseInt(string.substring(4, 6)) - 1;
        if (n >= this.valuesDisplayed) {
            return "";
        }
        return this.getTargetValueDetailString(n);
    }

    public int getTargetValuesCount() {
        return this.scoreDistributions.size();
    }

    private String getVisibleTargetValuesCount() {
        String string = "" + this.maxValuesDisplayed;
        int n = 0;
        n = this.getModel().isSortByConfidence() != false ? this.getTargetValuesCount() : this.getModel().getRootTargetValueCount();
        this.valuesDisplayed = n < this.maxValuesDisplayed ? n : this.maxValuesDisplayed;
        string = "" + this.valuesDisplayed;
        return string;
    }

    private String getNodeSupportDisplayString() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        String string = numberFormat.format(this.support);
        return DecisionTreeEditorLrb.get("NODE_SUPPORT") + " " + this.getData().getRecordCount() + " (" + string + ")";
    }

    private String getNodeConfidenceDisplayString() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        String string = numberFormat.format(this.confidence);
        return DecisionTreeEditorLrb.get("NODE_CONFIDENCE") + " " + string;
    }

    private String getSplitColumn() {
        if (this.splitVisible == null) {
            if (!this.getModel().isLoaded().booleanValue()) {
                return null;
            }
            List<DTTreeNode> list = this.findChildNodes();
            if (list.size() != 0) {
                DTTreeNode dTTreeNode = list.get(0);
                this.splitColumn = DTTreeRule.getSplitField(dTTreeNode.getData());
                this.splitVisible = Boolean.TRUE;
            } else {
                this.splitVisible = Boolean.FALSE;
            }
        }
        return this.splitColumn;
    }

    private Boolean isSplitVisible() {
        if (!this.getModel().isLoaded().booleanValue()) {
            return false;
        }
        if (this.splitVisible == null) {
            this.getSplitColumn();
        }
        return this.splitVisible;
    }

    private boolean hasChildrenMetadata(Node node) {
        List list = node.getSimplePredicateOrSimpleSetPredicateOrCompoundPredicate();
        for (Object e : list) {
            if (!(e instanceof Node)) continue;
            return true;
        }
        return false;
    }

    private boolean isExpanded() {
        return this.expanded == 1;
    }

    private List<DTTreeNode> findChildNodes() {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        ArrayList<DTTreeNode> arrayList = new ArrayList<DTTreeNode>();
        List<DTTreeLink> list = decisionTreeSDMModel.findLinksFromNode((IlvSDMNode)this);
        for (DTTreeLink dTTreeLink : list) {
            arrayList.add((DTTreeNode)dTTreeLink.getTo());
        }
        return arrayList;
    }

    public void setChildrenVisibility() {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine == null) {
            throw new RuntimeException("Could not obtain engine.");
        }
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, false);
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvGrapher.setVisibleBranch(ilvGraphic, 0, this.isExpanded(), true);
        if (this.isExpanded()) {
            List<DTTreeNode> list = this.findChildNodes();
            for (DTTreeNode dTTreeNode : list) {
                this.refreshChildrenVisibility(dTTreeNode, ilvSDMEngine, ilvGrapher);
            }
        }
        ilvGrapher.reDraw();
    }

    private void refreshChildrenVisibility(DTTreeNode dTTreeNode, IlvSDMEngine ilvSDMEngine, IlvGrapher ilvGrapher) {
        if (!dTTreeNode.isExpanded()) {
            ilvGrapher.setVisibleBranch(ilvSDMEngine.getGraphic((Object)dTTreeNode, false), 0, dTTreeNode.isExpanded(), true);
            return;
        }
        List<DTTreeNode> list = dTTreeNode.findChildNodes();
        for (DTTreeNode dTTreeNode2 : list) {
            this.refreshChildrenVisibility(dTTreeNode2, ilvSDMEngine, ilvGrapher);
        }
    }

    public String getTargetValueDetailString(int n) {
        double d;
        String string = null;
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        String string2 = null;
        String string3 = null;
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue()) {
            if (this.scoreDistributions.size() <= n) {
                return "";
            }
            ScoreDistribution scoreDistribution = this.scoreDistributions.get(n);
            string2 = scoreDistribution.getValue();
            string3 = scoreDistribution.getRecordCount();
        } else {
            string2 = decisionTreeSDMModel.getRootTargetValue(n);
            ScoreDistribution scoreDistribution = this.getScoreDistributionForTargetValue(string2);
            string3 = scoreDistribution != null ? scoreDistribution.getRecordCount() : "0";
        }
        DecisionTreeEditor decisionTreeEditor = (DecisionTreeEditor)this.getContext().getView();
        string2 = UIResourceHelper.trucateUIStringMiddle(string2, decisionTreeEditor.getMaxAttributeLength());
        if (n == this.maxValuesDisplayed - 1 && this.otherIsVisible) {
            d = this.getOtherRecordCount();
            string = "Other : " + d;
        } else {
            d = Double.valueOf(string3);
            string = string2 + " : " + string3;
        }
        double d2 = d / this.recordCount;
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        string = string + "  (" + numberFormat.format(d2) + ")";
        return string;
    }

    private String getTargetValueForIndex(int n) {
        String string;
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        if (n == this.maxValuesDisplayed - 1 && this.otherIsVisible) {
            return OTHER;
        }
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue() && n >= this.scoreDistributions.size()) {
            return "";
        }
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue()) {
            ScoreDistribution scoreDistribution = this.getScoreDistribution(n);
            string = scoreDistribution.getValue();
        } else {
            string = decisionTreeSDMModel.getRootTargetValue(n);
        }
        return string;
    }

    private Double getFrequencyPropertyValue(String string) {
        double d;
        String string2 = string.substring(4, 6);
        int n = Integer.parseInt(string2) - 1;
        if (n >= this.valuesDisplayed) {
            return 0.0;
        }
        ScoreDistribution scoreDistribution = this.getScoreDistribution(n);
        double d2 = n == this.maxValuesDisplayed - 1 && this.otherIsVisible ? this.getOtherRecordCount() : (scoreDistribution != null ? Double.valueOf(scoreDistribution.getRecordCount()) : 0.0);
        double d3 = d2 / (d = Double.valueOf(this.getData().getRecordCount()).doubleValue()) * 100.0;
        if (d3 == 0.0) {
            d3 = 0.1;
        }
        return d3;
    }

    private ScoreDistribution getScoreDistribution(int n) {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue()) {
            if (this.scoreDistributions.size() > n) {
                return this.scoreDistributions.get(n);
            }
            return null;
        }
        return this.getScoreDistributionForTargetValue(decisionTreeSDMModel.getRootTargetValue(n));
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public Double getSupport() {
        return this.support;
    }

    private Double getPredictedRecordCount(String string) {
        Double d = null;
        for (ScoreDistribution scoreDistribution : this.scoreDistributions) {
            if (!string.equals(scoreDistribution.getValue())) continue;
            d = Double.valueOf(scoreDistribution.getRecordCount());
            break;
        }
        return d;
    }

    private ScoreDistribution getScoreDistributionForTargetValue(String string) {
        return this.targetValueToScoreDistributionMap.get(string);
    }

    public List<ScoreDistribution> getScoreDistributions() {
        return this.scoreDistributions;
    }

    public double getOtherRecordCount() {
        if (!this.otherIsVisible) {
            throw new RuntimeException("Unexpectedly calculating other record count when \"other\" not enabled");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.maxValuesDisplayed - 1; ++i) {
            String string = this.getTargetValueForIndex(i);
            hashMap.put(string, string);
        }
        double d = 0.0;
        for (int i = 0; i < this.scoreDistributions.size(); ++i) {
            ScoreDistribution scoreDistribution = this.scoreDistributions.get(i);
            if (hashMap.containsKey(scoreDistribution.getValue())) continue;
            String string = scoreDistribution != null ? scoreDistribution.getRecordCount() : "0";
            d += (double)Integer.parseInt(string);
        }
        return d;
    }

    public String getLabel() {
        int n = 40;
        DTTreeRule.Predicate predicate = DTTreeRule.getPredicate(this.getData());
        if (predicate == null) {
            return "Root";
        }
        StringBuilder stringBuilder = new StringBuilder("<html>Predicate:<br>");
        stringBuilder.append(DTTreeRule.getFormattedPredicateString(predicate.getRuleElement(), n));
        stringBuilder.append("<br><br>");
        List<DTTreeRule.RuleElement> list = predicate.getSurrogates();
        if (list.isEmpty()) {
            return stringBuilder.toString();
        }
        stringBuilder.append("Surrogate Rules:<br>");
        int n2 = 1;
        for (DTTreeRule.RuleElement ruleElement : list) {
            stringBuilder.append(n2);
            stringBuilder.append(": ");
            stringBuilder.append(DTTreeRule.getFormattedPredicateString(ruleElement, n));
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static List<ScoreDistribution> getScoreDistributions(Node node) {
        List list = node.getSimplePredicateOrSimpleSetPredicateOrCompoundPredicate();
        ArrayList<ScoreDistribution> arrayList = new ArrayList<ScoreDistribution>();
        for (Object e : list) {
            if (!(e instanceof ScoreDistribution)) continue;
            arrayList.add((ScoreDistribution)e);
        }
        return arrayList;
    }

    public String[] getDependentProperties(String string) {
        return new String[0];
    }

    public final Node getData() {
        return this.jaxbData;
    }

    private static DTTreeNode createNode(String string, Context context, Node node, List<ScoreDistribution> list) throws Exception {
        DTTreeNode dTTreeNode = null;
        String string2 = DTTreeNode.class.getPackage().getName() + "." + string;
        Class<?> clazz = Class.forName(string2);
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructorArray.length && (constructor = constructorArray[i]).getGenericParameterTypes().length != 3; ++i) {
        }
        dTTreeNode = (DTTreeNode)constructor.newInstance(string, node, list, context);
        if (node == null) {
            dTTreeNode.initNewInstance(context);
        }
        return dTTreeNode;
    }

    public static DTTreeNode createNode(Node node, Context context) throws Exception, DecisionTreeSDMModel.MalformedModelException {
        List<ScoreDistribution> list = DTTreeNode.getScoreDistributions(node);
        if (node.getScore() == null) {
            throw new DecisionTreeSDMModel.MalformedModelException();
        }
        if (list.size() > 0 && list.get(0).getValue() == null) {
            throw new DecisionTreeSDMModel.MalformedModelException();
        }
        DTTreeNode dTTreeNode = DTTreeNode.createNode(DTTreeNode.class.getSimpleName(), context, node, list);
        return dTTreeNode;
    }

    protected void initNewInstance(Context context) {
        try {
            Class<?> clazz = Class.forName(Node.class.getPackage().getName());
            this.setData((Node)clazz.newInstance());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.context = context;
    }

    private void setData(Node node) {
        this.jaxbData = node;
    }

    protected Context getContext() {
        return this.context;
    }

    public DTTreeNode findParentNode() {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        DTTreeNode dTTreeNode = null;
        Node node = this.getData();
        List<DTTreeLink> list = decisionTreeSDMModel.findLinksToNode((IlvSDMNode)this);
        for (DTTreeLink dTTreeLink : list) {
            DTTreeNode dTTreeNode2 = (DTTreeNode)dTTreeLink.getTo();
            if (!dTTreeNode2.getData().getId().equals(node.getId())) continue;
            dTTreeNode = (DTTreeNode)dTTreeLink.getFrom();
            break;
        }
        return dTTreeNode;
    }
}

