/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.build.Column;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;

public class ESAFeatureFilterTableModel
extends ODMrTableModel<ColumnFilter> {
    public static final int NAME = 0;
    public static final int OPERATOR = 1;
    public static final int VALUE = 2;
    private static final String[] COLUMN_NAMES = new String[]{CommonLrb.get("NAME"), CommonLrb.get("OPERATOR"), CommonLrb.get("VALUE")};

    public ESAFeatureFilterTableModel() {
        super(COLUMN_NAMES);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ColumnFilter columnFilter = (ColumnFilter)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = columnFilter.getTargetColumn();
                break;
            }
            case 1: {
                object = columnFilter.getOperator();
                break;
            }
            case 2: {
                object = columnFilter.getValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return object == null ? "" : object;
    }

    public boolean isCellEditable(int n, int n2) {
        ColumnFilter columnFilter = (ColumnFilter)this.srcData.get(n);
        return n2 != 2 || columnFilter.getTargetColumn().isStringDataType();
    }

    public void setValueAt(Object object, int n, int n2) {
        ColumnFilter columnFilter = (ColumnFilter)this.srcData.get(n);
        switch (n2) {
            case 0: {
                columnFilter.setTargetColumn((Column)object);
                break;
            }
            case 1: {
                columnFilter.setOperator((ColumnFilter.Operator)object);
                break;
            }
            case 2: {
                columnFilter.setValue((String)object);
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        this.fireTableCellUpdated(n, n2);
    }
}

