/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseTreeTable;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.ReadOnlyCostMatrixModel;
import oracle.dmt.dataminer.controls.renderers.BooleanIconCellRenderer;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.settings.PartitionKeysPanel;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerGeneralTreeTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerSignatureTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerState;
import oracle.dmt.dataminer.mviewer.settings.TextFeaturesPanel;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.server.model.PartitionModelAttributeInfo;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.dialog.model.TargetValuesPanel;
import oracle.ide.Context;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class SettingsViewerTabPanel
extends DataMinerViewGUI {
    private SettingsViewerState _state;
    private TargetValuesPanel jTargetValues;
    private int _lastSelectedIindex = -1;
    private SettingsTreeTable _jSettingsTreeTable;
    private DataMinerTable _genericTableModelSignature;
    private DataMinerTable genericTableCostMatrix;
    private DataMinerTable genericTableWeights;
    private JLabel jAggregatesLbl;
    private DataMinerTablePanel jAggregatesTablePanel;
    private JPanel jAggregtesPanel;
    private JCheckBox jCheckBox1;
    private JPanel jCostMatrix;
    private TextFeaturesPanel jFeatures;
    private JLabel jLabel2;
    private JLabel jLabelCostMatrix;
    private JLabel jLabelWeifgts;
    private JPanel jModelSettings;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private PartitionKeysPanel jPartitionKeys;
    private JScrollPane jScrollPaneCostMatrix;
    private JScrollPane jScrollPaneSettings;
    private JScrollPane jScrollPaneSignature;
    private JScrollPane jScrollPaneWeights;
    private JScrollPane jScrollPaneXform;
    private JPanel jSignature;
    private ComponentWithTitlebar jSignaturesPanel;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane;
    private JTextArea jTextArea1;
    private JPanel jWeights;
    private ModelViewerPartitionToolbar partitionToolbar;
    private ControlBar signatureControlBar;
    private SearchField signatureSearchField;
    private JPanel topPanel;

    public SettingsViewerTabPanel(Editor editor, Context context) {
        super(editor, context);
        this._state = new SettingsViewerState(context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initRes() {
        this.jCheckBox1.setText(SettingsLrb.get("SHOW_REVERSEOEXPR"));
        this.jLabel2.setText(SettingsLrb.get("MODEL_XFORM"));
        this.jLabelCostMatrix.setText(SettingsLrb.get("COST_MATRIX_TABLE_TITLE"));
        this.jLabelWeifgts.setText(SettingsLrb.get("MODEL_WEIGHTS"));
    }

    private void initUI() {
        this.jCheckBox1.addActionListener(new CheckBoxListener());
        this._jSettingsTreeTable = new SettingsTreeTable(this._state.getGeneralTreeTableModel());
        this._jSettingsTreeTable.setRootInvisible();
        this._jSettingsTreeTable.hideHandles();
        this._jSettingsTreeTable.setShowGrid(true);
        this._jSettingsTreeTable.setAutoResizeMode(3);
        this.jScrollPaneSettings.setVerticalScrollBarPolicy(20);
        this.jScrollPaneSettings.setHorizontalScrollBarPolicy(30);
        this.jScrollPaneSettings.setViewportView((Component)((Object)this._jSettingsTreeTable));
        Dimension dimension = new Dimension(0, 0);
        this.jPanel1.setMinimumSize(dimension);
        this.jSplitPane1.setResizeWeight(0.75);
        this.partitionToolbar.setVisible(false);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void initializeTabs() {
        this.setupDummyTreeTable(CommonLrb.get("LOADING"));
        int n = this.jTabbedPane.indexOfComponent(this.jModelSettings);
        this.jTabbedPane.setTitleAt(n, CoreCommonLrb.get((String)"SUMMARY"));
        this.signatureSearchField.addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this._genericTableModelSignature, 0));
        this.jTabbedPane.remove(this.jCostMatrix);
        this.jTabbedPane.remove(this.jWeights);
        this.jTabbedPane.remove(this.jSignature);
        this.jTabbedPane.remove(this.jFeatures);
        this.jTabbedPane.remove(this.jPartitionKeys);
        this.jTabbedPane.remove(this.jTargetValues);
        this.jTabbedPane.remove(this.jAggregtesPanel);
    }

    private void setupWeights() {
        GenericBaseTableModel genericBaseTableModel = this._state.getWeightsModel();
        if (genericBaseTableModel != null) {
            this.genericTableWeights.setModel((TableModel)genericBaseTableModel);
            this.genericTableWeights.setSorted(false);
            this.genericTableWeights.getTableHeader().setReorderingAllowed(false);
            this.jTabbedPane.addTab(SettingsLrb.get("MODEL_WEIGHTS"), this.jWeights);
        }
    }

    private void setupTargetValues() {
        if (this._state.getTargetValues() != null) {
            MiningAttributeInfo miningAttributeInfo = this._state.getSignatureTableModel().getTargetAttributeInfo();
            String string = "";
            String string2 = "";
            if (miningAttributeInfo != null) {
                string = miningAttributeInfo.getAttributeName();
                string2 = miningAttributeInfo.getDataType();
            }
            this.jTargetValues = new TargetValuesPanel(string, string2, this._state.getTargetValues());
            this.jTabbedPane.addTab(SettingsLrb.get("MODEL_TARGET_VALUES"), this.jTargetValues);
        }
    }

    private void setupAggregatesTab() {
        int n = this._state.getAggregatesTableModel().getRowCount();
        if (n > 0) {
            this.jAggregatesLbl.setText(MessageFormat.format(SettingsLrb.get("NUMBER_OF_AGGREGATES"), n));
            this.jAggregatesTablePanel.setup((TableModel)((Object)this._state.getAggregatesTableModel()), null, 0);
            this.jTabbedPane.addTab(SettingsLrb.get("AGGREGATES_TAB"), this.jAggregtesPanel);
        }
    }

    private void setupDummyTreeTable(String string) {
        this._state.loadTempStatusTreeTable(string);
    }

    private void setupTreeTable() throws ODMrDAOException {
        this._state.loadTree(this.partitionToolbar.getSelectedPartitionID());
        SettingsViewerGeneralTreeTableModel settingsViewerGeneralTreeTableModel = (SettingsViewerGeneralTreeTableModel)((Object)this._jSettingsTreeTable.getTree().getModel());
        int n = this._state.getMaxStringLength();
        Dimension dimension = this._jSettingsTreeTable.getPreferredSize();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            Font font = this._jSettingsTreeTable.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n2 = fontMetrics.stringWidth("W") * n;
            int n3 = (fontMetrics.getHeight() + 3) * settingsViewerGeneralTreeTableModel.getNodeCount();
            dimension.width = n2;
            dimension.height = n3;
            this._jSettingsTreeTable.setPreferredSize(dimension);
        }
        this._jSettingsTreeTable.expandAll(true);
    }

    private void setupCostMatrixTable() {
        ReadOnlyCostMatrixModel readOnlyCostMatrixModel = this._state.getCostMatrix();
        if (readOnlyCostMatrixModel != null) {
            ((BaseCostMatrixTable)this.genericTableCostMatrix).setModel(this._state.getCostMatrix());
            this.jTabbedPane.addTab(SettingsLrb.get("MODEL_COST_MATRIX"), this.jCostMatrix);
        }
    }

    private void setupPartitionKeyTable() {
        List<PartitionModelAttributeInfo> list = this._state.getPartitionKeys();
        if (!list.isEmpty()) {
            this.jPartitionKeys.setData(list);
            this.jTabbedPane.add(SettingsLrb.get("PARTITION_KEYS_DIALOG_TITLE"), this.jPartitionKeys);
        }
    }

    private void setupSignatureTable() {
        SettingsViewerSignatureTableModel settingsViewerSignatureTableModel = this._state.getSignatureTableModel();
        if (settingsViewerSignatureTableModel != null) {
            this._genericTableModelSignature.setModel((TableModel)((Object)settingsViewerSignatureTableModel));
            this._genericTableModelSignature.setSorted(true);
            this._genericTableModelSignature.setUpdateSelectionOnSort(true);
            this._genericTableModelSignature.getTableHeader().setReorderingAllowed(false);
            this._genericTableModelSignature.setSelectionMode(2);
            TableColumnModel tableColumnModel = this._genericTableModelSignature.getColumnModel();
            BooleanIconCellRenderer booleanIconCellRenderer = new BooleanIconCellRenderer();
            tableColumnModel.getColumn(4).setCellRenderer(booleanIconCellRenderer);
            if (tableColumnModel.getColumnCount() > 5) {
                tableColumnModel.getColumn(5).setCellRenderer(booleanIconCellRenderer);
            }
            TableColumn tableColumn = tableColumnModel.getColumn(3);
            ModelNode modelNode = (ModelNode)this.getContext().getNode();
            if (modelNode instanceof DTModelNode || modelNode instanceof GLMCModelNode || modelNode instanceof GLMRModelNode || modelNode instanceof SVMCModelNode || modelNode instanceof SVMRModelNode || modelNode instanceof NBModelNode) {
                tableColumn.setCellRenderer(booleanIconCellRenderer);
            } else {
                this._genericTableModelSignature.removeColumn(tableColumn);
            }
            this._genericTableModelSignature.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int[] nArray = SettingsViewerTabPanel.this._genericTableModelSignature.getSelectedRowsInModel();
                    if (0 == nArray.length) {
                        SettingsViewerTabPanel.this._lastSelectedIindex = -1;
                        SettingsViewerTabPanel.this._state.setLastSelectedAttribute(SettingsViewerTabPanel.this._lastSelectedIindex);
                        SettingsViewerTabPanel.this.setXfrom();
                        return;
                    }
                    if (nArray.length > 1) {
                        SettingsViewerTabPanel.this.jTextArea1.setText(SettingsLrb.get("MULTIPLE_ATTRIBUTE_SELECTION"));
                        return;
                    }
                    int n = nArray[0];
                    if (n >= 0 && SettingsViewerTabPanel.this._lastSelectedIindex != n) {
                        SettingsViewerTabPanel.this._lastSelectedIindex = n;
                        SettingsViewerTabPanel.this._state.setLastSelectedAttribute(SettingsViewerTabPanel.this._lastSelectedIindex);
                        SettingsViewerTabPanel.this.setXfrom();
                    }
                }
            });
            this._genericTableModelSignature.setSortColumn(0, true);
            this._genericTableModelSignature.setFillsViewportHeight(true);
            this._genericTableModelSignature.autoSizeColumnsToFit();
            this.jTabbedPane.addTab(SettingsLrb.get("MODEL_SIGNATURE_ATTRIBUTES"), this.jSignature);
        }
    }

    private void setupTextAttrsTable() {
        if (this._state.getTextAttrsTableModel().getRowCount() > 0) {
            this.jFeatures = new TextFeaturesPanel();
            this.jFeatures.setupTextAttrsTable(this._state);
            this.jTabbedPane.addTab(SettingsLrb.get("MODEL_TEXT_ATTRIBUTES"), this.jFeatures);
        }
    }

    private void setXfrom() {
        this.jTextArea1.setText("");
        MiningAttributeInfo miningAttributeInfo = this._state.getLastSelectedAttribute();
        if (miningAttributeInfo == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = miningAttributeInfo.getExpression();
        if (stringBuilder2 != null && 0 != stringBuilder2.length()) {
            StringBuilder stringBuilder3;
            stringBuilder.append(SettingsLrb.get("MODEL_XFORM_TITLE"));
            stringBuilder.append("\n\t");
            stringBuilder.append((CharSequence)stringBuilder2);
            if (this.jCheckBox1.isSelected() && (stringBuilder3 = miningAttributeInfo.getRevExpression()) != null && 0 != stringBuilder3.length()) {
                stringBuilder.append("\n");
                stringBuilder.append(SettingsLrb.get("MODEL_REV_XFORM_TITLE"));
                stringBuilder.append("\n\t");
                stringBuilder.append((CharSequence)stringBuilder3);
            }
        }
        this.jTextArea1.setText(stringBuilder.toString());
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private void initComponents() {
        this.jScrollPaneXform = new JScrollPane();
        this._genericTableModelSignature = new DataMinerTable();
        this.signatureSearchField = new SearchField();
        this.signatureControlBar = new ControlBar();
        this.signatureControlBar.add((Component)this.signatureSearchField);
        this.jTabbedPane = new JTabbedPane2();
        this.jModelSettings = new JPanel();
        this.jScrollPaneSettings = new JScrollPane();
        this.jSignature = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPaneSignature = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jSignaturesPanel = new ComponentWithTitlebar();
        this.jWeights = new JPanel();
        this.jLabelWeifgts = new JLabel();
        this.jScrollPaneWeights = new JScrollPane();
        this.genericTableWeights = new DataMinerTable();
        this.jCostMatrix = new JPanel();
        this.jScrollPaneCostMatrix = new JScrollPane();
        this.genericTableCostMatrix = new BaseCostMatrixTable();
        this.jLabelCostMatrix = new JLabel();
        this.jPartitionKeys = new PartitionKeysPanel();
        this.jFeatures = new TextFeaturesPanel();
        this.jAggregtesPanel = new JPanel();
        this.jAggregatesTablePanel = new DataMinerTablePanel();
        this.jAggregatesLbl = new JLabel();
        this.topPanel = new JPanel();
        this.partitionToolbar = new ModelViewerPartitionToolbar();
        this._genericTableModelSignature.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.jScrollPaneXform.setViewportView((Component)((Object)this._genericTableModelSignature));
        this.signatureSearchField.setAutoFind(true);
        this.signatureSearchField.setDoubleBuffered(false);
        this.signatureSearchField.setNotifyOnEmptySearch(true);
        this.signatureSearchField.setPreferredSize(new Dimension(160, 21));
        this.signatureSearchField.setPrompt(CoreCommonLrb.get((String)"NAME"));
        this.signatureControlBar.setPreferredSize(new Dimension(160, 25));
        this.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this.jModelSettings);
        this.jModelSettings.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneSettings, -1, 643, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneSettings, -1, 342, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Settings", this.jModelSettings);
        this.jSplitPane1.setDividerLocation(500);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPaneSignature.setViewportView(this.jTextArea1);
        this.jLabel2.setText("jLabel2");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel2, -2, 166, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 238, Short.MAX_VALUE).addComponent(this.jCheckBox1, -2, 217, -2)).addComponent(this.jScrollPaneSignature, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneSignature, -1, 23, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setBottomComponent(this.jPanel1);
        this.jSignaturesPanel.setComponent((JComponent)this.jScrollPaneXform);
        this.jSignaturesPanel.setControlBar(this.signatureControlBar);
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jSignaturesPanel, GroupLayout.Alignment.TRAILING, -1, 641, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jSignaturesPanel, -1, 335, Short.MAX_VALUE));
        this.jSplitPane1.setTopComponent(this.jPanel2);
        GroupLayout groupLayout4 = new GroupLayout(this.jSignature);
        this.jSignature.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 342, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Signature", this.jSignature);
        this.jLabelWeifgts.setText("jLabel3");
        this.genericTableWeights.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneWeights.setViewportView((Component)((Object)this.genericTableWeights));
        GroupLayout groupLayout5 = new GroupLayout(this.jWeights);
        this.jWeights.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneWeights, -1, 643, Short.MAX_VALUE).addComponent(this.jLabelWeifgts, -2, 120, -2)).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jLabelWeifgts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneWeights, -1, 322, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Weights", this.jWeights);
        this.genericTableCostMatrix.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.genericTableCostMatrix.setAutoResizeMode(0);
        this.jScrollPaneCostMatrix.setViewportView((Component)((Object)this.genericTableCostMatrix));
        this.jLabelCostMatrix.setText("jLabel3");
        GroupLayout groupLayout6 = new GroupLayout(this.jCostMatrix);
        this.jCostMatrix.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneCostMatrix, -1, 643, Short.MAX_VALUE).addComponent(this.jLabelCostMatrix, -2, 152, -2)).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.jLabelCostMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneCostMatrix, -1, 322, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Cost Matrix", this.jCostMatrix);
        this.jTabbedPane.addTab("Partition Keys", this.jPartitionKeys);
        this.jTabbedPane.addTab("Features", this.jFeatures);
        this.jAggregatesLbl.setText("Number of Aggregates: #");
        GroupLayout groupLayout7 = new GroupLayout(this.jAggregtesPanel);
        this.jAggregtesPanel.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAggregatesTablePanel, -1, 643, Short.MAX_VALUE).addComponent(this.jAggregatesLbl, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.jAggregatesLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAggregatesTablePanel, -1, 322, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Aggregates", this.jAggregtesPanel);
        this.add((Component)this.jTabbedPane, "Center");
        GroupLayout groupLayout8 = new GroupLayout(this.topPanel);
        this.topPanel.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addGap(12, 12, 12).addComponent(this.partitionToolbar, -1, 646, Short.MAX_VALUE).addContainerGap()));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.partitionToolbar, -2, 30, -2));
        this.add((Component)this.topPanel, "North");
    }

    private static class CustomCellRenderer
    extends DefaultTreeCellRenderer {
        private SettingsTreeTable _parent;

        private CustomCellRenderer(SettingsTreeTable settingsTreeTable) {
            this._parent = settingsTreeTable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            SettingsViewerGeneralTreeTableModel.ModelSettingsNode modelSettingsNode = (SettingsViewerGeneralTreeTableModel.ModelSettingsNode)object;
            this.setText(modelSettingsNode.getLabel());
            this.setIcon(null);
            if (modelSettingsNode.isFolderNode()) {
                if (this._parent._leaffont == null) {
                    this._parent._leaffont = component.getFont();
                    this._parent._folderfont = component.getFont().deriveFont(1);
                }
                this.setFont(this._parent._folderfont);
            } else if (modelSettingsNode.isLeafNode()) {
                this.setFont(this._parent._leaffont);
            }
            return component;
        }
    }

    private static class CustomBasicUI
    extends BasicTreeUI {
        private CustomBasicUI() {
        }

        @Override
        protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        }

        @Override
        protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        }
    }

    private class SettingsTreeTable
    extends BaseTreeTable {
        private Font _leaffont;
        private Font _folderfont;

        SettingsTreeTable(SettingsViewerGeneralTreeTableModel settingsViewerGeneralTreeTableModel) {
            super((TreeTableModel)settingsViewerGeneralTreeTableModel);
            this.setIconRenderer();
        }

        private void setIconRenderer() {
            this.getTree().setCellRenderer(new CustomCellRenderer(this));
        }

        public void hideHandles() {
            SettingsViewerTabPanel.this._jSettingsTreeTable.getTree().setUI(new CustomBasicUI());
        }

        public boolean getScrollableTracksViewportWidth() {
            if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                boolean bl = this.getParent().getWidth() > this.getPreferredSize().width;
                return bl;
            }
            return false;
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(SettingsViewerTabPanel.this.jCheckBox1)) {
                SettingsViewerTabPanel.this.setXfrom();
            }
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        public LoadUI() {
            super(SettingsViewerTabPanel.this, SettingsViewerTabPanel.this.overLayPanel);
        }

        @Override
        protected void beforeExecute() {
            SettingsViewerTabPanel.this.initializeTabs();
            SettingsViewerTabPanel.this.setLoading(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            SettingsViewerTabPanel.this.getContext().getNode().ensureOpen();
            SettingsViewerTabPanel.this.partitionToolbar.load(SettingsViewerTabPanel.this.getEditor());
            SettingsViewerTabPanel.this._state.load(SettingsViewerTabPanel.this.partitionToolbar.getPartitionVO());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            if (StringUtils.isEmpty((String)SettingsViewerTabPanel.this._state.getModelViewerState().getOdmModel().getModelGeneralDescription().getMiningFunction())) {
                throw new DataMinerException("ORA-40203");
            }
            SettingsViewerTabPanel.this.setupTreeTable();
            SettingsViewerTabPanel.this.setupSignatureTable();
            SettingsViewerTabPanel.this.setupTextAttrsTable();
            SettingsViewerTabPanel.this.setupPartitionKeyTable();
            SettingsViewerTabPanel.this.setupCostMatrixTable();
            SettingsViewerTabPanel.this.setupWeights();
            SettingsViewerTabPanel.this.setupTargetValues();
            SettingsViewerTabPanel.this.setupAggregatesTab();
            SettingsViewerTabPanel.this.setLoaded(true);
        }

        @Override
        protected void onFailureOnSuccess(Exception exception) {
            DataMinerEditor.handleEditorException(SettingsViewerTabPanel.this.getEditor().getContext(), exception, SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            SettingsViewerTabPanel.this.setLoading(false);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            super.onFailure(throwable);
            SettingsViewerTabPanel.this.setupDummyTreeTable(SettingsLrb.get("SETTINGS_LOADING_ERROR"));
        }
    }
}

