/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.math.BigDecimal;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.clas.common.MatrixInfo;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;

public class SettingsViewerWeightTableModel
extends ODMrTableModel<NameValuePair> {
    private static final int WEIGHT_TARGET_VALUE = 0;
    private static final int WEIGHT_VALUE = 1;
    private static String[] COLUMNS = new String[]{DialogsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE"), DialogsLrb.get("PERFORMANCE_WEIGHTS_WEIGHT_VALUE")};

    public SettingsViewerWeightTableModel() {
        super(COLUMNS);
    }

    public SettingsViewerWeightTableModel(MatrixInfo matrixInfo) {
        super(COLUMNS, matrixInfo.getValues());
    }

    public Object getValueAt(int n, int n2) {
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        NameValuePair nameValuePair = (NameValuePair)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = nameValuePair.getName();
                break;
            }
            case 1: {
                string = NumericFormat.format((double)((BigDecimal)nameValuePair.getValue()).doubleValue(), (boolean)true, (int)8) + "";
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return string;
    }
}

