/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.property;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dmt.dataminer.property.Property;
import oracle.dmt.dataminer.property.PropertyConsumer;
import oracle.dmt.dataminer.property.PropertyEvent;
import oracle.dmt.dataminer.property.PropertyImplementer;
import oracle.dmt.dataminer.property.PropertyListener;
import oracle.dmt.dataminer.property.PropertyLrb;
import oracle.dmt.dataminer.property.PropertyManager;
import oracle.dmt.dataminer.property.PropertyPageProvider;
import oracle.dmt.dataminer.property.PropertyWindowGUI;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class PropertyWindow
extends DockableWindow
implements EditorListener,
ViewListener,
DockableListener,
ActiveViewListener {
    private static final Logger theLogger = Logger.getLogger(PropertyWindow.class.getName());
    public static final String VIEW_TYPE = "DATAMININGPROPERTYFACTORY";
    public static final String VIEW_NAME = "PROPERTY";
    protected HashMap<View, ArrayList<PropertyListener>> _propertyListenersByType;
    private Object _propertyListenerLock = new Object();
    protected ArrayList<Component> _propertyWindows;
    PropertyGUIEventHandler _guiEventHandler;
    private static final PropertyWindow _singleton = new PropertyWindow();
    private JScrollPane _rootContainer;
    private JPanel _emptyPanel;
    private final PropertyManager _propertyManager = PropertyManager.getPropertyManager();
    private final Property _property = Property.getInstance();
    private View _currentEditor = null;
    private View _currentView = null;
    private Component _currentGUI = null;
    private static boolean _isView = false;
    private static boolean _dockableHidden = false;
    private static boolean editorListenerAdded = false;
    private Collection<PropertyConsumer> _consumers = null;
    public static final String LAYOUT_SHOW_PROPERTY = "Layout.ShowProperty";
    public static final String LAYOUT_RAISE_PROPERTY = "Layout.RaiseProperty";

    public static String viewId() {
        return "DATAMININGPROPERTYFACTORY.PROPERTY";
    }

    public PropertyWindow() {
        super(PropertyWindow.viewId());
        DockStation.getDockStation().addDockableListener((DockableListener)this, (Dockable)this);
        this._propertyListenersByType = new HashMap();
        this._guiEventHandler = new PropertyGUIEventHandler();
    }

    private void initRootContainer() {
        this._rootContainer = new JScrollPane();
        this._emptyPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jLabel.setText("No Associated Editor");
        this._emptyPanel.add(jLabel);
        this.loadRootContainer(this._emptyPanel);
    }

    private void consumerListeners() {
        this._consumers = this._propertyManager.getPropertyConsumers();
        if (this._consumers == null) {
            return;
        }
        for (PropertyConsumer propertyConsumer : this._consumers) {
            propertyConsumer.getConsumerView().addViewListener((ViewListener)this);
        }
    }

    public Component getGUI() {
        View view;
        if (this._rootContainer == null) {
            this.initRootContainer();
        }
        if ((view = this.getEditor()) == null) {
            this.loadRootContainer(this._emptyPanel);
            this._currentGUI = null;
            return this.loadRootContainer(this._currentGUI);
        }
        this._currentView = view;
        _isView = true;
        if (this._consumers == null) {
            this.consumerListeners();
        }
        if (this._synchronizeProperty(this.getEditor(), false)) {
            return this._rootContainer;
        }
        this._currentGUI = null;
        return this.loadRootContainer(this._emptyPanel);
    }

    private Component loadRootContainer(Component component) {
        if (component != null) {
            this._rootContainer.setViewportView(component);
        } else {
            this._rootContainer.getViewport().removeAll();
        }
        return this._rootContainer;
    }

    private Component getInternalGUI() {
        Component component = null;
        PropertyConsumer propertyConsumer = null;
        if (this._currentEditor instanceof PropertyConsumer) {
            propertyConsumer = (PropertyConsumer)this._currentEditor;
        }
        PropertyPageProvider propertyPageProvider = null;
        if (propertyConsumer != null) {
            propertyPageProvider = this.findPropertyPageProvider(propertyConsumer);
            assert (propertyPageProvider != null) : "Property dockable received a request from a consumer, but there is no matching property provider.";
            if (propertyPageProvider != null) {
                component = propertyPageProvider.getPropertyPage().getGUI();
                if (component instanceof PropertyWindowGUI) {
                    this.addInternalGUIToListener(component);
                    this.loadRootContainer(component);
                } else assert (false) : "GUI provided by PropertyPageProvider is not an instance of PropertyWindowGUI";
            }
        }
        return component;
    }

    private void addInternalGUIToListener(Component component) {
        if (this._propertyWindows == null) {
            this._propertyWindows = new ArrayList();
        }
        if (!this._propertyWindows.contains(component)) {
            ((PropertyWindowGUI)component).addPropertyListener(this._guiEventHandler);
            this._propertyWindows.add(component);
        }
    }

    private PropertyPageProvider findPropertyPageProvider(PropertyConsumer propertyConsumer) {
        PropertyPageProvider propertyPageProvider = null;
        for (PropertyPageProvider propertyPageProvider2 : this._property.getPropertyPageProviders()) {
            if (!propertyPageProvider2.getPropertyType().equals(propertyConsumer.getPropertyType())) continue;
            propertyPageProvider = propertyPageProvider2;
            break;
        }
        return propertyPageProvider;
    }

    public static PropertyWindow getInstance() {
        return _singleton;
    }

    public void dockableShown(DockableEvent dockableEvent) {
        _dockableHidden = false;
        super.dockableShown(dockableEvent);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        this._synchronizeProperty(this.getEditor(), true);
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        this.unloadUI();
        _dockableHidden = true;
        this._currentEditor = null;
        super.dockableHidden(dockableEvent);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
    }

    public void stateChange(int n) {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        super.stateChange(n);
    }

    public View getEditor() {
        if (_isView) {
            return this._currentView;
        }
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null) {
            editor = null;
        }
        return editor;
    }

    private boolean _synchronizeProperty(View view, boolean bl) {
        if (!editorListenerAdded) {
            EditorManager.getEditorManager().addEditorListener((EditorListener)this);
            editorListenerAdded = true;
        }
        if (view == null) {
            this.loadRootContainer(this._emptyPanel);
            return false;
        }
        if (this._currentEditor == null || view != this._currentEditor) {
            Component component;
            if (!(view instanceof PropertyConsumer)) {
                this._currentEditor = view;
                this._currentGUI = null;
                this.loadRootContainer(this._emptyPanel);
                return true;
            }
            if (this._currentGUI != null) {
                this.unloadUI();
            }
            this._currentEditor = view;
            this._currentGUI = component = this.getInternalGUI();
            if (this._currentGUI != null) {
                this.loadRootContainer(this._currentGUI);
                if (bl) {
                    this.initializeUI();
                }
                return true;
            }
            this.loadRootContainer(this._emptyPanel);
            return false;
        }
        this.initializeUI();
        return true;
    }

    private void initializeUI() {
        if (this._currentGUI instanceof PropertyImplementer) {
            try {
                PropertyImplementer propertyImplementer = (PropertyImplementer)((Object)this._currentGUI);
                if (!propertyImplementer.isLoaded()) {
                    propertyImplementer.setupUI(this._currentEditor);
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PROPERTY_PROCESSING_MESG"), (String)PropertyLrb.get("PROPERTY_PROCESSING_TITLE"), null);
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    private void unloadUI() {
        if (this._currentGUI instanceof PropertyImplementer) {
            try {
                PropertyImplementer propertyImplementer = (PropertyImplementer)((Object)this._currentGUI);
                if (propertyImplementer.isLoaded()) {
                    propertyImplementer.unloadUI();
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PROPERTY_PROCESSING_MESG"), (String)PropertyLrb.get("PROPERTY_PROCESSING_TITLE"), null);
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        this.addPropertyListener(propertyListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(PropertyListener propertyListener, View view) {
        Object object = this._propertyListenerLock;
        synchronized (object) {
            ArrayList<PropertyListener> arrayList = null;
            if (this._propertyListenersByType == null) {
                this._propertyListenersByType = new HashMap();
            }
            if (!this._propertyListenersByType.containsKey(view)) {
                this._propertyListenersByType.put(view, new ArrayList());
            }
            arrayList = this._propertyListenersByType.get(view);
            arrayList.add(propertyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(PropertyListener propertyListener) {
        Object object = this._propertyListenerLock;
        synchronized (object) {
            if (this._propertyListenersByType == null) {
                return;
            }
            for (ArrayList<PropertyListener> arrayList : this._propertyListenersByType.values()) {
                arrayList.remove(propertyListener);
            }
        }
    }

    private void firePropertyEvent(PropertyEvent propertyEvent) {
        try {
            this.fireEvent(new PropertyListenerHandler(){

                @Override
                public void handle(PropertyListener propertyListener, PropertyEvent propertyEvent) {
                    propertyListener.selectionEvent(propertyEvent);
                }
            }, propertyEvent);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void fireEvent(PropertyListenerHandler propertyListenerHandler, PropertyEvent propertyEvent) {
        HashMap<View, ArrayList<PropertyListener>> hashMap = this.cloneToAvoidConcurrentModificationException(this._propertyListenersByType);
        ArrayList<PropertyListener> arrayList = hashMap.get(propertyEvent.getTarget());
        if (arrayList != null) {
            for (PropertyListener propertyListener : arrayList) {
                propertyListenerHandler.handle(propertyListener, propertyEvent);
            }
        }
        if (propertyEvent.getTarget() != null && (arrayList = hashMap.get(null)) != null) {
            for (PropertyListener propertyListener : arrayList) {
                propertyListenerHandler.handle(propertyListener, propertyEvent);
            }
        }
    }

    private HashMap<View, ArrayList<PropertyListener>> cloneToAvoidConcurrentModificationException(HashMap<View, ArrayList<PropertyListener>> hashMap) {
        return (HashMap)hashMap.clone();
    }

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        _isView = false;
        if (!_dockableHidden) {
            this._synchronizeProperty((View)editor, true);
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor != null && editor == this._currentEditor) {
            this._currentEditor = null;
            this._currentView = null;
            this.unloadUI();
            this._currentGUI = null;
            this.loadRootContainer(this._emptyPanel);
            _isView = false;
        }
    }

    public void viewActivated(ViewEvent viewEvent) {
        _isView = true;
        View view = viewEvent.getView();
        if (!_dockableHidden) {
            this._currentView = view;
            this._synchronizeProperty(view, true);
        }
    }

    public void viewDeactivated(ViewEvent viewEvent) {
    }

    public void viewClosed(ViewEvent viewEvent) {
        View view = viewEvent.getView();
        if (view != null && view == this._currentView) {
            this._currentView = null;
            this._currentEditor = null;
            this.unloadUI();
            this._currentGUI = null;
            this.loadRootContainer(this._emptyPanel);
            _isView = false;
        }
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.getNewView() == null) {
            this.loadRootContainer(this._emptyPanel);
            return;
        }
        View view = this.getEditor();
        if (view == null) {
            this.loadRootContainer(this._emptyPanel);
            return;
        }
        if (!_dockableHidden) {
            this._synchronizeProperty(view, true);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_dataminer_property_html");
    }

    public int getDefaultVisibility(Layout layout) {
        String string = layout.getProperty(LAYOUT_SHOW_PROPERTY, null);
        boolean bl = Boolean.valueOf(string);
        String string2 = layout.getProperty(LAYOUT_RAISE_PROPERTY, bl ? "true" : "false");
        boolean bl2 = Boolean.valueOf(string2);
        return (bl ? 1 : 0) | (bl2 ? 4 : 0);
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"settings.png");
    }

    public String getTitleName() {
        return PropertyLrb.get("PROPERTY_TAB_NAME");
    }

    public String getUniqueName() {
        return "DATAMININGPROPERTYFACTORY.PROPERTY";
    }

    class PropertyGUIEventHandler
    implements PropertyListener {
        PropertyGUIEventHandler() {
        }

        @Override
        public void selectionEvent(PropertyEvent propertyEvent) {
            PropertyWindow.this.firePropertyEvent(propertyEvent);
        }
    }

    private static interface PropertyListenerHandler {
        public void handle(PropertyListener var1, PropertyEvent var2);
    }
}

