/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelPartitionsQuery;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.build.partition.ModelPartitions;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.core.utils.Arrays;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.RepositoryLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.ide.Context;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;

public class DatabaseMetadataUtils {
    private static final Logger LOGGER = Logger.getLogger(DatabaseMetadataUtils.class.getName());
    private static final String NUMERICAL_MINING_TYPE = RepositoryLrb.get("MINING_ATTRIBUTE_TYPE_NUMERICAL");
    private static final String CATEGORICAL_MINING_TYPE = RepositoryLrb.get("MINING_ATTRIBUTE_TYPE_CATEGORICAL");
    private static final String TEXT_MINING_TYPE = RepositoryLrb.get("MINING_ATTRIBUTE_TYPE_TEXT");
    private static final String NOT_APPLICABLE_MINING_TYPE = RepositoryLrb.get("NOT_APPLICABLE");
    private static final String PARTITION_INFORMATION_QUERY = "WITH model_partitions AS \n   (SELECT p.model_name, p.partition_name, p.position, p.column_name, \n           NVL(p.column_value, '(null)') AS column_value, a.data_type \n    FROM all_mining_model_partitions p, all_mining_model_attributes a \n    WHERE p.owner = ? and p.model_name = ? \n      AND p.owner = a.owner and p.model_name = a.model_name \n      AND p.column_name = a.attribute_name) ,\n       top_partition AS \n    ( select * from (select * from all_mining_model_partitions \n                     WHERE owner = ? and model_name = ? \n                     order by partition_name, position )\n      where rownum = 1)\n SELECT * FROM \n  (SELECT \n    mp.partition_name as id,\n    LISTAGG(mp.column_value, '_') WITHIN GROUP(ORDER BY mp.partition_name, mp.position) as name, \n    LISTAGG(mp.column_name, ',')  WITHIN GROUP(ORDER BY mp.partition_name, mp.position) as keys, \n    LISTAGG(mp.data_type   , ',') WITHIN GROUP(ORDER BY mp.partition_name, mp.position) as data_types \n  FROM model_partitions mp, top_partition tp\n  WHERE mp.partition_name = tp.partition_name\n  GROUP BY mp.partition_name)\n";
    private static String[] m_TableSpaceObjectTypes = new String[]{"SYNONYM", "TABLE", "VIEW", "SEQUENCE", "PROCEDURE", "PACKAGE", "PACKAGE_BODY", "PROGRAM", "TYPE BODY", "TYPE", "FUNCTION", "JOB", "UNDEFINED", "INDEX PARTITION", "TABLE PARTITION", "MATERIALIZE VIEW"};
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final String DATA_QUALIFIER = "DATA_QUALIFIER";
    public static final String DATA_LENGTH = "DATA_LENGTH";
    public static final String MININIG_TYPE = "MININIG_TYPE";
    public static final String TEMP_TABLE_PREFIX = "ODMR$TMP";
    public static final String HIDDEN_TABLE_PREFIX = "ODMR$";
    static final int RANDOM_RANGE = 999999999;
    static final int INDEX_RANDOM_RANGE = 999999;
    public static final String EXCLUDE_SCHEMAS = "'SELECT_CATALOG_ROLE', 'PUBLIC', 'SYS', 'MDSYS', 'ODMRSYS', 'MDSYS', 'TSMSYS', 'CTXSYS', 'OLAPSYS', 'EXFSYS', 'SYSTEM', 'DBSNMP', 'SYSMAN', 'IX', 'XDB', 'WMSYS', 'ORDSYS'";
    public static final String ESCAPE_STRING = " ESCAPE '@' ";
    private static final String GET_TABLE_COLUMNS = "SELECT c.COLUMN_NAME,\n  c.DATA_TYPE, c.DATA_LENGTH\nFROM all_tab_columns c\nWHERE c.OWNER     = ? \nAND c.TABLE_NAME  = ? \nORDER BY column_name ASC";
    public static final String JSON_QUALIFIER = "JSON";
    private static final String JSON_COLUMNS = "SELECT COLUMN_NAME FROM ALL_JSON_COLUMNS WHERE  TABLE_NAME=? AND OWNER=?";
    public static final String JSON_TYPE_TEMPLATE = "JSON(<datatype>)";
    private static final String GET_ACCESSIBLE_SCHEMAS_QUERY = "select SCHEMA FROM (\nselect DISTINCT(OWNER) SCHEMA from all_tables\n where OWNER NOT IN (:owner_schema_param)\nUNION \nselect DISTINCT(OWNER) SCHEMA from all_views\n where OWNER NOT IN (:owner_schema_param))\n ORDER BY SCHEMA";
    private static final String GET_SYNONYM_INFO = "SELECT TABLE_OWNER, TABLE_NAME FROM ALL_SYNONYMS\nWHERE OWNER = ? AND SYNONYM_NAME = ?";
    public static final String ATTRIBUTE_TYPE_CATEGORICAL = "Categorical";
    public static final String ATTRIBUTE_TYPE_NUMERICAL = "Numerical";
    public static final String ATTRIBUTE_TYPE_TEXT = "Text";
    public static final String ATTRIBUTE_TYPE_TEXT_CUSTOM = "TextCustom";
    public static final String ATTRIBUTE_TYPE_NESTED_NUMERICALS = "Numerical";
    public static final String ATTRIBUTE_TYPE_NESTED_CATEGORICALS = "Categorical";
    public static final String ATTRIBUTE_TYPE_ODMR_HISTOGRAMS = "Categorical";
    public static final String ATTRIBUTE_TYPE_NOT_APPLICABLE = "NotApplicable";
    public static final String ORACLE_VARCHAR2 = "VARCHAR2";
    public static final String ORACLE_CHAR = "CHAR";
    public static final String ORACLE_NVARCHAR2 = "NVARCHAR2";
    public static final String ORACLE_NCHAR = "NCHAR";
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_NUMBER = "NUMBER";
    public static final String ORACLE_INTEGER = "INTEGER";
    public static final String ORACLE_BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String ORACLE_BINARY_FLOAT = "BINARY_FLOAT";
    public static final String ORACLE_DATE = "DATE";
    public static final String ORACLE_BFILE = "BFILE";
    public static final String ORACLE_BFILE_MINING_DATA_TYPE = "114";
    public static final String ORACLE_XMLTYPE = "XMLTYPE";
    public static final String ORACLE_URITYPE = "URITYPE";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String ORACLE_NCLOB = "NCLOB";
    public static final String ORACLE_LONG = "LONG";
    public static final String ORACLE_RAW = "RAW";
    public static final String ORACLE_LONG_RAW = "LONG RAW";
    public static final String ORACLE_ROWID = "ROWID";
    public static final String ORACLE_ROWID_DATA_TYPE_CODE = "11";
    public static final String ORACLE_UROWID = "UROWID";
    public static final String ORACLE_UROWID_DATA_TYPE_CODE = "208";
    public static final String ORACLE_NESTED_NUMERICALS = "DM_NESTED_NUMERICALS";
    public static final String ORACLE_NESTED_CATEGORICALS = "DM_NESTED_CATEGORICALS";
    public static final String ORACLE_NESTED_BINARY_DOUBLES = "DM_NESTED_BINARY_DOUBLES";
    public static final String ORACLE_NESTED_BINARY_FLOATS = "DM_NESTED_BINARY_FLOATS";
    public static final String ODMR_HISTOGRAMS = "ODMR_HISTOGRAMS";
    public static final String ORACLE_NESTED_VARCHAR2 = "ODMR_NESTED_VARCHAR2";
    public static final String ORACLE_NESTED_NVARCHAR2 = "ODMR_NESTED_NVARCHAR2";
    public static final String ODMR_HISTOGRAMS_EX = "ODMR_HISTOGRAMS_EX";
    public static final String ORACLE_NESTED_VARCHAR2_EX = "ODMR_NESTED_VARCHAR2_EX";
    public static final String ORACLE_NESTED_NVARCHAR2_EX = "ODMR_NESTED_NVARCHAR2_EX";
    public static final String ORACLE_NESTED_CHAR = "ODMR_NESTED_CHAR";
    public static final String ORACLE_NESTED_NCHAR = "ODMR_NESTED_NCHAR";
    public static final String ORACLE_NESTED_TABLE = "NESTED TABLE";
    public static final String ORACLE_NUMBER_TX = "DM_NESTED_NUMERICALS";
    public static final String ORACLE_VARCHAR2_TX = "DM_NESTED_CATEGORICALS";
    public static final String ORACLE_TIMESTAMP = "TIMESTAMP";
    public static final String ORACLE_TIMSTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    public static final String ORACLE_TIMSTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";
    private static final String _WITH_TIMEZONE = "WITH TIME ZONE";
    private static final String _WITH_LOCAL_TIMEZONE = "WITH LOCAL TIME ZONE";
    private static final String[] _INTERVAL_YEAR_TO_MONTH = new String[]{"INTERVAL YEAR", "TO MONTH"};
    private static final String[] _INTERVAL_DAY_TO_SECOND = new String[]{"INTERVAL DAY", "TO SECOND"};
    public static final String JSON_OBJECT = "OBJECT";
    public static final String JSON_ARRAY = "ARRAY";
    public static final String JSON_NUMBER = "NUMBER";
    public static final String JSON_STRING = "STRING";
    public static final String JSON_BOOLEAN = "BOOLEAN";
    public static final String JSON_NULL = "NULL";
    public static final String JSON_BOOLEAN_TRUE = "true";
    public static final String JSON_BOOLEAN_FALSE = "false";
    public static final String JSON_NULL_VALUE = "null";
    public static final String JSON_VARCHAR2 = "JSON(VARCHAR2)";
    public static final String JSON_NVARCHAR2 = "JSON(NVARCHAR2)";
    public static final String JSON_CHAR = "JSON(CHAR)";
    public static final String JSON_NCHAR = "JSON(NCHAR)";
    public static final String JSON_CLOB = "JSON(CLOB)";
    public static final String JSON_NCLOB = "JSON(NCLOB)";
    public static final String JSON_BLOB = "JSON(BLOB)";
    public static final String JSON_RAW = "JSON(RAW)";
    private static final String[] ORACLE_DATA_TYPES_SUPPORTED = new String[]{"VARCHAR2", "CHAR", "NVARCHAR2", "NCHAR", "FLOAT", "NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT", "DATE", "BLOB", "CLOB", "NCLOB", "BFILE", "DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "DM_NESTED_BINARY_DOUBLES", "DM_NESTED_BINARY_FLOATS", "XMLTYPE", "RAW", "ROWID", "UROWID", "URITYPE"};
    private static final String[] JSON_DATA_TYPES_SUPPORTED = new String[]{"JSON(VARCHAR2)", "JSON(NVARCHAR2)", "JSON(CHAR)", "JSON(NCHAR)", "JSON(CLOB)", "JSON(NCLOB)", "JSON(BLOB)", "JSON(RAW)"};
    private static final Map<String, String> JSON_DATA_TYPES_MAP = new HashMap<String, String>();
    private static final String[] ORACLE_COMPATIBLE_CHARACTER_TYPES;
    private static final String[] ORACLE_COMPATIBLE_NUMBER_TYPES;
    private static final String[] ORACLE_NESTED_TYPES_SUPPORTED;
    private static final String[] ORACLE_NESTED_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_NUMERIC_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_DYNAMIC_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_KEY_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_CASE_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_CASE_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_DYNAMIC_CASE_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_INDEX_NOT_SUPPORTED;
    private static final String[] ORACLE_TEXT_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_PARTITION_KEY_DATA_TYPES_SUPPORTED;
    private static final String sql = "SELECT TYPE_NAME FROM all_coll_types WHERE  COLL_TYPE = 'TABLE' AND ELEM_TYPE_NAME='VARCHAR2'";
    private static List<String> allowedDynamicTypes;
    static Random randNumberGen;
    private static String COLUMNS_WITH_CONSTRAINTS;
    private static String NOT_NULL;
    private static String DBMS_SQL_PARSE_TYPE;
    private static String DBMS_SQL_PARSE_LEGACY_APPLY_TYPE;
    static String sql_col_types;
    private static String _load_data_guide;
    private static String column_count_distincts;
    private static String count_distincts;

    public static String getReplacedString(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.length() > 0) {
            while ((n2 = string.indexOf(string2, n)) >= 0) {
                stringBuilder.append(string.substring(n, n2));
                stringBuilder.append(string3);
                n = n2 + string2.length();
            }
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTableOrView(ConnectionManager connectionManager, String string, String string2, boolean bl) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string3 = null;
            String string4 = "";
            string4 = string == null ? StringUtils.trimDoubleQuotes(string2) : StringUtils.trimDoubleQuotes(string) + "\".\"" + StringUtils.trimDoubleQuotes(string2);
            string3 = bl ? "DROP TABLE \"" + string4 + "\" PURGE" : "DROP VIEW \"" + string4 + "\"";
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
        }
    }

    public static String getCreateTableAsSQL(String string, String string2, String[] stringArray, String string3, String string4) throws Exception {
        CharSequence charSequence;
        String string5 = null;
        string5 = " execute immediate 'create table \"<outputSchemaName>\".\"<outputTableName>\" as select <selectedColumns> from \"<inputSchemaName>\".\"<inputTableName>\"'; \n";
        if (stringArray == null) {
            string5 = StringUtils.getReplacedString(string5, "<selectedColumns>", "*");
        } else {
            charSequence = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                ((StringBuilder)charSequence).append("\"");
                ((StringBuilder)charSequence).append(DatabaseMetadataUtils.getReplacedString(stringArray[i], "'", "''"));
                ((StringBuilder)charSequence).append("\"");
                if (i == stringArray.length - 1) continue;
                ((StringBuilder)charSequence).append(",");
            }
            string5 = StringUtils.getReplacedString(string5, "<selectedColumns>", ((StringBuilder)charSequence).toString());
        }
        StringUtils.trimDoubleQuotes(string3);
        StringUtils.trimDoubleQuotes(string4);
        StringUtils.trimDoubleQuotes(string);
        StringUtils.trimDoubleQuotes(string2);
        charSequence = DatabaseMetadataUtils.getReplacedString(string2, "'", "''");
        string5 = StringUtils.getReplacedString(string5, "<outputSchemaName>", string3);
        string5 = StringUtils.getReplacedString(string5, "<outputTableName>", string4);
        string5 = StringUtils.getReplacedString(string5, "<inputSchemaName>", string);
        string5 = StringUtils.getReplacedString(string5, "<inputTableName>", (String)charSequence);
        return string5;
    }

    public static String getCreateTableAsSQL(String string, String string2, String string3, String string4) throws Exception {
        return DatabaseMetadataUtils.getCreateTableAsSQL(string, string2, null, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createViewAs(ConnectionManager connectionManager, String string, String string2, String string3) throws SQLException {
        String string4 = null;
        SQLHelper sQLHelper = new SQLHelper();
        string4 = "create view \"{0}\".\"{1}\" as ";
        Object[] objectArray = new Object[]{StringUtils.trimDoubleQuotes(string2), StringUtils.trimDoubleQuotes(string3)};
        string4 = MessageFormat.format(string4, objectArray);
        string4 = string4 + string;
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.pstmt.execute();
        }
        finally {
            sQLHelper.close();
        }
    }

    public static String getCreateContextIndexSQL(String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = " execute immediate 'CREATE INDEX \"" + StringUtils.trimDoubleQuotes(string2) + "\".\"" + string.toUpperCase() + "\" ON \"" + StringUtils.trimDoubleQuotes(string2) + "\".\"" + StringUtils.trimDoubleQuotes(string3) + "\" (\"" + string4 + "\") INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS(''<settings>'')'; \n";
        string6 = StringUtils.getReplacedString(string6, "<settings>", string5);
        return string6;
    }

    public static String getDropContextIndexSQL(String string, String string2) throws Exception {
        String string3 = " execute immediate 'DROP INDEX \"" + StringUtils.trimDoubleQuotes(string) + "\".\"" + string2.toUpperCase() + "\"'; \n";
        return string3;
    }

    public static void dropTable(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        DatabaseMetadataUtils.dropTableOrView(connectionManager, string, string2, true);
    }

    public static void dropView(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        DatabaseMetadataUtils.dropTableOrView(connectionManager, string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAccessibleSchemas(ConnectionManager connectionManager, String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(GET_ACCESSIBLE_SCHEMAS_QUERY);
            sQLHelper.opstmt.setStringAtName("owner_schema_param", string);
            sQLHelper.opstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                arrayList.add(sQLHelper.rs.getString("SCHEMA"));
            }
        }
        return arrayList;
    }

    public static Collection<String> getUserTablesAndViews(ConnectionManager connectionManager) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "select TABLE_NAME from USER_TABLES union select VIEW_NAME as TABLE_NAME from USER_VIEWS ";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setFetchSize(5000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                arrayList.add(sQLHelper.rs.getString("TABLE_NAME"));
            }
        }
        return arrayList;
    }

    public static Map<String, String> getPrimaryObjectNamespaceHashMap(ConnectionManager connectionManager) throws SQLException {
        return DatabaseMetadataUtils.getNamespaceHashMap(connectionManager, m_TableSpaceObjectTypes);
    }

    public static Map<String, String> getUserConstraintNamespaceHashMap(ConnectionManager connectionManager) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(1000);
        String string = "select CONSTRAINT_NAME from USER_CONSTRAINTS order by CONSTRAINT_NAME";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                hashMap.put(sQLHelper.rs.getString(1), sQLHelper.rs.getString(1));
            }
        }
        return hashMap;
    }

    public static String[] getPrimaryObjectNamespace(ConnectionManager connectionManager) throws SQLException {
        return DatabaseMetadataUtils.getNamespace(connectionManager, m_TableSpaceObjectTypes);
    }

    private static String addObjectTypes(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("'");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("',");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getNamespaceHashMap(ConnectionManager connectionManager, String[] stringArray) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(1000);
        String string = "select OBJECT_NAME from USER_OBJECTS where OBJECT_TYPE in (" + DatabaseMetadataUtils.addObjectTypes(stringArray) + ") order by OBJECT_NAME";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                hashMap.put(sQLHelper.rs.getString(1), sQLHelper.rs.getString(1));
            }
        }
        return hashMap;
    }

    public static String[] getNamespace(ConnectionManager connectionManager, String[] stringArray) throws SQLException {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>(1000);
        String string = "select OBJECT_NAME from USER_OBJECTS where OBJECT_TYPE in (" + DatabaseMetadataUtils.addObjectTypes(stringArray) + ") order by OBJECT_NAME";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                arrayList.add(sQLHelper.rs.getString(1));
            }
            stringArray2 = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray2[i] = (String)arrayList.get(i);
            }
        }
        return stringArray2;
    }

    public static List<String> getJSONColumns(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        return DatabaseMetadataUtils.getJSONColumns(connectionManager.getConnection(), string, string2);
    }

    public static List<String> getJSONColumns(Connection connection, String string, String string2) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connection;
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(JSON_COLUMNS);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(COLUMN_NAME);
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public static String getJSONColumnTypeInfo(String string) {
        return StringUtils.getReplacedString(JSON_TYPE_TEMPLATE, "<datatype>", string);
    }

    public static List<Map<String, Object>> getColumnDetails(ConnectionManager connectionManager, Table table, List<String> list) throws SQLException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        table = DatabaseMetadataUtils.getSynonymTableInfo(connectionManager, table);
        String string = table.getSchema();
        String string2 = table.getName();
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object object;
            boolean bl = DbVersionHelper.isDB12102Up((Version)connectionManager.getDbVersion());
            if (bl) {
                object = DatabaseMetadataUtils.getJSONColumns(connectionManager, string2, string);
                list.addAll((Collection<String>)object);
            }
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(GET_TABLE_COLUMNS);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.pstmt.setFetchSize(500);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = new HashMap();
                String string3 = sQLHelper.rs.getString(COLUMN_NAME);
                object.put(COLUMN_NAME, string3);
                String string4 = sQLHelper.rs.getString(DATA_TYPE);
                String string5 = null;
                if (list != null && list.contains(string3)) {
                    string5 = JSON_QUALIFIER;
                }
                object.put(DATA_TYPE, string4);
                object.put(DATA_QUALIFIER, string5);
                object.put(DATA_LENGTH, sQLHelper.rs.getString(DATA_LENGTH));
                object.put(MININIG_TYPE, DatabaseMetadataUtils.getDefaultMiningType(string4));
                arrayList.add((Map<String, Object>)object);
            }
        }
        return arrayList;
    }

    public static List<List<String>> getColumnDetails(ConnectionManager connectionManager, Table table) throws SQLException {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>(50);
        table = DatabaseMetadataUtils.getSynonymTableInfo(connectionManager, table);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(GET_TABLE_COLUMNS);
            sQLHelper.pstmt.setString(1, table.getSchema());
            sQLHelper.pstmt.setString(2, table.getName());
            sQLHelper.pstmt.setFetchSize(500);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                ArrayList<String> arrayList2 = new ArrayList<String>(4);
                String string = sQLHelper.rs.getString(COLUMN_NAME);
                arrayList2.add(string);
                String string2 = sQLHelper.rs.getString(DATA_TYPE);
                arrayList2.add(string2);
                arrayList2.add(sQLHelper.rs.getString(DATA_LENGTH));
                arrayList2.add(DatabaseMetadataUtils.getDefaultMiningType(string2));
                arrayList.add(arrayList2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table getSynonymTableInfo(ConnectionManager connectionManager, Table table) {
        Table table2 = table;
        if (table.isSynonym()) {
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = connectionManager.getConnection();
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(GET_SYNONYM_INFO);
                sQLHelper.pstmt.setString(1, table.getSchema());
                sQLHelper.pstmt.setString(2, table.getName());
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                if (sQLHelper.rs.next()) {
                    String string = sQLHelper.rs.getString("TABLE_OWNER");
                    String string2 = sQLHelper.rs.getString("TABLE_NAME");
                    table2 = new Table(string, string2);
                }
            }
        }
        return table2;
    }

    public static boolean isTypeSupportedAsText(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_TEXT_DATA_TYPES_SUPPORTED, (Object)string);
        return bl;
    }

    public static boolean isTypeSupportedAsTableKey(String string) {
        boolean bl = !Arrays.contains((Object[])ORACLE_INDEX_NOT_SUPPORTED, (Object)string);
        return bl;
    }

    public static String[] getOracleKeyDataTypesSupported() {
        return ORACLE_KEY_DATA_TYPES_SUPPORTED;
    }

    public static String[] getOracleDataTypesSupported() {
        return ORACLE_DATA_TYPES_SUPPORTED;
    }

    public static boolean isIntervalYearToMonth(String string) {
        return -1 != string.indexOf(_INTERVAL_YEAR_TO_MONTH[0]) && -1 != string.indexOf(_INTERVAL_YEAR_TO_MONTH[1]);
    }

    public static boolean isIntervalDayToSeconds(String string) {
        return -1 != string.indexOf(_INTERVAL_DAY_TO_SECOND[0]) && -1 != string.indexOf(_INTERVAL_DAY_TO_SECOND[1]);
    }

    public static boolean isSupportedNestedType(Version version, String string) {
        boolean bl = false;
        bl = version.toCanonicalString().startsWith("11.") ? Arrays.contains((Object[])ORACLE_NESTED_TYPES_SUPPORTED, (Object)string) : Arrays.contains((Object[])ORACLE_NESTED_TYPES_SUPPORTED_12, (Object)string);
        return bl;
    }

    public static boolean isSupportedNestedType(Context context, String string) {
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        return DatabaseMetadataUtils.isSupportedNestedType(version, string);
    }

    public static boolean isNestedType(String string) {
        return DatabaseMetadataUtils.isNestedNumericType(string) || DatabaseMetadataUtils.isNestedBinaryNumericType(string) || DatabaseMetadataUtils.isNestedCategoricalType(string);
    }

    public static boolean isNestedNumericType(String string) {
        return string.equals("DM_NESTED_NUMERICALS") || DatabaseMetadataUtils.isNestedBinaryNumericType(string);
    }

    public static boolean isNestedBinaryNumericType(String string) {
        return string.equals(ORACLE_NESTED_BINARY_DOUBLES) || string.equals(ORACLE_NESTED_BINARY_FLOATS);
    }

    public static boolean isNestedCategoricalType(String string) {
        return string.equals("DM_NESTED_CATEGORICALS");
    }

    public static boolean isBinaryNumericType(String string) {
        return string.equals(ORACLE_BINARY_DOUBLE) || string.equals(ORACLE_BINARY_FLOAT);
    }

    public static boolean isNumericType(String string) {
        return string.equals("NUMBER") || string.equals(ORACLE_FLOAT);
    }

    public static boolean isDateType(String string) {
        return string.equals(ORACLE_DATE) || string.equals(ORACLE_TIMESTAMP) || string.equals(ORACLE_TIMSTAMP_WITH_LOCAL_TIME_ZONE) || string.equals(ORACLE_TIMSTAMP_WITH_TIME_ZONE);
    }

    public static boolean isDataTypeSupported(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_DATA_TYPES_SUPPORTED, (Object)string);
        if (!bl) {
            bl = DatabaseMetadataUtils.isTimestampDerived(string);
        }
        if (!bl) {
            bl = DatabaseMetadataUtils.isODMrCustom_TypeSupported(string);
        }
        return bl;
    }

    public static boolean isJSONTypeSupported(String string) {
        boolean bl = false;
        for (int i = 0; i < JSON_DATA_TYPES_SUPPORTED.length; ++i) {
            if (string.compareToIgnoreCase(JSON_DATA_TYPES_SUPPORTED[i]) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isJSONPredicateSupported(String string) {
        boolean bl = false;
        if (string != null && (string.equals(JSON_ARRAY) || string.equals(JSON_BOOLEAN) || string.equals(JSON_STRING) || string.equals("NUMBER"))) {
            bl = true;
        }
        return bl;
    }

    public static String getDataTypeCorresponsingToJSONType(String string) {
        return JSON_DATA_TYPES_MAP.get(string);
    }

    public static List<PartitionVO> getModelPartitions(ConnectionManager connectionManager, String string, String string2) {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        GetModelPartitionsQuery getModelPartitionsQuery = new GetModelPartitionsQuery(connectionManager.getDbVersion(), new String[]{string2}).setOwner(string);
        List list = Collections.emptyList();
        try {
            list = sqlDataAccessObject.readItem((Query)getModelPartitionsQuery).orElse(new ModelPartitions()).getRows();
        }
        catch (ODMrDAOException oDMrDAOException) {
            LOGGER.log(Level.SEVERE, oDMrDAOException.getMessage(), oDMrDAOException);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isModelPartitioned(ConnectionManager connectionManager, String string, String string2, PartitionVO partitionVO) {
        boolean bl = false;
        if (!DbVersionHelper.isDB122Up((Version)connectionManager.getDbVersion())) {
            return false;
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(PARTITION_INFORMATION_QUERY);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.pstmt.setString(3, string);
            sQLHelper.pstmt.setString(4, string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(2);
                String string4 = sQLHelper.rs.getString(1);
                String[] stringArray = sQLHelper.rs.getString(3).split(",");
                String[] stringArray2 = sQLHelper.rs.getString(4).split(",");
                ArrayList<PartitionColumn> arrayList = new ArrayList<PartitionColumn>();
                String[] stringArray3 = string3.split("_");
                for (int i = 0; i < stringArray3.length; ++i) {
                    PartitionColumn partitionColumn = new PartitionColumn(stringArray[i], stringArray2[i], stringArray3[i]);
                    arrayList.add(partitionColumn);
                }
                if (partitionVO != null) {
                    partitionVO.setPartitionName(string3);
                    partitionVO.setPartitionID(string4);
                    partitionVO.setColumns(arrayList);
                }
                bl = true;
            }
        }
        return bl;
    }

    public static void buildAllowedDynamicNodeTypes(Context context) {
        if (!allowedDynamicTypes.isEmpty()) {
            return;
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(sql);
            while (sQLHelper.rs.next()) {
                allowedDynamicTypes.add(sQLHelper.rs.getString(1));
            }
        }
    }

    public static boolean isDynamicPredictionNodeTypeSupported(Context context, String string) {
        if (allowedDynamicTypes.isEmpty()) {
            DatabaseMetadataUtils.buildAllowedDynamicNodeTypes(context);
        }
        return allowedDynamicTypes.contains(string);
    }

    public static boolean isACustomDataType(Context context, String string) throws Exception {
        return DatabaseMetadataUtils.isSupportedNestedType(context, string) || DatabaseMetadataUtils.isODMrCustom_TypeSupported(string);
    }

    public static boolean isACharacterOracleDataType(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_COMPATIBLE_CHARACTER_TYPES, (Object)string);
        return bl;
    }

    public static boolean isANumberOracleDataType(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_COMPATIBLE_NUMBER_TYPES, (Object)string);
        return bl;
    }

    public static boolean isATimeStampOracleDataType(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_PARTITION_KEY_DATA_TYPES_SUPPORTED, (Object)string);
        if (!bl) {
            bl = DatabaseMetadataUtils.isTimestampDerived(string);
        }
        return bl;
    }

    public static boolean isNumericTypeSupported(Context context, String string) {
        boolean bl = false;
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        boolean bl2 = false;
        bl = version.toCanonicalString().startsWith("11.") ? Arrays.contains((Object[])ORACLE_NUMERIC_DATA_TYPES_SUPPORTED, (Object)string) : Arrays.contains((Object[])ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12, (Object)string);
        return bl;
    }

    public static String mapNumericSupportedType(Context context, String string) {
        String string2 = null;
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        int n = 0;
        if (version.toCanonicalString().startsWith("11.")) {
            for (n = 0; n < ORACLE_NUMERIC_DATA_TYPES_SUPPORTED.length; ++n) {
                if (string.compareTo(ORACLE_NUMERIC_DATA_TYPES_SUPPORTED[n]) != 0) continue;
                string2 = string;
                break;
            }
        } else {
            for (n = 0; n < ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12.length; ++n) {
                if (string.compareTo(ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12[n]) != 0) continue;
                string2 = string;
                break;
            }
        }
        return string2;
    }

    public static boolean isTimestampDerived(String string) {
        return -1 != string.indexOf(ORACLE_TIMESTAMP);
    }

    public static boolean isTimestamp(String string) {
        return -1 != string.indexOf(ORACLE_TIMESTAMP) && -1 == string.indexOf(_WITH_TIMEZONE);
    }

    public static boolean isTimestampWithTimeZone(String string) {
        return -1 != string.indexOf(ORACLE_TIMESTAMP) && -1 != string.indexOf(_WITH_TIMEZONE);
    }

    public static boolean isTimestampWithLocalTimeZone(String string) {
        if (-1 != string.indexOf(ORACLE_TIMESTAMP)) {
            return -1 != string.indexOf(_WITH_LOCAL_TIMEZONE);
        }
        return false;
    }

    public static boolean isKeyDataTypeSupported(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_KEY_DATA_TYPES_SUPPORTED, (Object)string);
        if (!bl) {
            bl = DatabaseMetadataUtils.isTimestampDerived(string);
        }
        return bl;
    }

    public static boolean isCaseIdDataTypeSupported(Version version, String string) {
        boolean bl = false;
        bl = version == null || version.toCanonicalString().startsWith("11.") ? Arrays.contains((Object[])ORACLE_CASE_DATA_TYPES_SUPPORTED, (Object)string) : Arrays.contains((Object[])ORACLE_CASE_DATA_TYPES_SUPPORTED_12, (Object)string);
        return bl;
    }

    public static boolean isCaseIdDataTypeSupported(Context context, String string) {
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        return DatabaseMetadataUtils.isCaseIdDataTypeSupported(version, string);
    }

    public static boolean isCaseIdDataTypeSupported(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_CASE_DATA_TYPES_SUPPORTED_12, (Object)string);
        return bl;
    }

    public static boolean isPartitionKeyDataTypeSupported(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_PARTITION_KEY_DATA_TYPES_SUPPORTED, (Object)string);
        return bl;
    }

    public static boolean isDynamicCaseIdDataTypeSupported(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_DYNAMIC_CASE_DATA_TYPES_SUPPORTED_12, (Object)string);
        return bl;
    }

    public static boolean isTargetCategoricalDataTypeSupported(Context context, String string) {
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        return DbMetadataUtils.isTargetCategoricalDataTypeSupported((Version)version, (String)string);
    }

    public static boolean isODMrCustom_TypeSupported(String string) {
        Object[] objectArray = ODMrDataTypesUtil.getApply_12_1_Types();
        boolean bl = Arrays.contains((Object[])objectArray, (Object)string);
        if (!bl) {
            objectArray = ODMrDataTypesUtil.getODMr_Misc_Types();
            bl = Arrays.contains((Object[])objectArray, (Object)string);
        }
        return bl;
    }

    public static boolean isTargetNumericalDataTypeSupported(Context context, String string) {
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        return DbMetadataUtils.isTargetNumericalDataTypeSupported((Version)version, (String)string);
    }

    public static boolean isBinningDataTypeSupported(String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_DYNAMIC_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12, (Object)string);
        return bl;
    }

    public static boolean isSupervisedBinningDataTypeSupported(Version version, String string) {
        boolean bl = Arrays.contains((Object[])ORACLE_PARTITION_KEY_DATA_TYPES_SUPPORTED, (Object)string);
        if (!bl) {
            bl = DatabaseMetadataUtils.isSupportedNestedType(version, string);
        }
        return bl;
    }

    public static boolean canDataBeImplicitlyConverted(String string, String string2) {
        if (DatabaseMetadataUtils.isACharacterOracleDataType(string) && DatabaseMetadataUtils.isACharacterOracleDataType(string2)) {
            return true;
        }
        if (DatabaseMetadataUtils.isANumberOracleDataType(string) && DatabaseMetadataUtils.isANumberOracleDataType(string2)) {
            return true;
        }
        return DatabaseMetadataUtils.isATimeStampOracleDataType(string) && DatabaseMetadataUtils.isATimeStampOracleDataType(string2);
    }

    public static String getDefaultUIMiningType(String string) {
        return DatabaseMetadataUtils.getDefaultMiningType(string, true);
    }

    public static String getDefaultMiningType(String string) {
        return DatabaseMetadataUtils.getDefaultMiningType(string, false);
    }

    public static boolean isXMLType(String string) {
        return string.equals(ORACLE_XMLTYPE);
    }

    public static boolean isLOBType(String string) {
        return string.equals(ORACLE_CLOB) || string.equals(ORACLE_NCLOB) || string.equals(ORACLE_BLOB);
    }

    public static boolean isBFILEype(String string) {
        return string.equals(ORACLE_BFILE);
    }

    public static String getDefaultMiningType(String string, boolean bl) {
        String string2 = null;
        string2 = string.equals("NUMBER") || string.equals(ORACLE_FLOAT) || string.equals(ORACLE_DATE) || string.equals(ORACLE_BINARY_DOUBLE) || string.equals(ORACLE_BINARY_FLOAT) || DatabaseMetadataUtils.isTimestampDerived(string) ? (bl ? NUMERICAL_MINING_TYPE : "Numerical") : (string.equals(ORACLE_VARCHAR2) || string.equals(ORACLE_CHAR) || string.equals(ORACLE_NVARCHAR2) || string.equals(ORACLE_NCHAR) ? (bl ? CATEGORICAL_MINING_TYPE : "Categorical") : (string.equals("DM_NESTED_NUMERICALS") ? (bl ? NUMERICAL_MINING_TYPE : "Numerical") : (string.equals("DM_NESTED_CATEGORICALS") ? (bl ? CATEGORICAL_MINING_TYPE : "Categorical") : (string.equals(ODMR_HISTOGRAMS) || string.equals(ODMR_HISTOGRAMS_EX) ? (bl ? CATEGORICAL_MINING_TYPE : "Categorical") : (string.equals(ORACLE_BFILE_MINING_DATA_TYPE) || string.equals(ORACLE_BLOB) || string.equals(ORACLE_CLOB) || string.equals(ORACLE_NCLOB) ? (bl ? TEXT_MINING_TYPE : ATTRIBUTE_TYPE_TEXT) : (bl ? NOT_APPLICABLE_MINING_TYPE : ATTRIBUTE_TYPE_NOT_APPLICABLE))))));
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dataSourceExists(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        String string3;
        String string4 = "select table_name from all_tables where owner = :owner_param and table_name = :table_param";
        String string5 = "select view_name from all_views where owner = :owner_param and view_name = :table_param";
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
            string = DatabaseMetadataUtils.getReplacedString(string, "'", "''");
            string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
            string2 = DatabaseMetadataUtils.getReplacedString(string2, "'", "''");
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("owner_param", string);
            sQLHelper.opstmt.setStringAtName("table_param", string2);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string3 = sQLHelper.rs.getString(1)) != null) {
                boolean bl2 = true;
                return bl2;
            }
        }
        try {
            sQLHelper = new SQLHelper();
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string5);
            sQLHelper.opstmt.setStringAtName("owner_param", string);
            sQLHelper.opstmt.setStringAtName("table_param", string2);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string3 = sQLHelper.rs.getString(1)) != null) {
                boolean bl3 = true;
                return bl3;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean isTable(ConnectionManager connectionManager, String string, String string2) throws ODMrDAOException {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        String string3 = "select table_name from all_tables where owner = :owner_param and table_name = :table_param";
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string4;
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string;
            string = DatabaseMetadataUtils.getReplacedString(string, "'", "''");
            string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2;
            string2 = DatabaseMetadataUtils.getReplacedString(string2, "'", "''");
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("owner_param", string);
            sQLHelper.opstmt.setStringAtName("table_param", string2);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string4 = sQLHelper.rs.getString(1)) != null) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTableOrViewGrantedDirectly(ConnectionManager connectionManager, String string, String string2, String string3) throws SQLException {
        String string4 = "select grantor, grantee, table_schema, table_name, privilege from ALL_TAB_PRIVS \nWHERE TABLE_SCHEMA = :schema_param AND TABLE_NAME = :table_param \nAND GRANTEE IN (:owner_param, 'PUBLIC') AND PRIVILEGE = 'SELECT'";
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string5;
            String string6 = string3;
            string6 = StringUtils.isDoubleQuotedString(string6) ? StringUtils.trimDoubleQuotes(string6) : string6;
            string6 = DatabaseMetadataUtils.getReplacedString(string6, "'", "''");
            String string7 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2;
            string7 = DatabaseMetadataUtils.getReplacedString(string7, "'", "''");
            String string8 = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string;
            string8 = DatabaseMetadataUtils.getReplacedString(string8, "'", "''");
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("owner_param", string6);
            sQLHelper.opstmt.setStringAtName("table_param", string7);
            sQLHelper.opstmt.setStringAtName("schema_param", string8);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next() && (string5 = sQLHelper.rs.getString(1)) != null) {
                bl = true;
            }
        }
        return bl;
    }

    public static String createUniquePKConstraintName(String string, ConnectionManager connectionManager) throws SQLException {
        return DatabaseMetadataUtils.createUniquePKConstraintNameUsinRandom(string, connectionManager);
    }

    public static String createUniquePKConstraintNameUsinRandom(String string, ConnectionManager connectionManager) throws SQLException {
        Map<String, String> map = DatabaseMetadataUtils.getUserConstraintNamespaceHashMap(connectionManager);
        String string2 = string.length() > 16 ? string.substring(0, 16) : string;
        String string3 = DatabaseMetadataUtils.createUniqueDBObjNameUsingRandom(string2, map, 999999, "_PK");
        return string3;
    }

    public static String createUniqueConstraintNameUsinRandom(String string, ConnectionManager connectionManager) throws SQLException {
        Map<String, String> map = DatabaseMetadataUtils.getUserConstraintNamespaceHashMap(connectionManager);
        String string2 = string.length() > 16 ? string.substring(0, 16) : string;
        String string3 = DatabaseMetadataUtils.createUniqueDBObjNameUsingRandom(string2, map, 999999, "");
        return string3;
    }

    private static String createUniqueDBObjNameUsingRandom(String string, Map<String, String> map, int n, String string2) {
        boolean bl = true;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (bl) {
            string3 = String.valueOf(randNumberGen.nextInt(n));
            string4 = string + string3 + string2;
            if (map != null) {
                string5 = map.get(string4);
            }
            if (string5 != null) continue;
            bl = false;
        }
        return string4;
    }

    private static String createUniqueDBObjNameUsingSequence(String string, Map<String, String> map) {
        boolean bl = true;
        String string2 = string;
        String string3 = null;
        int n = 1;
        while (bl) {
            if (map != null) {
                string3 = map.get(string2);
            }
            if (string3 == null) {
                bl = false;
                continue;
            }
            string2 = string + ++n;
        }
        return string2;
    }

    public static boolean isSQLDataTypeNumeric(int n) {
        boolean bl = false;
        switch (n) {
            case -6: 
            case -5: 
            case -2: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isSQLDataTypeString(int n) {
        boolean bl = false;
        switch (n) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isSQLDataTypeDate(int n) {
        boolean bl = false;
        switch (n) {
            case 91: 
            case 92: 
            case 93: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static String createUniqueTableNameUsingRandom(String string, ConnectionManager connectionManager, int n, String string2) throws SQLException {
        Map<String, String> map = DatabaseMetadataUtils.getPrimaryObjectNamespaceHashMap(connectionManager);
        boolean bl = StringUtils.isDoubleQuotedString(string);
        int n2 = bl ? 15 : 16;
        String string3 = string.length() > n2 ? string.substring(0, n2) : string;
        String string4 = DatabaseMetadataUtils.createUniqueDBObjNameUsingRandom(string3, map, n, string2);
        if (bl) {
            string4 = string4 + "\"";
        }
        return string4;
    }

    public static String createUniqueTableName(String string, ConnectionManager connectionManager, String string2) throws SQLException {
        return DatabaseMetadataUtils.createUniqueTableNameUsingRandom(string, connectionManager, 999999999, string2);
    }

    public static String createUniqueTableName(String string, ConnectionManager connectionManager) throws SQLException {
        Map<String, String> map = DatabaseMetadataUtils.getPrimaryObjectNamespaceHashMap(connectionManager);
        boolean bl = StringUtils.isDoubleQuotedString(string);
        int n = bl ? 24 : 26;
        String string2 = string.length() > n ? string.substring(0, n) : string;
        String string3 = DatabaseMetadataUtils.createUniqueDBObjNameUsingSequence(string2, map);
        if (bl) {
            string3 = string3 + "\"";
        }
        return string3;
    }

    public static String createUniqueTempTableName(String string, ConnectionManager connectionManager) throws SQLException {
        return DatabaseMetadataUtils.createUniqueTableNameUsingRandom(string, connectionManager, 999999999, TEMP_TABLE_PREFIX);
    }

    public static List<String> getRequiredColumns(ConnectionManager connectionManager, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DatabaseMetadataUtils.getRequiredColumnsInternal(connectionManager, COLUMNS_WITH_CONSTRAINTS, string, string2, arrayList);
        DatabaseMetadataUtils.getRequiredColumnsInternal(connectionManager, NOT_NULL, string, string2, arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getRequiredColumnsInternal(ConnectionManager connectionManager, String string, String string2, String string3, List<String> list) {
        SQLHelper sQLHelper = new SQLHelper();
        Object[] objectArray = new String[]{string2, string3, "'"};
        String string4 = MessageFormat.format(string, objectArray);
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString(1);
                if (string5 == null || list.contains(string5)) continue;
                list.add(string5);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        finally {
            sQLHelper.close();
        }
    }

    public static String getColumnType(Context context, String string) throws SQLException {
        String string2 = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string3 = StringUtils.escapeSingleQuotesForSQL(string);
            String string4 = StringUtils.getReplacedString(DBMS_SQL_PARSE_TYPE, "[SQL_EXPRESSION]", string3);
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall(string4);
            sQLHelper.cstmt.registerOutParameter(1, 12);
            sQLHelper.cstmt.execute();
            string2 = sQLHelper.cstmt.getString(1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnableLegacyApplyOutputTypes(Context context) {
        int n = 0;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall(DBMS_SQL_PARSE_LEGACY_APPLY_TYPE);
            sQLHelper.cstmt.registerOutParameter(1, 4);
            sQLHelper.cstmt.execute();
            n = sQLHelper.cstmt.getInt(1);
        }
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ColumnInfo> getColumnInfo(Context context, String string) {
        Boolean bl = (Boolean)context.getProperty("EXTENDED_TYPE_STATUS");
        if (bl == null) {
            bl = SQLHelper.isExtendedTypeEnabled(context);
        }
        HashMap<String, ColumnInfo> hashMap = new HashMap<String, ColumnInfo>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(sql_col_types);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(COLUMN_NAME);
                String string3 = sQLHelper.rs.getString(DATA_TYPE);
                int n = sQLHelper.rs.getInt(DATA_LENGTH);
                if (string3.equals(ORACLE_NVARCHAR2)) {
                    if (bl.booleanValue()) {
                        if (n > 16383) {
                            n = 16383;
                        }
                    } else if (n > 2000) {
                        n = 2000;
                    }
                }
                String string4 = sQLHelper.rs.getString("COLL_TYPE");
                hashMap.put(string2, new ColumnInfo(string2, string3, n, string4));
            }
        }
        return hashMap;
    }

    public static boolean hasDataAccess(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            if (!string.equals(string.toUpperCase())) {
                string = StringUtils.addDoubleQuotes(string);
            }
            String string3 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            String string4 = "";
            string4 = string.equalsIgnoreCase("PUBLIC") ? "SELECT ROWNUM FROM " + string3 + " WHERE ROWNUM < 2" : "SELECT ROWNUM FROM " + string + "." + string3 + " WHERE ROWNUM < 2";
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.pstmt.execute();
        }
        return true;
    }

    public static void convertExtendedTypes(AttributeType attributeType, boolean bl) {
        if (attributeType.getDataType().equals(ORACLE_NESTED_VARCHAR2) || attributeType.getDataType().equals(ORACLE_NESTED_VARCHAR2_EX)) {
            attributeType.setDataType(bl ? ORACLE_NESTED_VARCHAR2_EX : ORACLE_NESTED_VARCHAR2);
        }
    }

    public static void convertExtendedTypes(List<AttributeType> list, boolean bl) {
        for (AttributeType attributeType : list) {
            if (!attributeType.getDataType().equals(ORACLE_NESTED_VARCHAR2) && !attributeType.getDataType().equals(ORACLE_NESTED_VARCHAR2_EX)) continue;
            attributeType.setDataType(bl ? ORACLE_NESTED_VARCHAR2_EX : ORACLE_NESTED_VARCHAR2);
        }
    }

    public static String convertJSONAttrType(String string) {
        if (string.compareToIgnoreCase(JSON_OBJECT) == 0) {
            return ATTRIBUTE_TYPE_NOT_APPLICABLE;
        }
        if (string.compareToIgnoreCase(JSON_ARRAY) == 0) {
            return ATTRIBUTE_TYPE_NOT_APPLICABLE;
        }
        if (string.compareToIgnoreCase("NUMBER") == 0) {
            return "NUMBER";
        }
        if (string.compareToIgnoreCase(JSON_STRING) == 0) {
            return ORACLE_VARCHAR2;
        }
        if (string.compareToIgnoreCase(JSON_NULL) == 0) {
            return ORACLE_VARCHAR2;
        }
        if (string.compareToIgnoreCase(JSON_BOOLEAN) == 0) {
            return "NUMBER";
        }
        return ATTRIBUTE_TYPE_NOT_APPLICABLE;
    }

    public static boolean isPrimitiveJSONType(String string) {
        return !ATTRIBUTE_TYPE_NOT_APPLICABLE.equals(DatabaseMetadataUtils.convertJSONAttrType(string));
    }

    public static DataGuideType loadDataGuide(Context context, List<NameValuePair> list, String string) throws SQLException {
        DataGuideType dataGuideType = new DataGuideType();
        List list2 = dataGuideType.getItem();
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object[] objectArray = new Object[]{StringUtils.trimDoubleQuotes(string)};
            String string2 = MessageFormat.format(_load_data_guide, objectArray);
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString("PATH");
                String string4 = sQLHelper.rs.getString("NAME");
                String string5 = sQLHelper.rs.getString("TYPE");
                NameValuePair nameValuePair = new NameValuePair(string4, (Object)string5);
                NameValuePair nameValuePair2 = new NameValuePair(string3, (Object)nameValuePair);
                list.add(nameValuePair2);
                DataGuideType.Item item = new DataGuideType.Item();
                item.setPath(string3);
                item.setType(string5);
                list2.add(item);
            }
        }
        return dataGuideType;
    }

    public static String[] getJSONPathElements(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray;
    }

    public static String getJSONDataType(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.equals(JSON_QUALIFIER)) {
            return DatabaseMetadataUtils.getJSONColumnTypeInfo(string);
        }
        return string;
    }

    public static boolean isJSONDataType(AttributeType attributeType) {
        assert (attributeType != null);
        String string = attributeType.getDataTypeQualifier();
        return string != null && string.equals(JSON_QUALIFIER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isQuantileBinningValid(ConnectionManager connectionManager, List<String> list, List<String> list2, String string, String string2) {
        String sQLException;
        boolean bl = true;
        if (list == null || list.isEmpty()) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String object2 : list) {
            if (!stringBuilder.toString().isEmpty()) {
                stringBuilder.append("  UNION ALL\n");
            }
            sQLException = StringUtils.isDoubleQuotedString(object2) ? object2 : StringUtils.addDoubleQuotes(object2);
            String string3 = StringUtils.getReplacedString(column_count_distincts, "<quoted_column_name>", sQLException);
            string3 = StringUtils.getReplacedString(string3, "<input_data>", string2);
            stringBuilder.append(string3);
        }
        Object object3 = StringUtils.getReplacedString(count_distincts, "<union_template>", stringBuilder.toString());
        object3 = StringUtils.getReplacedString((String)object3, "<input_sql>", string);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                sQLException = sQLHelper.rs.getString(1);
                list2.add(sQLException);
            }
        }
        return bl == list2.isEmpty();
    }

    static {
        JSON_DATA_TYPES_MAP.put(JSON_VARCHAR2, ORACLE_VARCHAR2);
        JSON_DATA_TYPES_MAP.put(JSON_NVARCHAR2, ORACLE_NVARCHAR2);
        JSON_DATA_TYPES_MAP.put(JSON_CHAR, ORACLE_CHAR);
        JSON_DATA_TYPES_MAP.put(JSON_NCHAR, ORACLE_NCHAR);
        JSON_DATA_TYPES_MAP.put(JSON_CLOB, ORACLE_CLOB);
        JSON_DATA_TYPES_MAP.put(JSON_NCLOB, ORACLE_NCLOB);
        JSON_DATA_TYPES_MAP.put(JSON_BLOB, ORACLE_BLOB);
        JSON_DATA_TYPES_MAP.put(JSON_RAW, ORACLE_RAW);
        ORACLE_COMPATIBLE_CHARACTER_TYPES = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_NVARCHAR2, ORACLE_NCHAR, ORACLE_BLOB, ORACLE_CLOB, ORACLE_NCLOB};
        ORACLE_COMPATIBLE_NUMBER_TYPES = new String[]{"NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT, ORACLE_FLOAT};
        ORACLE_NESTED_TYPES_SUPPORTED = new String[]{"DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS"};
        ORACLE_NESTED_TYPES_SUPPORTED_12 = new String[]{"DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS", ORACLE_NESTED_BINARY_DOUBLES, ORACLE_NESTED_BINARY_FLOATS};
        ORACLE_NUMERIC_DATA_TYPES_SUPPORTED = new String[]{ORACLE_FLOAT, "NUMBER"};
        ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        ORACLE_DYNAMIC_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_VARCHAR2, ORACLE_NVARCHAR2, "NUMBER", ORACLE_FLOAT, ORACLE_CHAR, ORACLE_NCHAR, ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        ORACLE_KEY_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_NVARCHAR2, ORACLE_NCHAR, ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT, ORACLE_DATE, ORACLE_TIMESTAMP, ORACLE_TIMSTAMP_WITH_TIME_ZONE, ORACLE_TIMSTAMP_WITH_LOCAL_TIME_ZONE};
        ORACLE_CASE_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_FLOAT, "NUMBER", ORACLE_RAW, ORACLE_ROWID, ORACLE_UROWID};
        ORACLE_CASE_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT, ORACLE_RAW, ORACLE_ROWID, ORACLE_UROWID};
        ORACLE_DYNAMIC_CASE_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_VARCHAR2, ORACLE_NVARCHAR2, ORACLE_CHAR, ORACLE_NCHAR, ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        ORACLE_INDEX_NOT_SUPPORTED = new String[]{ORACLE_XMLTYPE, ORACLE_CLOB, ORACLE_BLOB, ORACLE_NCLOB, "DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS"};
        ORACLE_TEXT_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_NVARCHAR2, ORACLE_NCHAR, ORACLE_CLOB, ORACLE_BLOB, ORACLE_NCLOB, ORACLE_BFILE};
        ORACLE_PARTITION_KEY_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, "NUMBER"};
        allowedDynamicTypes = new ArrayList<String>();
        randNumberGen = new Random();
        COLUMNS_WITH_CONSTRAINTS = "SELECT cols.COLUMN_NAME FROM all_constraints cons, all_cons_columns cols WHERE cols.owner = {2}{0}{2} AND cols.table_name = {2}{1}{2} AND cons.constraint_type IN ( {2}P{2}, {2}R{2}, {2}U{2}, {2}C{2} ) AND cons.constraint_name = cols.constraint_name AND cons.owner = cols.owner ORDER BY cols.table_name, cols.position";
        NOT_NULL = "SELECT column_name FROM all_tab_columns where OWNER = {2}{0}{2} AND TABLE_NAME = {2}{1}{2} AND NULLABLE = {2}N{2}";
        DBMS_SQL_PARSE_TYPE = "DECLARE   curid      INTEGER;\n  colcnt     NUMBER;\n  desctab    dbms_sql.desc_tab3;\n  r_value    INTEGER;\n  ret_value  VARCHAR2(200);\nBEGIN\n  curid := DBMS_SQL.OPEN_CURSOR;\n  DBMS_SQL.PARSE(curid, '[SQL_EXPRESSION]', DBMS_SQL.NATIVE);\n  dbms_sql.describe_columns3(curid, colcnt, desctab);\n       FOR i IN 1 .. colcnt LOOP\n         if (desctab(i).col_type = 1) then\n           ret_value := 'VARCHAR2';\n         elsif (desctab(i).col_type = 2) then\n           ret_value := 'NUMBER';\n         ELSIF (desctab(i).col_type = 100) THEN -- BINARY_FLOAT\n           ret_value := 'NUMBER';\n         ELSIF (desctab(i).col_type = 101) THEN -- BINARY_DOUBLE\n           ret_value := 'NUMBER';\n         elsif (desctab(i).col_type = 11) then\n           ret_value := 'ROWID';\n         elsif (desctab(i).col_type = 12) then\n           ret_value := 'DATE';\n         elsif (desctab(i).col_type = 23) then\n           ret_value := 'RAW';\n         elsif (desctab(i).col_type = 180) then\n           ret_value := 'TIMESTAMP';\n         elsif (desctab(i).col_type = 181) then \n           ret_value := 'TIMESTAMP WITH TIME ZONE';\n         elsif (desctab(i).col_type = 231) then\n           ret_value := 'TIMESTAMP WITH LOCAL TIME ZONE';\n         elsif (desctab(i).col_type = 182) then \n           ret_value := 'INTERVAL YEAR() TO MONTH';\n         elsif (desctab(i).col_type = 183) then\n           ret_value := 'INTERVAL DAY() TO SECOND()';\n         elsif (desctab(i).col_type = 96) then\n           ret_value := 'CHAR';\n         elsif (desctab(i).col_type = 8) then\n           ret_value := 'LONG';\n         elsif (desctab(i).col_type = 112) then\n           ret_value := 'CLOB';\n         elsif (desctab(i).col_type = 113) then\n           ret_value := 'BLOB';\n         elsif (desctab(i).col_type = 114) then \n           ret_value := 'BFILE';\n         elsif (desctab(i).col_type = 208) then \n           ret_value := 'UROWID';\n         elsif (desctab(i).col_type = 109) then\n           ret_value := desctab(i).col_type_name;\n         END IF;\n       end loop;\n  r_value := DBMS_SQL.EXECUTE(curid);\n  r_value := DBMS_SQL.FETCH_ROWS(curid);\n  dbms_sql.close_cursor(curid);\n  ? := ret_value;\n  EXCEPTION WHEN OTHERS THEN\n    DBMS_SQL.CLOSE_CURSOR(curid);\n    ret_value := NULL;    RAISE;  \nEND;\n";
        DBMS_SQL_PARSE_LEGACY_APPLY_TYPE = "DECLARE   intval INTEGER := 0;\n  strval VARCHAR2(256);\n  partyp BINARY_INTEGER;\nBEGIN\n  BEGIN\n    partyp := dbms_utility.get_parameter_value('_dm_enable_legacy_dmf_output_types', intval, strval);\n  EXCEPTION WHEN OTHERS THEN\n    NULL;\n  END;\n  ? := intval;\nEND;\n";
        sql_col_types = "SELECT tabs.COLUMN_NAME, tabs.DATA_TYPE, tabs.DATA_LENGTH, tpes.COLL_TYPE \nFROM all_tab_columns tabs, all_coll_types tpes\nWHERE tabs.TABLE_NAME=? AND tabs.DATA_TYPE = tpes.TYPE_NAME(+)";
        _load_data_guide = "SELECT PATH, NAME, TYPE FROM \"{0}\"";
        column_count_distincts = "  select '<quoted_column_name>' as attr_name, count (distinct <quoted_column_name> ) distincts from <input_data>\n";
        count_distincts = "WITH <input_sql>,distinct_counts_view as (\n  <union_template>)\nselect attr_name from distinct_counts_view where distincts < 2";
    }

    public static class ColumnInfo {
        private String columnName;
        private String columnAlias;
        private String dataType;
        private int dataLength;
        private String colType;
        private String primaryKey = "No";
        private String index = "No";

        public void setColumnAlias(String string) {
            this.columnAlias = string;
        }

        public String getColumnAlias() {
            return this.columnAlias;
        }

        public ColumnInfo(String string, String string2, int n, String string3) {
            this.columnName = string;
            this.dataType = string2;
            this.dataLength = n;
            this.colType = string3;
        }

        public ColumnInfo(String string, String string2, int n) {
            this.columnName = string;
            this.dataType = string2;
            this.dataLength = n;
        }

        public ColumnInfo(String string, String string2) {
            this.columnName = string;
            this.dataType = string2;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getDataType() {
            return this.dataType;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public String getColType() {
            return this.colType;
        }

        public void setColumnName(String string) {
            this.columnName = string;
        }

        public void setPrimaryKey(String string) {
            this.primaryKey = string;
        }

        public String getPrimaryKey() {
            return this.primaryKey;
        }

        public void setIndex(String string) {
            this.index = string;
        }

        public String getIndex() {
            return this.index;
        }
    }

    public static enum AggregateFunctions {
        MAX("MAX()"),
        AVG("AVG()"),
        MIN("MIN()"),
        MEDIAN("MEDIAN()"),
        MODE("STATS_MODE()"),
        SUM("SUM()"),
        VARIANCE("VARIANCE()"),
        STDDEV("STDDEV()"),
        COUNT("COUNT()"),
        COUNT_DISTINCT("COUNT(DISTINCT())"),
        CAST_COLLECT("CAST(COLLECT())");

        private final String sql;
        private static final Map<String, AggregateFunctions> stringToEnum;

        public static AggregateFunctions fromString(String string) {
            return stringToEnum.get(string);
        }

        private AggregateFunctions(String string2) {
            this.sql = string2;
        }

        public static String toAggregateName(String string) {
            String string2 = string.substring(0, string.indexOf("()"));
            string2 = string2.replace('(', '_');
            return string2;
        }

        public String toString() {
            return this.sql;
        }

        public static List<String> listNumericFunctions() {
            ArrayList<String> arrayList = new ArrayList<String>(stringToEnum.keySet());
            arrayList.remove(CAST_COLLECT.toString());
            return arrayList;
        }

        public static List<String> listCategoricFunctions() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(CAST_COLLECT.toString());
            arrayList.add(COUNT.toString());
            arrayList.add(COUNT_DISTINCT.toString());
            arrayList.add(MAX.toString());
            arrayList.add(MIN.toString());
            arrayList.add(MODE.toString());
            return arrayList;
        }

        public static List<String> listDateTimestampFunctions() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(COUNT.toString());
            arrayList.add(COUNT_DISTINCT.toString());
            arrayList.add(MAX.toString());
            arrayList.add(MEDIAN.toString());
            arrayList.add(MIN.toString());
            arrayList.add(MODE.toString());
            return arrayList;
        }

        public static List<String> listCommonCategoricAndNumericFunctions() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(COUNT.toString());
            arrayList.add(COUNT_DISTINCT.toString());
            arrayList.add(MAX.toString());
            arrayList.add(MIN.toString());
            arrayList.add(MODE.toString());
            return arrayList;
        }

        public static boolean isTypeTransparentFunction(String string) {
            if (string.equals(MODE.toString())) {
                return false;
            }
            if (string.equals(COUNT.toString())) {
                return false;
            }
            if (string.equals(COUNT_DISTINCT.toString())) {
                return false;
            }
            return !string.equals(CAST_COLLECT.toString());
        }

        static {
            stringToEnum = new HashMap<String, AggregateFunctions>();
            for (AggregateFunctions aggregateFunctions : AggregateFunctions.values()) {
                stringToEnum.put(aggregateFunctions.toString(), aggregateFunctions);
            }
        }
    }
}

